/*
 * fc_dumm_MqttDummTypes.h
 *
 *  Created on: Sep 21, 2017
 *      Author: gjd5kor
 */

#ifndef FC_DUMM_MQTTDUMMTYPES_H_
#define FC_DUMM_MQTTDUMMTYPES_H_

class fc_dumm_MqttDummTypes
{
public:
	 enum eSessionType
	{
		SESSION_ALWAYS_CONNECTED		= 0,
		SESSION_ON_DEMOND				= 1,
		SESSION_IVI_PERIODIC			= 2,
		SESSION_UNKNOWN					= 255,
	};

	 enum eConnectionType
	{
		MQTT_TLS_CONNECTION			= 0,
		MQTT_NON_TLS_CONNECTION 	= 1,
	};

	 enum eConnection_Response
	{
		CONNECTION_SUCCESS									= 0,
		CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION	= 1,
		CONNECTION_REFUSED_IDENTIFIER_REJECTED				= 2,
		CONNECTION_REFUSED_BROKER_UNAVAILABLE				= 3,
		CONNECTION_MAX										= 255
	};

	 enum eCompressionState
	{
		DISABLE				= 0,
		ENABLE				= 1,
	};

	 enum eTopicType
	{
		TOPIC_TYPE_ZLIB					= 0,
		TOPIC_TYPE_NONZLIB				= 1,
		TOPIC_TYPE_UNKNOWN				= 255
	};

	 enum eMosq_err
	{
		MOSQ_ERR_CONN_PENDING = -1,
		MOSQ_ERR_SUCCESS = 0,
		MOSQ_ERR_NOMEM = 1,
		MOSQ_ERR_PROTOCOL = 2,
		MOSQ_ERR_INVAL = 3,
		MOSQ_ERR_NO_CONN = 4,
		MOSQ_ERR_CONN_REFUSED = 5,
		MOSQ_ERR_NOT_FOUND = 6,
		MOSQ_ERR_CONN_LOST = 7,
		MOSQ_ERR_TLS = 8,
		MOSQ_ERR_PAYLOAD_SIZE = 9,
		MOSQ_ERR_NOT_SUPPORTED = 10,
		MOSQ_ERR_AUTH = 11,
		MOSQ_ERR_ACL_DENIED = 12,
		MOSQ_ERR_UNKNOWN = 13,
		MOSQ_ERR_ERRNO = 14,
		MOSQ_ERR_EAI = 15,
		MOSQ_ERR_PROXY = 16
	};

	enum eTCUStatus
	{
		TCU_NOT_CONNECTED = 0,
		TCU_CONNECTED = 1
	};

	enum eConnection_Status
	{
		DISCONNECTED 	= 0,
		CONNECTED 		= 1
	};

	enum eLoop_Status
	{
		LOOP_INACTIVE 	= 0,
		LOOP_ACTIVE 	= 1
	};

	enum eAgentErroCodes
	{
		AGENT_ERR_AGENT_REQUEST_SUCCESS = 0,
		AGENT_ERR_AGENT_SERVICE_UN_AVAILABLE = 1
	};

	enum eAgent_Response
	{
		INIT_STATUS_SUCCESS 						= 100,
		INIT_STATUS_FAILED							= 101,
		INIT_STATUS_INVALID_NAVI_UNIT_ID 			= 102,
		INIT_STATUS_UNKNOWN_STATUS		 			= 199,

		CONNECTION_STATUS_CONNECTED					= 200,
		CONNECTION_STATUS_FAILED_TO_CONNECT 		= 201,
		CONNECTION_STATUS_CONNECTING				= 202,
		CONNECTION_STATUS_DISCONECTING				= 203,
		CONNECTION_STATUS_DISCONECTED				= 204,
		CONNECTION_STATUS_NOT_INITIALIZED			= 205,
		CONNECTION_STATUS_AUTHENTICATION_FAILED		= 206,
		CONNECTION_STATUS_DISCONNECTED_BY_BROKER	= 207,
		CONNECTION_STATUS_UNKNOWN					= 299,

		SUBSCRIBE_STATUS_SUBSCRIBED					= 300,
		SUBSCRIBE_STATUS_SUBSCRIBING 				= 301,
		SUBSCRIBE_STATUS_FAILED_TO_SUBCRIBE			= 302,
		SUBSCRIBE_STATUS_NOT_INITIALIZED			= 303,
		SUBSCRIBE_STATUS_CONNECTION_UNAVAILABLE		= 304,

		PUBLISH_STATUS_PUBLISHED 					= 400,
		PUBLISH_STATUS_PUBLISHING					= 401,
		PUBLISH_STATUS_FAILED_TO_PUBLSIH			= 402,
		PUBLISH_STATUS_NOT_INITIALIZED				= 403,
		PUBLISH_STATUS_CONNECTION_UNAVAILABLE		= 404,
		PUBLISH_STATUS_RETRY_ATTEMPT				= 405,

		INTERNAL_SERVER_ERROR_CONNECTION_ISSUE 		= 501,

		UNSUBSCRIBE_STATUS_UNSUBSCRIBED				= 600,
		UNSUBSCRIBE_STATUS_UNSUBSCRIBING 			= 601,
		UNSUBSCRIBE_STATUS_FAILED_TO_UNSUBCRIBE		= 602,
		UNSUBSCRIBE_STATUS_NOT_INITIALIZED			= 603,
		UNSUBSCRIBE_STATUS_CONNECTION_UNAVAILABLE	= 604
	};

	enum eTLSTimer_Type
	{
		TLS_TIMER_CONNECT	= 0,
		TLS_TIMER_SUBSCRIBE,
		TLS_TIMER_PUBLISH,
		TLS_TIMER_INVALID = 255
	};

	enum eAgent_Running_Status
	{
		AGENT_SERVICE_UNAVAILABLE	= 0,
		AGENT_WAITING_FOR_ECU_SERIALNUMBERUPDATE,
		AGENT_INITIALIZING,
		AGENT_UPDATING_SESSION_TYPE,
		AGENT_UPDATING_TOPIC_LIST,
		AGENT_WAITING_FOR_URL_UPDATE_FROM_CFGMGR,
		AGENT_WAITING_STUNNEL_RESTART_STATUS,
		AGENT_READY_FOR_COMMUNICATION
	};

	enum eStatus
	{
		UNAVAILABLE,
		AVAILABLE
	};

	enum eAuthEngine
	{
		SDC_ECM,
		DEFAULT
	};

	enum eAction_On_CONACK
	{
		MQTT_CONNECT_ACTION_ON_CONACK_PROCEED_TO_SUBSCRIBE,
		MQTT_CONNECT_ACTION_ON_CONACK_DISCONNECT,
	};

	enum eAction_On_DisconnectACK
	{
		MQTT_CONNECT_ACTION_ON_DISCONNECTACK_NOACTION,
		MQTT_CONNECT_ACTION_ON_DISCONNECTACK_REINITIALIZE_CS_FALSE,
	};

	enum eSeesonFlag
	{
		NEW_SESSION = 0,
		SESSION_RESUMED = 1,
		UNKNOWN_OR_INVALID = 255
	};




};



#endif /* APPL_MQTTDUMMCLIENT_FC_DUMM_MQTTDUMMTYPES_H_ */
