/*
 * Copyright (C) 2008-2013 J.Rios <anonbeat@gmail.com>
 * Copyright (C) 2013 Jörn Magens
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file LICENSE.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301  USA
 * https://www.gnu.org/licenses/lgpl-2.1.txt
 *
 * Author:
 *     Jörn Magens <shuerhaaken@googlemail.com>
 *
 */


#include "taginfo.h"

#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include <tag.h>
#include <textidentificationframe.h>
#include <unsynchronizedlyricsframe.h>
#include <fileref.h>
#include <asffile.h>
#include <flacfile.h>
#include <id3v2tag.h>
#include <mpcfile.h>
#include <mpegfile.h>
#include <oggfile.h>
#include <vorbisfile.h>
#include <trueaudiofile.h>
#include <wavpackfile.h>
#include <popularimeterframe.h>

#include <id3v2tag.h>


#include <iostream> //ck to get it compiled with LinuxX86




#define BUFFERSIZE 512


using namespace TagLib;
using namespace std;
using namespace TagInfo;





namespace TagInfo {
    // Internal changed flags
    enum ChangedData {
        CHANGED_DATA_NONE          = 0,
        CHANGED_ARTIST_TAG         = (1 << 0),
        CHANGED_ALBUM_TAG          = (1 << 1),
        CHANGED_TITLE_TAG          = (1 << 2),
        CHANGED_GENRE_TAG          = (1 << 3),
        CHANGED_COMMENT_TAG        = (1 << 4),
        CHANGED_TRACKNO_TAG        = (1 << 5),
        CHANGED_YEAR_TAG           = (1 << 6),
        CHANGED_DATA_ALBUMARTIST   = (1 << 7),
        CHANGED_DATA_DISK_NUM      = (1 << 8),
        CHANGED_DATA_IMAGES        = (1 << 9),
        CHANGED_DATA_LYRICS        = (1 << 10),
        CHANGED_DATA_RATING        = (1 << 11),
        CHANGED_DATA_PLAYCOUNT     = (1 << 12),
        CHANGED_COMPOSER_TAG       = (1 << 13),
        CHANGED_TRACK_LABELS       = (1 << 14),
        CHANGED_ARTIST_LABELS      = (1 << 15),
        CHANGED_ALBUM_LABELS       = (1 << 16),
        CHANGED_IS_COMPILATION_TAG = (1 << 17),
        /* added for video */
        CHANGED_BITRATE_TAG        = (1 << 18),
        CHANGED_DURATION_TAG       = (1 << 19),
        CHANGED_EPISODE_TAG        = (1 << 20),
        CHANGED_VIDEOCODEC_TAG     = (1 << 21),
        CHANGED_AUDIOCODEC_TAG     = (1 << 22),
        CHANGED_CONTAINERFORMAT_TAG= (1 << 23),
        CHANGED_LANGUAGECODE_TAG   = (1 << 24),
        CHANGED_COPYRIGHT_TAG      = (1 << 25),
        CHANGED_ENCODER_TAG        = (1 << 26),
        CHANGED_WIDTH_TAG          = (1 << 27),
        CHANGED_HEIGHT_TAG         = (1 << 28),
        CHANGED_MPEGVERSION_TAG    = (1 << 29),
        CHANGED_PROFILE_TAG        = (1 << 30),
        CHANGED_LEVEL_TAG          = (1 << 31),
        CHANGED_ENCODINGTIME_TAG   = (1LL << 32)
        //CHANGED_FRAMERATE_TAG      = (1 << 32)
    };

    //Flag to indicate Yomidata is set
    enum ChangedYomiData
    {
        CHANGED_YOMIDATA_NONE         = 0,
        CHANGED_YOMITITLE_TAG         = (1 << 0), //1
        CHANGED_YOMIARTIST_TAG        = (1 << 1), //10
        CHANGED_YOMIALBUM_TAG         = (1 << 2)  //100
    };
}


inline StringList split(const String str, const String &separator) {
    return StringList::split(str, separator);
}


inline String format(const char* fmt, ...) {
    char buffer[BUFFERSIZE] = {'\0'};
    va_list vl;
    va_start(vl, fmt);
    int nsize = vsnprintf(buffer, BUFFERSIZE, fmt, vl);
    if(nsize < 0) {
        cout << "Error: String allocation failed in taginfo format function." << endl;
        va_end(vl);
        String ret = String("");
        return ret;
    }
    else {
        va_end(vl);
        String ret(buffer);
        return ret;
    }
}


inline string dirname_of(const string& fname) {
     size_t pos = fname.find_last_of("\\/");
     return (string::npos == pos) ? "" : fname.substr(0, pos);
}


inline void find_and_replace(string& source, const string& find, const string& replace) {
    size_t fLen = find.size();
    size_t rLen = replace.size();

    for(size_t pos = 0; (pos = source.find(find, pos)) != source.npos; pos += rLen) {
        source.replace(pos, fLen, replace);
    }
}


inline int popularity_to_rating(const int rating) {
    if(rating < 0)
        return 0;
    if(rating == 0)
        return 0;
    if(rating < 64)
        return 1;
    if(rating < 128)
        return 2;
    if(rating < 192)
        return 3;
    if(rating < 255)
        return 4;
    return 5;
}


inline int wm_rating_to_rating(const int rating) {
    if(rating <= 0)
        return 0;
    if(rating < 25)
        return 1;
    if(rating < 50)
        return 2;
    if(rating < 75)
        return 3;
    if(rating < 99)
        return 4;
    return 5;
}

inline int rating_to_popularity(const int rating) {
    int Ratings[] = { 0, 0, 1, 64, 128, 192, 255 };
    return Ratings[rating + 1];
}



////////// APE

void check_ape_label_frame(TagLib::APE::Tag * apetag, const char * description, const String &value);

bool get_ape_item_image(const TagLib::APE::Item &item, char*& data, int &data_length, ImageType &image_type);
bool get_ape_image(TagLib::APE::Tag * apetag, char*& data, int &data_length, ImageType &image_type);
bool set_ape_image(TagLib::APE::Tag * apetag, const char* data, int data_length, ImageType image_type);

String get_ape_lyrics(APE::Tag * apetag);
bool set_ape_lyrics(APE::Tag * apetag, const String &lyrics);

////////// end APE



//////////ID3

void id3v2_check_label_frame(ID3v2::Tag * tagv2, const String& description, const String &value);

String get_typed_id3v2_image(char*& idata, int &idata_length,TagLib::ID3v2::FrameList &framelist,
                             TagLib::ID3v2::AttachedPictureFrame::Type frametype);

bool get_id3v2_image(ID3v2::Tag * tagv2, char*& data, int &data_length, ImageType &image_type);
void set_id3v2_image(ID3v2::Tag * tagv2, const char* data, int data_length, ImageType image_type);
bool get_id3v2_image_all(ID3v2::Tag * tagv2, char*& data, int &data_length, ImageType &image_type);
bool get_id3v2_image_frontcover(ID3v2::Tag * tagv2, char*& data, int &data_length, ImageType &image_type);

String get_id3v2_lyrics(ID3v2::Tag * tagv2);
void set_id3v2_lyrics(ID3v2::Tag * tagv2, const String &lyrics);

TagLib::ID3v2::PopularimeterFrame * get_popularity_frame(TagLib::ID3v2::Tag * tag,
                                                         const TagLib::String &email);
//Get user text from yomi frame with the given description
String get_id3v2_user_text_frame(ID3v2::Tag * taglib_tagId3v2, const String& description);

////////// end ID3




////////// MP4

bool get_mp4_cover_art(TagLib::MP4::Tag * mp4tag, char*& data, int &data_length, ImageType &image_type);
bool set_mp4_cover_art(TagLib::MP4::Tag * mp4tag, const char* data, int data_length, ImageType image_type);

String get_mp4_lyrics(TagLib::MP4::Tag * mp4tag);
bool set_mp4_lyrics(TagLib::MP4::Tag * mp4tag, const String &lyrics);

////////// end MP4



////////// XIPH

String get_xiph_comment_lyrics(Ogg::XiphComment * xiphcomment);
bool set_xiph_comment_lyrics(Ogg::XiphComment * xiphcomment, const String &lyrics);

void check_xiph_label_frame(Ogg::XiphComment * xiphcomment,
                                 const char * description,
                                 const String &value);

bool get_xiph_comment_cover_art(Ogg::XiphComment * xiphcomment,
                                char*& data, int &data_length,
                                ImageType &image_type);
bool set_xiph_comment_cover_art(Ogg::XiphComment * xiphcomment,
                                const char* data, int data_length,
                                ImageType image_type);

////////// end XIPH




