/***************************************************************************
 *
 * Copyright (c) 2015 Advanced Driver Information Technology.
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#ifndef ICONFIGURATOR_H_
#define ICONFIGURATOR_H_

class ICommandExecutor;

/**
 * Abstract Base Class for all Configuration to provide a configuration at runtime
 */
class IConfigurator
{
public:
    /**
     * constructor: any configurator needs an executor for commands
     * @param executor Pointer to an object to send commands to
     */
    IConfigurator(ICommandExecutor* executor);
    virtual ~IConfigurator() {}

    /**
     * this method will be called on LayerManager startup
     * to reconfigure the LayerManagerService at runtime this will happen before loading
     * other plugins and it is useful if the setting cannot be stored in the root file system
     * persistently.
     */
    virtual bool configure() = 0;

protected:
    ICommandExecutor* m_executor;
};

inline IConfigurator::IConfigurator(ICommandExecutor* executor)
: m_executor(executor)
{
}



#endif /* ICONFIGURATOR_H_ */
