/*
 * jsonUtil.h
 *
 *  Created on: Sept 19, 2018
 *      Author: fgr2hi
 */
#ifndef JSON_UTIL_H_
#define JSON_UTIL_H_

#include "json.h"
#include "../ai_osal_linux/components/system/system_types.h"  // ??? has to change!!!

/*
   == response from VMM ==
// sent
"TimeStamp":"2016-07-27T09:37:14Z",
"ValetMode/Sent/Notification/Status":1,
"ValetMode/Sent/Notification/Method":"PROFILE",
"ValetMode/Sent/Notification/ErrorCode":1 
// receive
"ValetMode/Received/RemoteOrder/Action"
 */

class JsonObj {
private:
	Json::Value root;
	Json::Reader reader;		

public:
	// static const:
	// -------------- HEADER ----------------
	static const std::string TARGETID;
	static const std::string DEVID;
	static const std::string VIN;
	static const std::string CORRELATIONID;
	static const std::string USERID;
	static const std::string TOKEN;
	static const std::string DEVICETYPE;
	static const std::string UPLOADFUNCTIONID;

	// --------------  DATA  ----------------
	static const std::string STATUS;
	static const std::string ERROR;
	static const std::string METHOD;
	static const std::string TIMESTAMP;
	static const std::string ACTION;
	static const std::string VERSION;


	JsonObj(tVoid){};
	/*
  // copy constructor and assignment operator
  JsonObj(const JsonObj &jo){
		root = jo.root;
		reader = jo.reader;
  } 
  // assignment operator
  JsonObj& operator=(JsonObj other){
		root = other.root;
		reader = other.reader;
  }
	 */
	~JsonObj(tVoid){};
	//tBool parsingsuccessful = reader.parse(data, root);	
	tBool parse( const std::string &document);
	tBool isMember(const std::string &key);
	tU32 getIntValue(const std::string &key);
	std::string getStringValue(const std::string &key);

	tVoid setIntValue(const std::string &key, tU32 val);
	tVoid setStringValue(const std::string &key, std::string val);

	std::string getJsonString(tVoid);
};

#endif /* JSON_UTIL_H_ */
