/*
 * fc_dumm_JSONParser.h
 *
 *
 *
 */

#ifndef FC_DUMM_JSONPARSER_H_
#define FC_DUMM_JSONPARSER_H_

#define SYSTEM_S_IMPORT_INTERFACE_QUEUE
#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include "stl_pif.h"

#include "I_fc_dumm_JSONParser.h"
#include "fc_dumm_ULBuffer.h"

class I_fc_dumm_ConfigPolicy;
class I_fc_dumm_P_DP_Handler;
class I_fc_dumm_ConfigManager;

class fc_dumm_JSONParser: public I_fc_dumm_JSONParser {
private:
	I_fc_dumm_ConfigPolicy* _poConfigPolicy;
	I_fc_dumm_ConfigManager *_poConfigManager;

	tBool m_bConvertLabel;

public:
	fc_dumm_JSONParser(fc_dumm_tclAppMain* poMainAppl);
	~fc_dumm_JSONParser();

	virtual tVoid vHandleMessage(fc_dumm_tclBaseIf::TMsg* pMsg){ (tVoid)pMsg;}
	virtual tVoid vHandleTraceMessage(const tUChar* puchData){(tVoid)puchData;}
	virtual tVoid vGetReferences();
	virtual tVoid vStartCommunication();
	virtual tVoid vTraceInfo(){};
	virtual const tChar* getName() const { return "fc_dumm_JSONParser"; };

	tBool bParseApplicationHeader(Json::Value& root,T_ApplicationHeader& oChannelData);
	tBool bParseApplicationHeader(Json::Value root, Json::Value& jApplicationHeader);
	tBool bParseApplicationData(Json::Value root, Json::Value& jApplicationData);
	tBool bParseTargetID(Json::Value & root, std::string& strTargetID);
	tBool bParseCorrelationID(Json::Value & root, std::string& strCorrelationID);
	tBool bParseGlobalMessageId(Json::Value & root, std::string& strGlobalMessageId);
	tBool bParseMessageType(Json::Value & root, std::string& strMessageType);
	tBool bParseDataDictionaryVersion(Json::Value & root, std::string& strDataDictionaryVersion);
	///
	tBool bParseUploadHeader(Json::Value& root, T_UploadHeader& oChannelData);

	//convert long-short label
	tBool bShortToLongLabel(Json::Value jShortData, Json::Value& jLongData);
	tBool bLongToShortLabel(Json::Value jLongData, Json::Value& jShortData);
	tVoid vSetConvertLabel(tBool value);

	//Check Data of ApplicationHeader
	tBool CheckDataApplicationHeader(T_ApplicationHeader oChannelData);
	//Check Data of ApplicationData
	tBool CheckDataApplicationData(Json::Value& root);
	tBool CheckActionFieldOnDataWipe(Json::Value& root);
};

#endif /* FC_DUMM_JSONPARSER_H_ */
