/*
 * aud_gio_dbus_handler.cpp
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#include "LcmDBusProxy/aud_dbus_lcm_handler.h"

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/aud_dbus_lcm_handler.cpp.trc.h"
#endif

#include "LcmDBusProxy/aud_dbus_lcm_bus_watcher.h"
#include "LcmDBusProxy/aud_dbus_lcm_proxy.h"

#include "CAmControlSenderBase.h"

using namespace bpstl;

/**
* Default constructor
*/
aud_dbus_lcm_handler::aud_dbus_lcm_handler(CAmControlSenderBase& controlSenderBase, am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive)
:m_pWatcher(NULL)
,m_pProxy(NULL)
,m_poLoop(NULL)
,m_threadid(0)
,m_receiverShadow(receiverShadow)
,m_ControlReceive(controlReceive)
,m_ControlSenderBase(controlSenderBase)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_handler, Constructor."));
}

/**
* Destructor
*/
aud_dbus_lcm_handler::~aud_dbus_lcm_handler()
{
  vDeInit();
}
/**
* Helper function to initialize
*/
bool aud_dbus_lcm_handler::bInit()
{
  ETG_TRACE_USR4(("aud_dbus_lcm_handler::bInit Invoked "));

  //Create a bus watcher object
  if(m_pWatcher == NULL)
  {
    m_pWatcher = new aud_dbus_lcm_bus_watcher(G_BUS_TYPE_SYSTEM);
    if(!m_pWatcher)
    {
      ETG_TRACE_ERR(("CMD_AUDIO, aud_dbus_lcm_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }
  if(m_pProxy == NULL)
  {
    m_pProxy = new aud_dbus_lcm_proxy(m_pWatcher,G_BUS_TYPE_SYSTEM,m_ControlSenderBase,m_receiverShadow,m_ControlReceive);
    if(!m_pProxy)
    {
      ETG_TRACE_ERR(("CMD_AUDIO, aud_dbus_lcm_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }
  if(m_poLoop == NULL)
  {
    m_poLoop = g_main_loop_new(NULL,FALSE);
    if(!m_poLoop)
    {
      ETG_TRACE_ERR(("CMD_AUDIO, aud_dbus_lcm_handler::bInit OUT OF MEMORY "));
      return false;
    }
  }
  if(m_threadid == 0)
  {
    if(0 == pthread_create(&m_threadid,NULL,aud_dbus_lcm_handler::pThreadEntry,this))
    {
      //Thread created successfully
    }
    else
    {
      //Failed to create thread
      //ETG_TRACE_ERR(("CMD_AUDIO, aud_dbus_lcm_handler::bInit FAILED TO CREATE THREAD ! ! ! "));
      m_threadid = 0;
      return false;
    }
  }

  return true;
}

/**
* Helper function to deinitilaize
*/
void aud_dbus_lcm_handler::vDeInit()
{
  //ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit Invoked "));
  //Stop Mainloop First
  if(m_poLoop)
  {
    //ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit Deinitializing main loop "));
    g_main_loop_quit(m_poLoop);//Stop mainloop
    //Wait for mainloop to stop completely using thread join
    if(m_threadid)
    {
      ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit, Waiting for Thread Join "));
      pthread_join(m_threadid,NULL);
      ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit, Thread Joined "));
      m_threadid = 0;
    }
    g_main_loop_unref(m_poLoop);//Release reference
    m_poLoop = NULL;
  }
  //Delete Proxy
  if(m_pProxy)
  {
    ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit Deleting Proxy "));
    delete m_pProxy;
    m_pProxy = NULL;
  }
  //Delete Bus watcher
  if(m_pWatcher)
  {
    ETG_TRACE_USR4(("aud_dbus_lcm_handler::vDeInit Deleting Bus Watcher "));
    delete m_pWatcher;
    m_pWatcher = NULL;
  }
}
/**
* Thread entry function
*/
void* aud_dbus_lcm_handler::pThreadEntry(void* pvarg)
{
  ETG_TRACE_USR4(("aud_dbus_lcm_handler::pThreadEntry Worker Thread Started "));
  if(!pvarg)
    return NULL;
  aud_dbus_lcm_handler* self = (aud_dbus_lcm_handler*)pvarg;
  if(self->m_poLoop)
  {
    g_main_loop_run(self->m_poLoop);
  }
  ETG_TRACE_USR4(("aud_dbus_lcm_handler::pThreadEntry Worker Thread Stopped "));
  return NULL;
}

