/*
 * aud_dbus_lcm_bus_watcher.cpp
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#include "controllerplugin_Trace.h"
#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_AMCONTROLLERPLUGIN
#include "trcGenProj/Header/aud_dbus_lcm_bus_watcher.cpp.trc.h"
#endif

#include "LcmDBusProxy/aud_dbus_lcm_handler.h"

#include "LcmDBusProxy/aud_dbus_lcm_bus_watcher.h"
using namespace std;


/**
 * Default constructor
 */
aud_dbus_lcm_bus_watcher::aud_dbus_lcm_bus_watcher(GBusType bus_type)
:m_bus_type(bus_type)
,m_bus_name_notification_table()
{
  ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : Creating for Bus Type: %d",bus_type));
  //Set the mutex attributes to recursive
  pthread_mutexattr_t Attr;
  pthread_mutexattr_init(&Attr);
  pthread_mutexattr_settype(&Attr, PTHREAD_MUTEX_RECURSIVE);
  pthread_mutex_init(&m_bus_name_notification_table_lock, &Attr);//Setting the mutex to recursive to get rid of silly deadlock issues
}
/**
 * Unregister all watchers in destructor
 */
aud_dbus_lcm_bus_watcher::~aud_dbus_lcm_bus_watcher()
{
  pthread_mutex_lock(&m_bus_name_notification_table_lock);
  for(std::map<std::string,aud_dbus_lcm_bus_watch_data>::iterator it = m_bus_name_notification_table.begin();
      it != m_bus_name_notification_table.end();
      it++)
  {
    g_bus_unwatch_name(it->second.handle);
  }
  m_bus_name_notification_table.clear();
  pthread_mutex_unlock(&m_bus_name_notification_table_lock);

  ETG_TRACE_USR3(("aud_dbus_lcm_bus_watcher : Destroyed"));
}
/**
 * Function triggered by clients to register for notifications of a bus name
 */
bool aud_dbus_lcm_bus_watcher::bRegisterNotifyBusName(const char* busname,aud_dbus_lcm_bus_watcher_IF* pCallback)
{
  if((busname == NULL)||(pCallback == NULL))
  {
    ETG_TRACE_FATAL(("bRegisterNotifyBusName : Both the pointers cant be NULL, Registration Failed"));
    return false;
  }

  ETG_TRACE_USR3(("aud_dbus_lcm_bus_watcher : Watching for Bus Name : %s",busname));
  bool bretval = false;
  string s1 = busname;

  aud_dbus_lcm_bus_watch_data oTmp;

  pthread_mutex_lock(&m_bus_name_notification_table_lock);
  //Check if the bus type exists
  if(m_bus_name_notification_table.find(s1) == m_bus_name_notification_table.end())
  {
    oTmp.pCallbackIF = pCallback;
    oTmp.handle = g_bus_watch_name( m_bus_type,
                    busname,
                    G_BUS_NAME_WATCHER_FLAGS_NONE,
                    aud_dbus_lcm_bus_watcher::on_name_appeared,
                    aud_dbus_lcm_bus_watcher::on_name_vanished,
                    this,
                    NULL);
    m_bus_name_notification_table[s1] = oTmp;
    bretval = true;
  }

  pthread_mutex_unlock(&m_bus_name_notification_table_lock);
  return bretval;
}
/**
 * Helper function to unregister for notifications
 */
void aud_dbus_lcm_bus_watcher::vUnRegisterNotifyBusName(const char* busname)
{
    try
    {
        if(busname)
        {
            string s1 = busname;
            pthread_mutex_lock(&m_bus_name_notification_table_lock);
            std::map<std::string,aud_dbus_lcm_bus_watch_data>::iterator it = m_bus_name_notification_table.find(busname);
            if(it != m_bus_name_notification_table.end())
            {
                g_bus_unwatch_name(it->second.handle);
                //Erase content
                m_bus_name_notification_table.erase(it);
            }
            pthread_mutex_unlock(&m_bus_name_notification_table_lock);

            ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : Stopped Watching for Bus Name : %s",busname));
        }
    }
    catch (std::bad_alloc& ba)
    {
        //CID 4626537
        pthread_mutex_unlock(&m_bus_name_notification_table_lock);
        ETG_TRACE_ERR(("CMD_AUDIO, aud_gio_dbus_bus_watcher:vUnRegisterNotifyBusName bad_alloc caught : %s",ba.what()));
    }
}
/**
 * Function triggered by glib mainloop when the desired bus name appears
 */
void aud_dbus_lcm_bus_watcher::on_name_appeared(GDBusConnection * connection,
       const gchar *ptrname,
       const gchar * /*name_owner*/,
       gpointer user_data)
{
  if((user_data == NULL)||(ptrname == NULL))
  {
    return;
  }
  ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : on_name_appeared, %s",ptrname));
  string busname = ptrname;
  aud_dbus_lcm_bus_watcher* self = (aud_dbus_lcm_bus_watcher*) user_data;

  aud_dbus_lcm_bus_watcher_IF* x = NULL;

  ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : lock m_bus_name_notification_table_lock"));
  pthread_mutex_lock(&self->m_bus_name_notification_table_lock);
  std::map<std::string,aud_dbus_lcm_bus_watch_data>::iterator it = self->m_bus_name_notification_table.find(busname);
  if(it != self->m_bus_name_notification_table.end())
  {

    x = it->second.pCallbackIF;
  }
  pthread_mutex_unlock(&self->m_bus_name_notification_table_lock);
  ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : unlocked m_bus_name_notification_table_lock"));

  if(x)
  {
    //Invoke the callback
    ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : vOnServerAvailable call"));
    x->vOnServerAvailable(connection);
  }
}

/**
 * Function triggered by glib mainloop when the desired bus name disappears
 */
void aud_dbus_lcm_bus_watcher::on_name_vanished(GDBusConnection */*connection*/,
       const gchar *ptrname,
       gpointer user_data)
{
  if((user_data == NULL)||(ptrname == NULL))
  {
    return;
  }
  ETG_TRACE_USR3(("aud_gio_dbus_bus_watcher : on_name_vanished, %s",ptrname));
  string busname = ptrname;
  aud_dbus_lcm_bus_watcher* self = (aud_dbus_lcm_bus_watcher*) user_data;

  aud_dbus_lcm_bus_watcher_IF* x = NULL;

  pthread_mutex_lock(&self->m_bus_name_notification_table_lock);
  std::map<std::string,aud_dbus_lcm_bus_watch_data>::iterator it = self->m_bus_name_notification_table.find(busname);
  if(it != self->m_bus_name_notification_table.end())
  {
    x = it->second.pCallbackIF;
  }
  pthread_mutex_unlock(&self->m_bus_name_notification_table_lock);

  if(x)
  {
    //Invoke the callback
    x->vOnServerUnAvailable(busname);
  }
}
