/*
 * clGeniviAudioSource.cpp
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 *
 */

#include "include/audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/clGeniviAudioCtrlAdapter.h"
#include "AudioStack/SMT/clSrcStateFactory.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"

using namespace am;

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clGeniviAudioSource.cpp.trc.h"
#endif

namespace AudioStack
{
namespace AudioSource
{

using namespace SourceStateMachine;

   clGeniviAudioSource::clGeniviAudioSource(SourceID srcId) :
      clAudioSource(srcId),
      m_gam_handle(new am_Handle_s()),
      m_gam_connectionId(0)
   {
      const clSourceClass& srcClass = clFactory_AudioSourceClass::GetSourceClass(srcId.enSourceClass);

      am_SourceClass_s am_SrcClass;
      am_sourceClass_t srcClassID = static_cast<am_sourceClass_t>(srcId.enSourceClass);
      am_SrcClass.sourceClassID = srcClassID;
      am_SrcClass.name          = srcClass.getName();
      //This will fail for dynamic sources (
      clGeniviAudioCtrlAdapter::addSourceClass(am_SrcClass, srcClassID);

      m_gam_source_s.domainID = clGeniviAudioCtrlAdapter::GetDomainID();

      m_gam_source_s.available.availability = A_AVAILABLE;

      m_gam_source_s.available.availabilityReason = AR_UNKNOWN;
      //TODO
      //move this to configuration -> StackRules Table!?

      //quickly avoid compiler warning
      //TODO make this more beautiful -> maybe in configuration!?
      am_MainSoundProperty_s msp = {MSP_MIC_STATUS_CONNECTION,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp);
      am_MainSoundProperty_s msp_A = {MSP_MIC_STATUS_LEVEL,0};
      m_gam_source_s.listMainSoundProperties.push_back(msp_A);

      m_gam_source_s.name = srcClass.getName();
      m_gam_source_s.sourceID = 0;
    m_gam_source_s.visible = true;
      if(srcClass.getRegistrationMode() == clSourceClass::registerStatic)
      {
         //For static source we'll provide a SourceID
         m_gam_source_s.sourceID = static_cast<am_sourceID_t>(srcClass.SourceClassID); //take fixed ids to make thins easy
         am_Availability_s sAvail;
         sAvail.availabilityReason = AR_UNKNOWN;
         sAvail.availability = A_AVAILABLE;
         m_gam_source_s.available = sAvail;
      }

      //only when SubIDs are used we'll register with SubID(alias DeviceTag) as Genivi Name
      if((srcClass.getRegistrationMode() == clSourceClass::registerDynamic) && (srcClass.bSupressSubSource == false))
      {
         //m_gam_source_s.sourceID = 0; //moved above to ensure it for all dynamic sources. Otherwise it might crash due to assert in Daemon.
         const tU16 n = (tU16)snprintf(NULL, 0, "#%d", srcId.u16SubSource);
         //ASSERT_NORMAL(n > 0)
         char buf[n+1];

     //VVD lint fix
     memset(buf,0,sizeof(buf));

     //VVD lint fix
     (void)snprintf(buf, n+1, "#%d", srcId.u16SubSource);

         //assert(buf[n] == '\0');
         //assert(c == n);
         m_gam_source_s.name.append(buf);
      }
      ETG_TRACE_USR4(("clGeniviAudioSource: Name %s", m_gam_source_s.name.c_str()));
      delete[] m_pacName;
      char *cstr = new char[m_gam_source_s.name.length() + 1];

    //VVD lint fix
    if(cstr){
      strcpy(cstr, m_gam_source_s.name.c_str());
      m_pacName = cstr;
    }
    ETG_TRACE_USR4(("clAudioSource: Changed Name %s", clAudioSource::pacGetName()));
      m_gam_source_s.sourceState = SS_OFF;
      m_gam_source_s.sourceClassID = srcId.enSourceClass;
      m_gam_source_s.volume = 0;
      m_gam_source_s.listConnectionFormats.push_back(CF_GENIVI_STEREO);
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_CONNECTION,0});
      // item.listMainSoundProperties.push_back(am_MainSoundProperty_s{MSP_MIC_STATUS_LEVEL,0});

      m_gam_source_s.sourceID = clGeniviAudioCtrlAdapter::AddSource(m_SrcId, m_gam_source_s);
      ETG_TRACE_USR4(("clAudioSource: SourceClass: %d subID %d, GeniviID %d, Name %s"
            , m_SrcId.enSourceClass
            , (tU16)m_SrcId.u16SubSource
            , m_gam_source_s.sourceID
            , clAudioSource::pacGetName()));
   }

   clGeniviAudioSource::~clGeniviAudioSource()
   {
      clGeniviAudioCtrlAdapter::RemoveSource(m_gam_source_s.sourceID);
      delete(m_gam_handle);
   }

   void clGeniviAudioSource::vPrint()
   {
     ETG_TRACE_USR4(("%s", m_pacName));
     ETG_TRACE_USR4(("  | SourceClass: 0x%02x(%03d), SubID 0x%02x(%03d),"
         , m_SrcId.enSourceClass
         , m_SrcId.enSourceClass
         , m_SrcId.u16SubSource
         , m_SrcId.u16SubSource));
     ETG_TRACE_USR4(("  | MidwID 0x%02x(%03d)"
         , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())
         , (tU16)clFactory_AudioSourceClass::GetExternalID(sGetId())));
     ETG_TRACE_USR4(("  | GeniviSrcID 0x%02x(%03d)"
         , m_gam_source_s.sourceID
         , m_gam_source_s.sourceID));

   //daw2hi: 8.8.2016 print only for sink 1
   const tChar* pStateName = pacGetState(1);
   ETG_TRACE_USR2(("  | State: %d (%s)"
         , ETG_CENUM(AudioStates::enAudioStates, pclGetState(1)->m_enStateID),pStateName));

   ETG_TRACE_USR4(("  | State: %d", ETG_CENUM(AudioStates::enAudioStates, m_pclState->m_enStateID)));
   ETG_TRACE_USR4(("  | Availability: %d", ETG_CENUM(clAudioSource::enSourceAvailability, m_availability)));
   ETG_TRACE_USR4(("  | AutoPlay: %d", ETG_CENUM(clSourceClass::autoplay_t, clFactory_AudioSourceClass::GetAutoPlayMode(sGetId()))));
   ETG_TRACE_USR4(("                "));
}

tVoid clGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity)
{
   tU8 sinkID = 1;
   // use m_curActSinkID instead ??
   ETG_TRACE_ERR(("CMD_AUDIO, called vMW_CCAResponse without SinkID, using SinkID 1"));
   vMW_CCAResponse(extSourceId,subSrc,activity, sinkID);
}

   // daw2hi we need the sinkID also to identify for which sink the CCA Response was called
   tVoid clGeniviAudioSource::vMW_CCAResponse(tS32 extSourceId, tU16 subSrc, enSourceActivity activity, tU16 sinkID)
   {
    //VVD lint fix
    if(NULL == m_gam_handle)
       return;

   //SourceStateMachine::clSrcState* clActSrcState = pclGetState(m_curActSinkID);
   SourceStateMachine::clSrcState* clActSrcState = pclGetState(sinkID);

    // daw2hi: ToDo get the clActSrcState based on the sinkID we get
//    if(m_curActSinkID<=1) clActSrcState = m_pclState;
//    else clActSrcState = m_pclStateRSE;

   ETG_TRACE_USR2(("vMW_CCAResponse: Ext-SourceID: %d, SubID: %d Activity: %d Sink %d", extSourceId, subSrc, activity, sinkID));
   switch(activity)
   {
      case clGeniviAudioSource::On:
         ETG_TRACE_USR4(("vMW_CCAResponse: On"));
         if( clActSrcState == clSrcStateFactory::pclCreateRampUpRequesting())
         {
            clGeniviAudioCtrlAdapter::connect((*m_gam_handle), m_gam_connectionId,
                  CF_GENIVI_STEREO,
                  m_gam_source_s.sourceID,
                  static_cast<am_sinkID_t>(sinkID));

            //25.07.2016 daw2hi check if we have already an ON
            tBool bAlreadyOn = false;
            for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
            {
               if((it->first != sinkID) && (it->second == SS_ON))
               {
                  bAlreadyOn = true;
                  break;
               }
            }
            if(!bAlreadyOn)
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_ON);
            std::vector<am_connectionID_t> connectionList;
            connectionList.push_back(m_gam_connectionId);
            clGeniviAudioCtrlAdapter::changeMainConnectionRouteDB(m_gam_source_s.sourceID, connectionList);
            clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID),CS_CONNECTED);

            vSetCurActSink(sinkID); //daw2hi 21.07.2016
            m_logicalSourceStates[sinkID]=SS_ON; //22.07.2016

            vMW_OnDone(sinkID);
         }
         break;
      case clGeniviAudioSource::Pause:
         if( clActSrcState == clSrcStateFactory::pclCreateRampDownToPause())
         {
            //25.07.2016 daw2hi check if we have already an ON
            tBool bAnotherOn = false;
            for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
            {
               if((it->first != sinkID) && (it->second == SS_ON))
               {
                  bAnotherOn = true;
                  break;
               }
            }
            if(!bAnotherOn)
               // All of them are synchronously
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_PAUSED);

               //VVD need not to disconnect,
               //clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);

            //VVD need not to remove, change it to CS_SUSPENDED
            //clGeniviAudioCtrlAdapter::removeMainConnectionDB(m_u8Id);
            clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID, static_cast<am_sinkID_t>(sinkID), CS_SUSPENDED);

            vSetCurActSink(sinkID); //daw2hi 21.07.2016
            m_logicalSourceStates[sinkID]=SS_PAUSED; //22.07.2016
            vMW_PauseDone(sinkID);


            }
            break;
         case clGeniviAudioSource::Off:
            if(  (clActSrcState == clSrcStateFactory::pclCreateRampDownToOff())
               ||(clActSrcState == clSrcStateFactory::pclCreateOff()))
         {
            //25.07.2016 daw2hi check if we have already an ON
            tBool bAnotherOn = false;
            for(std::map<tU16,am_SourceState_e>::iterator it = m_logicalSourceStates.begin(); it != m_logicalSourceStates.end();++it)
            {
               if((it->first != sinkID) && (it->second == SS_ON))
               {
                  bAnotherOn = true;
                  break;
               }
            }
            if(!bAnotherOn)
               clGeniviAudioCtrlAdapter::setSourceState(*m_gam_handle, m_gam_source_s.sourceID, SS_OFF);

            clGeniviAudioCtrlAdapter::disconnect(*m_gam_handle, m_gam_connectionId);
            clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(sinkID));
            vSetCurActSink(sinkID); //daw2hi 21.07.2016
            m_logicalSourceStates[sinkID]=SS_OFF; //22.07.2016
            vMW_OffDone(sinkID);
         }
         break;
      default:
         break;
   }
}

   tVoid clGeniviAudioSource::vMW_Pause(SourceID possibleNextSrc)
   {
    ETG_TRACE_USR3(("clGeniviAudioSource::vMW_Pause()"));
    am_mainConnectionID_t mainConnectionID;
      clSourceClass::externalID extID = clFactory_AudioSourceClass::GetSourceClass(possibleNextSrc.enSourceClass).getExtID();
      clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
//      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
//      int extID = clStackRules::rules[ruleIndex].externalID;
    //Check if we have a MainConnection
      if(clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, mainConnectionID) != E_OK)
      {
         ETG_TRACE_USR3(("vMW_Pause(): Add MainConnection for Source %d", m_gam_source_s.sourceID));
         //e.g. restore LSM we need to add a connection initiation by our own
         am_Error_e retVal = clGeniviAudioCtrlAdapter::addMainConnection(m_gam_source_s.sourceID);
         if(retVal != E_OK)
         {
            ETG_TRACE_ERR(("CMD_AUDIO, vMW_Pause(): ERROR %d Add MainConnection for Source %d"
                  , ETG_CENUM(am::am_Error_e, retVal)
                  , m_gam_source_s.sourceID));
         }
      }
      ETG_TRACE_USR2(("GAS vMW_Pause: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d"
                  , sGetId().enSourceClass
                  , sGetId().u16SubSource
                  , myExtID
                  , possibleNextSrc.enSourceClass
                  , possibleNextSrc.u16SubSource));

      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
                                                     , m_SrcId.u16SubSource
                                                     ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
                                                     ,midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE
                                                     ,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (m_curActSinkID));
   }

   tVoid clGeniviAudioSource::vMW_Off(SourceID possibleNextSrc)
   {
      clSourceClass::externalID extID = clFactory_AudioSourceClass::GetSourceClass(possibleNextSrc.enSourceClass).getExtID();
      clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
//      int ruleIndex = clStackRules::ruleIndex(possibleNextSrc);
//      int extID = clStackRules::rules[ruleIndex].externalID;
      ETG_TRACE_USR2(("GAS vMW_Off: SourceClass: %d subID %d, ExtId %d, PNSClass %d PNSsubID %d PNSextID %d"
            , sGetId().enSourceClass
            , (tU16)sGetId().u16SubSource
            , myExtID
            , possibleNextSrc.enSourceClass
            , possibleNextSrc.u16SubSource
            , extID));

      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
                                                     , m_SrcId.u16SubSource
                                                     ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (extID)
                                                     ,midw_fi_tcl_e8_SrcActivity::FI_EN_OFF
                                                     ,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (m_curActSinkID));
      clGeniviAudioCtrlAdapter::changeMainConnectionStateDB(m_gam_source_s.sourceID,static_cast<am_sinkID_t>(m_curActSinkID),CS_DISCONNECTING);
   }

   tVoid clGeniviAudioSource::vMW_On()
   {
      ETG_TRACE_USR4(("clGeniviAudioSource::vMW_On()"));
      am_mainConnectionID_t mainConnectionID;
      clSourceClass::externalID myExtID = clFactory_AudioSourceClass::GetSourceClass(sGetId().enSourceClass).getExtID();
      //Check if we have a MainConnection
      if(clGeniviAudioCtrlAdapter::getMainConnectionOfSource(m_gam_source_s.sourceID, m_curActSinkID, mainConnectionID) != E_OK)
      {
         ETG_TRACE_USR2(("vMW_On(): Add MainConnection for Source %d, Sink %d", m_gam_source_s.sourceID, m_curActSinkID));
         //e.g. restore LSM we need to add a connection initiation by our own
         am_Error_e retVal = clGeniviAudioCtrlAdapter::addMainConnection(m_gam_source_s.sourceID,m_curActSinkID);
         if(retVal != E_OK)
         {
            ETG_TRACE_ERR(("CMD_AUDIO, vMW_On(): ERROR %d Add MainConnection for Source %d"
                  , ETG_CENUM(am::am_Error_e, retVal)
                  , m_gam_source_s.sourceID));
         }
      }
      // call connect to Genivi AudioManager

      clGeniviAudioCtrlAdapter::SourceActivityRequest(static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
                                                           , m_SrcId.u16SubSource
                                                           ,static_cast<midw_fi_tcl_e8_AudSource::tenType> (myExtID)
                                                           ,midw_fi_tcl_e8_SrcActivity::FI_EN_ON
                                                           ,static_cast<midw_fi_tcl_e8_ResourceNo::tenType> (m_curActSinkID));
   }

   void clGeniviAudioSource::vReset()
   {
      ETG_TRACE_USR1(("vReset: Reset SourceClass: %d subID %d "
            , m_SrcId.enSourceClass
            , m_SrcId.u16SubSource));
      //TODO
      //remove Genivi Connections
      //remove Genivi MainConnection
      //ToDo consider also all connected sinks
      clGeniviAudioCtrlAdapter::removeMainConnection(m_gam_source_s.sourceID);
      //finally call reset within base class
      clAudioSource::vReset();
   }

   clAudioSource::enSourceAvailability clGeniviAudioSource::mapAvailability(am_Availability_e avail)
   {
      enSourceAvailability retVal = unkonwn;
      switch(avail)
      {
         case A_AVAILABLE:
            retVal = available;
            break;
         case A_UNAVAILABLE:
            retVal = not_available;
            break;
         case A_UNKNOWN:
            retVal = unkonwn;
            break;
         default:
            ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in m_gam_source_s.available.availability: %d",
                  avail));
            break;
      }
      return retVal;
   }

   am_Availability_e clGeniviAudioSource::mapAvailability(clAudioSource::enSourceAvailability avail)
   {
      for(tU16 i = static_cast<tU16>(A_MAX)-1; i!=0; --i)
      {
         if(mapAvailability(static_cast<am_Availability_e>(i)) ==  avail)
            return static_cast<am_Availability_e>(i);
      }
      ETG_TRACE_FATAL(("clGeniviAudioSource::enIsSourceAvailable unkown value in clAudioSource::enSourceAvailability: %d",
            avail));
      return A_UNKNOWN;
   }

   clAudioSource::enSourceAvailability clGeniviAudioSource::enIsSourceAvailable()
   {
      clAudioSource::enSourceAvailability retVal = mapAvailability(m_gam_source_s.available.availability);
      ETG_TRACE_USR4(("enIsSourceAvailable: SourceClass: %d subID %d Available: %d"
               , m_SrcId.enSourceClass
               , (tU16)m_SrcId.u16SubSource
               , ETG_CENUM(enSourceAvailability, retVal)));
      return retVal;
   }

   tVoid clGeniviAudioSource::vSourceAvailablilityChange(enSourceAvailability availability,
         enSourceAvailabilityReason availabilityReason)
   {
      m_gam_source_s.available.availability = mapAvailability(availability);

    //VVD lint fix
    //am_Availability_e e;
      //am_AvailabilityReason_e r;
      am_Availability_s GAM_availability;
      switch(availability)
      {
         case clAudioSource::available:
            GAM_availability.availability = A_AVAILABLE;
            break;
         case clAudioSource::not_available:
            GAM_availability.availability = A_UNAVAILABLE;
            break;
         case clAudioSource::unkonwn:
            GAM_availability.availability = A_UNKNOWN;
            break;
         default:
            ETG_TRACE_ERR(("CMD_AUDIO, vSourceAvailablilityChange: availability %d is not handled"
                  , availability));
            GAM_availability.availability = A_UNKNOWN;
            break;
      }
      switch(availabilityReason)
      {
         case clAudioSource::voltage:
            GAM_availability.availabilityReason = AR_GENIVI_VOLTAGE;
            break;
         case clAudioSource::newmedia:
            GAM_availability.availabilityReason = AR_GENIVI_NEWMEDIA;
            break;
         case clAudioSource::samemedia:
            GAM_availability.availabilityReason = AR_GENIVI_SAMEMEDIA;
            break;
         case clAudioSource::nomedia:
            GAM_availability.availabilityReason = AR_GENIVI_NOMEDIA;
            break;
         case clAudioSource::temperature:
            GAM_availability.availabilityReason = AR_GENIVI_TEMPERATURE;
            break;
         case clAudioSource::error:
            GAM_availability.availabilityReason = AR_GENIVI_ERRORMEDIA;
            break;
         case clAudioSource::no_content:
            GAM_availability.availabilityReason = AR_GENIVI_MEDIA_NOCONTENT;
            break;
     case clAudioSource::overcurrent:
            GAM_availability.availabilityReason = AR_GENIVI_OVER_CURRENT;
            break;
     case clAudioSource::internaldisconnect:
            GAM_availability.availabilityReason = AR_GENIVI_INTERNAL_DISCONNECT;
            break;
         default:
            ETG_TRACE_ERR(("CMD_AUDIO, vSourceAvailablilityChange: availabilityReason %d is not handled"
                              , availabilityReason));
            GAM_availability.availabilityReason = AR_UNKNOWN;
            break;
      }
      clGeniviAudioCtrlAdapter::changeSourceAvailabilityDB(GAM_availability, m_gam_source_s.sourceID);

      //Call base class implementation
      clAudioSource::vSourceAvailablilityChange(availability, availabilityReason);
   }
}} //namespace


