// precompiled header, should always be the first include
//
#include "IAmControlReceiverShadow.h"
#include "AudioStack/InterfaceAudioStack.h"
#include "AudioStack/AudioSources/clAudioSourceFactory.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/AudioSources/clFactory_AudioSourceClass.h"
#include "AudioStack/AudioSources/clAudioSourceController.h"

#include <sstream>

#ifndef USE_DLT_TRACE
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define ETG_DEFAULT_TRACE_CLASS TR_COMP_AUDIOSTACK
#include "trcGenProj/Header/clAudioSourceFactory.cpp.trc.h"
#endif

namespace AudioStack
{
namespace AudioSource
{

std::map<SourceID, clAudioSource*> clAudioSourceFactory::audioSourceMap;
tU8                                  clAudioSourceFactory::SourceObjectCounter = 0;
tBool                                clAudioSourceFactory::m_rulesLoaded       = FALSE;

tVoid clAudioSourceFactory::Invalidate()
{
   ETG_TRACE_USR3(("AudioSourcefactory::Invalidate: audioSourceMap Size: %d, SourceObjectCounter: %d, m_rulesLoaded: %d  "
         , audioSourceMap.size()
         , SourceObjectCounter
         , m_rulesLoaded));
   //Iterate all Sources and delete them
   std::map<SourceID, clAudioSource*>::iterator tIterator;
   for(tIterator = audioSourceMap.begin(); tIterator != audioSourceMap.end(); ++tIterator)
   {
      if((*tIterator).second != NULL)
      {
         ETG_TRACE_USR4((" AudioSourcefactory: delete AudioSource: SourceClass: %d subID %d"
               , (*tIterator).second->sGetId().enSourceClass
               , (*tIterator).second->sGetId().u16SubSource
               ));
         delete (*tIterator).second;
         (*tIterator).second = NULL;
      }
   }
   audioSourceMap.clear();
   SourceObjectCounter = 0;
   m_rulesLoaded = FALSE;
}

tVoid clAudioSourceFactory::resetAudioSources()
{
     // Get Enumerator of ClientHandlers
     std::map<SourceID, clAudioSource*>::const_iterator tIterator;
     // iterate through Vector
     for ( tIterator  = audioSourceMap.begin();
           tIterator!=( audioSourceMap.end());
           ++tIterator)
     {
        if((*tIterator).second!=NULL)
        {
           (*tIterator).second->vReset();
        }
     }
}

tVoid clAudioSourceFactory::removeAudioSources(SourceID srcID)
{
  /*
   * If source present in both stack & removed during diagnosis session then
   * no need to delete source object As it will be accessed from
   * Backup Stack after diagnosis session is ended(PSARCC21-3180/PSARCC30-675)
   */
  if((clAudioSourceController::getInstance().bIsTopOfBackUpStackMuteAndOn())
    && (clAudioSourceController::bIsSourceOnBackUpStack(srcID)))
  {
    ETG_TRACE_USR3((" AudioSourcefactory:removeAudioSources,Diagnosis session active & source present \
         in BackUp Stack,No need to delete source "));
    return;
  }


   //Search for source
   std::map<SourceID, clAudioSource*>::iterator tIterator;
   tIterator = audioSourceMap.find(srcID);
   //if we found the corresponding source object
   if (tIterator!=(audioSourceMap.end()))
   {
      ETG_TRACE_USR3((" AudioSourcefactory: delete AudioSource: SourceClass: %d subID %#x(%d)"
            , srcID.enSourceClass
            , srcID.u16SubSource
            , srcID.u16SubSource));
      if((*tIterator).second != NULL)
      {
     delete (*tIterator).second;
     (*tIterator).second = NULL;
      }
      audioSourceMap.erase(srcID);
   }
}

tBool clAudioSourceFactory::Init()
{
   //LoadSourceClasses
   if(!m_rulesLoaded)
   {
      m_rulesLoaded = clFactory_AudioSourceClass::Ruleset_Load();
   }

   if(!m_rulesLoaded)
   {
      // loading rules error
      return FALSE;
   }
   const std::vector<clSourceClass>& srcClasses =
         clFactory_AudioSourceClass::GetSourceClassList();
   std::vector<clSourceClass>::const_iterator it;
   for(it = srcClasses.begin(); it!= srcClasses.end();++it)
   {
      if((*it).SourceClassID != clFactory_AudioSourceClass::GetInvalidSourceClass())
      {
         ETG_TRACE_USR3(("AudioSourcefactory: SourceClass: %d, Registration %d, Type: %d, Name: %s"
               , (*it).SourceClassID
               , (*it).SourceRegistration
               , (*it).SourceTypeID
               , (*it).SrcClassName.c_str()));

         if((*it).SourceRegistration == clSourceClass::registerStatic)
         {
            ETG_TRACE_USR3(("AudioSourcefactory: Create static AudioSource: SourceClass: %d "
                  , (*it).SourceClassID));
            //Do register only for those sources that are configured for static availability
            clAudioSource* pAudSrc = clAudioSourceFactory::getAudioSource(SourceID((*it).SourceClassID,0));
            if(pAudSrc != NULL)
            {
               pAudSrc->vSourceAvailablilityChange(clAudioSource::available,clAudioSource::samemedia);
            }
         }
      }
   }
   return TRUE;

   // Create StaticSource Objects
//   for(tU16 i = 0; i < static_cast<AudioSources::enAudioSources>(AudioSources::LAST); ++i)
//   {
//      if(clStackRules::rules[i].sourceRegistration == clSourceClass::registerStatic)
//      {
//         ETG_TRACE_USR3((" AudioSourcefactory: Create static AudioSource: SourceClass: %d "
//                ,ETG_CENUM(AudioSources::enAudioSources,static_cast<AudioSources::enAudioSources>(clStackRules::rules[i].src))));
//         //Do register only for those sources that are configured for static availability
//         clAudioSource* pAudSrc = clAudioSourceFactory::getAudioSource((clStackRules::rules[i].src),0);
//         if(pAudSrc != NULL)
//         {
//            pAudSrc->vSourceAvailablilityChange(clAudioSource::available,clAudioSource::samemedia);
//         }
//      }
//   }
}

tVoid clAudioSourceFactory::ListSources()
{
   ETG_TRACE_USR4((" AudioSourceFactory instantiated Sources: "));
   std::map<SourceID, clAudioSource*>::const_iterator tIterator;

   for ( tIterator  = audioSourceMap.begin();
         tIterator!=( audioSourceMap.end());
         ++tIterator)
   {
      if((*tIterator).second != NULL)
      {

         (*tIterator).second->vPrint();
      }
   }
}
clAudioSource* clAudioSourceFactory::getAudioSource(sourceClassID audioSourceClass, tU8 subSourceID)
{
   return getAudioSource(SourceID(audioSourceClass,subSourceID ));
}

clAudioSource* clAudioSourceFactory::getAudioSource(SourceID audioSource,tBool bCreateNewSource)
{
  //clAudioSource* pcoRetVal = NULL;
  // Map virtualSources to logicals, e.g. map PresetBanks of Tuner to TunerSource
  // AudioSources::enAudioSources logicalSource = mapVirtualToLogicalSource(audioSource);

  //Search for source
  std::map<SourceID, clAudioSource*>::const_iterator tIterator;
  tIterator = audioSourceMap.find(audioSource);
  //if we found the corresponding source object
  if (tIterator!=(audioSourceMap.end()))
  {
    return (*tIterator).second;
  }else if(bCreateNewSource){
  ETG_TRACE_USR4((" getAudioSource: calling createAudioSourceObj"));
    // else we have to create it...
    audioSourceMap[audioSource] = createAudioSourceObj(audioSource);
    return audioSourceMap[audioSource];
  }
  else //No need to create new source object if it's dynamic source vdu1kor SUZUKI-15832
  {
    ETG_TRACE_ERR(("CMD_AUDIO,  getAudioSource: No need to create new source object"));
    return NULL;
  }
}


//AudioSources::enAudioSources clAudioSourceFactory::mapVirtualToLogicalSource(AudioSources::enAudioSources audioSource)
//{
//   switch(audioSource)
//   {
//      case AudioSources::SOURCE_MEDIA:
//         audioSource = AudioSources::MEDIA_DB_PLAYER;
//         break;
//      default:
//         break;
//   }
//   return audioSource;
//}

//tBool clAudioSourceFactory::isSourceInstanceValid(SourceID srcID)
//{
//   if((clFactory_AudioSourceClass::GetRegistrationMode(srcID) == clSourceClass::registerDynamic)
//      && (srcID.u16SubSource == 0))
//   {
//      return FALSE;
//   }
//   return TRUE;
//}

clAudioSource* clAudioSourceFactory::getAvailableAudioSource()
{
   std::map<SourceID, clAudioSource*>::iterator tIterator;
   // iterate through Vector
   for ( tIterator  = audioSourceMap.begin();
         tIterator!=( audioSourceMap.end());
         ++tIterator)
   {
      if(((*tIterator).second != NULL) &&((*tIterator).second->enIsSourceAvailable()))
      {
         return (*tIterator).second;
      }
   }
   return NULL;
}

clAudioSource* clAudioSourceFactory::getAvailableAudioSource(sourceClassID sourceClass)
{
   if(sourceClass != clFactory_AudioSourceClass::GetInvalidSourceClass())
   {
      std::map<SourceID, clAudioSource*>::iterator tIterator;
      // iterate through Vector
      for ( tIterator  = audioSourceMap.begin();
            tIterator!=( audioSourceMap.end());
            ++tIterator)
      {
         if((*tIterator).first.enSourceClass == sourceClass)
         {
            if(((*tIterator).second != NULL) &&((*tIterator).second->enIsSourceAvailable()))
            {
               return (*tIterator).second;
            }
         }
      }
   }
   return NULL;
}

clAudioSource* clAudioSourceFactory::createAudioSourceObj(SourceID audioSource)
{
  clAudioSource* pRetAudioSrcObj = NULL;
  ETG_TRACE_USR3((" AudioSourcefactory: Create AudioSource: SourceClass: %d subID %d"
         , audioSource.enSourceClass
         , audioSource.u16SubSource));

//  if(! isSourceInstanceValid(audioSource))
//  {
//     return NULL;
//  }
  if(clFactory_AudioSourceClass::GetInvalidSourceClass() == audioSource.enSourceClass)
  {
     ETG_TRACE_USR3((" AudioSourcefactory: Create AudioSource: Not creating Invalid SourceClass %d subID %d"
           , audioSource.enSourceClass
           , audioSource.u16SubSource));
     return NULL;
  }

  if((clFactory_AudioSourceClass::GetRegistrationMode(audioSource)== clSourceClass::registerStatic )
        &&(audioSource.u16SubSource != 0 ))
  {
     ETG_TRACE_FATAL(("ERROR: createAudioSourceObj fails because SourceClass %d SubSource %d is configured for static registration. SubSource must be 0",
           audioSource.enSourceClass, audioSource.u16SubSource));
     return NULL;
  }
  // Create corresponding Object
  switch(clFactory_AudioSourceClass::GetRegistrationMode(audioSource))
  {
     case clSourceClass::registerNone:
        pRetAudioSrcObj = OSAL_NEW clAudioSource(audioSource);

    //VVD fix lint
        if(pRetAudioSrcObj)
        pRetAudioSrcObj->vSourceAvailablilityChange(clAudioSource::available, clAudioSource::samemedia);

        break;
     default:
        //       ++SourceObjectCounter;
        //       std::ostringstream s;
        //       s << "AudioSrcObj_" << SourceObjectCounter;
        pRetAudioSrcObj = OSAL_NEW clGeniviAudioSource(audioSource);
        //pRetAudioSrcObj = OSAL_NEW clAudioSource(s.str().c_str(), audioSource);
        break;
  }

  if(pRetAudioSrcObj != NULL)
  {
    //pRetAudioSrcObj->vSetTrace(m_poTrace);
     ETG_TRACE_USR3((" AudioSourcefactory: Instantiated AudioSource SourceClass: %d subID %#x(%d): %s"
         , audioSource.enSourceClass
         , audioSource.u16SubSource
         , audioSource.u16SubSource
         , pRetAudioSrcObj->pacGetName()));
  }
  return pRetAudioSrcObj;
}



clAudioSource* clAudioSourceFactory::isSourceInstantiated(SourceID srcId)
{
   //Search for source
    std::map<SourceID, clAudioSource*>::const_iterator tIterator;
    tIterator = audioSourceMap.find(srcId);
    //if we found the corresponding source object
    if (tIterator!=(audioSourceMap.end()))
    {
      return (*tIterator).second;
    }
    return NULL;
}


}}//namespace

