/*
 * aud_dbus_lcm_handler.h
 *
 *  Created on: 6th October, 2016
 *      Author: paj5kor
 */

#ifndef AUD_DBUS_LCM_HANDLER_H_
#define AUD_DBUS_LCM_HANDLER_H_

#include <gio/gio.h>
#include <pthread.h>

class CAmControlSenderBase;

#include "CThreadSwitchingClient.h"

using namespace am;

class aud_dbus_lcm_proxy;
class aud_dbus_lcm_bus_watcher;
/**
* Wrapper class that takes care of initialization of bus name watcher and the proxy objects
*/
class aud_dbus_lcm_handler
{
private:
  aud_dbus_lcm_bus_watcher*  m_pWatcher;//Pointer to watcher object
  aud_dbus_lcm_proxy* m_pProxy;//Pointer to proxy object
  GMainLoop*          m_poLoop;//Pointer to g-mainloop
  pthread_t          m_threadid;

  am::IAmControlReceiverShadow& m_receiverShadow;
  am::IAmControlReceive&        m_ControlReceive;
  CAmControlSenderBase& m_ControlSenderBase;
public:
  aud_dbus_lcm_handler(CAmControlSenderBase& controlSenderBase, am::IAmControlReceiverShadow& receiverShadow, am::IAmControlReceive& controlReceive);
  aud_dbus_lcm_handler(const aud_dbus_lcm_handler&) = delete;
  aud_dbus_lcm_handler& operator=(const aud_dbus_lcm_handler&) = delete;
  ~aud_dbus_lcm_handler();
  /**
  Helper function to initialize
  */
  bool bInit();
  /**
  * Helper function to deinitialize
  */
  void vDeInit();
  /**
  * pthread entry function
  */
  static void* pThreadEntry(void* pvarg);
  /**
  * Helper function to get audio process proxy
  */
  aud_dbus_lcm_proxy* poGetAudioProcProxy()
  {
    return m_pProxy;
  }
};

#endif /* AUD_DBUS_LCM_HANDLER_H_ */


