#ifndef _STACKRULES_H_
#define _STACKRULES_H_

//#include <string>
#include "IAmControlReceiverShadow.h"

//#include "audiomanagertypes.h"


namespace AudioStack
{
namespace AudioSource
{
//Forward Delcarations
struct SourceID;
class clAudioSource;
}
//AudioTypes
typedef tU8  sourceClassID;
typedef tU8  sourceTypeID;
typedef tU16 sourceRule;


struct stSourceType
{
   std::string  name;
   sourceTypeID id;
   tBool        stackable;
   tBool        exclusive;
   tBool        restorable;
   tBool        previous;
};
struct stSourceSetting
{
   tBool    AllowSrcAlreadyonStack;
   tBool    BackGroundSourceExchange;
};



/**
 * @Brief
 * defines attributes of a source class, which is
 * collection of source instances of same class.
 * Class differs by their priority, channel or
 * other specific attributes
 */
class clSourceClass
{
public:

   typedef tU16 externalID;
   typedef tU8  sourceGroupID;
   typedef tU8  sourceTypeID;

   typedef enum {
      disallowed,
      allowed,
      kicked
   } allow_t;

   typedef enum {
      action_abort   = 0x0100,
      action_waitFor = 0x0200,
	  action_pause   = 0x0400, //do we need like this or could it be 0x0300, 0x0400, 0x0500,...
	  action_restart = 0x0800,
      end            = 0xff00,
      mask           = 0xff00,
      idxMask        = 0x00ff
   } actions_t;

   typedef enum {
      registerStatic,
      registerDynamic,
      registerNone
   } registration_t;

   typedef enum {
      autoplay_none,
      autoplay_avail
      } autoplay_t;

   typedef enum{
      none,
      startUp,
      profileChange,
      startupAndProfileChange
      } restore_t;

   typedef struct {
     //tU16 sinkID;
     std::vector<tU16> sinkIDs; //keep here the allowed sinks for this source class
     tU16 DefaultSink;          //this is the default sink. We use it for source availability when we can not provide a sink
     std::vector<sourceRule>      Rules;
     std::vector<actions_t> PushActions;
     std::vector<actions_t> PopActions;
      } sinkRules_t;


    typedef enum{
      group_media,
      group_tuner,
      group_mute,
      group_none,
      group_voicerec
    } group_t;

   std::string            SrcClassName;
   sourceClassID          SourceClassID;
   externalID             ExtID;
   sourceTypeID           SourceTypeID;
   sourceGroupID          SourceGroupID;
   registration_t         SourceRegistration;
   tU16                   AvailabilityTimeout;
   autoplay_t             AutoPlay;
   restore_t              Restore;
   bool           Previous;
   bool bSupressSubSource;
   tU16           defaultSink;   // daw2hi 24.08.2016 ToDo check if this is still in use
//   AudioSource::clAudioSource*         SourcePointer;
   std::vector<sourceRule>      Rules;  /* which source is allowed on top of 'this' source */
   std::vector<actions_t> PushActions;  /* which additional action should be done to the audio stack after pushing source */
   std::vector<actions_t> PopActions;   /* which additional action should be done to the audio stack after popping source */


   // just keep also a vector for the sinks for this SourceClass
   std::vector<tU16> Sinks;   // daw2hi 24.08.2016 ToDo check if still in use or replaced by sinkIDs in sinkRules_t

   clSourceClass(sourceClassID ClassID, const char* SourceClassName)
      : SrcClassName(std::string(SourceClassName))
      , SourceClassID(ClassID)
      , ExtID(0)
      , SourceTypeID(0)
      , SourceGroupID(0)
      , SourceRegistration(registerStatic)
      , AvailabilityTimeout(0)
      , AutoPlay(autoplay_none)
      , Restore(startupAndProfileChange)
    , Previous(true)
    , bSupressSubSource(false)
      , defaultSink(1)
//      , SourcePointer(NULL)
   {}

   bool operator==(const AudioStack::clSourceClass &n1)
   {
      if(strcmp(SrcClassName.c_str(),n1.SrcClassName.c_str()) == 0)
      {
         return TRUE;
      }
      return FALSE;
   }

   bool operator!=(const AudioStack::clSourceClass &n1)
   {
   if(strcmp(SrcClassName.c_str(),n1.SrcClassName.c_str()) != 0)
   {
         return TRUE;
   }
   return FALSE;
   }

   bool operator==(const char *n1)
   {
      if(strcmp(SrcClassName.c_str(),n1) == 0)
      {
         return TRUE;
      }
      return FALSE;
   }

   //bool setRules(SourceID srcID);
   allow_t allowOnTop(AudioSource::SourceID enSrcId) const;
   actions_t getPushAction(int index);
   actions_t getPopAction(int index);
   const std::vector<actions_t>& getPushActionList() const {return PushActions;}
   sourceTypeID getTypeID() const { return SourceTypeID; }
   sourceGroupID getGroupID() const {return SourceGroupID; }
   sourceClassID getClassID() const {return SourceClassID; }
   registration_t getRegistrationMode() const {return SourceRegistration;}
   tU16 getAvailabilityTimeout() const {return AvailabilityTimeout;}
   const std::string getName() const {return SrcClassName;}
   externalID getExtID() const {return ExtID;}
};

class RuleQualifier
{
public:
   typedef enum
   {
        NONE        = 0x0000
      , ALL_SOURCES = 0x0100
      , NOT_SRC     = 0x0800
      , KICK_SRC    = 0x1000
      , ALLOW_GROUP = 0x2000
   } qualifier_t;

   /**
    * Apply NEGATION allowance Flag
    */
   static inline sourceRule Apply(sourceClassID classID, qualifier_t ruleQualifier)
   {
    return (sourceRule)(classID | ruleQualifier);
   }

   static inline qualifier_t GetQualifier(sourceRule ruleValue)
   {
      return (qualifier_t)(ruleValue & 0xFF00);
   }

   static inline sourceClassID GetSourceClass(sourceRule ruleValue)
   {
      //TODO need to check if this rule has NO Group qualifier
      //otherwise assert!?
      return (sourceClassID)(ruleValue & 0x00FF);
   }

   static inline clSourceClass::sourceGroupID GetGroupID(sourceRule ruleValue)
   {
      //TODO need to check if this rule has Group qualifier
      //otherwise assert!?
      return (sourceClassID)(ruleValue & 0x00FF);
   }
};

}
#endif // _STACKRULES_H_
