#ifndef _STACK_H_
#define _STACK_H_

#ifdef WIN32
#include "windows.h"
#endif



#include "AudioStack/AudioSources/clAudioSource.h"
#include "InterfaceAudioStack.h"

#define MAX_AUDIO_SOURCES 10


namespace AudioStack
{

class clStack : public am::IAmShTimerCallBack
{
public:
  clStack();
  clStack(int sinkID, const char* myName);
  virtual ~clStack();
    void vResetStack();

  static bool bTimerExpired;
  bool bIsStackStable;
  bool AddSource(AudioSource::clAudioSource &src);

  bool PushActionForSourceAlreadyOnStack(AudioSource::clAudioSource &src,uint8_t index);

  virtual AudioSource::clAudioSource*  AllowSource(AudioSource::clAudioSource &src);
  bool RemoveSource(AudioSource::clAudioSource &src);
  AudioSource::clAudioSource *GetUnderlayingSource(AudioSource::clAudioSource &src) const;
  //Callback from mainloop, to inform that the timer has expired
  virtual void Call(const am::sh_timerHandle_t handle, void* userData);
  tVoid vStackStableTimer();
  int GetSinkID();
  tVoid vStackStableTimerStart();
  tVoid vStackStableTimerStop();
  static bool bIsTimerexpired();
  bool bCheckStackStable();

  /**
   * Returns most Top source (regardless what type or group).
   * If Stack is empty NULL is returned
   */
  AudioSource::clAudioSource *GetTopSource() const;

  /**
   * Returns most Top source of type background.
   * If Stack doesn't contain a BG Source NULL is returned
   */
  //clAudioSource *GetCurrentBgSource() const;

  /**
   * Returns ptr to most to Source of given SourceClass.
   * NULL if no source of given class is found on the stack
   */
  AudioSource::clAudioSource *GetTopSource(sourceClassID srcClass) const;

  /**
   * Returns pointer to audiosource that is most top and
   * of given type ID
   */
  AudioSource::clAudioSource* GetTopSource_Type(sourceTypeID srcTypeID) const;

  /**
   * Searches for Sources in Stack that are of given SourceType
   * @RETURN NULL if no source of given type is no Stack
   * If a matching source is found a pointer to it is returned
   */
  AudioSource::clAudioSource* GetSourceInStack_EqualSourceType(clSourceClass::sourceTypeID typeID) const;

  // is implemented by the 'AudioSrcController' and switches of one source. this templte will contain 'AudioSrcController'
  bool virtual OFF(AudioSource::clAudioSource *source, AudioSource::SourceID u8SrcId);
  void trace() const;

protected:
  bool RemoveInternal_SourceClass(sourceClassID rmSrcClass, AudioSource::SourceID nextSrcID);
  bool RemoveInternal_Source(AudioSource::SourceID rmSrcID, AudioSource::SourceID nextSrcID);

  bool PauseInternal_SourceClass(sourceClassID rmSrcClass, AudioSource::SourceID nextSrcID);
  
  bool RestartInternal_SourceClass(sourceClassID rmSrcClass, AudioSource::SourceID nextSrcID);
  
  bool bIsRestartAllowedByAllSourcesOnStack(const clSourceClass& restartSrcClass,sourceClassID restartSrcClassid,AudioSource::SourceID srcID);

  //VVD
  //void DoPushActions(AudioSource::clAudioSource &src,);
  bool DoPushActions(AudioSource::clAudioSource &src,sourceClassID srcAllowedOnTopOf=0);

  void DoPopActions(AudioSource::clAudioSource &src);

private:
  AudioSource::clAudioSource *m_sources[MAX_AUDIO_SOURCES];
  int m_SP;
  int m_SinkID;
  std::string name;

  static CAmSocketHandler*    m_pSocketHandler;
  am::sh_timerHandle_t m_handle;//Handle for the timer
  bool bStartTimer(uint32_t seconds);//Helper function to start the timer


};

// here are the members of this template. MSDEV 6.0 has a problem with cpp files defining members of template classes
// therefor the cpp must be included.
//#if defined PROJECTBUILD_VWLL_NF || defined PROJECTBUILD_NISSAN_LCN
//#include "stack.cpp"
//#endif

}//namespace

#endif // _STACK_H_
