/*
 * clGeniviAudioCtrlAdapter.h
 *
 *  Created on: Jul 25, 2013
 *      Author: vo84hi
 */

#ifndef CLGENIVIAUDIOCTRLADAPTER_H_
#define CLGENIVIAUDIOCTRLADAPTER_H_

#include "InterfaceAudioStack.h"

#include "include/audiomanagertypes.h"
#include "IAmControlReceiverShadow.h"
#include "AudioStack/AudioSources/clGeniviAudioSource.h"
#include "AudioStack/clAudioSMEngine.h"
//#include "amcontrol_clienthandler_fc_audioroutemanager.h"

#ifndef _DO_NOT_USE_BOSCH_OSAL_
#include <list>
#include <algorithm>

#else
#include <list>
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include "midw_fi_if.h"

#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_TYPES
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_FUNCTIONIDS
#define SPM_FI_S_IMPORT_INTERFACE_SPM_COREFI_SERVICEINFO
//#include "spm_fi_if.h"
#include <libxml/parser.h>
#include <libxml/tree.h>

//includes for loading XML ruleset
#include <string.h>

#define GAM_AUDIO_SINK_ID 1

#define MUTE_NO_AUD_DEV_OFF 0
#define MUTE_NO_AUD_DEV_ON  1

class amcontrol_clienthandler_fc_audiomanager;
class amcontrol_clienthandler_fc_audioroutemanager;
class CAmControlSenderBase;

namespace AudioStack
{


/**
 * GeniviAudioControlAdapter_mainConnectionItem
 */
struct stGACA_mainConnectionItem
{
   am::am_Handle_s* handle;
   am::am_MainConnection_s* mainConnection;
   am::am_connectionID_t connectionID;
};



/**
 * Facade for Genivi Audiomanager  AudioStack
 */
class clGeniviAudioCtrlAdapter
{

private:
   clGeniviAudioCtrlAdapter();
   ~clGeniviAudioCtrlAdapter();


   /**
    * source observer listing
    */
   static std::map<am_sourceID_t, AudioSource::SourceID > m_registeredSources;

   /*
    * registered sink list
    */
   static std::map<am_sinkID_t, am_Sink_s> m_registeredSinks;

   /**
    * pointer to Genivi AudioManager Control Interface
    */
   static am::IAmControlReceive * m_geniviControlIF;
   static amcontrol_clienthandler_fc_audioroutemanager* m_clientHandlerAudioRouteMgr;
   static amcontrol_clienthandler_fc_audiomanager* m_clientHandlerFcAudioMgr;
   static CAmControlSenderBase* m_ControlSenderBase;

   static am::am_domainID_t m_domainID;


   static am::am_Error_e addMainConnection(const am::am_sourceID_t sourceID,
                                                          const am::am_sinkID_t sinkID,
                                                          am::am_mainConnectionID_t& mainConnectionID);

   static am::am_Error_e removeMainConnectionDB(const am_mainConnectionID_t mainConnectionID);
   static am::am_Error_e getConnectionOfSource(AudioSource::clGeniviAudioSource* sourceID, am_connectionID_t& connectionID);
   static tVoid initializeSourceClasses(am::am_domainID_t domainID);
   static tVoid initializeSources(am::am_domainID_t domainID);
   static am::am_Error_e initializeSinks(am::am_domainID_t domainID);

   static tBool  m_bEnableAutoPlay;
   static void initializeSinkRSE(am_domainID_t domainID);

public:

   typedef enum
   {
      CMD_SRC_OFF
      , CMD_SRC_ON
      , CMD_SRC_LIST
      , CMD_RESET
      , CMD_PRINT
      , CMD_SET_RUNLEVEL
      , CMD_GET_RUNLEVEL
      , CMD_KILL_SRC
      , CMD_SET_SRC_AVAILABLE
      , CMD_SET_SRC_NOT_AVAILABLE
      , CMD_SET_SRC_AVAILABLE_UNKOWN
      , CMD_LOADXML
      , CMD_PRINTXML
      , CMD_PRINTRULES
      , CMD_REMOTESTART
      , CMD_REMOTEEND
      , CMD_PRINT_BACKUP
   } enCommand;

   static tVoid Invalidate();

   /*
    * function to load correct volume context in fc_AudioManager->VolumeManager
    */
   static tVoid vLoadVolumeContext(clAudioSource* srcRemoved);

   static void SetRunLevel(tU8 u8Level);
   static am::am_Error_e Init(CAmControlSenderBase* pSenderBase,am::IAmControlReceive* pGeniviCtrlIF,
     amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr,
         amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr);

   static void inline Check_IAmControlReceive();

   template<class TClass>
   static void vSwitchThreadContext(TClass* instance, void (TClass::*function)())
   {
      IAmControlReceiverShadow* pReceiveShadow = IAmControlReceiverShadow::getInstance();
      if(pReceiveShadow != NULL)
      {
         pReceiveShadow->vSwitchThreadContext<TClass>(instance, function);
      }
      //m_geniviControlIF->vSwitchThreadContext<TClass>(instance, function);
   }

   static am_domainID_t GetDomainID() {return m_domainID;}

   static AudioSource::clAudioSource::enSourceActivity           Ext2Int_Activity          (midw_fi_tcl_e8_SrcActivity::tenType extActivity);
   static sourceClassID                             Ext2Int_SrcClass          (midw_fi_tcl_e8_AudSource::tenType enSrcExt);
   static AudioSource::clAudioSource::enSourceAvailability       Ext2Int_Availability      (midw_fi_tcl_e8_SrcAvailability::tenType extAvailability);
   static AudioSource::clAudioSource::enSourceAvailabilityReason Ext2Int_AvailabilityReason(midw_fi_tcl_e8_SrcAvailabilityReason::tenType extAvailabilityReason);

   static void Reset();
   /**
    * Adds a Source to a observer list. Incoming events that are
    * destined for source will be forwarded to all objects in the
    * observer list
    *
    * @param pSource source that is added to observer list
    */
   static am_sourceID_t AddSource(AudioSource::SourceID srcID, am_Source_s& gam_source_s);

   /**
    * Removes a Source from the observer list.
    * @param pSource
    * @return TRUE if source is removed or not listed. FALSE if source could
    * not be removed.
    */
   static tVoid RemoveSource(am_sourceID_t gam_sourceID);

   /**
    * Notification that a Source has send notification about
    * its availability state
    * @param Source whom the given availability state belongs to
    * @param SubSource SubSourceID
    * @param Availability state of the source
    * @param Reason why this availability was announced
    */
   static tVoid SourceAvailabilityChange(midw_fi_tcl_e8_AudSource::tenType Source,
                                         tU16 SubSource,
                                         midw_fi_tcl_e8_SrcAvailability::tenType Availability,
                                         midw_fi_tcl_e8_SrcAvailabilityReason::tenType Reason);



   // Sink handling

   static am_sinkID_t AddSink(const am_Sink_s& gam_sink_s);
   static tVoid RemoveSink(am_sinkID_t gam_sinkID);

   //sinkAvailability??


   /**
    * Adds Genivi AudioManager Control Interface for interaction with
    * Genivi AudioManager. When Interface becomes invalid (e.g. due
    * to destruction) the Interface needs to be removed.
    * @note when assigning NULL the interface won't get called.
    *
    * @param pGeniviCtrlIF pointer to Genivi AudioManager Control Interface
    * @return void
    */
   static tVoid AddGeniviCtrlIF(am::IAmControlReceive* pGeniviCtrlIF);

   /**
    * Removes the Genivi AudioManager Control Interface.
    * @return void
    */
   static tVoid RemoveGeniviCtrlIF();

   /**
    * Add Interface to INC Gateway to AudioRouteManager
    */
   static tVoid AddAudioRouteMgrIF(amcontrol_clienthandler_fc_audioroutemanager* clientHandlerAudioRouteMgr);

   /**
    * Remove Interface to INC Gateway to AudioRouteManager
    */
   static tVoid RemoveAudioRouteMgrIF();

   /**
    * Add Interface to FcAudioManager
    */
   static tVoid AddFcAudioMgrIF(amcontrol_clienthandler_fc_audiomanager* clientHandlerFcAudioMgr);

   /**
    * Remove Interface to FcAudioManager
    */
   static tVoid RemoveFcAudioMgrIF();


   static tVoid AddDomainID(am_domainID_t domainID);


   /**
    *
    * @return Poionter to Genivi AudioManager Ctrl Interface
    */
   static am::IAmControlReceive* GetGeniviCtrlIF();

   /**
    * Request by Genivi AudioManager to disconnect MainConnection (SourceOFF)
    * @param connectionID
    * @return
    */
   static am::am_Error_e hookUserDisconnectionRequest(const am::am_mainConnectionID_t connectionID);

   /**
    * Request by Genivi AudioManager to establish MainConnection (SourceOn)
    * @param sourceID
    * @param sinkID
    * @param mainConnectionID
    * @return
    */
   static am::am_Error_e hookUserConnectionRequest(const am::am_sourceID_t sourceID, const am::am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @return
    */
   static am::am_Error_e disconnect(am::am_Handle_s& handle, am::am_connectionID_t connectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param handle
    * @param errorID
    */
   static void cbAckDisconnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
    * Request from source to Genivi AudioManager Receive IF
    * @param handle
    * @param connectionID
    * @param format
    * @param sourceID
    * @param sinkID
    * @return
    */
   static am::am_Error_e connect(am::am_Handle_s&, am::am_connectionID_t&, am::am_CustomConnectionFormat_t, am::am_sourceID_t, am::am_sinkID_t);

   /**
    * From Genivi AudioManager to source
    * @param handle
    * @param errorID
    */
   static void cbAckConnect(const am::am_Handle_s handle, const am::am_Error_e errorID);

   /**
       * From Genivi AudioManager to source
       * @param handle
       * @param errorID
       */
   static void cbAckSourceState(const am_Handle_s handle, const am_Error_e error);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param sourceClassID MidwFI Value
    * @param sourceState source state of the source
    */
   static void handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity, midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc = 0);

   static void handleSourceStatus(midw_fi_tcl_e8_SrcActivity::tenType activity,
       midw_fi_tcl_e8_AudSource::tenType source,
       tU16 subSrc,
       midw_fi_tcl_e8_ResourceNo::tenType sinkID);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param enAudioSources
    * !!!! No more supported !!!
    */
   //static void vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType);

   /**
    * From AudioRoutingMgr via INC Adapter to AudioStack
    * @param enAudioSources
    * @param subSource
    */
   static void vHandleSourceError(midw_fi_tcl_e8_AudSource::tenType source, tU16 subSrc, tU16 ErrorCode);


   /**
    * From AudioStack to GeniviAudioManager
    */
   static am::am_Error_e setSourceState(am::am_Handle_s& handle,
         const am::am_sourceID_t sourceID,
         am::am_SourceState_e state);

   /**
    * add a source class
    */
   static am::am_Error_e addSourceClass( am_SourceClass_s& srcClass, am_sourceClass_t& srcClassID);

   /**
    * get the main connection id
    */
   static am::am_Error_e getMainConnectionOfSource(am_sourceID_t sourceID, am::am_mainConnectionID_t& mainConnectionID);

   static am::am_Error_e getMainConnectionOfSource(am_sourceID_t sourceID, am_sinkID_t sinkID, am::am_mainConnectionID_t& mainConnectionID);

   /**
    * from source/AudioStack to AudioManager
    * @param mainconnectionID
    * @param connectionState
    * @return
    */
   static am::am_Error_e changeMainConnectionStateDB(const am::am_sourceID_t sourceID,
                                                  const am::am_sinkID_t sinkID,
                                                  const am::am_ConnectionState_e connectionState);

   /**
    * update mute status of sink in DB
    */
   static am::am_Error_e changeSinkMuteStateDB(const am::am_MuteState_e muteState,
                                               const am::am_sinkID_t sinkId);

   /**
     * update system property
     */
    static void updateSystemPropertyDB(am_CustomSystemPropertyType_t etype,int16_t ivalue);
    static void updateSoundPropertyDB(am_CustomMainSoundPropertyType_t etype,int16_t ivalue);

   /**
    * Request Source deactivation at AudioStack
    */
   static am::am_Error_e RequestSourceOff(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOff(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOff(const AudioSource::SourceID srcID);
   static am::am_Error_e RequestSourceOff(const AudioSource::SourceID srcID, const tU16 sinkID);

   /**
    * Request Source pausing at AudioStack
    * ATTENTION: Actually not supported
    */
   static am::am_Error_e RequestSourcePause(AudioSource::SourceID srcID);

   /**
    * Request Source activation at AudioStack
    */
   static am::am_Error_e RequestSourceOn(midw_fi_tcl_e8_AudSource::tenType source, tU16 subID);
   static am::am_Error_e RequestSourceOn(const am_sourceID_t source);
   static am::am_Error_e RequestSourceOn(const AudioSource::SourceID srcID);
   static am::am_Error_e RequestSourceOn(const AudioSource::SourceID srcID, tU16 sinkID);

   /**
    * Send SourceActivity requests to FC_AudioRouteMgr via INC Gateway
    */
   static am::am_Error_e SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                                , tU16 subSource
                                                , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                                , midw_fi_tcl_e8_SrcActivity::tenType activity);

   // with aditional Sink Parameter
   static am::am_Error_e SourceActivityRequest(midw_fi_tcl_e8_AudSource::tenType source
                                                , tU16 subSource
                                                , midw_fi_tcl_e8_AudSource::tenType possibleNextSource
                                                , midw_fi_tcl_e8_SrcActivity::tenType activity
                                                , midw_fi_tcl_e8_ResourceNo::tenType sink);
   /**
    * From AudioStack to Genivi
    * When restoring last source a main connections is established
    */
   static am::am_Error_e addMainConnection(am_sourceID_t sourceID);
   static am::am_Error_e addMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID);
   /**
    * From AudioStack to Genivi
    * when a source has changed to Pause or Off state
    */
   static am::am_Error_e removeMainConnection(am_sourceID_t sourceID);
   static am::am_Error_e removeMainConnection(am_sourceID_t sourceID, am_sinkID_t sinkID);

   /**
    * From AudioStack to Genivi
    * attach or remove connections to MainConnections
    */
   static am::am_Error_e changeMainConnectionRouteDB(am_sourceID_t sourceID,  std::vector<am_connectionID_t>& listConnectionID);

   /**
    * To Map External(midw_fi) source ID to
    * Internal source ID used in Genivi Audio Manager
    */
   static am::am_Error_e changeSourceAvailabilityDB(am_Availability_s& availability, am_sourceID_t sourceID);

   /**
    * To check if system is already Muted
    */
   //static tBool bIsAudioMuted();

   /**
    * To check if source is current active source
    */
   static tBool bIsCurrentActiveAudiosource(AudioSource::SourceID srcID);
   static AudioSource::clAudioSource* pcoGetTopOfStackMixsource();

   static AudioSource::clAudioSource* pcoGetTopOfStack();

   static tVoid TTFisInput(tU8 cmd,tU16 value1 = 0xFFFF,tU16 value2 = 0xFFFF);
   static tVoid vTraceRxDefault(tPCUChar pcu8Data);

   static am_Error_e isValidSourceID(am_sourceID_t sourceID);
   static am_Error_e isValidSinkID(am_sinkID_t sinkID);

   static AudioSource::clGeniviAudioSource* getAudioSource(AudioSource::SourceID srcID);

   static tVoid vRemoteControlStart();
   static tVoid vRemoteControlEnd();
   static tVoid vRemoteControlUpdateDB(int16_t i16Type);

   static tBool bIsCurrentSourceStackable(midw_fi_tcl_e8_AudSource::tenType source,tU8 subID);
   static tVoid SetAudioState(tS16 audioState);
   static am_Error_e bSourceConnect(am_sourceID_t SourceId,clAudioSMEngine::enErrorCode & retval);
   static am_Error_e bSourceConnect(am_sourceID_t SourceId, am_sinkID_t SinkId, clAudioSMEngine::enErrorCode & retval);
   static am_Error_e vSetMuteOnStartUp(tU16,bool bStartup = false);

   static am_Error_e vSetWelcomeMuteOnStartUp(bool bStartup);
   static am_Error_e vSetAmplifierMute(tU16);
   static am_Error_e vSetPersistentMute();
   static tVoid vAudioStateLCMStatus(am_SystemAudioState_e oAudioSate);

   static tBool bIsAutoplayEnabled();
   static tVoid vSetEntertainmentMute(const am_MuteState_e muteState);
   static tVoid vUpdateMultiUsrDataPool(tBool bIsInitialProfileChange);
   static tBool bAudioDeviceAvailability();
};


}//namespace


#endif /* CLGENIVIAUDIOCTRLADAPTER_H_ */
