/**
 * Copyright (C) 2012 - 2014, BMW AG
 *
 * This file is part of GENIVI Project AudioManager.
 *
 * Contributions are licensed to the GENIVI Alliance under one or more
 * Contribution License Agreements.
 *
 * \copyright
 * This Source Code Form is subject to the terms of the
 * Mozilla Public License, v. 2.0. If a  copy of the MPL was not distributed with
 * this file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 *
 * \author Christian Linke, christian.linke@bmw.de BMW 2011 - 2014
 *
 * \file
 * For further information see http://projects.genivi.org/audio-manager
 *
 * THIS CODE HAS BEEN GENERATED BY ENTERPRISE ARCHITECT GENIVI MODEL. 
 * PLEASE CHANGE ONLY IN ENTERPRISE ARCHITECT AND GENERATE AGAIN.
 */
#if !defined(EA_D9D48C0D_77EC_4fa7_B861_1827740C7ECA__INCLUDED_)
#define EA_D9D48C0D_77EC_4fa7_B861_1827740C7ECA__INCLUDED_

#include <vector>
#include <string>
#include "audiomanagertypes.h"
namespace am {
class CAmDbusWrapper;
class CAmSocketHandler;
}


#include "audiomanagertypes.h"

#define CommandVersion "4.1"
namespace am {

/**
 * The interface towards the Controlling Instance (e.g HMI). It handles the
 * communication towards the HMI and other system components who need to interact
 * with the audiomanagement.
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmCommandReceive
{

public:
	IAmCommandReceive() {

	}

	virtual ~IAmCommandReceive() {

	}

	/**
	 * This function returns the version of the interface.
	 */
	virtual void getInterfaceVersion(std::string& version) const =0;
	/**
	 * connects a source to sink
	 * @return E_OK on success, E_NOT_POSSIBLE on failure, E_ALREADY_EXISTS if the
	 * connection does already exists
	 */
	virtual am_Error_e connect(const am_sourceID_t sourceID, const am_sinkID_t sinkID, am_mainConnectionID_t& mainConnectionID) =0;
	/**
	 * disconnects a mainConnection
	 * @return E_OK on successes, E_NON_EXISTENT if the connection does not exist,
	 * E_NOT_POSSIBLE on error.
	 */
	virtual am_Error_e disconnect(const am_mainConnectionID_t mainConnectionID) =0;
	/**
	 * sets the volume for a sink
	 * @return E_OK on success, E_UNKOWN on error, E_OUT_OF_RANGE in case the value is
	 * out of range
	 */
	virtual am_Error_e setVolume(const am_sinkID_t sinkID, const am_mainVolume_t volume) =0;
	/**
	 * This function is used to increment or decrement the current volume for a sink.
	 * @return E_OK on success, E_UNKNOWN on error and E_OUT_OF_RANGE if the value is
	 * not in the given volume range.
	 */
	virtual am_Error_e volumeStep(const am_sinkID_t sinkID, const int16_t volumeStep) =0;
	/**
	 * sets the mute state of a sink
	 * @return E_OK on success, E_UNKNOWN on error. If the mute state is already the
	 * desired one, the Daemon will return E_OK.
	 */
	virtual am_Error_e setSinkMuteState(const am_sinkID_t sinkID, const am_MuteState_e muteState) =0;
	/**
	 * This method is used to set sound properties, e.g. Equalizer Values. Since the
	 * capabilities of the system can differ, the exact key value pairs can be
	 * extended in each product
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setMainSinkSoundProperty(const am_MainSoundProperty_s& soundProperty, const am_sinkID_t sinkID) =0;
	/**
	 * This method is used to set the list of sound properties
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setMainSinkSoundProperties(const std::vector<am_MainSoundProperty_s> &/*listSoundProperties*/, const am_sinkID_t /*sinkID*/) { return E_OK; };
	/**
	 * This method is used to set sound properties, e.g. Equalizer Values. Since the
	 * capabilities of the system can differ, the exact key value pairs can be
	 * extended in each product
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setMainSourceSoundProperty(const am_MainSoundProperty_s& soundProperty, const am_sourceID_t sourceID) =0;
	/**
	 * This method is used to set the list of sound properties
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setMainSourceSoundProperties(const std::vector<am_MainSoundProperty_s> &/*listSoundProperties*/, const am_sourceID_t /*sourceID*/) { return E_OK; };
	/**
	 * is used to set a specific system property.
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setSystemProperty(const am_SystemProperty_s& property) =0;
	/**
	 * is used to set a specific system properties.
	 * @return E_OK on success, E_OUT_OF_RANGE if value exceeds range, E_UNKNOWN in
	 * case of an error
	 */
	virtual am_Error_e setSystemProperties(const std::vector<am_SystemProperty_s>&/*listSystemProperties*/ ) { return E_OK; };
	/**
	 * returns the actual list of MainConnections
	 * @return E_OK on success, E_DATABASE_ERROR on error
	 */
	virtual am_Error_e getListMainConnections(std::vector<am_MainConnectionType_s>& listConnections) const =0;
	/**
	 * returns the actual list of Sinks
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListMainSinks(std::vector<am_SinkType_s>& listMainSinks) const =0;
	/**
	 * returns the actual list of Sources
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListMainSources(std::vector<am_SourceType_s>& listMainSources) const =0;
	/**
	 * This is used to retrieve all source sound properties related to a source.
	 * Returns a vector of the sound properties and values as pair
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListMainSinkSoundProperties(const am_sinkID_t sinkID, std::vector<am_MainSoundProperty_s>& listSoundProperties) const =0;
	/**
	 * This is used to retrieve all source sound properties related to a source.
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListMainSourceSoundProperties(const am_sourceID_t sourceID, std::vector<am_MainSoundProperty_s>& listSourceProperties) const =0;
	/**
	 * This is used to retrieve SourceClass Information of all source classes
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListSourceClasses(std::vector<am_SourceClass_s>& listSourceClasses) const =0;
	/**
	 * This is used to retrieve SinkClass Information of all sink classes
	 * @return E_OK on success, E_DATABASE_ERROR on error
	 */
	virtual am_Error_e getListSinkClasses(std::vector<am_SinkClass_s>& listSinkClasses) const =0;
	/**
	 * Retrieves a complete list of all systemProperties.
	 * @return E_OK on success, E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e getListSystemProperties(std::vector<am_SystemProperty_s>& listSystemProperties) const =0;
	/**
	 * returns the delay in ms that the audiopath for the given mainConnection has
	 * @return E_OK on success, E_NOT_POSSIBLE if timing information is not yet
	 * retrieved, E_DATABASE_ERROR on read error on the database
	 */
	virtual am_Error_e getTimingInformation(const am_mainConnectionID_t mainConnectionID, am_timeSync_t& delay) const =0;
	/**
	 * this function is used to retrieve a pointer to the dBusConnectionWrapper
	 * @return E_OK if pointer is valid, E_UKNOWN if AudioManager was compiled without
	 * DBus Support
	 */
	virtual am_Error_e getDBusConnectionWrapper(CAmDbusWrapper*& dbusConnectionWrapper) const =0;
	/**
	 * This function returns the pointer to the socketHandler. This can be used to
	 * integrate socket-based activites like communication with the mainloop of the
	 * AudioManager.
	 * returns E_OK if pointer is valid, E_UNKNOWN in case AudioManager was compiled
	 * without socketHandler support,
	 */
	virtual am_Error_e getSocketHandler(CAmSocketHandler*& socketHandler) const =0;
	/**
	 * asynchronous confirmation of setCommandReady.
	 */
	virtual void confirmCommandReady(const uint16_t handle, const am_Error_e error) =0;
	/**
	 * asynchronous confirmation of setCommandRundown
	 */
	virtual void confirmCommandRundown(const uint16_t handle, const am_Error_e error) =0;
	/**
	 * Retrieves the list of MainNotifications for a sink. Does not return the
	 * possible ones.
	 */
	virtual am_Error_e getListMainSinkNotificationConfigurations(const am_sinkID_t sinkID, std::vector<am_NotificationConfiguration_s>& listMainNotificationConfigurations) const =0;
	/**
	 * Retrieves the list of MainNotifications for a source. Does not return the
	 * possible ones.
	 */
	virtual am_Error_e getListMainSourceNotificationConfigurations(const am_sourceID_t sourceID, std::vector<am_NotificationConfiguration_s>& listMainNotificationConfigurations) const =0;
	/**
	 * sets a MainNotificationConfiuration. This can be used to turn on an off
	 * notifications an to change the mode of the configuration.
	 * @return E_OK on success, E_NON_EXISTENT if sinkID does not exists,
	 * E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e setMainSinkNotificationConfiguration(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
	/**
	 * sets a MainNotificationConfiuration. This can be used to turn on an off
	 * notifications an to change the mode of the configuration.
	 * @return E_OK on success, E_NON_EXISTENT if sourceID does not exists,
	 * E_DATABASE_ERROR on error 
	 */
	virtual am_Error_e setMainSourceNotificationConfiguration(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
	/**
	 * Returns the current volume for the sink directly out of the database.
	 */
	virtual am_Error_e getVolume(const am_sinkID_t sinkID, am_mainVolume_t& mainVolume) const =0;

};

/**
 * This interface handles all communication from the AudioManagerDaemon towards
 * the system. It is designed in such a way that only callbacks with no return
 * types are implemented. So when the CommandInterfacePlugins are designed in such
 * a way that they broadcast signals to any node who is interested in the
 * particular information (like signals on Dbus for example), more information can
 * be retrieved via the CommandReceiveInterface.
 * There are two rules that have to be kept in mind when implementing against this
 * interface:\n
 * \warning
 * 1. CALLS TO THIS INTERFACE ARE NOT THREAD SAFE !!!! \n
 * 2. YOU MAY NOT CALL THE CALLING INTERFACE DURING AN SYNCHRONOUS OR ASYNCHRONOUS
 * CALL THAT EXPECTS A RETURN VALUE.\n
 * \details
 * Violation these rules may lead to unexpected behavior! Nevertheless you can
 * implement thread safe by using the deferred-call pattern described on the wiki
 * which also helps to implement calls that are forbidden.\n
 * For more information, please check CAmSerializer
 */
class IAmCommandSend
{

public:
	IAmCommandSend() {

	}

	virtual ~IAmCommandSend() {

	}

	/**
	 * returns the interface version as string.
	 */
	virtual void getInterfaceVersion(std::string& version) const =0;
	/**
	 * This command starts the interface, the plugin itself. This is not meant to
	 * start communication with the HMI itself. It is a good idea to implement here
	 * everything that sets up the basic communication like DbusCommunication etc...
	 * Be aware of side effects with systemd and socketbased communication!
	 * @return E_OK on success, E_UNKNOWN on error
	 */
	virtual am_Error_e startupInterface(IAmCommandReceive* commandreceiveinterface) =0;
	/**
	 * This function will indirectly be called by the Controller and is used to start
	 * the Communication. Before this command, all communication will be ignored by
	 * the AudioManager.
	 * After the Plugin is ready, it will asynchronously answer with
	 * condfirmCommandReady, the handle that is handed over must be returned.
	 */
	virtual void setCommandReady(const uint16_t handle) =0;
	/**
	 * This function will indirectly be called by the Controller and is used to stop
	 * the Communication. After this command, all communication will be ignored by the
	 * AudioManager. The plugin has to be prepared that either the power will be
	 * switched off or the Interface is started again with setCommandReady
	 * After the Plugin is ready to rundown, it will asynchronously answer with
	 * condfirmCommandRundown, the handle that is handed over must be returned.
	 */
	virtual void setCommandRundown(const uint16_t handle) =0;
	/**
	 * Callback that is called when the number of connections change
	 */
	virtual void cbNewMainConnection(const am_MainConnectionType_s& mainConnection) =0;
	/**
	 * Callback that is called when the number of connections change
	 */
	virtual void cbRemovedMainConnection(const am_mainConnectionID_t mainConnection) =0;
	/**
	 * Callback that is called when the number of sinks change
	 */
	virtual void cbNewSink(const am_SinkType_s& sink) =0;
	/**
	 * Callback that is called when the number of sinks change
	 */
	virtual void cbRemovedSink(const am_sinkID_t sinkID) =0;
	/**
	 * Callback that is called when the number of sources change
	 */
	virtual void cbNewSource(const am_SourceType_s& source) =0;
	/**
	 * Callback that is called when the number of sources change
	 */
	virtual void cbRemovedSource(const am_sourceID_t source) =0;
	/**
	 * this callback is fired if the number of sink classes changed
	 */
	virtual void cbNumberOfSinkClassesChanged() =0;
	/**
	 * this callback is fired if the number of source classes changed
	 */
	virtual void cbNumberOfSourceClassesChanged() =0;
	/**
	 * This callback is called when the ConnectionState of a connection changed.
	 */
	virtual void cbMainConnectionStateChanged(const am_mainConnectionID_t connectionID, const am_ConnectionState_e connectionState) =0;
	/**
	 * this callback indicates that a sinkSoundProperty has changed.
	 */
	virtual void cbMainSinkSoundPropertyChanged(const am_sinkID_t sinkID, const am_MainSoundProperty_s& soundProperty) =0;
	/**
	 * this callback indicates that sourceSoundProperties have changed.
	 */
	virtual void cbMainSinkSoundPropertiesChanged(const am_sinkID_t /*sinkID*/, const std::vector<am_MainSoundProperty_s> &/*listSoundProperties*/) { return; };
	/**
	 * this callback indicates that a sourceSoundProperty has changed.
	 */
	virtual void cbMainSourceSoundPropertyChanged(const am_sourceID_t sourceID, const am_MainSoundProperty_s& soundProperty) =0;
	/**
	 * this callback indicates that sourceSoundProperties have changed.
	 */
	virtual void cbMainSourceSoundPropertiesChanged(const am_sourceID_t /*sourceID*/, const std::vector<am_MainSoundProperty_s> &/*listSoundProperties*/) { return; };
	/**
	 * this callback is called when the availability of a sink has changed
	 */
	virtual void cbSinkAvailabilityChanged(const am_sinkID_t sinkID, const am_Availability_s& availability) =0;
	/**
	 * this callback is called when the availability of source has changed.
	 */
	virtual void cbSourceAvailabilityChanged(const am_sourceID_t sourceID, const am_Availability_s& availability) =0;
	/**
	 * this callback indicates a volume change on the indicated sink
	 */
	virtual void cbVolumeChanged(const am_sinkID_t sinkID, const am_mainVolume_t volume) =0;
	/**
	 * this callback indicates a mute state change on a sink.
	 */
	virtual void cbSinkMuteStateChanged(const am_sinkID_t sinkID, const am_MuteState_e muteState) =0;
	/**
	 * is fired if a systemProperty changed
	 */
	virtual void cbSystemPropertyChanged(const am_SystemProperty_s& systemProperty) =0;
	/**
	 * is fired if a systemProperties changed
	 */
	virtual void cbSystemPropertiesChanged(const std::vector<am_SystemProperty_s>&/*listSystemProperties*/) { return; };
	/**
	 * This callback is fired if the timinginformation for a mainConnectionID changed
	 */
	virtual void cbTimingInformationChanged(const am_mainConnectionID_t mainConnectionID, const am_timeSync_t time) =0;
	/**
	 * This callback is called when a sink is updated.
	 */
	virtual void cbSinkUpdated(const am_sinkID_t sinkID, const am_sinkClass_t sinkClassID, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
	/**
	 * This callback is called when a source is updated.
	 */
	virtual void cbSourceUpdated(const am_sourceID_t sourceID, const am_sourceClass_t sourceClassID, const std::vector<am_MainSoundProperty_s>& listMainSoundProperties) =0;
	/**
	 * This callback is called when a notificated value of a sink changes.
	 */
	virtual void cbSinkNotification(const am_sinkID_t sinkID, const am_NotificationPayload_s& notification) =0;
	/**
	 * This callback is called when a notifcated value of a source changes.
	 */
	virtual void cbSourceNotification(const am_sourceID_t sourceID, const am_NotificationPayload_s& notification) =0;
	/**
	 * This callback is triggered when a mainNotificationConfiguration is changed.
	 */
	virtual void cbMainSinkNotificationConfigurationChanged(const am_sinkID_t sinkID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;
	/**
	 * This callback is triggered when a mainNotificationConfiguration is changed.
	 */
	virtual void cbMainSourceNotificationConfigurationChanged(const am_sourceID_t sourceID, const am_NotificationConfiguration_s& mainNotificationConfiguration) =0;

};
}
#endif // !defined(EA_D9D48C0D_77EC_4fa7_B861_1827740C7ECA__INCLUDED_)
