/*
 * aud_async_call.h
 *
 *  Created on: Apr 14, 2016
 *      Author: rjk2kor
 *  Note: This is a derivative work of CAM Serializer of Audio Manager, adapted the FC Audio Manager Mainloop
 */

#ifndef AUD_ASYNC_CALL_H_
#define AUD_ASYNC_CALL_H_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "fc_audiomanager_main.h"
#include <unistd.h>
#include <sys/poll.h>
#include <iostream>
#include <fcntl.h>
#include <stdio.h>

/**
 * Delegate task, with no arguments, is a async call
 */
template<class TClass>
class aud_async_call_delegate_noargs: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)();

public:
    aud_async_call_delegate_noargs(TClass* instance, void (TClass::*function)()) :
            mInstance(instance), //
            mFunction(function)
    {}

    void vExecute()
    {
        (*mInstance.*mFunction)();
    }
};
/**
 * delegate template for one argument
 */
template<class TClass, typename Targ>
class aud_async_call_delegate_onearg: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)(Targ);
    Targ mArgument;

public:
    aud_async_call_delegate_onearg(TClass* instance, void (TClass::*function)(Targ), Targ argument) :
            mInstance(instance), //
            mFunction(function), //
            mArgument(argument)
    {}

    void vExecute()
    {
        (*mInstance.*mFunction)(mArgument);
    }
};

/**
 * delegate template for two arguments
 */
template<class TClass, typename Targ, typename Targ1>
class aud_async_call_delegate_twoargs: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)(Targ argument, Targ1 argument1);
    Targ mArgument;
    Targ1 mArgument1;

public:
    aud_async_call_delegate_twoargs(TClass* instance, void (TClass::*function)(Targ argument, Targ1 argument1), Targ argument, Targ1 argument1) :
            mInstance(instance), //
            mFunction(function), //
            mArgument(argument), //
            mArgument1(argument1)
    { }

    void vExecute()
    {
        (*mInstance.*mFunction)(mArgument, mArgument1);
    }
};
/**
 * delegate template for three arguments
 */
template<class TClass, typename Targ, typename Targ1, typename Targ2>
class aud_async_call_delegate_threeargs: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)(Targ argument, Targ1 argument1,Targ2 argument2);
    Targ mArgument;
    Targ1 mArgument1;
    Targ2 mArgument2;

public:
    aud_async_call_delegate_threeargs(TClass* instance, void (TClass::*function)(Targ argument, Targ1 argument1,Targ2 argument2), Targ argument, Targ1 argument1,Targ2 argument2) :
            mInstance(instance), //
            mFunction(function), //
            mArgument(argument), //
            mArgument1(argument1),
        mArgument2(argument2)
    { }

    void vExecute()
    {
        (*mInstance.*mFunction)(mArgument, mArgument1,mArgument2);
    }
};

/**
 * delegate template for four arguments
 */
template<class TClass, typename Targ, typename Targ1, typename Targ2, typename Targ3>
class aud_async_call_delegate_fourargs: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3);
    Targ mArgument;
    Targ1 mArgument1;
    Targ2 mArgument2;
    Targ3 mArgument3;

public:
    aud_async_call_delegate_fourargs(TClass* instance, void (TClass::*function)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3),\
        Targ argument, Targ1 argument1,Targ2 argument2,Targ3 argument3) :
            mInstance(instance), //
            mFunction(function), //
            mArgument(argument), //
            mArgument1(argument1),
        mArgument2(argument2),
        mArgument3(argument3)
    { }

    void vExecute()
    {
        (*mInstance.*mFunction)(mArgument, mArgument1,mArgument2,mArgument3);
    }
};

/**
 * delegate template for five arguments
 */
template<class TClass, typename Targ, typename Targ1, typename Targ2, typename Targ3, typename Targ4>
class aud_async_call_delegate_fiveargs: public aud_tcl_loopback_IF
{
private:
    TClass* mInstance;
    void (TClass::*mFunction)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3,Targ4 argument4);
    Targ mArgument;
    Targ1 mArgument1;
    Targ2 mArgument2;
    Targ3 mArgument3;
    Targ4 mArgument4;

public:
    aud_async_call_delegate_fiveargs(TClass* instance, void (TClass::*function)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3,Targ4 argument4),\
        Targ argument, Targ1 argument1,Targ2 argument2,Targ3 argument3,Targ4 argument4) :
            mInstance(instance), //
            mFunction(function), //
            mArgument(argument), //
            mArgument1(argument1),
        mArgument2(argument2),
        mArgument3(argument3),
        mArgument4(argument4)
    { };

    void vExecute()
    {
        (*mInstance.*mFunction)(mArgument, mArgument1,mArgument2,mArgument3,mArgument4);
    }
};

///////////////////////////////////////////////////////////////////////////////
// ASYNC HANDLER CLASS
//////////////////////////////////////////////////////////////////////////////
class aud_async_call_handler
{
private:
  //Explicit privates
  aud_async_call_handler();
  aud_async_call_handler(const aud_async_call_handler&);
  aud_tcl_loopback_mgr* m_ploopmgr;

public:
   /**
    * Constructor
    */
   aud_async_call_handler(aud_tcl_loopback_mgr* ploopback)
   :m_ploopmgr(ploopback)
   {
   }
   /**
    * Destructor
    */
   virtual ~aud_async_call_handler()
   {
     m_ploopmgr = NULL;
   }
   void send(aud_tcl_loopback_IF* p)
   {
     if(p)
     {
       if(m_ploopmgr)
       {
         //If data successfully posted to loopback
         if(m_ploopmgr->bSendDataforLoopBack(p))
         {
           return;
         }
       }
       delete p;
     }
   }
   /**
    * Call related functions
    */
   //0 args
   template<class TClass>
   void vCall(TClass* instance, void (TClass::*function)())
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_noargs<TClass>(instance, function));
       send(p);
   }
   //1 args
   template<class TClass1, class Targ>
   void vCall(TClass1* instance, void (TClass1::*function)(Targ), Targ argument)
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_onearg<TClass1, Targ>(instance, function, argument));
       send(p);
   }
   //2 args
   template<class TClass1, class Targ, class Targ1>
   void vCall(TClass1* instance, void (TClass1::*function)(Targ argument, Targ1 argument1), Targ argument, Targ1 argument1)
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_twoargs<TClass1, Targ, Targ1>(instance, function, argument, argument1));
       send(p);
   }
   //3 args
   template<class TClass1, class Targ, class Targ1, class Targ2>
   void vCall(TClass1* instance, void (TClass1::*function)(Targ argument, Targ1 argument1, Targ2 argument2), Targ argument, Targ1 argument1,Targ2 argument2)
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_threeargs<TClass1, Targ, Targ1,Targ2>(instance, function, argument, argument1,argument2));
       send(p);
   }
   //4 args
   template<class TClass1, class Targ, class Targ1, class Targ2, class Targ3>
   void vCall(TClass1* instance, void (TClass1::*function)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3), Targ argument, Targ1 argument1,Targ2 argument2,Targ3 argument3)
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_fourargs<TClass1, Targ, Targ1,Targ2,Targ3>(instance, function, argument, argument1,argument2,argument3));
       send(p);
   }
   //5 args
   template<class TClass1, class Targ, class Targ1, class Targ2, class Targ3,class Targ4>
   void vCall(TClass1* instance, void (TClass1::*function)(Targ argument, Targ1 argument1, Targ2 argument2,Targ3 argument3,Targ4 argument4), Targ argument, Targ1 argument1,Targ2 argument2,Targ3 argument3,Targ4 argument4)
   {
     aud_tcl_loopback_IF* p(new aud_async_call_delegate_fiveargs<TClass1, Targ, Targ1,Targ2,Targ3,Targ4>(instance, function, argument, argument1,argument2,argument3,argument4));
       send(p);
   }
};


#endif /* AUD_ASYNC_CALL_H_ */
