/*
 * Copyright (C) 2008-2013 J.Rios <anonbeat@gmail.com>
 * Copyright (C) 2013 Jörn Magens
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This Program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file LICENSE.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth 
 * Floor, Boston, MA  02110-1301  USA
 * https://www.gnu.org/licenses/lgpl-2.1.txt
 *
 * Author:
 * 	Jörn Magens <shuerhaaken@googlemail.com>
 * 	Pavel Vasin <rat4vier@gmail.com>
 */



#include <string>
#include "taginfo.h"
#include "taginfo_internal.h"
#include <mp4file.h>


bool get_mp4_cover_art(TagLib::MP4::Tag * mp4tag, char*& data, int &data_length, ImageType &image_type) {
    data = NULL;
    data_length = 0;
    image_type = IMAGE_TYPE_UNKNOWN;
    
    if(mp4tag && mp4tag->itemListMap().contains("covr")) {
        TagLib::MP4::CoverArtList Covers = mp4tag->itemListMap()[ "covr" ].toCoverArtList();
        
        for(TagLib::MP4::CoverArtList::Iterator it = Covers.begin(); it != Covers.end(); it++) {
            if(it->format() == TagLib::MP4::CoverArt::PNG) {
                image_type = IMAGE_TYPE_PNG;
            }
            else if(it->format() == TagLib::MP4::CoverArt::JPEG) {
                image_type = IMAGE_TYPE_JPEG;
            }
            data_length = it->data().size();
            data = new char[data_length];
            memcpy(data, it->data().data(), it->data().size());
            return true;
        }
        return false;
    }
    return false;
}


bool set_mp4_cover_art(TagLib::MP4::Tag * mp4tag, const char* data, int data_length, ImageType image_type) {
    if(mp4tag) {
        if(mp4tag->itemListMap().contains("covr")) {
            mp4tag->itemListMap().erase("covr");
        }
        if(data && data_length > 0) {
            ByteVector image_data((TagLib::uint) data_length);
            memcpy(image_data.data(), data, data_length);
            TagLib::MP4::CoverArtList cover_list;
            TagLib::MP4::CoverArt::Format format = TagLib::MP4::CoverArt::JPEG;
            if(image_type == IMAGE_TYPE_JPEG || image_type == IMAGE_TYPE_UNKNOWN) //default to jpeg
                format = TagLib::MP4::CoverArt::JPEG;
            if(image_type == IMAGE_TYPE_PNG)
                format = TagLib::MP4::CoverArt::PNG;
            TagLib::MP4::CoverArt cover(format, image_data);
            cover_list.append(cover);
            mp4tag->itemListMap()[ "covr" ] = cover_list;
            return true;
        }
        return true;
    }
    return false;
}

String get_mp4_lyrics(TagLib::MP4::Tag * mp4tag) {
    if(mp4tag) {
            if(mp4tag->itemListMap().contains("\xa9lyr"))
            return mp4tag->itemListMap()[ "\xa9lyr" ].toStringList().front();
    }
    return String();
}


bool set_mp4_lyrics(TagLib::MP4::Tag * mp4tag, const String &lyrics) {
    if(mp4tag) {
            if(mp4tag->itemListMap().contains("\xa9lyr")) {
            mp4tag->itemListMap().erase("\xa9lyr");
        }
        if(!lyrics.isEmpty()) {
            mp4tag->itemListMap()[ "\xa9lyr" ] = TagLib::StringList(lyrics);
        }
        return true;
    }
    return false;
}



