/*
 * fc_dumm_JSONParser.cpp
 *
 *
 *
 */
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "fc_dumm_AppMain_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_DUMM_UTIL
#include "trcGenProj/Header/fc_dumm_JSONParser.cpp.trc.h"
#endif

#include <uuid/uuid.h>
#include "fc_dumm_JSONParser.h"
#include "I_fc_dumm_ConfigPolicy.h"
#include "I_fc_dumm_P_DP_Handler.h"
#include "I_fc_dumm_ConfigManager.h"

#define DATAWIPE_ACTION "Wipe"

fc_dumm_JSONParser::fc_dumm_JSONParser(fc_dumm_tclAppMain* poMainAppl)
:I_fc_dumm_JSONParser(poMainAppl)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser() -->"));
	_poConfigPolicy = OSAL_NULL;
	_poConfigManager = OSAL_NULL;
	m_bConvertLabel = true;//default value
	ETG_TRACE_USR4(("fc_dumm_JSONParser::fc_dumm_JSONParser default m_bConvertLabel:%d ", m_bConvertLabel));

	ETG_TRACE_USR4(("fc_dumm_JSONParser() <--"));

}

fc_dumm_JSONParser::~fc_dumm_JSONParser() {
}

tVoid fc_dumm_JSONParser::vStartCommunication()
{
	ETG_TRACE_USR1(("fc_dumm_JSONParser::vStartCommunication -->"));

	FC_DUMM_NULL_POINTER_CHECK(_poConfigPolicy);
	_poConfigPolicy->getLabelConvert(m_bConvertLabel);
	ETG_TRACE_USR4(("fc_dumm_JSONParser::vStartCommunication new m_bConvertLabel:%d ", m_bConvertLabel));

	ETG_TRACE_USR1(("fc_dumm_JSONParser::vStartCommunication <--"));

}

tVoid fc_dumm_JSONParser::vGetReferences()
{
	ETG_TRACE_USR1(("fc_dumm_JSONParser::vGetReferences -->"));

	_poConfigPolicy = dynamic_cast<I_fc_dumm_ConfigPolicy*>(_cpoMain->getHandler("I_fc_dumm_ConfigPolicy"));
	FC_DUMM_NULL_POINTER_CHECK(_poConfigPolicy);

    _poConfigManager = dynamic_cast<I_fc_dumm_ConfigManager*>(_cpoMain->getHandler("I_fc_dumm_ConfigManager"));
     FC_DUMM_NULL_POINTER_CHECK(_poConfigManager);

	ETG_TRACE_USR1(("fc_dumm_JSONParser::vGetReferences <--"));
}


tBool fc_dumm_JSONParser::bParseTargetID(Json::Value & root, std::string& strTargetID)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseTargetID -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseTargetID ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseTargetID TARGETID"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::TARGETID, strTargetID);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseTargetID strTargetID: %s", strTargetID.c_str()));

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseCorrelationID(Json::Value & root, std::string& strCorrelationID)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseCorrelationID -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseCorrelationID ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseCorrelationID CorrelationID"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::CORRELATIONID, strCorrelationID);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseCorrelationID strCorrelationID: %s", strCorrelationID.c_str()));

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseGlobalMessageId(Json::Value & root, std::string& strGlobalMessageId)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseGlobalMessageId -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseGlobalMessageId ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseGlobalMessageId GlobalMessageId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::GLOBALMESSAGEID, strGlobalMessageId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseGlobalMessageId GlobalMessageId: %s", strGlobalMessageId.c_str()));

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseDataDictionaryVersion(Json::Value & root, std::string& strDataDictionaryVersion)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseDataDictionaryVersion  -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseDataDictionaryVersion  ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseDataDictionaryVersion  DataDictionaryVersion "));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::DATADICTIONARYVERSION , strDataDictionaryVersion );
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseDataDictionaryVersion DataDictionaryVersion Error"));
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseDataDictionaryVersion  DataDictionaryVersion : %s", strDataDictionaryVersion .c_str()));

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseApplicationHeader(Json::Value& root,T_ApplicationHeader& oChannelData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//parse GlobalMessageId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader GlobalMessageId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::GLOBALMESSAGEID, oChannelData.GlobalMessageId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader GlobalMessageId: %s", oChannelData.GlobalMessageId.c_str()));

	//parse DataDictionaryVersion
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DataDictionaryVersion"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::DATADICTIONARYVERSION, oChannelData.DataDictionaryVersion);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DataDictionaryVersion: %s", oChannelData.DataDictionaryVersion.c_str()));

	//parse strMessageType
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader strMessageType"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::MESSAGETYPE, oChannelData.MessageType);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader strMessageType: %s", oChannelData.MessageType.c_str()));

	//parse TargetId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader TargetId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::TARGETID, oChannelData.TargetId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader TargetId: %s", oChannelData.TargetId.c_str()));

	//parse DevId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DevId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::DEVID, oChannelData.DevId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DevId: %s", oChannelData.DevId.c_str()));

	//parse DeviceType
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DeviceType"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::DEVICETYPE, oChannelData.DeviceType);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DeviceType: %s", oChannelData.DeviceType.c_str()));

	//parse VIN
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader VIN"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::VIN, oChannelData.VIN);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader VIN: %s", oChannelData.VIN.c_str()));

	//parse TimeStamp
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader TimeStamp"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::TIMESTAMP, oChannelData.TimeStamp);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader TimeStamp: %s", oChannelData.TimeStamp.c_str()));

	//parse DCMVersion
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DCMVersion"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::DCMVERSION, oChannelData.DCMVersion);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader DCMVersion: %s", oChannelData.DCMVersion.c_str()));

	//parse CorrelationId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader CorrelationId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::CORRELATIONID, oChannelData.CorrelationId);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader CorrelationId: %s", oChannelData.CorrelationId.c_str()));

	//parse BIN
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader BIN"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::BIN, oChannelData.BIN);
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader Optional field BIN does not exist"));
	}
	else
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader BIN: %s", oChannelData.BIN.c_str()));
	}

	//parse UserId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader UserId"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::USERID, oChannelData.UserId);
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader Optional field UserId does not exist"));
	}
	else
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader UserId: %s", oChannelData.UserId.c_str()));
	}

	//parse Token
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader Token"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::TOKEN, oChannelData.Token);
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader Optional field Token does not exist"));
	}
	else
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader Token: %s", oChannelData.Token.c_str()));
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader <--"));
	return true;
}

tBool fc_dumm_JSONParser::bParseUploadHeader(Json::Value& root, T_UploadHeader& oChannelData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader -->"));

	tBool bIsParsingSuccess = FALSE;

	//parse uploadFunctionID
	tU8 uploadFunctionID;
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader UPLOADFUNCTIONID"));
	bIsParsingSuccess = jsonUtils.gettU8UInt(root, json_utils::UPLOADFUNCTIONID, uploadFunctionID);//oChannelData.uploadFunctionID
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader uploadFunctionID: %d", uploadFunctionID));
	oChannelData.uploadFunctionID = (UploadFunctionID)uploadFunctionID;

	//parse CorrelationId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader CORRELATIONID"));
	bIsParsingSuccess = jsonUtils.getString(root, json_utils::CORRELATIONID, oChannelData.CorrelationId);//add to test due to: convert long to short label is not yet done
	//bIsParsingSuccess = jsonUtils.getString(root, json_utils::CORRELATIONID, oChannelData.CorrelationId); true
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader CorrelationId: %s", oChannelData.CorrelationId.c_str()));

	//parse UserId
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader USERID"));
	if(jsonUtils.getString(root, json_utils::USERID, oChannelData.UserId))
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader UserId: %s", oChannelData.UserId.c_str()));
	}
	else
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader UserId field not exist"));
	}
	//parse Token
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader TOKEN"));
	if(jsonUtils.getString(root, json_utils::TOKEN, oChannelData.Token))
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader Token: %s", oChannelData.Token.c_str()));
	}
	else
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseUploadHeader Token field not exist"));
	}

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseMessageType(Json::Value & root, std::string& strMessageType)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseMessageType root:%s-->", root.toStyledString().c_str()));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseMessageType ApplicationHeader"));
	Json::Value jApplicationHeader;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseMessageType strMessageType"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationHeader, json_utils::MESSAGETYPE, strMessageType);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseMessageType strMessageType: %s", strMessageType.c_str()));

	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseApplicationHeader(Json::Value root, Json::Value& jApplicationHeader)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationHeader ApplicationHeader"));
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONHEADER, jApplicationHeader);
	return bIsParsingSuccess;
}

tBool fc_dumm_JSONParser::bParseApplicationData(Json::Value root, Json::Value& jApplicationData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationData -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bParseApplicationData ApplicationData"));
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONDATA, jApplicationData);
	return bIsParsingSuccess;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_dumm_JSONParser::bShortToLongLabel
*
* DESCRIPTION: Convert Short to Long Label
*
*******************************************************************************/

tBool fc_dumm_JSONParser::bShortToLongLabel(Json::Value jShortData, Json::Value& jLongData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel -->"));
	if(m_bConvertLabel == false)
	{
		jLongData = jShortData;
		return true;
	}

	if(jShortData.size() <= 0)
		return false;

	T_dumm_ConfigPolicy* poConfigPolicy = _poConfigPolicy->getObjectConfigPolicy();
	if(poConfigPolicy == OSAL_NULL)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel poConfigPolicy is NULL"));
		return false;
	}

	for( Json::ValueIterator itr = jShortData.begin() ; itr != jShortData.end() ; itr++ ) {
		std::map<std::string, std::string>::iterator it;
		std::string strKeyNew, strKey = itr.memberName();

		it = poConfigPolicy->DataDictionary.mShortToLongLabel.find(strKey);
		if(it != poConfigPolicy->DataDictionary.mShortToLongLabel.end()) {
			strKeyNew = it->second;
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel strKey: %s ", strKey.c_str()));
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel strKeyNew: %s", strKeyNew.c_str()));
			jLongData[strKeyNew] = *itr;
		}
		else {
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel not found:%s ", strKey.c_str()));
			return false;
		}
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bShortToLongLabel <--"));
	return true;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_dumm_JSONParser::bLongToShortLabel
*
* DESCRIPTION: Convert Short to Long Label
*
*******************************************************************************/
tBool fc_dumm_JSONParser::bLongToShortLabel(Json::Value jLongData, Json::Value& jShortData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel -->"));
	if(m_bConvertLabel == false)
	{
		jShortData = jLongData;
		return true;
	}

	if(jLongData.size() <= 0)
		return false;

	T_dumm_ConfigPolicy* poConfigPolicy = _poConfigPolicy->getObjectConfigPolicy();
	if(poConfigPolicy == OSAL_NULL)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel poConfigPolicy is NULL"));
		return false;
	}

	for( Json::ValueIterator itr = jLongData.begin() ; itr != jLongData.end() ; itr++ ) {
		std::map<std::string, std::string>::iterator it;
		std::string strKeyNew, strKey = itr.memberName();

		it = poConfigPolicy->DataDictionary.mLongToShortLabel.find(strKey);
		if(it != poConfigPolicy->DataDictionary.mLongToShortLabel.end()) {
			strKeyNew = it->second;
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel strKey: %s ", strKey.c_str()));
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel strKeyNew: %s", strKeyNew.c_str()));
			jShortData[strKeyNew] = *itr;
		}
		else {
			ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel not found:%s ", strKey.c_str()));
			return false;
		}
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::bLongToShortLabel <--"));
	return true;
}

/*******************************************************************************
*
* FUNCTION: tVoid vSetConvertLabel(tBool value)
*
* DESCRIPTION: set to enable or disable label conversion
*
*******************************************************************************/
tVoid fc_dumm_JSONParser::vSetConvertLabel(tBool value)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::vSetConvertLabel -->"));
	m_bConvertLabel = value;
	ETG_TRACE_USR4(("fc_dumm_JSONParser::vSetConvertLabel m_bConvertLabel: %d <--", m_bConvertLabel));
}

tBool fc_dumm_JSONParser::CheckDataApplicationHeader(T_ApplicationHeader oChannelData)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader -->"));

	//Verify GlobalMessageId format or value
    uuid_t id;
    int iParse;
    iParse = uuid_parse(oChannelData.GlobalMessageId.c_str(), id);
    ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader GlobalMessageId iParse: %d", iParse));
    if(iParse == -1)
    {
    	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader GlobalMessageId: %s is wrong format", oChannelData.GlobalMessageId.c_str()));
    	return false;
    }

    //Verify CorrelationId format or value
	iParse = uuid_parse(oChannelData.CorrelationId.c_str(), id);
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader CorrelationId iParse: %d", iParse));
	if(iParse == -1)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader CorrelationId: %s is wrong format", oChannelData.CorrelationId.c_str()));
		return false;
	}

	//Verify MessageType and TargetId format or value
	BuffersType buffersType;
	DBPrio dbPrio;
	if(_poConfigPolicy->getDBMapDownLoad(oChannelData.MessageType, oChannelData.TargetId, buffersType, dbPrio) == false)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader MessageType: %s", oChannelData.MessageType.c_str()));
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader TargetId: %s", oChannelData.TargetId.c_str()));
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader MessageType or TargetId are wrong format"));
		return false;
	}

	//Verify DevId format or value
	FC_DUMM_NULL_POINTER_CHECK_VAL(_poConfigManager);
	std::string devId = _poConfigManager->getClientID();
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader DevId on target: %s", devId.c_str()));
	if(devId != oChannelData.DevId)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DevId is different from: %s", oChannelData.DevId.c_str()));
		return false;
	}

	//Verify DeviceType format or value
	FC_DUMM_NULL_POINTER_CHECK_VAL(_poConfigManager);
	std::string DeviceType = _poConfigManager->sGetDevType();
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader DeviceType on target: %s", DeviceType.c_str()));
	if(DeviceType != oChannelData.DeviceType)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DeviceType is different from: %s", oChannelData.DeviceType.c_str()));
		return false;
	}

	//Verify VIN format or value
	FC_DUMM_NULL_POINTER_CHECK_VAL(_poConfigManager);
	std::string VIN = _poConfigManager->sGetVIN();
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader VIN on target: %s", VIN.c_str()));
	if(VIN != oChannelData.VIN)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received VIN is different from: %s", oChannelData.VIN.c_str()));
		return false;
	}
	/*
	//Verify TimeStamp is empty
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp: %s", oChannelData.TimeStamp.c_str()));
	if(oChannelData.TimeStamp == "")
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp is empty: %s", oChannelData.TimeStamp.c_str()));
		return false;
	}

	//Verify DCMVersion is empty
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DCMVersion: %s", oChannelData.DCMVersion.c_str()));
	if(oChannelData.DCMVersion == "")
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DCMVersion is empty: %s", oChannelData.DCMVersion.c_str()));
		return false;
	}

	//Verify DataDictionaryVersion is empty
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DataDictionaryVersion: %s", oChannelData.DataDictionaryVersion.c_str()));
	if(oChannelData.DataDictionaryVersion == "")
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DataDictionaryVersion is empty: %s", oChannelData.DataDictionaryVersion.c_str()));
		return false;
	}
	*/

	//Verify TimeStamp format or value
	fc_dumm_Time timeStamp;
	if(!timeStamp.bNavTimeStamp(oChannelData.TimeStamp))
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp format incorrectly: %s", oChannelData.TimeStamp.c_str()));
		return false;
	}

	//Verify DCMVersion format or value
	FC_DUMM_NULL_POINTER_CHECK_VAL(_poConfigManager);
	std::string sDCMVersion = _poConfigManager->sGetDCMVersion();
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader DCMVersion on target: %s", sDCMVersion.c_str()));
	if(sDCMVersion != oChannelData.DCMVersion)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DCMVersion is different from: %s", oChannelData.DCMVersion.c_str()));
		return false;
	}

	//Verify DataDictionaryVersion format or value
	FC_DUMM_NULL_POINTER_CHECK_VAL(_poConfigManager);
	std::string sDataDictionaryVersion = _poConfigManager->sGetDataDictionaryVersion();
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader DataDictionaryVersion on target: %s", sDataDictionaryVersion.c_str()));
	if(sDataDictionaryVersion != oChannelData.DataDictionaryVersion)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received DataDictionaryVersion is different from: %s", oChannelData.DataDictionaryVersion.c_str()));
		return false;
	}


	return true;
}

/*******************************************************************************
*
* FUNCTION: tVoid CheckDataApplicationData()
*
* DESCRIPTION: Check Data ApplicationData
*
*******************************************************************************/

tBool fc_dumm_JSONParser::CheckDataApplicationData(Json::Value& root)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData ApplicationData"));
	Json::Value jApplicationData;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONDATA, jApplicationData);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//parse TimeStamp
	std::string strTimeStamp;
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData TimeStamp"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationData, json_utils::TS, strTimeStamp);
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData TimeStamp cannot be found"));
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData TimeStamp: %s", strTimeStamp.c_str()));

/*
	//Verify TimeStamp is empty
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp: %s", strTimeStamp.c_str()));
	if(strTimeStamp == "")
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp is empty: %s", strTimeStamp.c_str()));
		return false;
	}
*/
	
	//Verify TimeStamp format or value
	fc_dumm_Time timeStamp;
	if(!timeStamp.bNavTimeStamp(strTimeStamp))
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationHeader received timeStamp format incorrectly: %s", strTimeStamp.c_str()));
		return false;
	}

	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckDataApplicationData <--"));
	return true;
}

/*******************************************************************************
*
* FUNCTION: tBool CheckActionFieldOnDataWipe(Json::Value& root)
*
* DESCRIPTION: Check Action Field On DataWipe
*
*******************************************************************************/
tBool fc_dumm_JSONParser::CheckActionFieldOnDataWipe(Json::Value& root)
{
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe -->"));

	tBool bIsParsingSuccess = FALSE;

	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe ApplicationData"));
	Json::Value jApplicationData;
	bIsParsingSuccess = jsonUtils.getJSONObject(root, json_utils::APPLICATIONDATA, jApplicationData);
	if(!bIsParsingSuccess)
	{
		return bIsParsingSuccess;
	}

	//parse DataWipeAction
	std::string strDataWipeAction;
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe strDataWipeAction"));
	bIsParsingSuccess = jsonUtils.getString(jApplicationData, json_utils::DWAC, strDataWipeAction);
	if(!bIsParsingSuccess)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe DataWipeAction cannot be found"));
		return bIsParsingSuccess;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe DataWipeAction: %s", strDataWipeAction.c_str()));

	//check value
	if(strDataWipeAction != DATAWIPE_ACTION)
	{
		ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe value of DataWipeAction field is different from *Wipe* "));
		return FALSE;
	}
	ETG_TRACE_USR4(("fc_dumm_JSONParser::CheckActionFieldOnDataWipe <--"));
	return bIsParsingSuccess;
}
