#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_mp.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#ifdef TARGET_BUILD
#include "trcGenProj/Header/IpcBase.cpp.trc.h"
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_GEN_MEDIAPLAYER_FRAMEWORK
#endif
#endif

#include "IpcBase.h"
#include "TraceDefinitions.h"
#include <unistd.h>

const  char* iddbusAddress = "unix:path=/tmp/shared/iddbus/lxcdbus";


#define IPC_DBUS_PARAM_DELIMITER "\n"
/*lint -save -e429 */
void IpcBase::ParseMessage_iter(DBusMessageIter *iter, string& params)
{
    do
    {
        int type = dbus_message_iter_get_arg_type(iter);
        if (type == DBUS_TYPE_INVALID)
        {
            break;
        }
        switch (type)
        {
            case DBUS_TYPE_STRING:
            {
                char valmem[1024];
                char *val=valmem;
                dbus_message_iter_get_basic(iter, &val);
                params.append(val);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_SIGNATURE:
            {
                char valmem[1024];
                char *val=valmem;
                dbus_message_iter_get_basic(iter, &val);
                params.append(val);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_OBJECT_PATH:
            {
                char valmem[1024];
                char *val=valmem;
                dbus_message_iter_get_basic(iter, &val);
                params.append(val);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_INT16:
            {
                char data[16];
                dbus_int16_t val;
                dbus_message_iter_get_basic(iter, &val);
                sprintf(data, "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_UINT16:
            {
                char data[16];
                dbus_uint16_t val;
                dbus_message_iter_get_basic(iter, &val);
                sprintf(data, "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_INT32:
            {
                char data[16];
                dbus_int32_t val;
                dbus_message_iter_get_basic(iter, &val);
                sprintf(data, "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_UINT32:
            {
                dbus_uint32_t val;
                dbus_message_iter_get_basic(iter, &val);
                char data[32];
                snprintf(data, sizeof(data), "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_INT64:
            {
                char data[32];
                dbus_int64_t val;
                dbus_message_iter_get_basic(iter, &val);
                snprintf(data, sizeof(data), "%lld", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_UINT64:
            {
                char data[32];
                dbus_uint64_t val;
                dbus_message_iter_get_basic(iter, &val);
                snprintf(data, sizeof(data), "%llu",val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_DOUBLE:
            {
                char data[32];
                double val;
                dbus_message_iter_get_basic(iter, &val);
                snprintf(data, sizeof(data), "%g",val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_BYTE:
            {
                char data[8];
                unsigned char val;
                dbus_message_iter_get_basic(iter, &val);
                sprintf(data, "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_BOOLEAN:
            {
                char data[8];
                dbus_bool_t val;
                dbus_message_iter_get_basic(iter, &val);
                sprintf(data, "%d", val);
                params.append(data);
                params.append(IPC_DBUS_PARAM_DELIMITER);
                break;
            }

            case DBUS_TYPE_VARIANT:
            {
                DBusMessageIter subiter;
                dbus_message_iter_recurse(iter, &subiter);
                ParseMessage_iter(&subiter, params);
                break;
            }
            case DBUS_TYPE_ARRAY:
            {
                int current_type;
                DBusMessageIter subiter;
                dbus_message_iter_recurse(iter, &subiter);
                while ((current_type = dbus_message_iter_get_arg_type(&subiter)) != DBUS_TYPE_INVALID)
                {
                    ParseMessage_iter(&subiter, params);
                    dbus_message_iter_next(&subiter);
                    if (dbus_message_iter_get_arg_type(&subiter) != DBUS_TYPE_INVALID)
                    {
                        params.append(IPC_DBUS_PARAM_DELIMITER);
                    }
                }
                break;
            }
            case DBUS_TYPE_DICT_ENTRY:
            {
                DBusMessageIter subiter;
                dbus_message_iter_recurse(iter, &subiter);
                ParseMessage_iter(&subiter, params);
                dbus_message_iter_next(&subiter);
                ParseMessage_iter(&subiter, params);
                break;
            }
            case DBUS_TYPE_STRUCT:
            {
                int current_type;
                DBusMessageIter subiter;
                dbus_message_iter_recurse(iter, &subiter);
                while ((current_type = dbus_message_iter_get_arg_type(&subiter)) != DBUS_TYPE_INVALID)
                {
                    ParseMessage_iter(&subiter, params);
                    dbus_message_iter_next(&subiter);
                    if (dbus_message_iter_get_arg_type(&subiter) != DBUS_TYPE_INVALID)
                    {
                        params.append(IPC_DBUS_PARAM_DELIMITER);
                    }
                }
                break;
            }

            default:
                ETG_TRACE_USR1(("Dbus data type  %c is not supported by this binding yet \n ",type));
                break;
        }
    }
    while (dbus_message_iter_next(iter));
}


static DBusHandlerResult message_received (DBusConnection *connection, DBusMessage *pDBusMessage, void *user_data);

static DBusObjectPathVTable callbacksVTable = {
        NULL,
        message_received,
        NULL,
        NULL,
        NULL,
        NULL
};

IpcBase::IpcBase()
{
    /* enable locking of data structures in the D-Bus library for multi threading. */
    dbus_threads_init_default();

    /* get session bus connection*/
    DBusError err;
    dbus_error_init(&err);
    mSessionBusConnection = dbus_bus_get(DBUS_BUS_SESSION, &err);

    if (dbus_error_is_set(&err))
    {
        ETG_TRACE_ERR(("DBUS Connection Error (%s)", err.message));
        dbus_error_free(&err);
    }
    else
    {
        dbus_connection_set_exit_on_disconnect(mSessionBusConnection, FALSE );
    }

    //mCustomSessionBusConnection needs to connect to separate session bus to connect to "com.bosch.MediaAgentService" Service
    //details about iddbus can be found here https://inside-docupedia.bosch.com/confluence/display/gen3generic/CM+Containers
    mCustomSessionBusConnection =  dbus_connection_open(iddbusAddress, &err);
    if (dbus_error_is_set(&err))
    {
       ETG_TRACE_ERR(("DBUS with address connection Error (%s)", err.message));
       dbus_error_free(&err);
    }
    else
    {
       dbus_bus_register(mCustomSessionBusConnection, &err);
       dbus_connection_set_exit_on_disconnect(mCustomSessionBusConnection, FALSE );
    }


    /* get system bus connection*/
    DBusError err1;
    dbus_error_init(&err1);
    mSystemBusConnection = dbus_bus_get(DBUS_BUS_SYSTEM, &err1);

    if (dbus_error_is_set(&err1))
    {
        ETG_TRACE_ERR(("DBUS Connection Error while getting DBUS_BUS_SYSTEM(%s)", err1.message));
        dbus_error_free(&err1);
    }
    else
    {
        dbus_connection_set_exit_on_disconnect(mSystemBusConnection, FALSE );
    }
}

IpcBase::~IpcBase()
{

    if(mSessionBusConnection != NULL)
    {
        // destroy/unref the dbus connection if required;
        mSessionBusConnection = NULL;
    }

    if(mSystemBusConnection != NULL)
    {
        // destroy/unref the dbus connection if required;
        mSystemBusConnection = NULL;
    }

    if(mCustomSessionBusConnection != NULL)
    {
        // destroy/unref the dbus connection if required;
        mCustomSessionBusConnection = NULL;
    }
}

int IpcBase::RegisterService(const char* service ,const char* path ,const char* interface)
{

    (void)path;
    (void)interface;

    DBusError derror ;
    dbus_error_init(&derror);

    if (mSessionBusConnection && service)
    {
        int ret = dbus_bus_request_name(mSessionBusConnection, service, DBUS_NAME_FLAG_REPLACE_EXISTING ,&derror);
        if (ret != DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER)
        {
            ETG_TRACE_ERR(("Could not aquire D-BUS name (ret: %d) '%s'", ret,service));
            if (dbus_error_is_set(&derror))
            {
                ETG_TRACE_ERR(("%s", derror.message));
                dbus_error_free(&derror);
            }
            return -1;
        }
        return 0;
    }
    return -1;
}

int IpcBase::RegisterObjectPath(GMPDBusBusType busType ,const char* path)
{

    DBusConnection *pDbusConnection;
    if(busType == GMPDBUS_BUS_SYSTEM)
    {
        pDbusConnection = mSystemBusConnection;
    }
    else
    {
        pDbusConnection = mSessionBusConnection;
    }

    DBusError error;
    dbus_error_init(&error);

    if(0 == dbus_connection_try_register_object_path(pDbusConnection, path, &callbacksVTable, NULL, &error))
    {
        ETG_TRACE_ERR(("dbus_connection_try_register_object_path: %s", error.message));
        return -1;
    }
    return 0;
}

tBoolean IpcBase::SignalReceived(const char* name , const char* params)
{

    ETG_TRACE_USR2(("SignalReceived -> %128s:%s ", name, params));
    return 0x00;
}

tBoolean IpcBase::MethodAnswered(dbus_uint32_t serial , const char* params)
{

    ETG_TRACE_USR2(("MethodAnswered -> serial(%d):%s ",serial, params));
    return 0x00;
}

tBoolean IpcBase::MethodRequested(dbus_uint32_t serial , const char* name ,  const char* params)
{

    ETG_TRACE_USR2(("MethodRequested -> serial(%d), name(%128s):%s ",serial, name, params));
    return 0x00;
}

tBoolean IpcBase::Error(dbus_uint32_t serial , const char* errorName , const char* errorMessage)
{

    ETG_TRACE_USR2(("Error -> serial(%d) errorName:%s ", serial ,errorName));
    ETG_TRACE_USR2(("Error -> serial(%d) errorMessage:%s ", serial ,errorMessage));
    return 0x00;
}

#define APPEND_NUMBER(iter , params , type ,format) \
{ \
    char data[32]; \
    type value; \
    dbus_message_iter_get_basic(&iter, &value); \
    sprintf(data,format,value); \
    params.append(data); \
    if(dbus_message_iter_has_next(&iter)) \
        params.append(","); \
}

void IpcBase::AppendByteArray(DBusMessageIter &iter,string &params)
{

    DBusMessageIter subiter;
    dbus_message_iter_recurse(&iter, &subiter);
    int type = dbus_message_iter_get_arg_type( &subiter);
    if (type == DBUS_TYPE_DICT_ENTRY || type == DBUS_TYPE_OBJECT_PATH)
    {
        ParseMessage_iter(&subiter, params);
    }
    else
    {
    unsigned char val = 0;
    unsigned char* data = NULL;
    DBusMessageIter subiterlength;
    unsigned int arrayLength = 0;
    char arrayLengthString[32] = {0};
    DBusMessageIter subiterData;
    unsigned int arrayIndex = 0;
    char dataPtrString[32] = {0};
    dbus_message_iter_recurse (&iter, &subiterlength);
    dbus_message_iter_recurse (&iter, &subiterData);
    while((dbus_message_iter_get_arg_type (&subiterlength)) != DBUS_TYPE_INVALID)
    {
        arrayLength++;
        dbus_message_iter_next (&subiterlength);
    }
    sprintf(arrayLengthString,"%d",arrayLength);
    params.append(arrayLengthString);
    params.append(",");
    if(arrayLength)
    {
        data = new unsigned char[arrayLength];
        if(data != NULL)
        {
            while ((dbus_message_iter_get_arg_type (&subiterData)) != DBUS_TYPE_INVALID && (arrayIndex < arrayLength))
            {
                dbus_message_iter_get_basic(&subiterData, &val);
                data[arrayIndex++]= val;
                dbus_message_iter_next (&subiterData);
            }
            sprintf(dataPtrString,"%p",data);
            params.append(dataPtrString);
            delete [] data; // sim4hi: fix for Coverity CID-30025
        }
        else
        {
            params.append("0");
        }
    }
    else
    {
        params.append("0");
    }
    if(dbus_message_iter_has_next(&iter))
    params.append(",");
    }
}

DBusHandlerResult IpcBase::ParseMessage(DBusMessage *pDBusMessage)
{

    tBoolean messageHandled = 0x00;
    const char* name = "";
    if ( pDBusMessage )
    {
        name = dbus_message_get_member(pDBusMessage);
        string params = "";

        DBusMessageIter iter;
        if(dbus_message_iter_init (pDBusMessage, &iter))
        {
            int type = 0;
            while ((type = dbus_message_iter_get_arg_type (&iter)) != DBUS_TYPE_INVALID)
            {
                switch(type)
                {
                    case DBUS_TYPE_BOOLEAN:
                        APPEND_NUMBER(iter,params,int,"%d");
                        break;

                    case DBUS_TYPE_INT32:
                        APPEND_NUMBER(iter,params,int,"%d");
                        break;

                    case DBUS_TYPE_UINT32:
                        APPEND_NUMBER(iter,params,unsigned int,"%d");
                        break;
                    case DBUS_TYPE_INT16:
                        APPEND_NUMBER(iter,params,unsigned int,"%hd");
                        break;
                    case DBUS_TYPE_DOUBLE:
                        APPEND_NUMBER(iter,params,double,"%f");
                        break;

                    case DBUS_TYPE_INT64:
                        APPEND_NUMBER(iter,params,long long,"%lld");
                        break;

                    case DBUS_TYPE_UINT16:

                        APPEND_NUMBER(iter,params,unsigned short int,"%u");
                        break;


                    case DBUS_TYPE_STRING:
                    {
                        if(name!=NULL &&(!strcmp(name,"PropertiesChanged")))
                        {
                            ParseMessage_iter(&iter, params);

                        }else
                        {
                           char value[255];
                           char *str_val = value;
                           dbus_message_iter_get_basic(&iter, &str_val);
                           params.append(str_val);
                           if(dbus_message_iter_has_next(&iter)) \
                               params.append(","); \
                        }
                    }
                    break;

                    case DBUS_TYPE_STRUCT:// TODO : handle this in a generic way not method specific
                        if(name!=NULL && !strcmp(name,"Tick_TimeElapsedSlot"))
                        {
                            DBusMessageIter struct_iter;
                            dbus_message_iter_recurse (&iter, &struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            if(dbus_message_iter_has_next(&iter)) \
                                params.append(","); \
                        }
                        else if (name!=NULL && !strcmp(name,"MainSinkSoundPropertyChanged"))
                        {
                            DBusMessageIter struct_iter;
                            dbus_message_iter_recurse (&iter, &struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            if(dbus_message_iter_has_next(&iter)) \
                                    params.append(","); \
                                    params.append(",");
                        }
                        break;
                    case DBUS_TYPE_BYTE:
                        APPEND_NUMBER(iter,params,unsigned char,"%d");
                        break;

                    case DBUS_TYPE_ARRAY:
                        if(name!=NULL &&  (!strcmp(name,"PlayerAdded")|| !strcmp(name,"PropertiesChanged")))
                        {
                            DBusMessageIter subiter;
                            dbus_message_iter_recurse(&iter, &subiter);
                            ParseMessage_iter(&subiter, params);

                        }
                        else
                        {
                            if(dbus_type_is_fixed(DBUS_TYPE_ARRAY))
                            {
                                AppendByteArray(iter,params);
                            }
                            else
                            {
                                ETG_TRACE_USR1(("dbus_type_is_ NOT a fixed length"));
                                AppendByteArray(iter,params);
                            }
                        }
                        break;
                    case DBUS_TYPE_VARIANT:
                    {
                        DBusMessageIter subiter;
                        dbus_message_iter_recurse(&iter, &subiter);
                        ParseMessage_iter(&subiter, params);
                    }
                    break;
                    case DBUS_TYPE_OBJECT_PATH:
                    {
                        ParseMessage_iter(&iter, params);
                    }
                    break;
                    default:
                        ETG_TRACE_USR1(("Dbus data type  %c in not supprted by this binding yet \n ",type));
                        break;
                }
                dbus_message_iter_next (&iter);
            }
        }
        else
        {
            ETG_TRACE_USR1(("received DBus message %s has no arguments ",dbus_message_get_member(pDBusMessage)));
        }

        switch( dbus_message_get_type (pDBusMessage))
        {
            case DBUS_MESSAGE_TYPE_SIGNAL:
                // thoemel too many traces ETG_TRACE_USR1(("IpcBase::ParseMessage ->received signal : %128s , params : %s",name,params.c_str()));
                messageHandled = SignalReceived(name,params.c_str());

                // todo: thoemel: hack: The IpcProvider filteres all signals away from
                // the current process because he do not expect one,
                // but the RemoteStateMachienManager needs signals
                // therefore it has to return NOT handled to dbus to forward the signal to others.
                return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;

                break;

            case DBUS_MESSAGE_TYPE_METHOD_CALL:
                ETG_TRACE_USR1(("IpcBase::ParseMessage ->received Method request : %128s , params : %s",name!=NULL?name:"null" ,params.c_str()));
                messageHandled = MethodRequested(dbus_message_get_serial(pDBusMessage),name,params.c_str());

                /* Reply all method calls with an answer with empty payload (very important for synchronous GDBus method calls)*/
                if(mSessionBusConnection)
                {
                    DBusMessage *pReplyMessage = dbus_message_new_method_return(pDBusMessage);
                    dbus_connection_send(mSessionBusConnection, pReplyMessage, NULL);
                    dbus_message_unref(pReplyMessage);
                }
                break;

            case DBUS_MESSAGE_TYPE_METHOD_RETURN:
                ETG_TRACE_USR1(("IpcBase::ParseMessage ->received Method answer params : %s",params.c_str()));
                messageHandled = MethodAnswered(dbus_message_get_reply_serial(pDBusMessage),params.c_str());
                break;

            case DBUS_MESSAGE_TYPE_ERROR:
                messageHandled = Error(dbus_message_get_reply_serial(pDBusMessage),dbus_message_get_error_name(pDBusMessage),params.c_str());
                break;

            default:
                break;
        }
    }

    if(messageHandled)
    {
        return DBUS_HANDLER_RESULT_HANDLED;
    }
    else
    {
        ETG_TRACE_USR4(("IpcBase::ParseMessage ->message not handled by GMP: %s",name));
        return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
    }
}
void IpcBase::ParseMessageWithByteArray(DBusMessage *pDBusMessage,string& params)
{

    const char* name = "";
    if ( pDBusMessage )
    {
        name = dbus_message_get_member(pDBusMessage);
        params = "";

        DBusMessageIter iter;
        if(dbus_message_iter_init (pDBusMessage, &iter))
        {
            int type = 0;
            while ((type = dbus_message_iter_get_arg_type (&iter)) != DBUS_TYPE_INVALID)
            {
                switch(type)
                {
                    case DBUS_TYPE_BOOLEAN:
                        APPEND_NUMBER(iter,params,int,"%d");
                        break;

                    case DBUS_TYPE_INT32:
                        APPEND_NUMBER(iter,params,int,"%d");
                        break;

                    case DBUS_TYPE_UINT32:
                        APPEND_NUMBER(iter,params,unsigned int,"%d");
                        break;

                    case DBUS_TYPE_DOUBLE:
                        APPEND_NUMBER(iter,params,double,"%f");
                        break;

                    case DBUS_TYPE_INT64:
                        APPEND_NUMBER(iter,params,long long,"%lld");
                        break;

                    case DBUS_TYPE_STRING:
                    {
                        if(name!=NULL &&(!strcmp(name,"PropertiesChanged")))
                        {
                            ParseMessage_iter(&iter, params);

                        }else
                        {
                           char value[255];
                           char *str_val = value;
                           dbus_message_iter_get_basic(&iter, &str_val);
                           params.append(str_val);
                           if(dbus_message_iter_has_next(&iter)) \
                               params.append(","); \
                        }
                    }
                    break;

                    case DBUS_TYPE_STRUCT:// TODO : handle this in a generic way not method specific
                        if(name!=NULL && !strcmp(name,"Tick_TimeElapsedSlot"))
                        {
                            DBusMessageIter struct_iter;
                            dbus_message_iter_recurse (&iter, &struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            APPEND_NUMBER(struct_iter,params,int,"%d");
                            dbus_message_iter_next (&struct_iter);

                            if(dbus_message_iter_has_next(&iter)) \
                                params.append(","); \
                        }
                        break;
                    case DBUS_TYPE_BYTE:
                        APPEND_NUMBER(iter,params,unsigned char,"%d");
                        break;

                    case DBUS_TYPE_ARRAY:
                        if(name!=NULL &&  (!strcmp(name,"PlayerAdded")|| !strcmp(name,"PropertiesChanged")))
                        {
                            DBusMessageIter subiter;
                            dbus_message_iter_recurse(&iter, &subiter);
                            ParseMessage_iter(&subiter, params);

                        }
                        else
                        {
                            if(dbus_type_is_fixed(DBUS_TYPE_ARRAY))
                            {
                                AppendByteArray(iter,params);
                            }
                            else
                            {
                                ETG_TRACE_USR1(("dbus_type_is_ NOT a fixed length"));
                                AppendByteArray(iter,params);
                            }
                        }
                        break;
                    case DBUS_TYPE_VARIANT:
                    {
                        DBusMessageIter subiter;
                        dbus_message_iter_recurse(&iter, &subiter);
                        ParseMessage_iter(&subiter, params);
                    }
                    break;
                    case DBUS_TYPE_OBJECT_PATH:
                    {
                        ParseMessage_iter(&iter, params);
                    }
                    break;
                    default:
                        ETG_TRACE_USR1(("Dbus data type  %c in not supprted by this binding yet \n ",type));
                        break;
                }
                dbus_message_iter_next (&iter);
            }
        }
        else
        {
            ETG_TRACE_USR1(("received DBus message %s has no arguments ",dbus_message_get_member(pDBusMessage)));
        }
    }
}

static DBusHandlerResult message_received (DBusConnection *connection, DBusMessage *pDBusMessage, void *user_data)
{

    (void)connection;
    IpcBase *self = (IpcBase*)(user_data);

    return self->ParseMessage(pDBusMessage);
}

int IpcBase::SetFilter(GMPDBusBusType busType , const char* filter)
{

    DBusConnection *pDbusConnection;

    if( GMPDBUS_BUS_SYSTEM == busType )
    {
        pDbusConnection = mSystemBusConnection;
    }
    else if( GMPDBUS_BUS_CUSTOMSESSION == busType )
    {
        pDbusConnection = mCustomSessionBusConnection;
    }
    else
    {
        pDbusConnection = mSessionBusConnection;
    }

    if(pDbusConnection)
    {
        DBusError err;
        dbus_error_init(&err);

        dbus_bus_add_match (pDbusConnection, filter, &err);
        if (dbus_error_is_set(&err))
        {
            ETG_TRACE_ERR(("DBUS add match Error (%s)", err.message));
            dbus_error_free(&err);
            return -1;
        }

        #if 0
        if(!dbus_connection_add_filter (pDbusConnection, message_received, this, NULL))
            return -1;
        #endif

        /*Success*/
        return 0;

    }
    return -1;
}

int IpcBase::RemoveFilter(GMPDBusBusType busType , const char* filter)
{

    DBusConnection *pDbusConnection;

    if( GMPDBUS_BUS_SYSTEM == busType )
    {
        pDbusConnection = mSystemBusConnection;
    }
    else if(GMPDBUS_BUS_CUSTOMSESSION == busType )
    {
        pDbusConnection = mCustomSessionBusConnection;
    }
    else
    {
        pDbusConnection = mSessionBusConnection;
    }

    if(pDbusConnection)
    {
        DBusError err;
        dbus_error_init(&err);

        dbus_bus_remove_match (pDbusConnection, filter, &err);
        if (dbus_error_is_set(&err))
        {
            ETG_TRACE_ERR(("DBUS remove match Error (%s)", err.message));
            dbus_error_free(&err);
            return -1;
        }

        /*Success*/
        return 0;
    }
    return -1;
}

int IpcBase::DispatchMessages(void)
{

    enum {dispatchTimeout = 10}; // former 50
    enum {waitTime = 1000L}; // former 10000

    if(mSessionBusConnection)
    {
        usleep(waitTime); // wait 10ms that the sending thread has the chance to send something
        //sched_yield(); //own thread is relinquished the CPU

        m_Mutex.lock();
        if(dbus_connection_read_write_dispatch(mSessionBusConnection, dispatchTimeout)) // max wait 50ms
        {
            if(mSystemBusConnection && dbus_connection_read_write_dispatch(mSystemBusConnection, dispatchTimeout)) // max wait 50ms
            {
                //dispatch the messages from custom session bus address
                if(mCustomSessionBusConnection && dbus_connection_read_write_dispatch(mCustomSessionBusConnection, dispatchTimeout)) // max wait 50ms
                {
                    m_Mutex.unlock();
                    return 0;
                }
                m_Mutex.unlock();
                return 0;
            }
        }

        m_Mutex.unlock();
    }
    return -1;
}
void IpcBase::RegisterCallbackFunction(GMPDBusBusType busType)
{

    DBusConnection *pDbusConnection = NULL;

    if(GMPDBUS_BUS_SYSTEM == busType)
    {
        pDbusConnection = mSystemBusConnection;
    }
    else if(GMPDBUS_BUS_CUSTOMSESSION == busType)
    {
        pDbusConnection = mCustomSessionBusConnection;
    }
    else if(GMPDBUS_BUS_SESSION == busType)
    {
        pDbusConnection = mSessionBusConnection;
    }
    else
    {
        ETG_TRACE_ERR(("GMPDBusBusType not supported"));
    }

    if(pDbusConnection)
    {
        if(!dbus_connection_add_filter (pDbusConnection, message_received, this, NULL))
        {
            ETG_TRACE_ERR(("dbus_connection_add_filter failed for GMPDBusBusType : %d",busType));
        }
    }
    else
    {
        ETG_TRACE_ERR(("dbusConnection is NULL"));
    }
}

void IpcBase::DeRegisterCallbackFunction(GMPDBusBusType busType)
{
    DBusConnection *pDbusConnection = NULL;

    if(GMPDBUS_BUS_SYSTEM == busType)
    {
        pDbusConnection = mSystemBusConnection;
    }
    else if(GMPDBUS_BUS_CUSTOMSESSION == busType)
    {
        pDbusConnection = mCustomSessionBusConnection;
    }
    else if(GMPDBUS_BUS_SESSION == busType)
    {
        pDbusConnection = mSessionBusConnection;
    }
    else
    {
        ETG_TRACE_ERR(("GMPDBusBusType not supported"));
    }

    if(pDbusConnection)
    {
        dbus_connection_remove_filter (pDbusConnection, message_received, this);
    }
    else
    {
        ETG_TRACE_ERR(("dbusConnection is NULL"));
    }
}
