/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/src/osgDB/DatabasePager.cpp
List of changes:
1. Changed name of class in className to detect this node visitor
*/


#ifndef MAPENGINE_OSS_OSGUTILS_CVTRIGGEREDINCCOMPILEHELPERS_
#define MAPENGINE_OSS_OSGUTILS_CVTRIGGEREDINCCOMPILEHELPERS_ 1

#include <osg/KdTree>
#include <osgUtil/IncrementalCompileOperation>
#include <osgDB/Registry>
#include "oss/Export.h"

namespace mapengine {
namespace oss {

class FindCompileableGLObjectsVisitor : public osgUtil::StateToCompile
{
public:
   FindCompileableGLObjectsVisitor(bool uploadTextures = true):
      osgUtil::StateToCompile(osgUtil::GLObjectsVisitor::COMPILE_DISPLAY_LISTS|osgUtil::GLObjectsVisitor::COMPILE_STATE_ATTRIBUTES),
         _changeAutoUnRef(false), _valueAutoUnRef(false),
         _changeAnisotropy(false), _valueAnisotropy(1.0),
         _uploadTextures(uploadTextures)
      {
         _assignPBOToImages = false;
         _changeAutoUnRef = false;
         _valueAutoUnRef = true;
         _changeAnisotropy = false;
         _valueAnisotropy = 1.0F;
         _mode = _mode | osgUtil::GLObjectsVisitor::SWITCH_ON_VERTEX_BUFFER_OBJECTS;

         if (osgDB::Registry::instance()->getBuildKdTreesHint()==osgDB::Options::BUILD_KDTREES &&
             osgDB::Registry::instance()->getKdTreeBuilder())
         {
            _kdTreeBuilder = osgDB::Registry::instance()->getKdTreeBuilder()->clone();
         }
      }

      META_NodeVisitor("utils","CVTFindCompileableGLObjectsVisitor")

      bool requiresCompilation() const { return !empty(); }

      virtual void apply(osg::Geode& geode)
      {
         StateToCompile::apply(geode);

         if (_kdTreeBuilder.valid())
         {
            geode.accept(*_kdTreeBuilder);
         }
      }

      void apply(osg::Texture& texture)
      {
         if (_uploadTextures)
         {
            StateToCompile::apply(texture);

            if (_changeAutoUnRef)
            {
               texture.setUnRefImageDataAfterApply(_valueAutoUnRef);
            }

            if ((_changeAnisotropy && texture.getMaxAnisotropy() != _valueAnisotropy))
            {
               texture.setMaxAnisotropy(_valueAnisotropy);
            }
         }
      }

      bool                                    _changeAutoUnRef;
      bool                                    _valueAutoUnRef;
      bool                                    _changeAnisotropy;
      float                                   _valueAnisotropy;
      osg::ref_ptr<osg::KdTreeBuilder>        _kdTreeBuilder;
      bool                                    _uploadTextures;

protected:
   virtual ~FindCompileableGLObjectsVisitor(){}
   FindCompileableGLObjectsVisitor& operator = (const FindCompileableGLObjectsVisitor&) { return *this; }
};

}
}

#endif // MAPENGINE_OSS_OSGUTILS_CVTRIGGEREDINCCOMPILEHELPERS_
