/**
* @file ktxplatform.h
* @author RBEI/ECS1 Shreya Devurkar
* @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
* @description Platform specific code for building ktx across multiple platforms
* @{
*/

#ifndef __ktxheader_h_
#define __ktxheader_h_

#include <stdio.h>
#include "KHR/khrplatform.h"

#ifndef WIN32

   // Required for compatibility with glext.h sytle function definitions of
   // OpenGL extensions, such as in src/osg/Point.cpp.
   #ifndef APIENTRY
   #define APIENTRY
   #endif

#else // WIN32

   #if defined(__CYGWIN__) || defined(__MINGW32__)

      #ifndef APIENTRY
         #define GLUT_APIENTRY_DEFINED
         #define APIENTRY __stdcall
      #endif
// XXX This is from Win32's <windef.h>
      #ifndef CALLBACK
         #define CALLBACK __stdcall
      #endif

   #else // ! __CYGWIN__

// Under Windows avoid including <windows.h>
// to avoid name space pollution, but Win32's <GL/gl.h>
// needs APIENTRY and WINGDIAPI defined properly.
// XXX This is from Win32's <windef.h>
      #ifndef APIENTRY
         #define GLUT_APIENTRY_DEFINED
            #if (_MSC_VER >= 800) || defined(_STDCALL_SUPPORTED)
               #define WINAPI __stdcall
               #define APIENTRY WINAPI
            #else
               #define APIENTRY
            #endif
      #endif

// XXX This is from Win32's <windef.h>
   #ifndef CALLBACK
      #if (_MSC_VER >= 800) || defined(_STDCALL_SUPPORTED)
         #define CALLBACK __stdcall
      #else
         #define CALLBACK
      #endif
   #endif

   #endif // __CYGWIN__

// XXX This is from Win32's <wingdi.h> and <winnt.h>
   #ifndef WINGDIAPI
      #define GLUT_WINGDIAPI_DEFINED
      #define DECLSPEC_IMPORT __declspec(dllimport)
      #define WINGDIAPI DECLSPEC_IMPORT
   #endif

// XXX This is from Win32's <ctype.h>
   #if !defined(_WCHAR_T_DEFINED) && !(defined(__GNUC__)&&((__GNUC__ == 3)||(__GNUC__ == 4)))
      typedef unsigned short wchar_t;
      #define _WCHAR_T_DEFINED
   #endif

#endif // WIN32

#ifndef GL_TEXTURE_SWIZZLE_RGBA
#define GL_TEXTURE_SWIZZLE_RGBA 0x8E46
#endif

#ifndef GL_ARB_texture_rg
#define GL_RG                             0x8227
#define GL_RG_INTEGER                     0x8228
#define GL_R8                             0x8229
#define GL_R16                            0x822A
#define GL_RG8                            0x822B
#define GL_RG16                           0x822C
#define GL_R16F                           0x822D
#define GL_R32F                           0x822E
#define GL_RG16F                          0x822F
#define GL_RG32F                          0x8230
#define GL_R8I                            0x8231
#define GL_R8UI                           0x8232
#define GL_R16I                           0x8233
#define GL_R16UI                          0x8234
#define GL_R32I                           0x8235
#define GL_R32UI                          0x8236
#define GL_RG8I                           0x8237
#define GL_RG8UI                          0x8238
#define GL_RG16I                          0x8239
#define GL_RG16UI                         0x823A
#define GL_RG32I                          0x823B
#define GL_RG32UI                         0x823C
#endif

#endif /* _KTX_H_ */
