/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
- Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/src/osg/Stats.cpp
- Implementation of the additional APIs to enable storing and accessing of dynamically changing strings as stats for debugging purposes.
*/

#include "oss/stats/CustomStats.h"

using namespace mapengine::oss;

me_CustomStats::me_CustomStats(const std::string& name)
:Stats(name)
{
   customAllocate(noOfFrames);
}


void me_CustomStats::customAllocate(unsigned int numberOfFrames)
{
   OpenThreads::ScopedLock<OpenThreads::Mutex> lock(_mutex);
   
   _customAttributeMapList.clear();
   _customAttributeMapList.resize(numberOfFrames);
}

bool me_CustomStats::setCustomAttribute(unsigned int frameNumber, const std::string& attributeName, const std::string& value)
{
   if (frameNumber < getEarliestFrameNumber()) return false;

   OpenThreads::ScopedLock<OpenThreads::Mutex> lock(_mutex);

   if (frameNumber > _latestFrameNumber)
   {
      // need to advance

      // first clear the entries up to and including the new frameNumber
      for(unsigned int i = _latestFrameNumber+1; i <= frameNumber; ++i)
      {
         unsigned int index = (i - _baseFrameNumber) % _customAttributeMapList.size();
         _customAttributeMapList[index].clear();
      }

      if ( (frameNumber-_baseFrameNumber) >= static_cast<unsigned int>(_customAttributeMapList.size()))
      {
         _baseFrameNumber = (frameNumber/_customAttributeMapList.size())*_customAttributeMapList.size();
      }

      _latestFrameNumber = frameNumber;
   }

   int index = getIndex(frameNumber);
   if (index < 0)
   {
      OSG_NOTICE << "Failed to passing valid index for Stats::setAttribute" << frameNumber << "," << attributeName << "," << value << ")"<< std::endl;
      return false;
   }

   CustomAttributeMap& customAttributeMap = _customAttributeMapList[index];
   customAttributeMap[attributeName] = value;

   return true;
}

bool me_CustomStats::getCustomAttributeNoMutex(unsigned int frameNumber, const std::string& attributeName, std::string& value) const
{
   int index = getIndex(frameNumber);
   if (index < 0) return false;

   const CustomAttributeMap& customAttributeMap = _customAttributeMapList[index];
   CustomAttributeMap::const_iterator itr = customAttributeMap.find(attributeName);
   if (itr == customAttributeMap.end()) return false;

   value = itr->second;
   return true;
}
