/*
 * Curl_Download_handler.cpp
 *
 *  Created on: Jan 16, 2018
 *      Author: gjd5kor
 */

#include "Curl_Download_handler.h"
#include <curl/curl.h>
#include "alliance_telematics_AppMain.h"
#include "alliance_telematics_DLT_Trace_Header.h"
#include "alliance_telematics_AppMain_Trace.h"

#include <iostream>
#include <fstream>
#include "json_utils.h"
#define TRACE_FILE_NAME "Curl_Download_handler.cpp"

Curl_Download_handler::Curl_Download_handler(alliance_telematics_tclAppMain* _poMainAppl):
I_Curl_Download_handler(_poMainAppl) {
	// TODO Auto-generated constructor stub

}

Curl_Download_handler::~Curl_Download_handler() {
	// TODO Auto-generated destructor stub
}

void parseCertData(std::string sCertData)
{
	ATEL_LOG_INFO(("fc_alliance_telematics_ConfigManager::vGetReferences() Entered "));(("fc_alliance_telematics_ConfigManager::vGetReferences() Entered "));
	json_utils util;
	Json::Value root;
	Json::Reader reader;

	bool parsingSuccessful = reader.parse( sCertData.c_str(), root );
	ATEL_LOG_INFO(("Root Parse :: %d",parsingSuccessful));

	std::string sn;
	util.getString(root,"sn",sn);

	std::string certData;
	util.getString(root,"certificate",certData);

	std::ofstream myfile;
	myfile.open ("/opt/bosch/tcu/certs/BOSCHRLT201220171013.crt");
	myfile << certData;
	myfile.close();

}

size_t write_callback(char *ptr, size_t size, size_t nmemb, void *userdata)
{
	ATEL_LOG_INFO(("Curl_Download_handler :: WriteMemoryCallback() Entered"));
	std::string Data(ptr,size*nmemb);
	//ATEL_LOG_INFO(("Curl_Download_handler :: WriteMemoryCallback() :: Data downloaded :: %s", Data.c_str()));
	Curl_Download_handler *_poSelf = dynamic_cast<Curl_Download_handler*>(alliance_telematics_tclAppMain::theServer()->getHandler("Curl_Download_handler"));
	if(_poSelf)
	{
		_poSelf->SetResponseData(Data);
	}
	else
	{
		ATEL_LOG_INFO(("Unable to Self Ptr"));
	}
	ATEL_LOG_INFO(("Curl_Download_handler :: WriteMemoryCallback() Done"));
	return size*nmemb;
}


static
int trace_cb(CURL *handle, curl_infotype type,
             char *data, size_t size,
             void *userp)
{
	 ATEL_LOG_INFO(("my_trace() Entered"));
	(void)userp;
  const char *text;
  (void)handle; /* prevent compiler warning */

  switch(type)
  {
  case CURLINFO_TEXT:
   // fprintf(stderr, "== Info: %s", data);
	  ATEL_LOG_INFO(("Curl Log :: %s",data));
    /* FALLTHROUGH */
  default: /* in case a new one is introduced to shock us */
    return 0;

  case CURLINFO_HEADER_OUT:
    text = "=> Send header";
    break;
  case CURLINFO_DATA_OUT:
    text = "=> Send data";
    break;
  case CURLINFO_SSL_DATA_OUT:
    text = "=> Send SSL data";
    break;
  case CURLINFO_HEADER_IN:
    text = "<= Recv header";
    break;
  case CURLINFO_DATA_IN:
    text = "<= Recv data";
    break;
  case CURLINFO_SSL_DATA_IN:
    text = "<= Recv SSL data";
    break;
  }

  //dump(text, stderr, (unsigned char *)data, size, config->trace_ascii);


  std::ofstream myfile;
  myfile.open ("/tmp/curllog.txt");
  myfile << data;
  myfile.close();
  return 0;
}

int  Curl_Download_handler::SendRequest(std::string sURL,eAuth_Type eType)
{

	ATEL_LOG_INFO(("Curl_Download_handler::SendRequest()"));
	ATEL_LOG_INFO(("Curl_Download_handler::URL :: %s",sURL.c_str()));
	ATEL_LOG_INFO(("Curl_Download_handler::Auth_Type :: %d", eType));

	CURLcode ret;
	CURL *hnd;
	struct curl_slist *slist1;

	slist1 = NULL;
	slist1 = curl_slist_append(slist1, "Accept:application/json");

	hnd = curl_easy_init();
	curl_easy_setopt(hnd, CURLOPT_DEBUGFUNCTION, trace_cb);
	curl_easy_setopt(hnd, CURLOPT_VERBOSE, 1L);
	curl_easy_setopt(hnd, CURLOPT_FOLLOWLOCATION, 1L);
	curl_easy_setopt(hnd, CURLOPT_URL, sURL.c_str());
	curl_easy_setopt(hnd, CURLOPT_NOPROGRESS, 1L);
	curl_easy_setopt(hnd, CURLOPT_USERAGENT, "curl/7.35.0");
	curl_easy_setopt(hnd, CURLOPT_HTTPHEADER, slist1);
	curl_easy_setopt(hnd, CURLOPT_MAXREDIRS, 50L);

	switch(eType)
	{
		case MUTUAL_AUTH:
		{
			ATEL_LOG_INFO(("Curl_Download_handler::MUTUAL AUTHENTICATION"));
			curl_easy_setopt(hnd, CURLOPT_SSLCERT, "/opt/bosch/tcu/certs/BOSCHRLT201220171013.crt");
			curl_easy_setopt(hnd, CURLOPT_SSLKEY, "/opt/bosch/tcu/certs/BOSCHRLT201220171013.key");
		}
		//Intentionally missed the Break.
		case ONE_WAY_AUTH:
		{
			ATEL_LOG_INFO(("Curl_Download_handler::ONE WAY AUTHENTICATION"));
			curl_easy_setopt(hnd, CURLOPT_CAINFO, "/opt/bosch/tcu/certs/Fake_A-VNext_CA.pem");
		}
		break;

		case NO_AUTH:
		{
			ATEL_LOG_INFO(("Curl_Download_handler::NO Authentication"));
			//No Authentication
		}
		break;

		default:
		{
			ATEL_LOG_INFO(("INVALID AUTH TYPE"));
		}
	}

	curl_easy_setopt(hnd, CURLOPT_CUSTOMREQUEST, "GET");
	curl_easy_setopt(hnd, CURLOPT_WRITEFUNCTION, write_callback);
	curl_easy_setopt(hnd, CURLOPT_TCP_KEEPALIVE, 1L);
	ret = curl_easy_perform(hnd);
	ATEL_LOG_INFO(("Curl_Download_handler::Handle return value %d ", ret));
	SetResponseCurlCode(ret);
	long response_code = 0;
	long http__conn_code = 0;
	curl_easy_getinfo(hnd,CURLINFO_RESPONSE_CODE,&response_code);
	curl_easy_getinfo(hnd,CURLINFO_HTTP_CONNECTCODE,&http__conn_code);
	ATEL_LOG_INFO(("HTTP RESPONSE CODE :: %d",response_code));
	ATEL_LOG_INFO(("HTTP CONNECTION CODE :: %d",http__conn_code));
	//SetResponseHttpCode(http__conn_code);
	SetResponseHttpCode(response_code);
	curl_easy_cleanup(hnd);
	hnd = NULL;
	curl_slist_free_all(slist1);
	slist1 = NULL;
	return ret;

}

int Curl_Download_handler::SendUserAuthRequest(std::string sURL,std::string sReqData,eAuth_Type eType)
{
	ATEL_LOG_INFO(("Curl_Download_handler::SendUserAuthRequest()"));
	ATEL_LOG_INFO(("Curl_Download_handler::URL :: %s",sURL.c_str()));
	ATEL_LOG_INFO(("Curl_Download_handler::RequestData :: %s",sReqData.c_str()));
	ATEL_LOG_INFO(("Curl_Download_handler::Auth_Type :: %d", eType));

	CURLcode ret;
	CURL *hnd;
	struct curl_slist *slist1;

	slist1 = NULL;
	slist1 = curl_slist_append(slist1, "Accept:application/json");

	hnd = curl_easy_init();
	curl_easy_setopt(hnd, CURLOPT_DEBUGFUNCTION, trace_cb);
	curl_easy_setopt(hnd, CURLOPT_VERBOSE, 1L);
	curl_easy_setopt(hnd, CURLOPT_FOLLOWLOCATION, 1L);
	curl_easy_setopt(hnd, CURLOPT_URL, sURL.c_str());
	curl_easy_setopt(hnd, CURLOPT_NOPROGRESS, 1L);
	curl_easy_setopt(hnd, CURLOPT_USERAGENT, "curl/7.35.0");
	curl_easy_setopt(hnd, CURLOPT_HTTPHEADER, slist1);
	curl_easy_setopt(hnd, CURLOPT_MAXREDIRS, 50L);

	switch(eType)
	{
		case MUTUAL_AUTH:
		{
			ATEL_LOG_INFO(("Curl_Download_handler::MUTUAL AUTHENTICATION"));
			curl_easy_setopt(hnd, CURLOPT_SSLCERT, "/opt/bosch/tcu/certs/BOSCHRLT201220171013.crt");
			curl_easy_setopt(hnd, CURLOPT_SSLKEY, "/opt/bosch/tcu/certs/BOSCHRLT201220171013.key");
		}
		break;

		case NO_AUTH:
		{
			ATEL_LOG_INFO(("Curl_Download_handler::NO Authentication"));
			//No Authentication
		}
		break;

		default:
		{
			ATEL_LOG_INFO(("INVALID AUTH TYPE"));
		}
	}

	curl_easy_setopt(hnd, CURLOPT_CUSTOMREQUEST, "GET");
	curl_easy_setopt(hnd, CURLOPT_WRITEFUNCTION, write_callback);
	curl_easy_setopt(hnd, CURLOPT_TCP_KEEPALIVE, 1L);
	ret = curl_easy_perform(hnd);
	ATEL_LOG_INFO(("Curl_Download_handler::Handle return value %d ", ret));
	SetResponseCurlCode(ret);
	long response_code = 0;
	long http__conn_code = 0;
	curl_easy_getinfo(hnd,CURLINFO_RESPONSE_CODE,&response_code);
	curl_easy_getinfo(hnd,CURLINFO_HTTP_CONNECTCODE,&http__conn_code);
	ATEL_LOG_INFO(("HTTP RESPONSE CODE :: %d",response_code));
	ATEL_LOG_INFO(("HTTP CONNECTION CODE :: %d",http__conn_code));
	//SetResponseHttpCode(http__conn_code);
	SetResponseHttpCode(response_code);
	curl_easy_cleanup(hnd);
	hnd = NULL;
	curl_slist_free_all(slist1);
	slist1 = NULL;
	return ret;

}

void Curl_Download_handler::SetResponseData(std::string sResopnse)
{
	ATEL_LOG_INFO(("Curl_Download_handler::SetResponseData()"));
	tResponse.sResopnse = sResopnse;
}

void Curl_Download_handler::SetResponseCurlCode(int CurlReturnCode)
{
	ATEL_LOG_INFO(("Curl_Download_handler::SetResponseCurlCode()"));
	tResponse.CurlReturnCode = CurlReturnCode;
}

void Curl_Download_handler::SetResponseHttpCode(int HttpCode)
{
	ATEL_LOG_INFO(("Curl_Download_handler::SetResponseHttpCode()"));
	tResponse.HttpResponseCode = HttpCode;
}

TDownodedResponse Curl_Download_handler::tGetResponseData()
{
	return tResponse;
}
