/* EasyCODE V6.5 29.06.2000 10:28:44 */
/* EasyCODE O
If=vertical
LevelNumbers=no
LineNumbers=yes
Colors=16777215,0,12582912,12632256,0,0,0,16711680,8388736,0,33023,32768,0,0,0,0,0,32768,12632256,255,65280,255,255,16711935
ScreenFont=Courier New,Standard,100,4,-13,0,400,0,0,0,0,0,0,3,2,1,49,96,96
PrinterFont=Courier New,Standard,90,4,-75,0,400,0,0,0,0,0,0,3,2,1,49,600,600
LastLevelId=117 */
/* EasyCODE ( 1 */
/************************** .EXPORT_ME ************************ +IHDR * .IA *

 .DATEI                    [ tnlist.h ]

 .BESCHREIBUNG                                                           
  Diese Include-Datei enthaelt ein Klassentemplate fuer eine verkettete 
  Liste (NList).

 .COPYRIGHT            [ (c) 2000 Robert Bosch GmbH, Hildesheim ]
 .AUTOR                [ Hallmann / Ler ]

 .HISTORIE

   Datum   | Name        Modifikation
  -------------------------------------------------------------------------
  28. 6.00 | K7/EFT42-Lr Uebernahme aus nfc / nfx
*************************************************************** -IHDR * .IE */
/* EasyCODE ( 3
   PVCS Change Description */
/*
  $Log:   V:/Vasco/swnavi/archives/components/nfc/tnlist.h-arc  $
 * 
 *    Rev 1.3   Nov 18 2003 18:18:30   Pirklbauer
 * Destructor of NLIST is now virtual (LINT-WARNING)
 * 
 *    Rev 1.2   Oct 07 2002 14:58:18   ArnoldJoerg
 * remove class specifier inside method definition
 * 
 *    Rev 1.1   Jun 03 2002 11:12:50   Pirklbauer
 * noi_ => OSAL
 * Assert calling now compatible 
 * 
 *    Rev 1.0   Feb 26 2001 13:43:58   tnd2hi
 * Initial revision.
 * 
   old pvcs-log removed (ND971v25-OSAL_25)
   you can find them in the old archiv of "TNList.h"
   in the following pvcs-dir:
   "\\hi210076\navvcs\navvcs\e:\workdir/nfc/"
*/
/* EasyCODE ) */
#ifndef TNLIST_H_DEF
   #define TNLIST_H_DEF
/* EasyCODE ( 78
   Einbinden von Headerfiles */
/* EasyCODE C */
/* EasyCODE E */
#ifndef NOBJECT_H_DEF
#include "nobject.h"
#endif
#ifndef NMACROS_H_DEF
#include "nmacros.h"
#endif
#ifndef NPLEX_H_DEF
#include "nplex.h"
#endif
/* EasyCODE ) */
/* EasyCODE ( 116
   Deklaration intern benutzter Defines */
/* EasyCODE ( 117
   __NFX_POSITION */
/* EasyCODE C */
struct __NFX_POSITION
{
};
/* EasyCODE E */
/* EasyCODE ) */
typedef __NFX_POSITION* NFX_POSITION;
typedef const tVoid*     NfxPointer_t;
/* EasyCODE ) */
/* EasyCODE ( 80
   Deklaration */
/* EasyCODE C */
template<class TYPE, class ARG_TYPE>
class NList : public NObject
{
   protected:
      /* EasyCODE ( 81
         NNode */
      /* EasyCODE C */
      struct NNode
      {
         NNode* pNext;
         NNode* pPrev;
         TYPE   data;
      };
      /* EasyCODE E */
      /* EasyCODE ) */
   public:
      // Construction
      NList(tS16 nBlockSize = 10);
      
      // Attributes (head and tail)
      // count of elements
      tS16 GetCount() const;
      tBool IsEmpty() const;
      
      // peek at head or tail
      TYPE& GetHead();
      TYPE GetHead() const;
      TYPE& GetTail();
      TYPE GetTail() const;
      
      // Operations
      // get head or tail (and remove it) - don't call on empty list !
      TYPE RemoveHead();
      TYPE RemoveTail();
      
      // add before head or after tail
      NFX_POSITION AddHead(ARG_TYPE newElement);
      NFX_POSITION AddTail(ARG_TYPE newElement);
      
      // add another list of elements before head or after tail
      tVoid AddHead(NList* pNewList);
      tVoid AddTail(NList* pNewList);
      
      // remove all elements
      tVoid RemoveAll();
      
      // iteration
      NFX_POSITION GetHeadPosition() const;
      NFX_POSITION GetTailPosition() const;
      TYPE& GetNext(NFX_POSITION& rPosition); // return *Position++
      TYPE GetNext(NFX_POSITION& rPosition) const; // return *Position++
      TYPE& GetPrev(NFX_POSITION& rPosition); // return *Position--
      TYPE GetPrev(NFX_POSITION& rPosition) const; // return *Position--
      
      // getting/modifying an element at a given position
      TYPE& GetAt(NFX_POSITION position);
      TYPE GetAt(NFX_POSITION position) const;
      tVoid SetAt(NFX_POSITION pos, ARG_TYPE newElement);
      tVoid RemoveAt(NFX_POSITION position);
      
      // inserting before or after a given position
      NFX_POSITION InsertBefore(NFX_POSITION position, ARG_TYPE newElement);
      NFX_POSITION InsertAfter(NFX_POSITION position, ARG_TYPE newElement);
      
      // helper functions (note: O(n) speed)
      NFX_POSITION Find(ARG_TYPE searchValue, NFX_POSITION startAfter = NULL) const;
              // defaults to starting at the HEAD, return NULL if not found
      NFX_POSITION FindIndex(tS16 nIndex) const;
      // get the 'nIndex'th element (may return NULL)
      
      // Implementation
   protected:
      NNode* m_pNodeHead;
      NNode* m_pNodeTail;
      tS16 m_nCount;
      NNode* m_pNodeFree;
      struct NPlex* m_pBlocks;
      tS16 m_nBlockSize;
      
      NNode* NewNode(NNode* pPrev, NNode* pNext)
      {
         if (m_pNodeFree == NULL)
         {
            // add another block
            NPlex* pNewBlock = NPlex::Create(m_pBlocks, m_nBlockSize,
                             sizeof(NNode));

            if ( pNewBlock != NULL )
            {
               // chain them into free list
               NNode* pNode = (NNode*) pNewBlock->data();
               // free in reverse order to make it easier to debug
               pNode += m_nBlockSize - 1;
               for (tS16 i = m_nBlockSize-1; i >= 0; i--, pNode--)
               {
                  pNode->pNext = m_pNodeFree;
                  m_pNodeFree = pNode;
               }
            }
         }

         /*NList::*/NNode* pNode = m_pNodeFree;
         if (pNode != NULL)
         {
            m_pNodeFree = m_pNodeFree->pNext;
            pNode->pPrev = pPrev;
            pNode->pNext = pNext;
            m_nCount++;
            OSAL_vAssert(m_nCount > 0);  // make sure we don't overflow
      
            ConstructElements(&pNode->data, 1);
         }
         return pNode;
      }

      tVoid FreeNode(NNode* pNode)
      {
         DestructElements(&pNode->data, 1);
         pNode->pNext = m_pNodeFree;
         m_pNodeFree = pNode;
         m_nCount--;
         OSAL_vAssert(m_nCount >= 0);  // make sure we don't underflow
   
         // if no more elements, cleanup completely
         if (m_nCount == 0)
         {
            RemoveAll();
         }
      }

   public:
      virtual ~NList();
      //tVoid Serialize(CArchive&);
      #ifdef _DEBUG
      //tVoid Dump(CDumpContext&) const;
      //tVoid AssertValid() const;
      #endif
};
/* EasyCODE E */
/* EasyCODE ) */
/* EasyCODE ( 83
   Definition */
/* EasyCODE ( 84
   GetCount */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline tS16 NList<TYPE, ARG_TYPE>::GetCount() const
{
   return m_nCount;
}
/* EasyCODE ) */
/* EasyCODE ( 85
   IsEmpty */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline tBool NList<TYPE, ARG_TYPE>::IsEmpty() const
{
   return m_nCount == 0;
}
/* EasyCODE ) */
/* EasyCODE ( 86
   GetHead */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE& NList<TYPE, ARG_TYPE>::GetHead()
{
   OSAL_vAssert(m_pNodeHead != NULL);
   return m_pNodeHead->data;
}
/* EasyCODE ) */
/* EasyCODE ( 87
   GetHead */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE NList<TYPE, ARG_TYPE>::GetHead() const
{
   OSAL_vAssert(m_pNodeHead != NULL);
   return m_pNodeHead->data;
}
/* EasyCODE ) */
/* EasyCODE ( 88
   GetTail */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE& NList<TYPE, ARG_TYPE>::GetTail()
{
   OSAL_vAssert(m_pNodeTail != NULL);
   return m_pNodeTail->data;
}
/* EasyCODE ) */
/* EasyCODE ( 89
   GetTail */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE NList<TYPE, ARG_TYPE>::GetTail() const
{
   OSAL_vAssert(m_pNodeTail != NULL);
   return m_pNodeTail->data;
}
/* EasyCODE ) */
/* EasyCODE ( 90
   GetHeadPosition */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline NFX_POSITION NList<TYPE, ARG_TYPE>::GetHeadPosition() const
{
   return (NFX_POSITION) m_pNodeHead;
}
/* EasyCODE ) */
/* EasyCODE ( 91
   GetTailPosition */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline NFX_POSITION NList<TYPE, ARG_TYPE>::GetTailPosition() const
{
   return (NFX_POSITION) m_pNodeTail;
}
/* EasyCODE ) */
/* EasyCODE ( 92
   GetNext */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE& NList<TYPE, ARG_TYPE>::GetNext(NFX_POSITION& rPosition) // return *Position++
{
   NNode* pNode = (NNode*) rPosition;
   rPosition = (NFX_POSITION) pNode->pNext;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 93
   GetNext */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE NList<TYPE, ARG_TYPE>::GetNext(NFX_POSITION& rPosition) const // return *Position++
{
   NNode* pNode = (NNode*) rPosition;
   rPosition = (NFX_POSITION) pNode->pNext;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 94
   GetPrev */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE& NList<TYPE, ARG_TYPE>::GetPrev(NFX_POSITION& rPosition) // return *Position--
{
   NNode* pNode = (NNode*) rPosition;
   rPosition = (NFX_POSITION) pNode->pPrev;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 95
   GetPrev */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE NList<TYPE, ARG_TYPE>::GetPrev(NFX_POSITION& rPosition) const // return *Position--
{
   NNode* pNode = (NNode*) rPosition;
   rPosition = (NFX_POSITION) pNode->pPrev;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 96
   GetAt */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE& NList<TYPE, ARG_TYPE>::GetAt(NFX_POSITION position)
{
   NNode* pNode = (NNode*) position;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 97
   GetAt */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline TYPE NList<TYPE, ARG_TYPE>::GetAt(NFX_POSITION position) const
{
   NNode* pNode = (NNode*) position;
   return pNode->data;
}
/* EasyCODE ) */
/* EasyCODE ( 98
   SetAt */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
inline tVoid NList<TYPE, ARG_TYPE>::SetAt(NFX_POSITION pos, ARG_TYPE newElement)
{
   NNode* pNode = (NNode*) pos;  
   pNode->data = newElement;
}
/* EasyCODE ) */
/* EasyCODE ( 99
   NList */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NList<TYPE, ARG_TYPE>::NList(tS16 nBlockSize)
{
   OSAL_vAssert(nBlockSize > 0);
   
   m_nCount = 0;
   m_pNodeHead = m_pNodeTail = m_pNodeFree = NULL;
   m_pBlocks = NULL;
   m_nBlockSize = nBlockSize;
}
/* EasyCODE ) */
/* EasyCODE ( 100
   RemoveAll */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
tVoid NList<TYPE, ARG_TYPE>::RemoveAll()
{
   //ASSERT_VALID(this);
   
   // destroy elements
   NNode* pNode;
   for (pNode = m_pNodeHead; pNode != NULL; pNode = pNode->pNext)
   {
      DestructElements(&pNode->data, 1);
   }
   m_nCount = 0;
   m_pNodeHead = m_pNodeTail = m_pNodeFree = NULL;
       
   if(NULL != m_pBlocks)
   {
      m_pBlocks->FreeDataChain();
      m_pBlocks = NULL;
   }
}
/* EasyCODE ) */
/* EasyCODE ( 101
   ~NList */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NList<TYPE, ARG_TYPE>::~NList()
{
   RemoveAll();
   OSAL_vAssert(m_nCount == 0);
}
/* EasyCODE ) */
/* EasyCODE ( 102
   NewNode */
/* EasyCODE F */
/////////////////////////////////////////////////////////////////////////////
// Node helpers
//
// Implementation note: NNode's are stored in CPlex blocks and
//  chained together. Free blocks are maintained in a singly linked list
//  using the 'pNext' member of NNode with 'm_pNodeFree' as the head.
//  Used blocks are maintained in a doubly linked list using both 'pNext'
//  and 'pPrev' as links and 'm_pNodeHead' and 'm_pNodeTail'
//   as the head/tail.
//
// We never free a CPlex block unless the List is destroyed or RemoveAll()
//  is used - so the total number of CPlex blocks may grow large depending
//  on the maximum past size of the list.
//

/* EasyCODE ) */
/* EasyCODE ( 103
   FreeNode */
/* EasyCODE F */
/* EasyCODE ) */
/* EasyCODE ( 104
   AddHead */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::AddHead(ARG_TYPE newElement)
{
   //OSAL_vAssert_VALID(this);
   
   NNode* pNewNode = NewNode(NULL, m_pNodeHead);
   if ( pNewNode != NULL )
   {
      pNewNode->data = newElement;
      if (m_pNodeHead != NULL)
      {
         m_pNodeHead->pPrev = pNewNode;
      }
      else
      {
         m_pNodeTail = pNewNode;
      }
      m_pNodeHead = pNewNode;
   }
   return (NFX_POSITION) pNewNode;
}
/* EasyCODE ) */
/* EasyCODE ( 105
   AddTail */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::AddTail(ARG_TYPE newElement)
{
   //ASSERT_VALID(this);
   
   NNode* pNewNode = NewNode(m_pNodeTail, NULL);
   if ( pNewNode != NULL )
   {
      pNewNode->data = newElement;
      if (m_pNodeTail != NULL)
      {
         m_pNodeTail->pNext = pNewNode;
      }
      else
      {
         m_pNodeHead = pNewNode;
      }
      m_pNodeTail = pNewNode;
   }
   return (NFX_POSITION) pNewNode;
}
/* EasyCODE ) */
/* EasyCODE ( 106
   AddHead */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
tVoid NList<TYPE, ARG_TYPE>::AddHead(NList* pNewList)
{
   //ASSERT_VALID(this);
   
   OSAL_vAssert(pNewList != NULL);
   //ASSERT_VALID(pNewList);
   
   // add a list of same elements to head (maintain order)
   NFX_POSITION pos = pNewList->GetTailPosition();
   while (pos != NULL)
   {
      AddHead(pNewList->GetPrev(pos));
   }
}
/* EasyCODE ) */
/* EasyCODE ( 107
   AddTail */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
tVoid NList<TYPE, ARG_TYPE>::AddTail(NList* pNewList)
{
   //ASSERT_VALID(this);
   OSAL_vAssert(pNewList != NULL);
   //ASSERT_VALID(pNewList);
   
   // add a list of same elements
   NFX_POSITION pos = pNewList->GetHeadPosition();
   while (pos != NULL)
   {
      AddTail(pNewList->GetNext(pos));
   }
}
/* EasyCODE ) */
/* EasyCODE ( 108
   RemoveHead */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
TYPE NList<TYPE, ARG_TYPE>::RemoveHead()
{
   //ASSERT_VALID(this);
   OSAL_vAssert(m_pNodeHead != NULL);  // don't call on empty list !!!
   
   NNode* pOldNode = m_pNodeHead;
   TYPE returnValue = pOldNode->data;
   
   m_pNodeHead = pOldNode->pNext;
   if (m_pNodeHead != NULL)
   {
      m_pNodeHead->pPrev = NULL;
   }
   else
   {
      m_pNodeTail = NULL;
   }
   FreeNode(pOldNode);
   return returnValue;
}
/* EasyCODE ) */
/* EasyCODE ( 109
   RemoveTail */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
TYPE NList<TYPE, ARG_TYPE>::RemoveTail()
{
   //ASSERT_VALID(this);
   OSAL_vAssert(m_pNodeTail != NULL);  // don't call on empty list !!!
   
   NNode* pOldNode = m_pNodeTail;
   TYPE returnValue = pOldNode->data;
   
   m_pNodeTail = pOldNode->pPrev;
   if (m_pNodeTail != NULL)
   {
      m_pNodeTail->pNext = NULL;
   }
   else
   {
      m_pNodeHead = NULL;
   }
   FreeNode(pOldNode);
   return returnValue;
}
/* EasyCODE ) */
/* EasyCODE ( 110
   InsertBefore */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::InsertBefore(NFX_POSITION position, ARG_TYPE newElement)
{
   //ASSERT_VALID(this);
   if (position == NULL)
   {
      return AddHead(newElement);
      // insert before nothing -> head of the list
   }
   // Insert it before position
   NNode* pOldNode = (NNode*) position;
   NNode* pNewNode = NewNode(pOldNode->pPrev, pOldNode);
   if ( pNewNode != NULL )
   {
      pNewNode->data = newElement;
      if (pOldNode->pPrev != NULL)
      {
         pOldNode->pPrev->pNext = pNewNode;
      }
      else
      {
         OSAL_vAssert(pOldNode == m_pNodeHead);
         m_pNodeHead = pNewNode;
      }
      pOldNode->pPrev = pNewNode;
   }
   return (NFX_POSITION) pNewNode;
}
/* EasyCODE ) */
/* EasyCODE ( 111
   InsertAfter */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::InsertAfter(NFX_POSITION position, ARG_TYPE newElement)
{
   //ASSERT_VALID(this);
   if (position == NULL)
   {
      return AddTail(newElement);
      // insert after nothing -> tail of the list
   }
   // Insert it before position
   NNode* pOldNode = (NNode*) position;
   NNode* pNewNode = NewNode(pOldNode, pOldNode->pNext);
   if ( pNewNode != NULL )
   {
      pNewNode->data = newElement;
      if (pOldNode->pNext != NULL)
      {
         pOldNode->pNext->pPrev = pNewNode;
      }
      else
      {
         OSAL_vAssert(pOldNode == m_pNodeTail);
         m_pNodeTail = pNewNode;
      }
      pOldNode->pNext = pNewNode;
   }
   return (NFX_POSITION) pNewNode;
}
/* EasyCODE ) */
/* EasyCODE ( 112
   RemoveAt */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
tVoid NList<TYPE, ARG_TYPE>::RemoveAt(NFX_POSITION position)
{
   //ASSERT_VALID(this);
   
   NNode* pOldNode = (NNode*) position;
   
   // remove pOldNode from list
   if (pOldNode == m_pNodeHead)
   {
      m_pNodeHead = pOldNode->pNext;
   }
   else
   {
      pOldNode->pPrev->pNext = pOldNode->pNext;
   }
   if (pOldNode == m_pNodeTail)
   {
      m_pNodeTail = pOldNode->pPrev;
   }
   else
   {
      pOldNode->pNext->pPrev = pOldNode->pPrev;
   }
   FreeNode(pOldNode);
}
/* EasyCODE ) */
/* EasyCODE ( 113
   FindIndex */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::FindIndex(tS16 nIndex) const
{
   //ASSERT_VALID(this);
   OSAL_vAssert(nIndex >= 0);
   OSAL_vAssert(nIndex >= 0);
   if (nIndex >= m_nCount)
   {
      return NULL;
      // went too far
   }
   NNode* pNode = m_pNodeHead;
   while (nIndex--)
   {
      pNode = pNode->pNext;
   }
   return (NFX_POSITION) pNode;
}
/* EasyCODE ) */
/* EasyCODE ( 114
   Find */
/* EasyCODE F */
template<class TYPE, class ARG_TYPE>
NFX_POSITION NList<TYPE, ARG_TYPE>::Find(ARG_TYPE searchValue, NFX_POSITION startAfter) const
{
   //ASSERT_VALID(this);
   
   NNode* pNode = (NNode*) startAfter;
   if (pNode == NULL)
   {
      pNode = m_pNodeHead;  // start at head
   }
   else
   {
      pNode = pNode->pNext;  // start after the one specified
   }
   for (; pNode != NULL; pNode = pNode->pNext)
   {
      if (!OSAL_s32MemoryCompare(&pNode->data, &searchValue, sizeof(TYPE)))
      {
         return (NFX_POSITION)pNode;
      }
   }
   return NULL;
}
/* EasyCODE ) */
/* EasyCODE ) */
#endif  /* TNLIST_H_DEF */
/* EasyCODE ) */
