//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef HB_SUBSTITUTED_ALLOC_H
#define HB_SUBSTITUTED_ALLOC_H

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

    typedef size_t hb_ssize_t;
    typedef char hb_schar;
    typedef int hb_sint;

    // Overrides of standard functions.
    void *hb_smalloc(hb_ssize_t size);
    void hb_sfree(void *ptr);
    void *hb_scalloc(hb_ssize_t nmemb, hb_ssize_t size);
    void *hb_srealloc(void *ptr, hb_ssize_t size);

    hb_schar *hb_sstrdup(const hb_schar *s);

    hb_sint hb_satexit(void(*function)(void));

#ifdef __cplusplus
}
#endif

#endif /* HB_SUBSTITUTED_ALLOC_H */
