/*
 * ecnr-service.h
 *
 ********************************
 * qwa-object.h
 *
 * Andy Lowe <alowe@mvista.com>
 *
 * 2010 (c) MontaVista Software, LLC. This file is licensed under
 * the terms of the AFL.
 **********************************
 * Author: Patrick Rey
 * Date: 15.08.2013
 * Version 0.1 :  adaption qwa-object.h as ecnr-object.h
 */


#ifndef __ECNR_SERVICE_H__
#define __ECNR_SERVICE_H__


#include "sse.h"


//#define ECNR_OBJECT_ERROR (ecnr_object_error_quark())

extern  GQuark ecnr_object_error_quark(void);
extern  const gchar *ecnr_error_str(int code);
extern  gboolean report_ecnr_error(int status, const gchar * dbus_msg, GError ** error);
extern const gchar *qwa_rcs_error_str(int code);




struct EcnrError
{
    int     code; // tQwaInt code;
    const   gchar *str;
};


typedef enum _audproc_type_defs
{
    ECNR_QWA_PARAM_TYPE_INVALID = 0,
    ECNR_TYPE_U8 = 1,
    ECNR_TYPE_I8 ,  /*2*/
    ECNR_TYPE_U16 , /*3*/
    ECNR_TYPE_I16 , /*4*/
    ECNR_TYPE_U32 , /*5*/
    ECNR_TYPE_I32,  /*6*/
    ECNR_TYPE_ARRAY_U8 ,  /*7*/
    ECNR_TYPE_ARRAY_I8 ,  /*8*/
    ECNR_TYPE_ARRAY_U16 , /*9*/
    ECNR_TYPE_ARRAY_I16 , /*10*/
    ECNR_TYPE_ARRAY_U32 , /*11*/
    ECNR_TYPE_ARRAY_I32,  /*12*/
    ECNR_TYPE_SELECT,
    ECNR_TYPE_UNDEF
}ecnr_type_defs;


typedef enum _ecnr_access_defs
{
    ECNR_ACCESS_UNDEF = 0,
    ECNR_ACCESS_RO = 1,              // Read only
    ECNR_ACCESS_WB,                  // Data can only be written before initialization, read anytime
    ECNR_ACCESS_WA,                  // Data can only be written after initialization, read anytime
    ECNR_ACCESS_RW,                  // Data can be written, read anytime
    ECNR_ACCESS_WO                   // Data can only be written after initialization, never read */
}ecnr_access_defs;


typedef enum _ecnr_update_defs
{
    ECNR_UPDATE_UNDEF = 0,
    ECNR_UPDATE_ON_PROCESS = 1,  // update and set paramter within the streaming task prior to processing call, means the filter parameter are set prior to audio processing
    ECNR_UPDATE_IMMEDIAT         // update, set parameter at any time asynchronously to the streaming context
}ecnr_update_defs;

enum{
  PROP_ALSA_DEV_OPEN_ORDER = 1,
  PROP_ALSA_DEV_PREFILL
};


/* ECNR dbug mode  */
enum {
    ECNR_DBUG_DEFAULT=0,
    ECNR_DBUG_PRINT_ALL_OPTIONS = 0,
    ECNR_DBUG_SET_TRIGGER_FILE = 1,
    ECNR_DBUG_DELETE_TRIGGER_FILE = 2,
    ECNR_DBUG_FORCE_AUDIO_IO = 3,
    ECNR_DBUG_DATA_ALSA_AVAILABLE= 4,
    ECNR_DBUG_DATA_ALSA_DISABLE= 5,
    ECNR_DBUG_START_TUNING_SESSION= 6,
    ECNR_DBUG_STOP_TUNING_SESSION= 7,
    ECNR_DBUG_PRINT_DEV_PROP= 8,
    ECNR_DBUG_PRINT_RTS_CONFIG= 9,
    ECNR_DBUG_PRINT_ECNR_DATA_CONFIG= 10,
    ECNR_DBUG_SWITCH_OFF_CHECK_ALSA_DEV= 11,
    ECNR_DBUG_SWITCH_OFF_CHECK_APPID_CNFGID= 12,
    ECNR_DBUG_TEST_TRIGGER_NOTIFICATION_NEW_DATAPOOL_ALL= 13,
    ECNR_DBUG_TEST_TRIGGER_NOTIFICATION_NEW_DATAPOOL_1= 14,
    ECNR_DBUG_TEST_FORCE_EXIT_ALSA_THREAD= 15,
    ECNR_DBUG_TEST_FORCE_CREATE_ALSA_THREAD= 16,
    ECNR_DBUG_PRINT_CURRENT_AUDI0_STATE=17,
    ECNR_DBUG_PRINT_RCS_CONF_FILES=18,
    ECNR_CALL_NATIVE_START_AUDIO = 19,
    ECNR_DBUG_PRINT_DP_INFOS = 20,
    ECNR_DBUG_SET_IO_CTRL_HF_VR_MODE = 21,
    ECNR_DBUG_RESET_IO_CTRL_HF_VR_MODE = 22,
    ECNR_DBUG_FORCE_USE_DEFAULT_DP = 23,
    ECNR_DBUG_FORCE_USE_DEFAULT_DP_EXIT = 24,  //ECNR_DBUG_LAST_ENTRY removed due to lint error
    ECNR_DBUG_SET_ACTIVATE_AUDIO_RECORD = 30,
    ECNR_DBUG_STOP_AUDIO_RECORD = 31,
    ECNR_DBUG_RESTART_AUDIO_RECORD = 32,
    ECNR_DBUG_SET_ACTIVATE_DEBUG_LOG_LEVEL = 33,
    ECNR_DBUG_SET_DEACTIVATE_DEBUG_LOG_LEVEL = 34,
    ECNR_DBUG_FORCE_MAIN_TERMINATION = 35,
    ECNR_DBUG_IMPORT_BIN_FILE_OPEN = 36,
    ECNR_DBUG_IMPORT_BIN_FILE_CLOSE = 37,
    ECNR_DBUG_ENABLE_PERFORMANCE_TEST = 38,
    ECNR_DBUG_DISABLE_PERFORMANCE_TEST = 39
};


struct ecnrParameter
{

    const gchar*      prop_name;           /* obj parameter name */
    const gchar*      ecnr_name;           /* ecnr parameter  */
    gint              ecnr_data_id;        /* parameter id*/
    gint              ecnr_channel;        /* parameter channel */
    gint              ecnr_num;            /* number of ecnr data type */
    ecnr_type_defs      ecnr_type;           /* ecnr data type */
    ecnr_access_defs    ecnr_access;         /* ecnr access restriction */
    ecnr_update_defs    ecnr_update;         /* ecnr update mode */
    const gchar*      ecnr_instance_name;  /* name of the ecnr instance for which the parameter is available */
    GType             parm_type;          /* obj parameter type  */
    GType             element_type;       /* obj element type */
    GParamFlags       flags;              /* obj Parameter flag */
};



#define ECNR_PARM(pname, name, id, ch, num, type, access, update, iname,  ptype, etype, gflags ) \
  { \
    .prop_name          = pname, \
    .ecnr_name           = name, \
    .ecnr_data_id        = id, \
    .ecnr_channel        = ch, \
    .ecnr_num            = num, \
    .ecnr_type           = type, \
    .ecnr_access         = access, \
    .ecnr_update         = update,\
    .ecnr_instance_name  = iname,\
    .parm_type          = ptype, \
    .element_type       = etype, \
    .flags              = gflags, \
  }


#define ECNR_PARM_RW(pname, name, id, ch, type, ptype, iname) \
  ECNR_PARM(pname, name, id, ch, 1, type, ECNR_ACCESS_RW, ECNR_UPDATE_IMMEDIAT,iname, ptype, 0, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))

#define ECNR_PARM_RW_EXT(pname, name, type, ptype, access, update, iname) \
  ECNR_PARM(pname, #name, name, 0, 1, type, access, update, iname, ptype, 0, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))

#define ECNR_PARM_R(pname, name, id, ch, type, ptype, iname) \
  ECNR_PARM(pname, name, id, ch, 1, type, ECNR_ACCESS_RW, ECNR_UPDATE_IMMEDIAT,iname, ptype, 0, \
    (G_PARAM_READABLE | G_PARAM_STATIC_STRINGS))

#define ECNR_PARM_RW_ARRAY(pname, name, id, ch, num, type, etype, iname) \
  ECNR_PARM(pname, name, id, ch, num, type, ECNR_ACCESS_RW, ECNR_UPDATE_IMMEDIAT, iname, G_TYPE_BOXED, etype, \
    (G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS))

#define ECNR_PARM_U8(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_U8, G_TYPE_UINT, iname)

#define ECNR_PARM_I16(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_I16, G_TYPE_INT, iname)

#define ECNR_PARM_U16(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_U16, G_TYPE_UINT, iname)

#define ECNR_PARM_I32(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_I32, G_TYPE_INT, iname)

#define ECNR_PARM_I32_R_ACCESS_ONLY(pname, name, iname) \
  ECNR_PARM_R(pname, #name, name, 0, ECNR_TYPE_I32, G_TYPE_INT, iname)

#define ECNR_PARM_U32_RW_ACCESS(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_U32, G_TYPE_UINT, iname)


#define ECNR_PARM_U32(pname, name, iname) \
  ECNR_PARM_RW(pname, #name, name, 0, ECNR_TYPE_U32, G_TYPE_UINT, iname)

#define ECNR_PARM_U8_ARRAY(pname, name, num, iname) \
    ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_U8, G_TYPE_UCHAR, iname)

#define ECNR_PARM_U8_ARRAY_VAR_SIZE(pname, name, iname) \
    ECNR_PARM_RW_ARRAY(pname, #name, name, 0, 0, ECNR_TYPE_ARRAY_U8, G_TYPE_UCHAR, iname)

#define ECNR_PARM_I8_ARRAY(pname, name, num, iname) \
    ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_I8, G_TYPE_INT, iname)

#define ECNR_PARM_I16_ARRAY(pname, name, num, iname) \
  ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_I16, G_TYPE_INT, iname)

#define ECNR_PARM_U16_ARRAY(pname, name, num, iname) \
  ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_U16, G_TYPE_UINT, iname)

#define ECNR_PARM_I32_ARRAY(pname, name, num, iname) \
  ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_I32, G_TYPE_INT, iname)

#define ECNR_PARM_U32_ARRAY(pname, name, num, iname) \
  ECNR_PARM_RW_ARRAY(pname, #name, name, 0, num, ECNR_TYPE_ARRAY_U32, G_TYPE_UINT, iname)




struct ecnr_instance_object
{
    gboolean            ecnr_is_initialized;
    gboolean            ecnr_Debug_intf_initialized;
    gint                ecnr_current_config_id;
    guchar              ecnr_current_app_id;
    guint8              ecnr_alsa_thread_ref;
    gboolean            ecnr_service_terminate_req;
    ecnr_audio_state    ecnr_service_audio_state;
};


#define     ecnrEnableAsrMode  0x0100


/* service modul functions */

extern  gboolean                        ecnr_service_handle_quit_loop (gpointer user_data);
extern  void                            ecnr_service_init(void);
extern  void                            ecnr_service_destroy(void);
extern  gboolean                        ecnr_service_finalize(void);
extern  struct ecnr_instance_object*    ecnr_service_instance_get(guchar app_id);
extern  struct ecnr_instance_object*    ecnr_service_instance_active_get(void);
extern  int                             ecnr_service_instance_active_is(guchar app_id, gboolean* state);
extern  int                             ecnr_service_instance_remove(guchar app_id);
extern  int                             ecnr_service_instance_current_appid_remove(void);
extern  int                             ecnr_service_instance_create_new(guchar app_id);

/* API interface services */
extern  gboolean                        ecnr_service_handle_quit_signal (void);
extern  int                             ecnr_service_fi_initialize(guchar ecnrAppId, gint ecnrConfigurationId);
extern  int                             ecnr_service_fi_destroy(guchar ecnrAppId);
extern  int                             ecnr_service_fi_start_audio(guchar ecnrAppId, guchar StartMode);
extern  int                             ecnr_service_fi_stop_audio(guchar ecnrAppId);
extern  int                             ecnr_service_fi_set_configuration(guchar ecnrAppId, gint ecnrConfigurationId);
extern  int                             ecnr_service_fi_start_debug_data(guchar ecnrDebugMode);
extern  int                             ecnr_service_fi_set_send_mute_switch(guchar ecnrAppId, guchar ecnrSendMuteSwitch);
extern  int                             ecnr_service_fi_set_send_gain_delta(guchar ecnrAppId, gint16 ecnrLevel);
extern  int                             ecnr_service_fi_set_mic_gain(gint16 MicGainLevel);
extern  int                             ecnr_service_fi_set_pass_through_mode(guchar ecnrAppId, guchar ecnrPassThroughMode);
extern  int                             ecnr_service_fi_set_nr_comb_floor(guchar ecnrAppId, gint16 ecnrNRCombFloor);
extern  int                             ecnr_service_fi_set_eecho_cancellation(guchar ecnrAppId, guchar EcnrECState);
extern  int                             ecnr_service_fi_set_noise_reduction(guchar ecnrAppId, guchar EcnrNRState);
extern  int                             ecnr_service_fi_alsa_set_device (guchar ecnrAppId, guint AlsaDeviceSelect, gchar * AlsaDeviceName);
extern  int                             ecnr_service_fi_start_itctest(gint32 troubleCode, gint32* rspTroubleCode, guchar* result, gint32* errorCode);
extern  int                             ecnr_service_fi_get_ecnr_configuration(gchar ** DatasetName, GArray ** EcnrProperties);
extern  int                             ecnr_service_fi_alsa_set_device_properties(guchar  ecnrAppId, guint  AlsaDeviceSelect, guchar  AlsaDeviceProperty, guint  PropertyValue);
extern  int                             ecnr_service_fi_mic_clip_stats(gint Channel, guint * ClipFrames, guint * ClipCount, gint * MaxAmp, gint * MinAmp);
extern  int                             ecnr_service_fi_ref_clip_stats(guint * ClipFrames, guint * ClipCount, gint * MaxAmp, gint * MinAmp);
extern  int                             ecnr_service_fi_recv_clip_stats(guint * ClipFrames, guint * ClipCount, gint * MaxAmp, gint * MinAmp);
extern  int                             ecnr_service_fi_mic_out_clip_stats(guint * ClipFrames, guint * ClipCount, gint * MaxAmp, gint * MinAmp);
extern  int                             ecnr_service_fi_recv_out_clip_stats(guint * ClipFrames, guint * ClipCount, gint * MaxAmp, gint * MinAmp);
extern  int                             ecnr_service_fi_alsa_set_thread_priority(guchar ecnrAppId, gint priority);
extern  int                             ecnr_service_fi_get_engine_param(guint  param_id, GArray **data);
extern  int                             ecnr_service_fi_set_param(guint param_id, ecnr_type_defs data_type, const GValue* value);
extern  int                             ecnr_service_fi_get_param(guint16 param_id, ecnr_type_defs data_type, GValue* param);
extern  int                             ecnr_service_fi_get_version(GArray ** version,gchar ** version_string, gchar ** version_comment);
extern  int                             ecnr_service_do_action_initialize(gint config_id);
extern  int                             ecnr_service_do_action_destroy(void);
extern  void                            ecnr_service_do_action_micro_level_monitor(guint32 timeout_ms);

/* configuration */
extern  int                             ecnr_service_check_AppId_ConfigId_Matching(gint ecnrConfigurationId, guchar ecnrAppId);
extern  gboolean                        ecnr_service_handle_quit_loop (gpointer user_data);

/* audio services */
extern  int                             ecnr_service_audio_create(void);
extern  int                             ecnr_service_audio_unref(void);
extern  int                             ecnr_service_audio_ref(void);
extern  int                             ecnr_service_audio_get_ref(void);
extern  int                             ecnr_service_audio_terminate_cb(void);
extern  ecnr_audio_state                ecnr_service_audio_get_state(void);
extern  int                             ecnr_service_audio_change_state(ecnr_audio_state astate);


/* ecnr engine services */
extern  void                            ecnr_service_set_pass_through_mode_default_state(gboolean ptm_default_state);
extern  gboolean                        ecnr_service_get_pass_through_mode_default_state(void);
        void                            ecnr_service_set_micro_level_notify_interval(guint32 interval_in_ms);
        guint32                         ecnr_service_get_micro_level_notify_interval(void);
extern  void                            ecnr_service_set_mic_gain_level(guint16 mic_gain_level);
extern  gint16                          ecnr_service_get_mic_gain_level(void);
extern  void                            ecnr_service_set_use_default_dp(void);
extern  void                            ecnr_service_set_use_default_dp_exit(void);
extern  gboolean                        ecnr_service_is_use_default_dp(void);
extern  guint                           ecnr_service_get_param_table_size(void);
extern  const struct ecnrParameter*     ecnr_service_get_param_table(void);
extern  const struct ecnrParameter*     ecnr_service_get_param_infos(guint16 param_id);
extern  ecnr_audio_state                ecnr_service_get_audio_state(void);
extern  const char*                     ecnr_audio_state_str(ecnr_audio_state code);



/* Hw Plattform services*/
extern  gpointer                        ecnr_service_gpio_thread(gpointer data);

/*************************
 * function for testing  *
 */
#ifdef D_TRIGGER_PERFORMANCE_TEST
extern void                             ecnr_service_test_performance_initialize(void);
extern void                             ecnr_service_test_performance_start(void);
extern void                             ecnr_service_test_performance_stop(void);
#endif


#endif
