#include "hash.h"

//////////////////////////////////////////////////////////////////////////
#define ROTL32(num,amount)    (((num) << (amount)) | ((num) >> (32 - (amount))))  //Rotate left for Murmur3 hashing algorithm

//////////////////////////////////////////////////////////////////////////
namespace Hash
{
   //-----------------------------------------------------------------------------
   // MurmurHash3 was written by Austin Appleby, and is placed in the public
   // domain. The author hereby disclaims copyright to this source code.

   // Note - The x86 and x64 versions do _not_ produce the same results, as the
   // algorithms are optimized for their respective platforms. You can still
   // compile and run any of them on any platform, but your performance with the
   // non-native version will be less than optimal.

   // Adaption to OSAL platform and removal of unused parts by Christian Deneke.

   //-----------------------------------------------------------------------------
   // Block read - if your platform needs to do endian-swapping or can only
   // handle aligned reads, do the conversion here
   static tU32 getblock32 ( const tU32 * p, int i )
   {
      return p[i];
   }

   //-----------------------------------------------------------------------------
   // Finalization mix - force all bits of a hash block to avalanche

   static tU32 fmix32 ( tU32 h )
   {
      h ^= h >> 16;
      h *= 0x85ebca6b;
      h ^= h >> 13;
      h *= 0xc2b2ae35;
      h ^= h >> 16;

      return h;
   }


   tU32 u32GetHash_Murmur3( const tU8* pu8Data, tU32 u32Buffersize, tU32 u32Seed )
   {
      const tS32  nblocks = u32Buffersize / 4;
      tU32        h1 = u32Seed;

      const tU32 c1 = 0xcc9e2d51;
      const tU32 c2 = 0x1b873593;

      //----------
      // body

      tU32 k1 = 0;
      //in case the buffer doesn't start at a 32-bit boundary, advance the 
      //pointer to the next boundary
      switch( ((tU32)pu8Data) & 3)
      {
      case 1: k1 ^= *pu8Data;++pu8Data;
         /* fall through */
      case 2: k1 ^= (*pu8Data) << 8;++pu8Data;
         /* fall through */
      case 3: k1 ^= (*pu8Data) << 16;++pu8Data;
         k1 *= c1; k1 = ROTL32(k1,15); k1 *= c2; h1 ^= k1;
         /* fall through */
      default:break;
      };


      const tU32 * blocks = (const tU32 *)(pu8Data + nblocks*4);

      for(int i = -nblocks; i; i++)
      {
         k1 = getblock32(blocks,i);

         k1 *= c1;
         k1 = ROTL32(k1,15);
         k1 *= c2;

         h1 ^= k1;
         h1 = ROTL32(h1,13);
         h1 = h1*5+0xe6546b64;
      }

      //----------
      // tail

      const tU8 * tail = (const tU8*)(pu8Data + nblocks*4);

      switch(u32Buffersize & 3)
      {
      case 3: k1 ^= tail[2] << 16;
         /* fall through */
      case 2: k1 ^= tail[1] << 8;
         /* fall through */
      case 1: k1 ^= tail[0];
         k1 *= c1; k1 = ROTL32(k1,15); k1 *= c2; h1 ^= k1;
         /* fall through */
      default:break;
      };

      //----------
      // finalization

      h1 ^= u32Buffersize;

      tU32 u32FinalHash = fmix32(h1);

      return u32FinalHash;
   }

}
