/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
- Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/include/osgViewer/ViewerEventHandlers
- Some additional APIs are provided to enable display of dynamically changing strings as stats in addition to integers and floating point values for debugging purposes.
- Also provides some additional APIs to group stats based on whether they change or remain consistent across multiple views.
*/


#ifndef MAPENGINE_OSS_CUSTOMSTATSHANDLERBASE_
#define MAPENGINE_OSS_CUSTOMSTATSHANDLERBASE_ 1

#include <sstream>
#include <stdio.h>
#include <osg/io_utils>
#include <osgViewer/Renderer>
#include <osgText/Text>
#include <osgGA/GUIEventAdapter>
#include <osgGA/GUIActionAdapter>
#include <osgGA/GUIEventHandler>
#include <osgViewer/ViewerEventHandlers>
#include <osgViewer/Renderer>
#include "oss/Export.h"

const int KEY_CUSTOM_STATS = 'u';
const int KEY_CUSTOM_STATS_TRACE = 'U';
const int KEY_DEPENDENT_STATS = 'q';
const int KEY_INDEPENDENT_STATS = 'a';


namespace mapengine {
namespace oss {

/**
* Base Class to handle display of custom mapengine stats 
* on pressing the 'u' key
*/
class MAPENGINE_OSS_EXPORT me_CustomStatsHandlerBase :  public osgViewer::StatsHandler
{
public: 
   me_CustomStatsHandlerBase();
   
   /**
   * Holds the enum to string conversions for the enums to be represented as stats
   * Stored as a map with groupID and the map holding the enum to string conversions
   */ 
   typedef std::map <int, std::map <int, std::string> > CustomMap;
   CustomMap _viewIndEnumToStringMaps;
   CustomMap _viewDepEnumToStringMaps;
   std::vector<CustomMap> _enumToStringMaps;

   bool _updateStatsFlag;

   // used to sort stats based on type of dynamic data
   enum StatsDataType
   {
      IS_DOUBLE,
      IS_INT,
      IS_STRING
   }; 

   
   enum UserStatsType
   {
      USER_VIEW_INDEPENDENT_STATS,
      USER_VIEW_DEPENDENT_STATS,
      USER_STATS_COUNT
   };

   enum StatsVisibility
   {
      NO_USER_STATS,
      VIEW_INDEPENDENT_STATS_VISIBLE,
      ALL_MAP_STATS_VISIBLE,
      STATS_VISIBILITY_COUNT
   };

   enum DepStatsVisibility
   {
      VIEW_DEPENDENT_STATS_TRACE,
      NO_DEPENDENT_STATS_TRACE,
      DEP_STATS_VISIBILITY_COUNT
   };

   enum IndStatsVisibility
   {
      VIEW_INDEPENDENT_STATS_TRACE,
      NO_INDEPENDENT_STATS_TRACE,
      IND_STATS_VISIBILITY_COUNT
   };
protected:
   
   virtual ~me_CustomStatsHandlerBase(){}

   osg::ref_ptr<osg::Camera>  _customCamera;
   osg::ref_ptr<osg::Switch> _customSwitch;
   
   StatsVisibility _userStatsVisibility;
   DepStatsVisibility _userDepStatsVisibility;
   IndStatsVisibility _userIndStatsVisibility;
   
   float _customStatsWidth;
   float _customStatsHeight;
   float _customCharacterSize;

   osg::Vec4 _backgroundColor;
   float _backgroundMargin;
   float _backgroundSpacing;

   osg::Vec4 _staticTextColor;
   osg::Vec4 _dynamicTextColor;

   /**
   * Called when the 'u' or 'U' key is pressed.
   * Helps to toggle between view independent and view dependent stats by enabling collection of stats
   */
   virtual bool handle(const osgGA::GUIEventAdapter& ea, osgGA::GUIActionAdapter& aa); 

   virtual void customSetUpScene(osgViewer::View* viewer, int printStatsToTrace, bool initialized) = 0;

   /**
   * Used to set the graphics context of the custom stats handler camera to the current view
   * Done once for every view created
   * @param[in] viewer The current view object  
   */
   void customSetUpHUDCamera(osgViewer::View* viewer);
   
   /**  
   * Used to set the projection matrix for the custom stats handler camera every time the window is resized
   * @param[in] width The width of the window 
   * @param[in] height The height of the window  
   */
   void customSetWindowSize(int width, int height);  
   
};
}
}
#endif 
