/* -*-c++-*-
mapengine_oss

Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
Not derived from OSG code. Developed entirely at Bosch Car Multimedia
- Initial implementation of this file.
*/

#ifndef MAPENGINE_OSS_OSSCONFIG_
#define MAPENGINE_OSS_OSSCONFIG_ 1

#include <osgViewer/GraphicsWindow>
#include <osgDB/Registry>

#if defined (MAP_OS_IOS)
/** windowing system */
USE_GRAPICSWINDOW_IMPLEMENTATION(IOS)
#endif

/*
#if defined (MAP_OS_LINUX_GEN3)
USE_OSGPLUGIN(dbghmi)
#endif
*/

#if defined (MAP_OS_ANDROID) || defined (MAP_OS_IOS)
/** serializer wrapper */
USE_SERIALIZER_WRAPPER_LIBRARY(osg)

/** osg plugins */
USE_OSGPLUGIN(dot)
USE_OSGPLUGIN(png)
//USE_OSGPLUGIN(curl)
USE_OSGPLUGIN(freetype)
USE_OSGPLUGIN(rgb)
USE_OSGPLUGIN(pvr)
USE_OSGPLUGIN(osg2)
USE_OSGPLUGIN(ktx)
USE_OSGPLUGIN(obj)
#endif

#endif // MAPENGINE_OSS_OSSCONFIG_
