/*
 * json_utils.cpp
 *
 *
 *
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "fc_dumm_AppMain_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_DUMM_UTIL
#include "trcGenProj/Header/json_utils.cpp.trc.h"
#endif
#include "json_utils.h"
#include <string.h>


//ApplicationHeader: File Header JSON object names
tCString json_utils::APPLICATIONHEADER = "ApplicationHeader";
tCString json_utils::DATADICTIONARYVERSION = "DataDictionaryVersion";

tCString json_utils::MESSAGETYPE = "MessageType";//long lablel
tCString json_utils::MSGTYPE = "MsgType";//short lablel

tCString json_utils::TARGETID = "TargetId";//long lablel
tCString json_utils::TID = "TID";//short lablel

tCString json_utils::DEVID = "DevId";
tCString json_utils::DEVICETYPE = "DeviceType";
tCString json_utils::VIN = "VIN";
tCString json_utils::BIN = "BIN";
tCString json_utils::TIMESTAMP = "TimeStamp";
tCString json_utils::TS = "TS";

tCString json_utils::CORRELATIONID = "CorrelationId";//long lablel
tCString json_utils::CID = "CID";//short lablel

tCString json_utils::GLOBALMESSAGEID = "GlobalMessageId";//long lablel
tCString json_utils::GID = "GID";//short lablel

tCString json_utils::USERID = "UserId";
tCString json_utils::TOKEN = "Token";

//ApplicationData: Data JSON object name
tCString json_utils::VERSION = "Version";
tCString json_utils::DCMVERSION = "DCMVersion";
//tCString json_utils::TIMESTAMP = "TimeStamp";
tCString json_utils::DATAWIPE_DATA_ACTION = "DataWipe/Data/Action";

//UpLoadData from clients
tCString json_utils::UPLOADHEADER = "UploadHeader";
tCString json_utils::UPLOADFUNCTIONID = "UploadFunctionID";
tCString json_utils::UPLOADDATA = "UploadData";
// For DownLoad and UpLoad ConfigPolicy
//DownLoad
tCString json_utils::DBMAPDOWNLOAD = "DBMapDownLoad";
tCString json_utils::DOWNLOAD = "DownLoad";
tCString json_utils::DRMDATAREQTIMEOUT = "DRMdataReqTimeout";
tCString json_utils::GIDLISTMAX = "GIDListMax";

//Upload
tCString json_utils::DBMAPUPLOAD = "DBMapUpLoad";
tCString json_utils::UPLOAD = "UpLoad";

tCString json_utils::UPLOADTOPIC = "UploadTopic";
tCString json_utils::TOPICNAME = "TopicName";

//Common of ConfigPolicy
tCString json_utils::BUFFERSTYPE = "BuffersType";
tCString json_utils::DBPRIO = "DBPrio";
tCString json_utils::UMSOURCE = "UMSource";
tCString json_utils::BUFFERS = "Buffers";
tCString json_utils::QUEUESIZE = "QueueSize";
tCString json_utils::QUEUELENGTH = "QueueLength";

//UploadFunction
tCString json_utils::UPLOADFUNCTION = "UploadFunction";

//Signal Map DownLoad
tCString json_utils::SIGNALMAPDOWNLOAD = "SignalMapDownLoad";
tCString json_utils::SIGNAL = "Signal";

//SignalDownLoadBlock
tCString json_utils::SIGNALDOWNLOADBLOCK = "SignalDownLoadBlock";

//GenGlobalMessageId
tCString json_utils::GENGLOBALMESSAGEID = "GenerateNewGlobalMessageId";

//Data Dictionary
tCString json_utils::DATADICTIONARY = "DataDictionary";
tCString json_utils::LONGLABEL = "LL";
tCString json_utils::SHORTLABEL = "SL";

//DataWipe
tCString json_utils::DATAWIPE = "DataWipe";

tCString json_utils::DWASTA = "dwasta";
tCString json_utils::DATAWIPE_DATA_STATUS = "DataWipe/Data/Status";

tCString json_utils::DWAEC = "dwaec";
tCString json_utils::DATAWIPE_DATA_ERRORCODE = "DataWipe/Data/ErrorCode";

tCString json_utils::DWAC = "dwac";


//FIFOFull
tCString json_utils::DRMBUFFERFULL = "DRMBufferFull";
tCString json_utils::REMOTEREQUEST_SENT_DRM_ERRORCODE = "RemoteRequest/Sent/DRM/ErrorCode";

//FIFO full recovery
tCString json_utils::DRMBUFFERSTATUS = "DRMBufferStatus";
tCString json_utils::REMOTEREQUEST_SENT_DRM_BUFFERSTATE = "RemoteRequest/Sent/DRM/BufferState";

//LogTrace
tCString json_utils::LOGTRACE = "LogTrace";

//LabelConvert
tCString json_utils::LABELCONVERT = "LabelConvert";

//IVIVersionNotification
tCString json_utils::MQTTMANAGERVERSION = "IVIVersion/Sent/Notification/MQTTManagerVersion";
tCString json_utils::DDVERSION = "IVIVersion/Sent/Notification/DDVersion";

//Mqtt Configuration Needs
tCString json_utils::MQTT = "MQTT";
tCString json_utils::DRM = "DRM";

tCString json_utils::MQTTCONFIGPOLICY = "MqttConfigPolicy";
tCString json_utils::MQTTSESSIONTYPE = "MQTTSessionType";
tCString json_utils::MQTTKEEPTIMEALIVE = "MQTTkeepAlive";

tCString json_utils::KEEPALIVE = "keepalive";
tCString json_utils::INTERVAL = "Interval";
tCString json_utils::USERNAME = "Username";
tCString json_utils::PASSWORD = "Password";
tCString json_utils::OCCURRENCE = "Occurrence";
tCString json_utils::TIMEOUT = "Timeout";
tCString json_utils::CLEANSESSION = "CleanSession";
tCString json_utils::DELAY = "Delay";

tCString json_utils::MQTTPERIODICCONNECTINTERVAL = "MQTTperiodicConnectInterval";
tCString json_utils::MQTTPAYLOADCOMPRESSION = "MQTTPayloadCompression";
tCString json_utils::MQTTUSERNAMECONFIG = "MQTTUsernameConfig";
tCString json_utils::MQTTPASSWORDCONFIG = "MQTTPasswordConfig";
tCString json_utils::URL = "URL";
tCString json_utils::PORT = "PORT";
tCString json_utils::TLS = "TLS";
tCString json_utils::MQTTRETRYCONNECTINTERVAL = "MQTTRetryCONNECTInterval";
tCString json_utils::MQTTRETRYCONNECTOCCURRENCE = "MQTTRetryCONNECTOccurrence";
tCString json_utils::MQTTRETRYPUBLISHINTERVAL = "MQTTRetryPUBLISHInterval";
tCString json_utils::MQTTRETRYPUBLISHOCCURRENCE = "MQTTRetryPUBLISHOccurrence";
tCString json_utils::MQTTRETRYSUBSCRIBEINTERVAL = "MQTTRetrySUBSCRIBEInterval";
tCString json_utils::MQTTRETRYSUBSCRIBEOCCURRENCE = "MQTTRetrySUBSCRIBEOccurrence";
tCString json_utils::MQTTCONNECTIONTIMEOUT = "MQTTConnectionTimeOut";
tCString json_utils::MQTTSUBSCRIPTIONTIMEOUT = "MQTTSubscriptionTimeOut";
tCString json_utils::MQTTPUBLISHTIMEOUT = "MQTTPublishTimeOut";
tCString json_utils::MQTTCLEANSWITCHTOZLIB = "MQTTCleanSwitchToZlib";
tCString json_utils::MQTTCLEANSWITCHFROMZLIB = "MQTTCleanSwitchFromZlib";
tCString json_utils::TLS_EXPBACKOFFSTARTDELAY = "TLS_EXPBackOffStartDelay";
tCString json_utils::MQTTSESSIONTIMEOUT = "MQTTsessionTimeout";

//Dummy Download and Upload topics
tCString json_utils::MQTTDOWNLOADTOPIC_01 = "MQTTDownloadTopic01";
tCString json_utils::MQTTDOWNLOADTOPIC_02 = "MQTTDownloadTopic02";
tCString json_utils::MQTTDOWNLOADTOPIC_03 = "MQTTDownloadTopic03";
tCString json_utils::MQTTDOWNLOADTOPIC_04 = "MQTTDownloadTopic04";

tCString json_utils::MQTTUPLOADTOPIC_DEFAULT = "MQTTUploadTopicDefault";
tCString json_utils::MQTTUPLOADTOPIC_01 = "MQTTUploadTopic01";
tCString json_utils::MQTTUPLOADTOPIC_02 = "MQTTUploadTopic02";
tCString json_utils::MQTTUPLOADTOPIC_03 = "MQTTUploadTopic03";
tCString json_utils::MQTTUPLOADTOPIC_04 = "MQTTUploadTopic04";
tCString json_utils::MQTTUPLOADTOPIC_05 = "MQTTUploadTopic05";

//Application data
tCString json_utils::APPLICATIONDATA = "ApplicationData";

json_utils::json_utils()
{
	ETG_TRACE_USR1(("json_utils()"));
}
json_utils::~json_utils()
{
	ETG_TRACE_USR1(("~json_utils()"));
}
tBool json_utils::getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if (!value.isObject()) {
		ETG_TRACE_USR2(("%s is not an Object",jsonObjName));
		return FALSE;
	} else if(value == Json::Value::null){ // Cannot find JSONObject for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else {
		output = value;
		return TRUE;
	}
}

tBool json_utils::getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isArray()) {
		ETG_TRACE_USR2(("%s is not an Array",jsonObjName));
		return FALSE;
	}
	//	else if (value.isArray() && value.size() == 0) {
	//		ETG_TRACE_USR2(("%s is empty",jsonObjName));
	//		return FALSE;
	//	}
	else if (value.isArray()) {
		output = value;
		return TRUE;
	}

	return FALSE;
}

tBool json_utils::getString(Json::Value& input, tCString jsonObjName, std::string& output) {

	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isString()) {
		ETG_TRACE_USR2(("%s is not an String",jsonObjName));
		return FALSE;
	} else {
		std::string temp = value.asCString();
		output = temp;
		ETG_TRACE_USR2(("Get String: %s",temp.c_str()));
		return TRUE;
	}
}

tBool json_utils::gettBool(Json::Value& input, tCString jsonObjName, tBool& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isBool()) {
		ETG_TRACE_USR2(("%s is not a Bool",jsonObjName));
		return FALSE;
	} else {
		output = value.asBool();
		return TRUE;
	}
}

tBool json_utils::gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU8) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU16) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU32) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output) {
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if(value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found",jsonObjName));
		return FALSE;
	} else if (!value.isInt()) {
		ETG_TRACE_USR2(("%s is not an Integer",jsonObjName));
		return FALSE;
	} else {
		output = (tU64) value.asUInt();
		return TRUE;
	}
}

tBool json_utils::getDouble(Json::Value& input, tCString jsonObjName, double& output){
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if (value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found", jsonObjName));
		return FALSE;
	}else if(!value.isDouble()){
		ETG_TRACE_USR2(("Not a double type"));
		return FALSE;
	}
	else {
		output = (double) value.asDouble();
		ETG_TRACE_USR2(("Double: %lf", output));
		return TRUE;
	}
}

tBool json_utils::getFloat(Json::Value& input, tCString jsonObjName, float& output){
	Json::Value value = input.get(jsonObjName, Json::Value::null);

	if (value == Json::Value::null){ // Cannot find JSONArray for wrong name.
		ETG_TRACE_USR2(("%s cannot be found", jsonObjName));
		return FALSE;
	}else if(!value.isNumeric()){
		ETG_TRACE_USR2(("Not a numeric type"));
		return FALSE;
	}
	else {
		output = (float) value.asFloat();
		ETG_TRACE_USR2(("Double: %f", output));
		return TRUE;
	}
}
