/*
 * I_fc_dumm_JSONParser.h
 *
 *
 *
 */

#ifndef I_FC_DUMM_JSONPARSER_H_
#define I_FC_DUMM_JSONPARSER_H_

#include "fc_dumm_AppMain.h"
#include "I_fc_dumm_RequestQueue.h"
#include "I_fc_dumm_Buffer.h"
#include "fc_dumm_DiskStore.h"
#include "json_utils.h"
#include "fc_dumm_Api_Type.h"
#include "com/bosch/cm/dumm/DummService.h"

using namespace::com::bosch::cm::dumm::DummService;

class T_ApplicationHeader{
public:
	std::string GlobalMessageId;
	std::string DataDictionaryVersion;
	std::string MessageType;
	std::string TargetId;
	std::string DevId;
	std::string DeviceType;
	std::string VIN;
	std::string BIN;
	std::string TimeStamp;
	std::string DCMVersion;
	std::string CorrelationId;
	std::string UserId;
	std::string Token;
};

class T_UploadHeader{
public:
	UploadFunctionID uploadFunctionID;
	std::string CorrelationId;
	std::string UserId;
	std::string Token;
	std::string strMessageType;
	std::string strTargetID;
	std::string GlobalMessageId;
};

class I_fc_dumm_JSONParser : public fc_dumm_tclBaseIf
{

public:
	I_fc_dumm_JSONParser(fc_dumm_tclAppMain* poMainAppl):fc_dumm_tclBaseIf(poMainAppl){;}
	virtual ~I_fc_dumm_JSONParser() {}
	virtual const tChar* getIfName() const { return "I_fc_dumm_JSONParser"; };

	virtual tBool bParseApplicationHeader(Json::Value& root,T_ApplicationHeader& oChannelData) = 0;
	virtual tBool bParseApplicationHeader(Json::Value root, Json::Value& jApplicationHeader) = 0;
	virtual tBool bParseApplicationData(Json::Value root, Json::Value& jApplicationData) = 0;
	virtual tBool bParseTargetID(Json::Value & root, std::string& strTargetID) = 0;
	virtual tBool bParseCorrelationID(Json::Value & root, std::string& strCorrelationID) = 0;
	virtual tBool bParseGlobalMessageId(Json::Value & root, std::string& strGlobalMessageId) = 0;
	virtual tBool bParseDataDictionaryVersion(Json::Value & root, std::string& strDataDictionaryVersion) = 0;

	virtual tBool bParseMessageType(Json::Value & root, std::string& strMessageType) = 0;
	virtual tBool bParseUploadHeader(Json::Value& root, T_UploadHeader& oChannelData) = 0;

	//convert long-short label
	virtual tBool bShortToLongLabel(Json::Value jShortData, Json::Value& jLongData) = 0;
	virtual tBool bLongToShortLabel(Json::Value jLongData, Json::Value& jShortData) = 0;
	virtual tVoid vSetConvertLabel(tBool value) = 0;

	//Check Data of ApplicationHeader
	virtual tBool CheckDataApplicationHeader(T_ApplicationHeader oChannelData) = 0;
	//Check Data of ApplicationData
	virtual tBool CheckDataApplicationData(Json::Value& root) = 0;
	//Check Action Field On DataWipe
	virtual tBool CheckActionFieldOnDataWipe(Json::Value& root) = 0;
protected:
	 json_utils jsonUtils;
};


#endif /* I_FC_DUMM_JSONPARSER_H_ */
