/*!
*******************************************************************************
* @file             : URI_DBusHandler.h
*******************************************************************************
*  - PROJECT:       : ECore
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Implementation of Handler functions for URI
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
*  21.03.2016 | Ashish(RBEI/ECO2) | 1.0.0 | methods for URI DBus Server
*  09.05.2016 | RHK6KOR(RBEI/ECO2)| 2.0.0 | D-Bus name changes.
******************************************************************************/
#ifndef URI_DBUS_HANDLER_H
#define URI_DBUS_HANDLER_H

#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "URI_generated.h"
#include "AutomDBusServer.h"
#include "NaviDBusHandler.h"

/* handler for delegate_uri method */
gboolean
handle_delegate_uri(URI *object,
                    GDBusMethodInvocation *invocation,
                    const gchar *arg_uri);

GQuark uri_error_quark (void);

typedef enum
{
  URI_ERROR_INVALID_URI,
  URI_ERROR_UNKNOWN_SCHEME,
} URIError;

#endif // URI_DBUS_HANDLER_H