#pragma once

#include <litehtml/disable_warnings.h>
#include <litehtml/Config.h>
#include <Candera/System/Mathematics/Math.h>
#include <cstdio>
#include <assert.h>

#define UniqueRef Ref
#define nullptr 0
#define MIN Candera::Math::Minimum
#define MAX Candera::Math::Maximum

namespace std {
    template <typename T>
    class enable_shared_from_this {
        public:
            Ref<T> shared_from_this()
            {
                return Ref<T>(static_cast<T*>(this));
            }

            Ref<const T> shared_from_this() const
            {
                return Ref<const T>(static_cast<T*>(this));
            }
    };
}

namespace litehtml {
#if defined( WIN32 ) || defined( WINCE )
#ifndef LITEHTML_UTF8
    typedef std::wstring        tstring;
    typedef wchar_t             tchar_t;
    typedef std::wstringstream  tstringstream;

#define _t(quote)           L##quote

#define t_strlen            wcslen
#define t_strcmp            wcscmp
#define t_strncmp           wcsncmp
#define t_strcasecmp        _wcsicmp
#define t_strncasecmp       _wcsnicmp
#define t_strtol            wcstol
#define t_atoi              _wtoi
#define t_strtod            wcstod
#define t_itoa(value, buffer, size, radix)  _itow_s(value, buffer, size, radix)
#define t_strstr            wcsstr
#define t_tolower           towlower
#define t_isdigit           iswdigit

#else

    typedef std::string tstring;
    typedef char tchar_t;
    typedef std::stringstream tstringstream;

#define _t(quote)           quote

#define t_strlen            strlen
#define t_strcmp            strcmp
#define t_strncmp           strncmp
#define t_strcasecmp        _stricmp
#define t_strncasecmp       _strnicmp
#define t_strtol            strtol
#define t_atoi              atoi
#define t_strtod            strtod
#define t_itoa(value, buffer, size, radix)  _itoa_s(value, buffer, size, radix)
#define t_strstr            strstr
#define t_tolower           tolower
#define t_isdigit           isdigit

#endif

typedef size_t uint_ptr;

#else
    #define LITEHTML_UTF8
    typedef std::string         tstring;
    typedef char                tchar_t;
    typedef size_t              uint_ptr;
    typedef std::stringstream   tstringstream;

}  // namespace litehtml

#define _t(quote)           quote

#define t_strlen            strlen
#define t_strcmp            strcmp
#define t_strncmp           strncmp

#define t_strcasecmp        strcasecmp
#define t_strncasecmp       strncasecmp
#define t_itoa(value, buffer, size, radix) { int len = sprintf(buffer, "%d", value); assert(len < size); }

#define t_strtol            strtol
#define t_atoi              atoi
#define t_strtod            strtod
#define t_strstr            strstr
#define t_tolower           tolower
#define t_isdigit           isdigit

//extern "C" int strcasecmp(const litehtml::tchar_t* s1, const litehtml::tchar_t* s2);
//extern "C" int strncasecmp (const litehtml::tchar_t* s1, const litehtml::tchar_t* s2, size_t n);

namespace std {

    template<typename T>
    const T& move(const T& obj)
    {
        return obj;
    }

#endif
}
