/*!
 *
 * \copyright     (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 * \file          x:\ai_navigation\components\common\imagelib\resources\images.cpp
 * \author        CM-AI/ECN3-Pirklbauer
 * \date          13 Jan 2015
 *
 * \brief         This module contains svg resources for traffic signs.
 *                The svg descriptions were copied from the following location:
 *                http://de.wikipedia.org/wiki/Bildtafel_der_Verkehrszeichen_in_Deutschland
 *                https://en.wikipedia.org/wiki/Road_signs_in_Sweden
 *
 *                The images are in the public domain according to German copyright law because they are part of a statute, ordinance, official decree 
 *                or judgment (official work) issued by a German federal or state authority or court ( 5 Abs.1 UrhG).
 *   
 */
#include "precompiled.hh"
#include "images.h"

namespace ImageLib
{

   namespace Resources
   {
      tCString tcl_SVG_Resources_GER::get_Zeichen_101()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.99px\" height=\"659.08px\" viewBox=\"0 0 749.99 659.08\" enable-background=\"new 0 0 749.99 659.08\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_101.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"480\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.39752381\" inkscape:cx=\"374.995\" inkscape:cy=\"329.54001\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.692,18.139L344.692,18.139L5.351,605.904c-3.08,5.325-4.708,11.387-4.708,17.514  c0,19.284,15.718,34.994,35.019,34.994H714.36c6.129,0,12.188-1.618,17.48-4.691c16.713-9.65,22.456-31.086,12.821-47.816  L405.306,18.139c-3.057-5.301-7.495-9.733-12.805-12.805C375.796-4.308,354.351,1.435,344.692,18.139\" id=\"path3\"/>"
            "<path d=\"M375.003,0c-12.305,0-24.292,6.377-30.87,17.813L4.768,605.586C1.637,611.012,0,617.156,0,623.417  c0,19.685,15.961,35.662,35.646,35.662H714.36c6.245,0,12.389-1.652,17.798-4.793c11.487-6.61,17.864-18.614,17.832-30.969  c0-6.027-1.537-12.138-4.76-17.731L405.856,17.813c-3.122-5.425-7.63-9.917-13.039-13.048C387.198,1.519,381.081,0,375.003,0   M35.646,657.761c-18.925,0-34.335-15.393-34.335-34.344c0-6.026,1.594-11.972,4.583-17.162L345.26,18.481  C351.362,7.88,362.765,1.31,375.003,1.31c6.003,0,11.938,1.578,17.173,4.583c5.19,3.03,9.55,7.371,12.545,12.588l339.356,587.774  c9.484,16.394,3.808,37.446-12.553,46.896c-5.211,3.023-11.17,4.609-17.164,4.609H35.646z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.663,645.708c-12.33,0-22.297-10.002-22.297-22.29c0-3.924,1.027-7.747,2.996-11.135L355.703,24.492  c6.16-10.644,19.784-14.308,30.452-8.147c3.365,1.945,6.187,4.766,8.155,8.147l339.316,587.791  c6.179,10.652,2.521,24.275-8.132,30.436c-3.389,1.954-7.229,2.989-11.135,2.989 M112.847,578.856H637.16l-262.157-454.09  L112.847,578.856z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<path d=\"M410.665,520.907c0,19.7-15.96,35.645-35.662,35.645c-19.693,0-35.662-15.944-35.662-35.645  c0-19.686,15.969-35.646,35.662-35.646C394.705,485.261,410.665,501.221,410.665,520.907 M392.751,451.185  c-0.853,9.8-9.518,17.046-19.334,16.179c-8.582-0.77-15.402-7.58-16.169-16.179L339.5,252.222  c-1.762-19.609,12.73-36.931,32.348-38.692c19.609-1.745,36.914,12.739,38.667,32.348c0.185,2.121,0.185,4.225,0,6.345  L392.751,451.185z\" id=\"path9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_103_10()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.966px\" height=\"659.078px\" viewBox=\"0 0 749.966 659.078\" enable-background=\"new 0 0 749.966 659.078\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_103-10.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"480\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.39752503\" inkscape:cx=\"374.983\" inkscape:cy=\"329.539\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.681,18.156L344.681,18.156L5.351,605.92c-3.08,5.31-4.708,11.354-4.708,17.496  c0,19.283,15.719,34.993,35.018,34.993h678.677c6.128,0,12.188-1.619,17.481-4.675c16.712-9.666,22.454-31.103,12.821-47.814  L405.293,18.156c-3.056-5.301-7.495-9.733-12.805-12.806C375.785-4.291,354.339,1.452,344.681,18.156\" id=\"path3\"/>"
            "<path d=\"M374.992,0c-12.305,0-24.292,6.394-30.869,17.83L4.767,605.587C1.636,610.995,0,617.14,0,623.416  c0,19.701,15.96,35.662,35.645,35.662h678.694c6.245,0,12.389-1.653,17.798-4.775c11.486-6.628,17.864-18.632,17.83-30.986  c0-6.043-1.536-12.138-4.757-17.729L405.844,17.83c-3.121-5.426-7.629-9.917-13.038-13.047C387.188,1.536,381.069,0,374.992,0   M35.645,657.759c-18.924,0-34.334-15.409-34.334-34.343c0-6.01,1.595-11.97,4.583-17.162L345.249,18.481  c6.103-10.585,17.505-17.171,29.743-17.171c6.002,0,11.937,1.594,17.172,4.599c5.191,3.03,9.549,7.371,12.545,12.572  l339.349,587.772c9.482,16.395,3.806,37.431-12.556,46.897c-5.208,3.021-11.169,4.607-17.163,4.607H35.645z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.661,645.721c-12.329,0-22.296-10.017-22.296-22.305c0-3.905,1.026-7.746,2.997-11.152L355.692,24.508  c6.161-10.651,19.784-14.308,30.452-8.147c3.364,1.945,6.186,4.766,8.156,8.147l339.306,587.755  c6.177,10.685,2.521,24.275-8.131,30.452c-3.39,1.954-7.229,3.005-11.137,3.005 M112.843,578.84H637.14L374.992,124.78  L112.843,578.84z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<path d=\"M424.009,449.603c0-24.592-19.951-44.561-44.568-44.561h-66.28l-54.043-31.186l54.043-31.203h66.28  c59.093,0,106.975,47.882,106.975,106.949v106.949l-31.203-31.17l-31.203,31.17\" id=\"path9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_103_20()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.966px\" height=\"659.086px\" viewBox=\"0 0 749.966 659.086\" enable-background=\"new 0 0 749.966 659.086\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_103-20.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"480\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.3975202\" inkscape:cx=\"374.983\" inkscape:cy=\"329.543\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.682,18.156L344.682,18.156L5.351,605.912c-3.08,5.325-4.708,11.386-4.708,17.514  c0,19.266,15.719,34.993,35.019,34.993h678.678c6.127,0,12.188-1.637,17.479-4.691c16.712-9.667,22.455-31.104,12.822-47.815  L405.293,18.156c-3.056-5.301-7.496-9.733-12.806-12.805C375.785-4.299,354.34,1.453,344.682,18.156\" id=\"path3\"/>"
            "<path d=\"M374.992,0c-12.305,0-24.292,6.386-30.87,17.831L4.767,605.595C1.636,611.004,0,617.147,0,623.426  c0,19.684,15.96,35.66,35.645,35.66h678.695c6.244,0,12.388-1.669,17.797-4.791c11.486-6.628,17.863-18.615,17.83-30.97  c0-6.027-1.535-12.154-4.758-17.73L405.844,17.831c-3.122-5.417-7.63-9.917-13.039-13.047C387.188,1.536,381.069,0,374.992,0   M35.645,657.751c-18.924,0-34.334-15.394-34.334-34.325c0-6.027,1.594-11.987,4.583-17.163L345.249,18.49  c6.102-10.593,17.505-17.179,29.743-17.179c6.002,0,11.938,1.594,17.171,4.599c5.192,3.03,9.55,7.371,12.547,12.58l339.347,587.772  c9.483,16.395,3.807,37.431-12.555,46.88c-5.209,3.039-11.169,4.608-17.162,4.608H35.645z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.661,645.714c-12.33,0-22.296-10.001-22.296-22.288c0-3.924,1.026-7.747,2.997-11.153L355.692,24.517  c6.161-10.651,19.784-14.316,30.452-8.164c3.364,1.954,6.186,4.775,8.155,8.164l339.306,587.755  c6.178,10.652,2.521,24.275-8.13,30.452c-3.39,1.938-7.229,2.989-11.136,2.989 M112.843,578.849H637.14L374.992,124.78  L112.843,578.849z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<path d=\"M321.517,556.544l-31.195-31.17l-31.204,31.17V449.595c0-59.068,47.891-106.95,106.967-106.95h66.305l54.025,31.204  l-54.025,31.187h-66.305c-24.617,0-44.568,19.968-44.568,44.56\" id=\"path9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_113()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.966px\" height=\"659.078px\" viewBox=\"0 0 749.966 659.078\" enable-background=\"new 0 0 749.966 659.078\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_113.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.35807598\" inkscape:cx=\"374.983\" inkscape:cy=\"329.539\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.682,18.165L344.682,18.165L5.351,605.92c-3.08,5.309-4.708,11.386-4.708,17.496  c0,19.3,15.719,35.01,35.019,35.01h678.678c6.127,0,12.188-1.636,17.479-4.708c16.712-9.649,22.455-31.086,12.822-47.798  L405.293,18.165c-3.056-5.309-7.496-9.733-12.806-12.805C375.785-4.291,354.34,1.453,344.682,18.165\" id=\"path3\"/>"
            "<path d=\"M374.992,0c-12.305,0-24.292,6.395-30.87,17.831L4.767,605.586C1.636,611.012,0,617.172,0,623.417  c0,19.701,15.96,35.661,35.645,35.661h678.695c6.244,0,12.388-1.652,17.797-4.774c11.486-6.628,17.863-18.615,17.83-30.986  c0-6.011-1.535-12.138-4.758-17.73L405.844,17.831c-3.122-5.409-7.63-9.917-13.039-13.039C387.188,1.536,381.069,0,374.992,0   M35.645,657.776c-18.924,0-34.334-15.41-34.334-34.359c0-6.01,1.594-11.953,4.583-17.162L345.249,18.482  c6.102-10.585,17.505-17.146,29.743-17.146c6.002,0,11.938,1.586,17.171,4.591c5.192,3.022,9.55,7.363,12.547,12.555  l339.347,587.772c9.483,16.395,3.807,37.447-12.555,46.896c-5.209,3.021-11.169,4.625-17.162,4.625H35.645z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.661,645.721c-12.33,0-22.296-10-22.296-22.305c0-3.906,1.026-7.729,2.997-11.136L355.692,24.525  c6.161-10.651,19.784-14.308,30.452-8.164c3.364,1.954,6.186,4.775,8.155,8.164l339.306,587.755  c6.178,10.669,2.521,24.275-8.13,30.436c-3.39,1.953-7.229,3.005-11.136,3.005 M112.843,578.857H637.14L374.992,124.78  L112.843,578.857z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<polyline points=\"374.992,300.648 389.633,309.112 389.633,323.921 402.472,316.525 417.097,324.956 417.097,341.852   389.633,357.696 389.633,402.138 428.116,379.933 428.116,348.212 442.741,339.765 457.382,348.212 457.382,363.038   470.205,355.609 484.846,364.073 484.846,380.968 472.024,388.365 484.846,395.777 484.846,412.673 470.205,421.137 442.741,405.26   404.275,427.499 442.741,449.719 470.205,433.859 484.846,442.307 484.846,459.203 472.024,466.598 484.846,474.028   484.846,490.907 470.205,499.355 457.382,491.958 457.382,506.767 442.741,515.199 428.116,506.767 428.116,475.063   389.633,452.841 389.633,497.268 417.097,513.128 417.097,530.024 402.472,538.488 389.633,531.092 389.633,545.901   374.992,554.332 360.358,545.901 360.358,531.092 347.536,538.488 332.903,530.024 332.903,513.128 360.358,497.268   360.358,452.841 321.893,475.063 321.893,506.767 307.259,515.199 292.609,506.767 292.609,491.958 279.787,499.355   265.154,490.907 265.154,474.028 277.976,466.598 265.154,459.203 265.154,442.307 279.787,433.859 307.259,449.719   345.725,427.499 307.259,405.26 279.787,421.137 265.154,412.673 265.154,395.777 277.976,388.365 265.154,380.968 265.154,364.073   279.787,355.609 292.609,363.038 292.609,348.212 307.259,339.765 321.893,348.212 321.893,379.933 360.358,402.138   360.358,357.696 332.903,341.852 332.903,324.956 347.536,316.525 360.358,323.921 360.358,309.112 \" id=\"polyline9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_114()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.966px\" height=\"659.078px\" viewBox=\"0 0 749.966 659.078\" enable-background=\"new 0 0 749.966 659.078\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_114.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.35807598\" inkscape:cx=\"374.983\" inkscape:cy=\"329.539\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.681,18.148L344.681,18.148L5.351,605.903c-3.08,5.327-4.708,11.37-4.708,17.514  c0,19.283,15.719,34.993,35.019,34.993h678.678c6.127,0,12.187-1.619,17.479-4.708c16.713-9.633,22.455-31.069,12.822-47.799  L405.293,18.148c-3.055-5.292-7.496-9.717-12.805-12.806C375.784-4.291,354.339,1.453,344.681,18.148\" id=\"path3\"/>"
            "<path d=\"M374.991,0c-12.305,0-24.292,6.395-30.87,17.831L4.767,605.586C1.636,610.996,0,617.157,0,623.417  c0,19.7,15.96,35.661,35.644,35.661h678.695c6.243,0,12.388-1.653,17.797-4.791c11.486-6.611,17.864-18.615,17.83-30.97  c0-6.044-1.536-12.138-4.758-17.73L405.844,17.831c-3.121-5.426-7.63-9.917-13.038-13.055C387.187,1.536,381.068,0,374.991,0   M35.644,657.759c-18.924,0-34.333-15.41-34.333-34.343c0-6.026,1.594-11.971,4.583-17.162L345.249,18.481  c6.102-10.584,17.505-17.162,29.742-17.162c6.002,0,11.937,1.586,17.171,4.591c5.191,3.022,9.55,7.363,12.547,12.571  l339.347,587.773c9.483,16.395,3.807,37.431-12.555,46.896c-5.209,3.021-11.169,4.608-17.162,4.608H35.644z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.661,645.705c-12.33,0-22.296-10-22.296-22.288c0-3.923,1.027-7.747,2.997-11.152L355.691,24.509  c6.161-10.651,19.784-14.308,30.452-8.147c3.363,1.937,6.186,4.758,8.156,8.147l339.305,587.755  c6.178,10.669,2.521,24.275-8.13,30.452c-3.389,1.954-7.229,2.988-11.136,2.988 M112.843,578.84H637.14L374.991,124.78  L112.843,578.84z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<path d=\"M337.126,469.654c2.446,0,4.449,1.001,4.449,2.22c0,1.104-1.611,2.055-3.765,2.205l-9.867,0.768  c-56.071,4.34-93.326,15.626-93.326,28.231c0,3.939,4.14,7.563,10.894,9.583l1.261,0.367c1.887,0.568,2.963,2.537,2.396,4.44  c-0.375,1.303-1.485,2.271-2.821,2.505l-1.945,0.317c-15.459,2.57-31.353-3.056-35.527-12.589c-0.667-1.502-0.993-3.056-0.993-4.624  C207.88,484.613,265.737,469.654,337.126,469.654 M256.897,561.01c-8.005,0-15.986-0.802-23.833-2.371  c-4.207-0.868-6.945-4.975-6.085-9.199c0.852-4.224,4.958-6.944,9.183-6.093c0.184,0.032,0.359,0.083,0.526,0.134l3.731,1.018  c7.538,2.087,15.334,3.155,23.165,3.155c27.08,0,49.025-7.997,49.025-17.813c0-3.373-3.74-6.545-9.967-8.365l-8.206-2.471  c-8.064-2.387-13.022-6.778-13.022-11.485c0-15.36,46.889-27.848,104.729-27.848c2.463,0,4.458,1.002,4.458,2.237  c0,1.102-1.569,2.02-3.74,2.187l-7.096,0.585c-44.518,3.672-73.834,12.737-73.834,22.839c0,3.372,3.739,6.493,9.958,8.364  l8.197,2.453c8.081,2.405,13.039,6.762,13.039,11.504C337.126,547.037,301.207,561.01,256.897,561.01z M410.652,489.705  c1.67,0,3.038,0.685,3.038,1.52c0,0.518-0.533,1.002-1.436,1.269l-3.055,0.969c-7.329,2.304-11.912,6.861-11.912,11.837  c0,11.252,20.109,20.735,46.889,22.121l50.419,2.604c26.078,1.353,45.278,8.832,45.278,17.631c0,7.38-12.956,13.356-28.95,13.356  c-0.5,0-0.885-0.401-0.885-0.901c0-0.233,0.101-0.485,0.267-0.652l1.82-1.651c2.104-1.954,3.239-4.342,3.239-6.829  c0-6.845-12.121-12.604-28.049-13.289l-56.463-2.438c-31.737-1.386-55.862-12.37-55.862-25.493  C374.991,498.704,390.96,489.705,410.652,489.705z M273.927,356.092c0.818-3.072,2.613-5.776,5.092-7.745l3.848-2.989  c2.679-2.12,5.109-4.559,7.245-7.229l30.127-37.849c3.022-3.79,8.014-5.426,12.697-4.19l117.852,31.604  c4.707,1.252,8.214,5.159,8.932,9.95l7.162,47.866c0.518,3.389,1.403,6.678,2.671,9.85l1.837,4.524  c1.168,2.938,1.369,6.193,0.534,9.266l-8.197,30.62c-1.754,6.51-8.431,10.384-14.942,8.631l-174.448-46.714  c-6.512-1.77-10.376-8.448-8.632-14.976L273.927,356.092z M301.365,343.221l153.229,41.054l-6.244-41.588  c-0.267-1.904-1.669-3.473-3.556-4.007l-112.159-30.035c-1.887-0.501-3.865,0.15-5.083,1.669L301.365,343.221z M273.067,406.378  l-6.937,25.928c-1.043,3.906,1.26,7.931,5.176,8.966l14.141,3.807c3.898,1.035,7.914-1.286,8.957-5.192l6.962-25.928  L273.067,406.378z M419.234,445.546l28.28,7.579l-6.944,25.927c-1.053,3.907-5.075,6.228-8.982,5.193l-14.123-3.807  c-3.907-1.035-6.245-5.059-5.177-8.966L419.234,445.546z\" id=\"path9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_115_10()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Generator: Adobe Illustrator 15.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" id=\"Ebene_1\" x=\"0px\" y=\"0px\" width=\"749.966px\" height=\"659.078px\" viewBox=\"0 0 749.966 659.078\" enable-background=\"new 0 0 749.966 659.078\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_115-10.svg\"><metadata id=\"metadata15\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs13\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview11\" showgrid=\"false\" inkscape:zoom=\"0.35807598\" inkscape:cx=\"374.983\" inkscape:cy=\"329.539\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<path fill=\"#FFFFFF\" d=\"M344.682,18.165L344.682,18.165L5.351,605.92c-3.08,5.309-4.708,11.369-4.708,17.496  c0,19.283,15.719,35.011,35.019,35.011h678.678c6.127,0,12.188-1.637,17.479-4.708c16.712-9.65,22.455-31.087,12.822-47.799  L405.293,18.165c-3.056-5.309-7.496-9.733-12.806-12.805C375.785-4.291,354.34,1.453,344.682,18.165\" id=\"path3\"/>"
            "<path d=\"M374.992,0c-12.305,0-24.292,6.395-30.87,17.831L4.767,605.586C1.636,611.012,0,617.156,0,623.417  c0,19.701,15.96,35.661,35.645,35.661h678.695c6.244,0,12.388-1.652,17.797-4.774c11.486-6.628,17.863-18.615,17.83-30.986  c0-6.027-1.535-12.138-4.758-17.73L405.844,17.831c-3.122-5.409-7.63-9.917-13.039-13.039C387.188,1.536,381.069,0,374.992,0   M35.645,657.776c-18.924,0-34.334-15.41-34.334-34.359c0-6.01,1.594-11.953,4.583-17.162L345.249,18.482  c6.102-10.585,17.505-17.163,29.743-17.163c6.002,0,11.938,1.586,17.171,4.591c5.192,3.039,9.55,7.379,12.547,12.572  l339.347,587.772c9.483,16.395,3.807,37.447-12.555,46.896c-5.209,3.022-11.169,4.625-17.162,4.625H35.645z\" id=\"path5\"/>"
            "<path fill=\"#E30613\" d=\"M35.661,645.722c-12.33,0-22.296-10.001-22.296-22.306c0-3.906,1.026-7.729,2.997-11.136L355.692,24.525  c6.161-10.651,19.784-14.308,30.452-8.164c3.364,1.954,6.186,4.775,8.155,8.164l339.306,587.755  c6.178,10.652,2.521,24.275-8.13,30.436c-3.39,1.954-7.229,3.006-11.136,3.006 M112.843,578.857H637.14L374.992,124.78  L112.843,578.857z\" id=\"path7\" style=\"fill:#c1121c;fill-opacity:1\"/>"
            "<path d=\"M128.286,569.925l12.872-22.271h102.367l-11.144-11.152h-13.373l-13.365-24.509l31.204-33.424l17.83,2.237l13.365-6.694  l31.204,11.136l20.051,17.83l-2.237,26.763l-35.644,17.813h84.67l15.593-84.694l11.169-8.882l-8.924-89.153l13.365-8.898  l-8.924-13.373l8.924-62.39l44.551-21.854l179.874,311.516 M270.262,451.84l24.517-15.594l6.687-22.305l-15.593-15.61l-8.924,6.712  l-8.907-6.712l-22.271,17.831l2.221,13.373l2.22,15.609L270.262,451.84z M352.72,356.026l-20.051-4.474l-26.738,22.288  l-2.245,28.982l17.83,15.594l8.924-13.373h8.907l18.949-22.288l-5.576-6.695V356.026z M390.602,278.042l-46.789,4.441  l-13.373-26.746l15.593-11.136l2.221-15.593l35.669-6.695l17.814,11.152l4.457-2.237l13.373,11.136L390.602,278.042z\" id=\"path9\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_116()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" width=\"749.96716\" height=\"659.05261\" viewBox=\"0 0 749.96716 659.05261\" id=\"Ebene_1\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_116.svg\"><metadata id=\"metadata23\"><rdf:RDF><cc:Work rdf:about=\"\"><dc:format>image/svg+xml</dc:format><dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/><dc:title/></cc:Work></rdf:RDF></metadata><defs id=\"defs21\"/><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview19\" showgrid=\"false\" inkscape:zoom=\"0.35808977\" inkscape:cx=\"374.98358\" inkscape:cy=\"329.52631\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"Ebene_1\"/>"
            "<g transform=\"matrix(17.095603,0,0,-17.095603,-1991.4839,3494.478)\" id=\"g4283\">"
            "<path d=\"m 136.653,203.347 0,0 -19.849,-34.38 c -0.18,-0.311 -0.275,-0.666 -0.275,-1.024 0,-1.128 0.919,-2.047 2.048,-2.047 l 39.698,0 c 0.359,0 0.713,0.095 1.023,0.275 0.977,0.564 1.314,1.818 0.75,2.796 l -19.85,34.38 c -0.179,0.31 -0.438,0.569 -0.749,0.749 -0.977,0.564 -2.231,0.228 -2.796,-0.749\" id=\"path4299\" style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 118.576,165.934 c -1.107,0 -2.008,0.901 -2.008,2.009 0,0.352 0.093,0.7 0.268,1.004 l 19.85,34.38 c 0.357,0.62 1.024,1.004 1.74,1.004 0.351,0 0.698,-0.093 1.004,-0.268 0.304,-0.177 0.559,-0.431 0.734,-0.736 l 19.85,-34.38 c 0.554,-0.959 0.223,-2.19 -0.735,-2.743 -0.305,-0.177 -0.653,-0.27 -1.004,-0.27 l -39.699,0 z m 19.85,38.474 c -0.72,0 -1.421,-0.373 -1.806,-1.042 l -19.85,-34.38 c -0.183,-0.317 -0.279,-0.677 -0.279,-1.043 0,-1.152 0.934,-2.086 2.085,-2.086 l 39.699,0 c 0.366,0 0.725,0.097 1.042,0.28 0.671,0.387 1.045,1.089 1.043,1.812 0,0.352 -0.09,0.71 -0.279,1.037 l -19.85,34.38 c -0.183,0.317 -0.447,0.58 -0.763,0.763 -0.329,0.19 -0.687,0.279 -1.042,0.279\" id=\"path4301\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 123.092,170.55 30.668,0 -15.334,26.56 -15.334,-26.56 z m -4.515,-3.911 c -0.721,0 -1.304,0.585 -1.304,1.304 0,0.229 0.06,0.453 0.175,0.652 l 19.849,34.38 c 0.36,0.623 1.157,0.837 1.781,0.477 0.197,-0.114 0.362,-0.279 0.477,-0.477 l 19.848,-34.38 c 0.36,-0.624 0.147,-1.421 -0.476,-1.781 -0.198,-0.114 -0.423,-0.175 -0.652,-0.175\" id=\"path4303\" style=\"fill:#c1121c;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 124.146,171.332 0.451,0.783 8.165,0 c -0.269,0 -0.489,0.219 -0.489,0.488 l 0,1.792 1.956,0 0,-1.792 c 0,-0.269 -0.219,-0.488 -0.489,-0.488 l 18.515,0 0.452,-0.783\" id=\"path4305\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 134.229,177.165 c 0,0.54 -0.438,0.978 -0.978,0.978 -0.54,0 -0.978,-0.438 -0.978,-0.978 0,-0.54 0.438,-0.977 0.978,-0.977 0.54,0 0.978,0.437 0.978,0.977 z m -3.612,5.377 2.308,0 c 0.325,0 0.618,-0.193 0.747,-0.489 l 1.289,-2.962 c 0.091,-0.21 0.206,-0.408 0.343,-0.59 l 0.195,-0.26 c 0.127,-0.17 0.196,-0.376 0.196,-0.587 l 0,-2.118 c 0,-0.451 -0.365,-0.814 -0.814,-0.814 l -8.779,0 2.446,4.235 5.599,0 -1.12,2.574 c -0.052,0.119 -0.169,0.196 -0.299,0.196 l -2.581,0\" id=\"path4307\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 135.93,172.375 -0.044,0.311 8.828,1.24 0.044,-0.309\" id=\"path4309\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 137.494,173.314 -0.117,0.289 8.266,3.341 0.117,-0.29\" id=\"path4311\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 135.93,172.943 -0.171,0.263 5.684,3.691 0.171,-0.262\" id=\"path4313\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 142.811,177.589 -0.626,0.292 0.292,0.627 0.796,0.29 0.627,-0.293 -0.293,-0.626\" id=\"path4315\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 145.314,177.798 -0.321,0.321 0.321,0.321 0.556,0 0.322,-0.321 -0.322,-0.321\" id=\"path4317\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 146.487,175.504 -0.321,0.32 0.321,0.321 0.557,0 0.321,-0.321 -0.321,-0.32\" id=\"path4319\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 143.75,174.226 -0.537,0.25 0.25,0.538 0.683,0.248 0.536,-0.251 -0.25,-0.536\" id=\"path4321\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 145.835,172.74 -0.349,0.349 0.349,0.35 0.605,0 0.35,-0.35 -0.35,-0.349\" id=\"path4323\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 148.129,172.637 -0.412,0.191 0.193,0.411 0.523,0.19 0.412,-0.191 -0.193,-0.412\" id=\"path4325\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/><path d=\"m 147.086,173.679 -0.626,0.292 0.292,0.626 0.797,0.291 0.626,-0.293 -0.292,-0.626\" id=\"path4327\" style=\"fill:#231f20;fill-opacity:1;fill-rule:nonzero;stroke:none\"/>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_117_10()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"753.12\" height=\"671.52002\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_117-10.svg\">"
            "<metadata id=\"metadata10\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"1024\" inkscape:window-height=\"720\" id=\"namedview8\" showgrid=\"false\" inkscape:zoom=\"0.38867047\" inkscape:cx=\"-263.23442\" inkscape:cy=\"295.00817\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs11\"/>"
            "<g transform=\"matrix(1.106567,0,0,1.106567,-40.1289,-35.78094)\" id=\"g1875\">"
            "<path d=\"M 71.985614,631.52918 C 60.553114,631.52918 49.989054,625.43 44.272794,615.52918 C 38.556554,605.62833 38.556554,593.43 44.272794,583.52918 L 348.84719,55.99085 C 354.56345,46.09002 365.12751,39.99084 376.56,39.99084 C 387.99251,39.99084 398.55659,46.09002 404.27283,55.99085 L 708.84723,583.52918 C 714.56347,593.43 714.56347,605.62833 708.84723,615.52918 C 703.13097,625.42999 692.56691,631.52918 681.13441,631.52918 L 71.985614,631.52918 z \" style=\"fill:white;fill-rule:evenodd;stroke:black;stroke-width:2\" id=\"path6\"/>"
            "<path d=\"M 71.985614,619.52918 C 64.840294,619.52918 58.237754,615.7172 54.665094,609.52918 C 51.092454,603.34114 51.092454,595.7172 54.665094,589.52918 L 359.23951,61.99086 C 362.81215,55.80282 369.41471,51.99084 376.56,51.99084 C 383.70533,51.99084 390.30787,55.80282 393.88053,61.99086 L 698.45493,589.52918 C 702.02757,595.7172 702.02757,603.34114 698.45493,609.52918 C 694.88227,615.7172 688.27973,619.52918 681.13441,619.52918 L 71.985614,619.52918 z M 141.2677,559.52918 L 376.56,151.99085 L 611.85233,559.52918 L 141.2677,559.52918 z \" style=\"fill:#c1121c;fill-rule:evenodd;stroke:none;fill-opacity:1\" id=\"path8\"/>"
            "</g>"
            "<path d=\"m 389.82909,315.21875 75.59375,20.59375 0.0937,0.375 0,-2.875 12.125,0 0,237 -12.125,0.0937 0,-220.6875 -18.21875,65.9375 -189.125,78.59375 c -1.51788,0.62051 -2.39892,1.86894 -4.75,1.65625 -19.56171,-11.28879 -30.27964,-29.31827 -30.75,-51.28125 15.87344,-13.56917 111.44237,-86.27083 167.15625,-129.40625 z m 13.75,11.6875 c 19.6302,14.33876 36.69303,35.70155 42.625,71.9375 l 13.875,-58.25 -56.5,-13.6875 z m -48.3125,25.5625 -32.53125,24.40625 c 25.42813,14.00818 37.16776,39.1729 38.78125,67.3125 l 36.34375,-15.3125 c -0.54843,-24.09081 -7.12885,-51.55508 -42.59375,-76.40625 z m -68.46875,51.34375 -29.28125,21.96875 c 16.09135,13.595 23.57321,31.3385 29.5,49.8125 l 33.09375,-13.9375 c -3.45509,-21.41613 -11.56686,-41.53194 -33.3125,-57.84375 z m -57.25,42.96875 -1.25,0.9375 -0.28125,-0.15625 c 2.14151,17.78136 12.35983,30.62531 24.46875,42.5625 l 1,-0.4375 c -3.38792,-15.97459 -11.66436,-30.16264 -23.9375,-42.90625 z\" style=\"fill:#000000;fill-opacity:1;fill-rule:evenodd;stroke:none\" id=\"path1884\" inkscape:connector-curvature=\"0\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_120()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"753.12\" height=\"671.52002\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_120.svg\">"
            "<metadata id=\"metadata11\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "<dc:title/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"480\" id=\"namedview9\" showgrid=\"false\" inkscape:zoom=\"0.39015963\" inkscape:cx=\"376.56\" inkscape:cy=\"335.76001\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs11\"/>"
            "<g transform=\"matrix(1.106567,0,0,1.106567,-40.1289,-35.78094)\" id=\"g1875\">"
            "<path d=\"M 71.985614,631.52918 C 60.553114,631.52918 49.989054,625.43 44.272794,615.52918 C 38.556554,605.62833 38.556554,593.43 44.272794,583.52918 L 348.84719,55.99085 C 354.56345,46.09002 365.12751,39.99084 376.56,39.99084 C 387.99251,39.99084 398.55659,46.09002 404.27283,55.99085 L 708.84723,583.52918 C 714.56347,593.43 714.56347,605.62833 708.84723,615.52918 C 703.13097,625.42999 692.56691,631.52918 681.13441,631.52918 L 71.985614,631.52918 z \" style=\"fill:white;fill-rule:evenodd;stroke:black;stroke-width:2\" id=\"path6\"/>"
            "<path d=\"M 71.985614,619.52918 C 64.840294,619.52918 58.237754,615.7172 54.665094,609.52918 C 51.092454,603.34114 51.092454,595.7172 54.665094,589.52918 L 359.23951,61.99086 C 362.81215,55.80282 369.41471,51.99084 376.56,51.99084 C 383.70533,51.99084 390.30787,55.80282 393.88053,61.99086 L 698.45493,589.52918 C 702.02757,595.7172 702.02757,603.34114 698.45493,609.52918 C 694.88227,615.7172 688.27973,619.52918 681.13441,619.52918 L 71.985614,619.52918 z M 141.2677,559.52918 L 376.56,151.99085 L 611.85233,559.52918 L 141.2677,559.52918 z \" style=\"fill:#c1121c;fill-rule:evenodd;stroke:none;fill-opacity:1\" id=\"path8\"/>"
            "</g>"
            "<path d=\"M 467.50175,559.62429 L 430.04105,559.62429 L 430.04105,434.50795 L 394.04307,399.53969 L 394.04307,294.63492 L 431.26877,294.63492 L 431.26877,384.43976 L 467.10439,418.21592 L 467.50175,559.62429 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path2823\"/>"
            "<path d=\"M 285.76069,559.80589 L 323.22139,559.80589 L 323.22139,434.68955 L 359.21937,399.72129 L 359.21937,294.81652 L 321.99367,294.81652 L 321.99367,384.62136 L 286.15805,418.39752 L 285.76069,559.80589 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path2821\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_123()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:ns=\"http://ns.adobe.com/SaveForWeb/1.0/\" xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.1\" width=\"758.90997\" height=\"667.65002\" viewBox=\"0 0 758.90998 667.65002\" id=\"svg2\" xml:space=\"preserve\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_123.svg\"><sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"1024\" inkscape:window-height=\"720\" id=\"namedview9\" showgrid=\"false\" fit-margin-top=\"0\" fit-margin-left=\"0\" fit-margin-right=\"0\" fit-margin-bottom=\"0\" inkscape:zoom=\"0.71515154\" inkscape:cx=\"393.72381\" inkscape:cy=\"339.79853\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/><defs id=\"defs11\"/>"
            "<metadata id=\"metadata3\">"
            "<ns:sfw>"
            "<ns:slices/>"
            "<ns:sliceSourceBounds bottomLeftOrigin=\"true\" x=\"-75\" y=\"93\" width=\"745\" height=\"655\"/>"
            "</ns:sfw>"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "<dc:title/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "<ns:sfw>"
            "<ns:slices/>"
            "<ns:sliceSourceBounds bottomLeftOrigin=\"true\" x=\"-75\" y=\"93\" width=\"745\" height=\"655\"/>"
            "</ns:sfw>"
            "</metadata>"
            "<g transform=\"matrix(1.118133,0,0,1.118133,-41.591102,-41.601731)\" id=\"g1875\"><path inkscape:connector-curvature=\"0\" d=\"m 71.985614,631.52918 c -11.4325,0 -21.99656,-6.09918 -27.71282,-16 -5.71624,-9.90085 -5.71624,-22.09918 0,-32 L 348.84719,55.99085 c 5.71626,-9.90083 16.28032,-16.00001 27.71281,-16.00001 11.43251,0 21.99659,6.09918 27.71283,16.00001 l 304.5744,527.53833 c 5.71624,9.90082 5.71624,22.09915 0,32 -5.71626,9.90081 -16.28032,16 -27.71282,16 l -609.148796,0 z\" style=\"fill:#ffffff;fill-rule:evenodd;stroke:#000000;stroke-width:2\" id=\"path6\"/><path inkscape:connector-curvature=\"0\" d=\"m 71.985614,619.52918 c -7.14532,0 -13.74786,-3.81198 -17.32052,-10 -3.57264,-6.18804 -3.57264,-13.81198 0,-20 L 359.23951,61.99086 c 3.57264,-6.18804 10.1752,-10.00002 17.32049,-10.00002 7.14533,0 13.74787,3.81198 17.32053,10.00002 l 304.5744,527.53832 c 3.57264,6.18802 3.57264,13.81196 0,20 -3.57266,6.18802 -10.1752,10 -17.32052,10 l -609.148796,0 z m 69.282086,-60 235.2923,-407.53833 235.29233,407.53833 -470.58463,0 z\" style=\"fill:#c1121c;fill-opacity:1;fill-rule:evenodd;stroke:none\" id=\"path8\"/></g>"
            "<path d=\"m 360.32772,470.0846 c -0.037,-1.172 -0.394,-2.313 -1.03,-3.296 l -25.693,-39.712 -40.21,-21.285 -60.942,115.098 c -1.978,3.755 -3.021,7.93 -3.021,12.17 0,9.639 5.324,18.466 13.842,22.976 l 64.264,-121.387 27.011,41.759 2.022,54.599 c 0.517,13.973 11.995,25.029 25.978,25.029 0.446,0 0.526,0 0.968,-0.011 l -3.189,-85.94 m -53.667,-96.3 -5.134,9.691 -15.344,-12.685 -6.881,13.01 c -7.452,-3.951 -12.114,-11.682 -12.114,-20.114 0,-3.705 0.906,-7.361 2.645,-10.641 l 18.727,-35.348 c 2.809,-5.324 8.334,-8.653 14.354,-8.653 h 57.349 c 14.361,0 25.988,11.645 25.988,26.007 0,0.561 -0.005,1.1 -0.051,1.665 l -6.343,97.532 60.983,50.71 c -2.361,2.796 -5.355,4.972 -8.744,6.364 l -53.094,-43.854 -0.716,11.022 c -11.961,-0.77 -21.273,-10.705 -21.273,-22.7 0,-0.504 0.019,-0.957 0.042,-1.457 l 0.313,-4.742 -14.902,-12.31 5.131,-9.681 10.621,8.767 2.631,-40.745 -24.199,45.711 -40.213,-21.297 36.126,-68.236 h -25.734 l -15.523,29.305 15.355,12.679 z m 99.091,-102.111 c -13.464,0 -24.374,10.91 -24.374,24.371 0,13.467 10.91,24.379 24.374,24.379 13.465,0 24.373,-10.912 24.373,-24.379 0,-13.461 -10.908,-24.371 -24.373,-24.371 z m 25.703,223.349 c 4.621,-1.498 8.733,-4.258 11.869,-7.963 l 25.354,-30.006 c 6.174,-7.298 15.252,-11.507 24.815,-11.507 10.106,0 19.621,4.683 25.776,12.689 l 67.13,87.344 c 0.873,1.139 1.34,2.523 1.34,3.962 0,3.589 -2.902,6.492 -6.49,6.492 h -195 c -3.581,0 -6.493,-2.903 -6.493,-6.492 0,-1.547 0.537,-3.022 1.531,-4.194 l 37.284,-44.111 c 1.571,-1.858 3.626,-3.234 5.937,-3.988 l 6.947,-2.226 z\" id=\"path7\" style=\"fill:#000000;fill-rule:evenodd;stroke:none\" inkscape:connector-curvature=\"0\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_124()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"753.12\" height=\"671.52002\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_124.svg\">"
            "<metadata id=\"metadata16\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview14\" showgrid=\"false\" inkscape:zoom=\"0.3514415\" inkscape:cx=\"376.56\" inkscape:cy=\"335.76001\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs11\"/>"
            "<g transform=\"matrix(1.118133,0,0,1.118133,-44.48418,-39.66434)\" id=\"g1875\">"
            "<path d=\"M 71.985614,631.52918 C 60.553114,631.52918 49.989054,625.43 44.272794,615.52918 C 38.556554,605.62833 38.556554,593.43 44.272794,583.52918 L 348.84719,55.99085 C 354.56345,46.09002 365.12751,39.99084 376.56,39.99084 C 387.99251,39.99084 398.55659,46.09002 404.27283,55.99085 L 708.84723,583.52918 C 714.56347,593.43 714.56347,605.62833 708.84723,615.52918 C 703.13097,625.42999 692.56691,631.52918 681.13441,631.52918 L 71.985614,631.52918 z \" style=\"fill:white;fill-rule:evenodd;stroke:black;stroke-width:2\" id=\"path6\"/>"
            "<path d=\"M 71.985614,619.52918 C 64.840294,619.52918 58.237754,615.7172 54.665094,609.52918 C 51.092454,603.34114 51.092454,595.7172 54.665094,589.52918 L 359.23951,61.99086 C 362.81215,55.80282 369.41471,51.99084 376.56,51.99084 C 383.70533,51.99084 390.30787,55.80282 393.88053,61.99086 L 698.45493,589.52918 C 702.02757,595.7172 702.02757,603.34114 698.45493,609.52918 C 694.88227,615.7172 688.27973,619.52918 681.13441,619.52918 L 71.985614,619.52918 z M 141.2677,559.52918 L 376.56,151.99085 L 611.85233,559.52918 L 141.2677,559.52918 z \" style=\"fill:#c1121c;fill-rule:evenodd;stroke:none;fill-opacity:1\" id=\"path8\"/>"
            "</g>"
            "<path d=\"M 251.98382,404.28319 C 251.66543,380.81233 250.39181,401.00818 264.53801,366.21128 C 274.77239,342.55848 264.40155,348.92654 317.34741,348.06231 C 364.47107,349.01752 354.96446,342.19458 365.79016,367.30294 C 379.34503,399.46165 378.29885,382.63177 378.20788,403.60089 C 377.70754,426.61686 386.21345,420.70369 314.89117,421.47694 C 244.11473,420.52174 252.48417,426.52593 251.98382,404.28319 z M 266.31195,381.63109 L 276.0005,359.2519 C 277.80816,355.27663 277.23144,355.86346 281.45886,355.84044 L 349.19614,355.83313 C 352.86312,355.84662 352.32514,355.60852 353.83572,359.10814 L 363.47038,381.35816 L 266.31195,381.63109 z M 259.38291,424.04436 L 277.50156,424.00395 C 277.44596,446.75209 279.33112,445.48354 269.45051,445.63009 C 257.68475,445.5846 259.54463,446.77229 259.38291,424.04436 z M 352.69016,424.2061 L 370.83912,424.2061 C 370.71783,446.9896 372.37555,445.43299 362.10578,445.49362 C 351.4873,445.3521 352.83672,447.03004 352.69016,424.2061 z \" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"path3794\"/>"
            "<path d=\"M 323.78634,428.86156 L 336.51408,397.63919 C 339.64934,389.4738 345.27789,389.78113 350.517,389.52988 L 384.88886,389.72671\" style=\"fill:none;fill-opacity:0.75;fill-rule:evenodd;stroke:white;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path4683\"/>"
            "<path d=\"M 327.43953,429.79656 L 344.21007,393.77096 L 398.45551,394.18505 L 398.24846,434.97265 L 327.02545,434.35152 L 327.43953,429.79656 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path4693\"/>"
            "<path d=\"M 316.81717,455.92552 C 316.44508,428.49668 314.95669,452.09823 331.48841,411.43339 C 343.44866,383.79193 331.32894,391.23386 393.20328,390.22389 C 448.27359,391.34017 437.16384,383.36667 449.81513,412.70915 C 465.65581,450.29091 464.43321,430.62294 464.32689,455.12816 C 463.74217,482.02541 473.68247,475.11508 390.33283,476.01872 C 307.62107,474.90244 317.40189,481.91914 316.81717,455.92552 z M 333.56151,429.45351 L 344.88388,403.30042 C 346.99636,398.65479 346.32239,399.34058 351.26269,399.31367 L 430.42279,399.30514 C 434.70814,399.32089 434.07944,399.04264 435.84476,403.13242 L 447.10414,429.13455 L 333.56151,429.45351 z M 325.46399,479.0191 L 346.63806,478.97187 C 346.57308,505.55612 348.77614,504.07365 337.22933,504.24492 C 323.47947,504.19176 325.65299,505.57973 325.46399,479.0191 z M 434.50602,479.20812 L 455.71551,479.20812 C 455.57376,505.83369 457.51103,504.01457 445.50943,504.08544 C 433.10031,503.92005 434.67729,505.88094 434.50602,479.20812 z \" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"path3792\"/>"
            "<path d=\"M 401.24843,476.21364 L 413.97617,444.99127 C 416.62423,437.29155 422.70874,437.18989 427.97909,436.88196 L 462.35095,437.07879\" style=\"fill:none;fill-opacity:0.75;fill-rule:evenodd;stroke:white;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path3796\"/>"
            "<path d=\"M 407.4619,482.07508 L 424.23244,446.04948 L 478.47788,446.46357 L 478.27083,487.25117 L 407.04782,486.63004 L 407.4619,482.07508 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path4691\"/>"
            "<path d=\"M 389.91014,514.87887 C 389.47083,482.49599 387.71362,510.36032 407.23121,462.35083 C 421.35165,429.71693 407.04294,438.50297 480.09267,437.31059 C 545.10945,438.62849 531.99313,429.21486 546.92942,463.85701 C 565.63115,508.22657 564.18773,485.00629 564.06221,513.9375 C 563.37188,545.69277 575.10754,537.53434 476.70377,538.60119 C 379.05309,537.2833 390.60047,545.56731 389.91014,514.87887 z M 409.67874,483.62563 L 423.0461,452.74893 C 425.54012,447.26424 424.74442,448.07388 430.577,448.04212 L 524.03455,448.03205 C 529.09389,448.05064 528.35164,447.72214 530.4358,452.55058 L 543.72878,483.24908 L 409.67874,483.62563 z M 400.1187,542.14349 L 425.1171,542.08771 C 425.04039,573.47346 427.64135,571.72324 414.00902,571.92544 C 397.77574,571.86268 400.34183,573.50134 400.1187,542.14349 z M 528.85526,542.36664 L 553.8955,542.36664 C 553.72814,573.80117 556.01531,571.65349 541.84605,571.73716 C 527.19566,571.5419 529.05747,573.85695 528.85526,542.36664 z \" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"Car\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_129()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.0\" width=\"753.12\" height=\"671.52002\" id=\"svg2\">"
            "<defs id=\"defs11\"/>"
            "<g transform=\"matrix(1.118133,0,0,1.118133,-44.48418,-39.66434)\" id=\"g1875\">"
            "<path d=\"M 71.985614,631.52918 C 60.553114,631.52918 49.989054,625.43 44.272794,615.52918 C 38.556554,605.62833 38.556554,593.43 44.272794,583.52918 L 348.84719,55.99085 C 354.56345,46.09002 365.12751,39.99084 376.56,39.99084 C 387.99251,39.99084 398.55659,46.09002 404.27283,55.99085 L 708.84723,583.52918 C 714.56347,593.43 714.56347,605.62833 708.84723,615.52918 C 703.13097,625.42999 692.56691,631.52918 681.13441,631.52918 L 71.985614,631.52918 z \" style=\"fill:white;fill-rule:evenodd;stroke:black;stroke-width:2\" id=\"path6\"/>"
            "<path d=\"M 71.985614,619.52918 C 64.840294,619.52918 58.237754,615.7172 54.665094,609.52918 C 51.092454,603.34114 51.092454,595.7172 54.665094,589.52918 L 359.23951,61.99086 C 362.81215,55.80282 369.41471,51.99084 376.56,51.99084 C 383.70533,51.99084 390.30787,55.80282 393.88053,61.99086 L 698.45493,589.52918 C 702.02757,595.7172 702.02757,603.34114 698.45493,609.52918 C 694.88227,615.7172 688.27973,619.52918 681.13441,619.52918 L 71.985614,619.52918 z M 141.2677,559.52918 L 376.56,151.99085 L 611.85233,559.52918 L 141.2677,559.52918 z \" style=\"fill:#c00;fill-rule:evenodd;stroke:none\" id=\"path8\"/>"
            "</g>"
            "<g transform=\"matrix(-0.339445,-9.496738e-2,-9.496738e-2,0.339445,510.7242,410.7256)\" id=\"layer1\">"
            "<path d=\"M 640.23853,222.03787 C 640.23853,249.14264 618.26578,271.11539 591.16101,271.11539 C 564.05624,271.11539 542.08349,249.14264 542.08349,222.03787 C 542.08349,194.9331 564.05624,172.96035 591.16101,172.96035 C 618.26578,172.96035 640.23853,194.9331 640.23853,222.03787 L 640.23853,222.03787 z \" transform=\"matrix(1.079545,0,0,1.079545,-521.3741,-27.12071)\" style=\"opacity:1;fill:black;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:30;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path25345\"/>"
            "<path d=\"M 285.83418,10.247082 C 288.65554,6.9807461 291.87058,4.1737036 297.80466,4.5388804 L 554.11195,4.5388804 L 681.49562,105.68157 C 682.90126,108.65248 683.61253,110.92902 683.96915,112.85091 L 684.45326,202.47755 C 682.08558,207.61498 679.30008,212.00034 674.33227,212.45753 L 644.76683,212.45753 C 644.76683,124.83077 515.22193,124.6518 515.22193,212.45753 L 182.38817,212.45753 C 182.38817,125.17065 51.857393,124.83574 51.857393,212.45753 L 15.791737,212.45753 C 12.71653,211.01909 9.9497784,212.35674 5.8866518,202.02701 L 5.492299,137.57457 C 7.5896054,131.71045 10.205427,129.47594 12.815364,127.20023 L 200.16379,96.077198 L 285.83418,10.247082 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path24454\"/>"
            "<path d=\"M 640.23853,222.03787 C 640.23853,249.14264 618.26578,271.11539 591.16101,271.11539 C 564.05624,271.11539 542.08349,249.14264 542.08349,222.03787 C 542.08349,194.9331 564.05624,172.96035 591.16101,172.96035 C 618.26578,172.96035 640.23853,194.9331 640.23853,222.03787 L 640.23853,222.03787 z \" transform=\"matrix(1.079545,0,0,1.079545,-58.73586,-27.14299)\" style=\"opacity:1;fill:black;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:30;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path25343\"/>"
            "<path d=\"M 226.41173,97.07302 L 290.25519,34.075171 C 291.69464,32.851906 292.82676,31.167654 295.32884,31.538345 L 408.85181,31.538345 L 408.85181,108.70014 L 231.27398,108.70014 C 224.51388,106.03369 223.59914,101.99187 226.41173,97.07302 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path25349\"/>"
            "<path d=\"M 585.23723,89.186408 L 530.52565,34.0864 C 529.0862,32.863135 527.95408,31.178883 525.452,31.549574 L 429.94598,31.549574 L 429.94598,108.71136 L 592.71536,108.71136 C 600.41757,107.17544 590.2821,96.783985 585.23723,89.186408 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path26236\"/>"
            "</g>"
            "<path d=\"M 286.79499,455.92956 L 286.79499,578.88533 L 125.09423,578.88533 L 196.16251,455.92219 L 286.79499,455.92956 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5595\"/>"
            "<path d=\"M 313.71875,525.15625 C 306.15692,525.17556 300.57881,527.71769 295.09375,530.6875 L 294.84375,546 C 305.64166,541.48899 316.50419,537.05159 334.21875,546 C 344.82812,549.74426 355.32281,553.8077 370.03125,546 C 382.88139,539.7403 396.12529,536.33775 411.25,546 C 421.36699,550.42091 431.80481,553.81518 445.875,546 C 452.23351,543.12923 458.61024,541.23738 464.96875,540.84375 C 470.56045,540.81757 476.86717,542.1759 484.4375,546 C 495.04687,549.74426 505.54154,553.8077 520.25,546 C 533.10014,539.7403 546.37528,536.33775 561.5,546 C 571.61699,550.42091 582.05479,553.81518 596.125,546 C 597.13284,546.24753 602.34723,543.49411 605.65625,541.75 C 606.32244,541.39888 601.27934,533.19469 599.3125,529.34375 C 585.82095,534.34368 572.52576,536.76786 560.5625,530.6875 C 546.68568,523.1339 533.78603,524.48668 521.4375,530.6875 C 509.17424,535.90082 497.54106,535.56701 486.40625,530.8125 L 486.40625,530.6875 C 485.47457,530.33639 484.57224,530.01955 483.65625,529.6875 C 464.34603,521.82014 454.70525,525.61883 445.34375,530.6875 L 445.34375,530.90625 C 433.26329,534.77877 420.94467,536.09134 410.3125,530.6875 C 396.43568,523.1339 383.53605,524.48668 371.1875,530.6875 C 358.81096,535.94898 347.0721,535.56841 335.84375,530.6875 C 326.66903,526.64966 319.60017,525.14123 313.71875,525.15625 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5597\"/>"
            "<path d=\"M 314.12432,552.9482 C 306.56249,552.96751 300.98438,555.50964 295.49932,558.47945 L 295.24932,573.79195 C 306.04723,569.28094 316.90976,564.84354 334.62432,573.79195 C 345.23369,577.53621 355.72838,581.59965 370.43682,573.79195 C 383.28696,567.53225 396.53086,564.1297 411.65557,573.79195 C 421.77256,578.21286 432.21038,581.60713 446.28057,573.79195 C 452.63908,570.92118 459.01581,569.02933 465.37432,568.6357 C 470.96602,568.60952 477.27274,569.96785 484.84307,573.79195 C 495.45244,577.53621 505.94711,581.59965 520.65557,573.79195 C 533.50571,567.53225 546.78085,564.1297 561.90557,573.79195 C 572.02256,578.21286 582.46036,581.60713 596.53057,573.79195 C 597.53841,574.03948 602.50711,570.70623 606.06182,569.54195 C 613.94415,566.96025 623.07466,570.70165 620.9683,567.49344 C 618.87424,564.30396 614.95095,555.86648 613.14242,553.8703 C 611.92608,552.52776 602.81415,556.37499 599.71807,557.1357 C 586.22652,562.13563 572.93133,564.55981 560.96807,558.47945 C 547.09125,550.92585 534.1916,552.27863 521.84307,558.47945 C 509.57981,563.69277 497.94663,563.35896 486.81182,558.60445 L 486.81182,558.47945 C 485.88014,558.12834 484.97781,557.8115 484.06182,557.47945 C 464.7516,549.61209 455.11082,553.41078 445.74932,558.47945 L 445.74932,558.6982 C 433.66886,562.57072 421.35024,563.88329 410.71807,558.47945 C 396.84125,550.92585 383.94162,552.27863 371.59307,558.47945 C 359.21653,563.74093 347.47767,563.36036 336.24932,558.47945 C 327.0746,554.44161 320.00574,552.93318 314.12432,552.9482 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5633\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_151()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg id=\"svg2\" xmlns=\"http://www.w3.org/2000/svg\" height=\"671.52\" width=\"753.12\" version=\"1.0\">"
            "<g id=\"g1875\" fill-rule=\"evenodd\" transform=\"matrix(1.1181 0 0 1.1181 -44.484 -39.664)\">"
            "<path id=\"path6\" d=\"m71.986 631.53c-11.433 0-21.997-6.1-27.713-16s-5.716-22.1 0-32l304.58-527.54c5.71-9.9 16.28-15.999 27.71-15.999s22 6.099 27.71 16l304.58 527.54c5.71 9.9 5.71 22.1 0 32-5.72 9.9-16.28 16-27.72 16h-609.14z\" stroke=\"#000\" stroke-width=\"2\" fill=\"#fff\"/>"
            "<path id=\"path8\" fill=\"#c00\" d=\"m71.986 619.53c-7.146 0-13.748-3.81-17.321-10s-3.573-13.81 0-20l304.58-527.54c3.57-6.187 10.17-9.999 17.32-9.999s13.75 3.812 17.32 10l304.57 527.54c3.58 6.19 3.58 13.81 0 20-3.57 6.19-10.17 10-17.32 10h-609.14zm69.284-60l235.29-407.54 235.29 407.54h-470.58z\"/>"
            "</g>"
            "<g id=\"layer1\" transform=\"matrix(.72452 0 0 .72452 242.96 312.68)\">"
            "<g id=\"g2285\" transform=\"matrix(1.6788 0 0 1.6788 -1258.5 -55.289)\">"
            "<path id=\"path2251\" d=\"m1009.2 214.28h-230.69c-10.88 0-23.86-17.1-23.86-28.23-0.24-18.83 0.66-37.08 1.27-55.49 2.93-20.98 10.99-40.168 18.98-59.383 1.96-4.017 4.32-7.941 9.11-7.941h83.6c7.6 3.422 15.81 6.031 19.27 14.895 23.99 59.059 71.4 87.289 125.72 97.249l0.1 35.75c0 1.41-2 3.15-3.5 3.15z\" fill-rule=\"evenodd\"/>"
            "<path id=\"path2253\" d=\"m793.88 37.031c-3.16 0-3.06 6.125 0 6.125h13.59c11.49 4.644 18.28 11.247 21.44 20.125h5.21v-0.031h5.16c3.16-8.878 9.95-15.45 21.44-20.094h13.28c3.28 0 2.78-6.125 0-6.125h-80.12zm27.65 6.125h25.06c-5.4 4.551-11.25 9.179-11.25 16.282h-1.22-1.28c0-7.125-5.89-11.717-11.31-16.282z\" fill-rule=\"evenodd\"/>"
            "<path id=\"path2260\" d=\"m770.43 114.14h105.09c2.55 0 3.5-5.28 2.3-8.57-3.8-10.144-8.43-29.966-13.68-29.966h-80.79c-4.38 0-10.22 20.142-15.33 30.216-1.01 4-0.01 8.32 2.41 8.32z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2265\" d=\"m787.98 164.94c0 5.3-4.29 9.6-9.59 9.6-5.31 0-9.6-4.3-9.6-9.6s4.29-9.6 9.6-9.6c5.3 0 9.59 4.3 9.59 9.6z\" transform=\"translate(1.5481 -.61924)\" fill=\"#fff\"/>"
            "<path id=\"path2267\" d=\"m787.98 164.94c0 5.3-4.29 9.6-9.59 9.6-5.31 0-9.6-4.3-9.6-9.6s4.29-9.6 9.6-9.6c5.3 0 9.59 4.3 9.59 9.6z\" transform=\"translate(80.811 -.61924)\" fill=\"#fff\"/>"
            "<path id=\"path2271\" d=\"m913.61 136.36v34.92l-15.98-7.34c-1.52-14.73-1.66-29.75-1.75-44.77 5.91 5.73 12.25 13.59 17.73 17.19z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2273\" d=\"m937.81 155.41l0.23 26.87-15.28-6.4c-0.36-14.74 0.09-16.34-0.01-31.37 6.61 5.62 9.34 6.72 15.06 10.9z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2275\" d=\"m945.69 160.18v23.99c4.38 2.35 9.45 3.6 14.93 4.2v-22.09l-14.93-6.1z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2277\" d=\"m966.8 169.25v20.93c3.83 1.49 7.82 1.97 11.87 2.15v-20.03l-11.87-3.05z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2279\" d=\"m984.77 174.36v18.79c3.14 0.88 6.36 1.37 9.73 1.16v-18.06l-9.73-1.89z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2281\" d=\"m999.69 177.24v17.81l7.81 1.32v-18.06l-7.81-1.07z\" fill-rule=\"evenodd\" fill=\"#fff\"/>"
            "<path id=\"path2283\" d=\"m754.66 229.21h19.93v-9.98h30.04v9.86h44v-9.89h164.07v10.04c-46.21 1.69-93.32 3.01-117.79 14.03h-140.28l0.03-14.06z\" fill-rule=\"evenodd\"/>"
            "</g>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_250()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" width=\"725\" height=\"725\" version=\"1.1\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_250.svg\">"
            "<metadata id=\"metadata12\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<defs id=\"defs10\"/>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview8\" showgrid=\"false\" inkscape:zoom=\"0.32551724\" inkscape:cx=\"362.5\" inkscape:cy=\"362.5\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<circle style=\"fill:#FFF; stroke:#000; stroke-width:2.5px\" r=\"350\" cx=\"362.5\" cy=\"362.5\" id=\"circle4\"/>"
            "<path style=\"font-size:medium;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-indent:0;text-align:start;text-decoration:none;line-height:normal;letter-spacing:normal;word-spacing:normal;text-transform:none;direction:ltr;block-progression:tb;writing-mode:lr-tb;text-anchor:start;baseline-shift:baseline;color:#000000;fill:#c1121c;fill-opacity:1;stroke:none;stroke-width:83.75000000000000000;marker:none;visibility:visible;display:inline;overflow:visible;enable-background:accumulate;font-family:Sans;-inkscape-font-specification:Sans\" d=\"m 362.5,25.625 c -185.55493,0 -336.875,151.32007 -336.875,336.875 0,185.55493 151.32007,336.875 336.875,336.875 185.55493,0 336.875,-151.32007 336.875,-336.875 C 699.375,176.94507 548.05493,25.625 362.5,25.625 z m 0,83.75 c 140.29307,0 253.125,112.83193 253.125,253.125 0,140.29307 -112.83193,253.125 -253.125,253.125 -140.29307,0 -253.125,-112.83193 -253.125,-253.125 0,-140.29307 112.83193,-253.125 253.125,-253.125 z\" id=\"circle6\" inkscape:connector-curvature=\"0\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_251()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" width=\"725\" height=\"725\" version=\"1.1\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_251.svg\">"
            "<metadata id=\"metadata16\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "<dc:title/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<defs id=\"defs14\"/>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview12\" showgrid=\"false\" inkscape:zoom=\"0.32551724\" inkscape:cx=\"362.5\" inkscape:cy=\"362.5\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<circle style=\"fill:#FFF; stroke:#000; stroke-width:2.5px\" r=\"350\" cx=\"362.5\" cy=\"362.5\" id=\"circle4\"/>"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"290\" style=\"stroke:#c1121c;stroke-width:93.75000000000000000;fill:none;stroke-opacity:1\" id=\"circle6\"/>"
            "<g transform=\"matrix(0.387772,0.000000,0.000000,0.387772,168.3417,207.4427)\" id=\"CarSymbol\">"
            "<path style=\"stroke:none; fill:black; fill-rule:evenodd\" id=\"Car\" d=\"M 26.666667,456.41026 C 24.273504,280.00000 14.700854,431.79487 121.02564,170.25641 C 197.94872,-7.5213676 120.00000,40.341880 517.94872,33.846154 C 872.13675,41.025642 800.68376,-10.256409 882.05128,178.46154 C 983.93162,420.17094 976.06838,293.67521 975.38462,451.28205 C 971.62393,624.27350 1035.5556,579.82906 499.48718,585.64103 C -32.478634,578.46155 30.427346,623.58974 26.666667,456.41026 z     M 134.35897,286.15385 L 207.17949,117.94872 C 220.76607,88.070065 216.43137,92.480742 248.20513,92.307692 L 757.32827,92.252822 C 784.88973,92.354119 780.84626,90.564525 792.20006,116.86821 L 864.61538,284.10256 L 134.35897,286.15385 z     M 82.279202,604.93828 L 218.46154,604.63438 C 218.04369,775.61254 232.21273,766.07788 157.94872,767.17949 C 69.515671,766.83761 83.494777,775.76449 82.279202,604.93828 z     M 783.58974,606.15385 L 920.00000,606.15385 C 919.08832,777.39791 931.54796,765.69801 854.35897,766.15385 C 774.54890,765.09022 784.69135,777.70181 783.58974,606.15385 z\"/>"
            "<circle style=\"fill:white; fill-opacity:1; stroke:none\" r=\"66.5\" cy=\"412\" cx=\"150\" id=\"LeftLamp\" d=\"m 216.5,412 c 0,36.72694 -29.77306,66.5 -66.5,66.5 -36.72694,0 -66.5,-29.77306 -66.5,-66.5 0,-36.72694 29.77306,-66.5 66.5,-66.5 36.72694,0 66.5,29.77306 66.5,66.5 z\"/>"
            "<circle style=\"fill:white; fill-opacity:1; stroke:none\" r=\"66.5\" cy=\"412\" cx=\"850\" id=\"RightLamp\" d=\"m 916.5,412 c 0,36.72694 -29.77306,66.5 -66.5,66.5 -36.72694,0 -66.5,-29.77306 -66.5,-66.5 0,-36.72694 29.77306,-66.5 66.5,-66.5 36.72694,0 66.5,29.77306 66.5,66.5 z\"/>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_260()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"725\" height=\"725\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_260.svg\">"
            "<metadata id=\"metadata20\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview18\" showgrid=\"false\" inkscape:zoom=\"0.32551724\" inkscape:cx=\"362.5\" inkscape:cy=\"362.5\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs9\"/>"
            "<g id=\"g1875\">"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"350\" style=\"fill:white;stroke:black;stroke-width:2.5px\" id=\"circle4\"/>"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"290\" style=\"fill:none;stroke:#c1121c;stroke-width:93.75000000000000000;stroke-opacity:1\" id=\"circle6\"/>"
            "</g>"
            "<path d=\"M 131.43407,350.50236 L 593.25172,350.50236\" style=\"fill:none;fill-opacity:0.75;fill-rule:evenodd;stroke:black;stroke-width:11.26880264;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path1993\"/>"
            "<g transform=\"matrix(0.249759,0,0,0.249759,235.6439,375.1742)\" id=\"g1971\">"
            "<path d=\"M 26.666667,456.41026 C 24.273504,280 14.700854,431.79487 121.02564,170.25641 C 197.94872,-7.5213676 120,40.34188 517.94872,33.846154 C 872.13675,41.025642 800.68376,-10.256409 882.05128,178.46154 C 983.93162,420.17094 976.06838,293.67521 975.38462,451.28205 C 971.62393,624.2735 1035.5556,579.82906 499.48718,585.64103 C -32.478634,578.46155 30.427346,623.58974 26.666667,456.41026 z M 134.35897,286.15385 L 207.17949,117.94872 C 220.76607,88.070065 216.43137,92.480742 248.20513,92.307692 L 757.32827,92.252822 C 784.88973,92.354119 780.84626,90.564525 792.20006,116.86821 L 864.61538,284.10256 L 134.35897,286.15385 z M 82.279202,604.93828 L 218.46154,604.63438 C 218.04369,775.61254 232.21273,766.07788 157.94872,767.17949 C 69.515671,766.83761 83.494777,775.76449 82.279202,604.93828 z M 783.58974,606.15385 L 920,606.15385 C 919.08832,777.39791 931.54796,765.69801 854.35897,766.15385 C 774.5489,765.09022 784.69135,777.70181 783.58974,606.15385 z \" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"Car\"/>"
            "<circle cx=\"150\" cy=\"412\" r=\"66.5\" style=\"fill:white;fill-opacity:1;stroke:none\" id=\"LeftLamp\" d=\"m 216.5,412 c 0,36.72694 -29.77306,66.5 -66.5,66.5 -36.72694,0 -66.5,-29.77306 -66.5,-66.5 0,-36.72694 29.77306,-66.5 66.5,-66.5 36.72694,0 66.5,29.77306 66.5,66.5 z\"/>"
            "<circle cx=\"850\" cy=\"412\" r=\"66.5\" style=\"fill:white;fill-opacity:1;stroke:none\" id=\"RightLamp\" d=\"m 916.5,412 c 0,36.72694 -29.77306,66.5 -66.5,66.5 -36.72694,0 -66.5,-29.77306 -66.5,-66.5 0,-36.72694 29.77306,-66.5 66.5,-66.5 36.72694,0 66.5,29.77306 66.5,66.5 z\"/>"
            "</g>"
            "<g transform=\"matrix(0.409224,0,0,0.409224,224.4982,131.9194)\" id=\"layer1\">"
            "<path d=\"M 438.12826,429.16927 C 375.32987,426.00501 282.92602,437.06422 251.92375,397.77007 C 237.71768,323.00073 197.12299,285.36345 127.4223,284.58694 C 84.626532,201.93866 162.31092,188.98722 215.41306,167.75274 C 218.78636,206.16837 216.71935,246.10015 277.48123,268.52224 C 279.92034,256.63453 284.90432,246.92813 300.84807,246.61583 L 390.66436,246.98094 L 454.19295,197.3264 C 464.45935,213.65423 484.83147,234.57558 484.86193,246.25072 L 581.25015,246.61583 C 588.2694,252.59444 594.22298,268.45864 580.15483,284.22184 C 522.41354,282.46908 417.46802,288.77717 438.12826,429.16927 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path4749\"/>"
            "<path d=\"M 281.45311,113.13794 L 281.71128,79.094411 L 319.83363,73.920272 L 319.83363,46.902363 L 280.93677,53.36735 C 283.79727,29.02724 299.44705,11.428004 333.92156,6.3312047 C 355.56786,7.8567994 378.26787,9.030436 391.1807,49.520754 C 394.96498,65.581097 392.60623,81.830116 382.63201,95.826685 C 350.34442,78.127222 326.17913,90.209532 304.13403,110.06585 L 281.45311,113.13794 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5636\"/>"
            "<path d=\"M 215.04795,186.7383 L 328.59619,100.93818 C 343.85852,92.79748 360.69029,91.248459 380.80647,103.49393 C 398.00264,119.11558 427.05087,162.39207 450.17678,191.84979 L 385.55287,240.22646 L 323.48469,153.87868 L 225.27094,229.0907 C 217.71099,215.89572 215.94199,200.40941 215.04795,186.7383 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path6523\"/>"
            "<path d=\"M 241.70075,414.19989 C 241.70789,460.38118 204.27256,497.8223 158.09128,497.8223 C 111.90999,497.8223 74.474661,460.38118 74.481804,414.19989 C 74.474661,368.0186 111.90999,330.57748 158.09128,330.57748 C 204.27256,330.57748 241.70789,368.0186 241.70075,414.19989 L 241.70075,414.19989 z \" transform=\"matrix(0.974466,0,0,0.974466,-15.37667,-10.08382)\" style=\"opacity:1;fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:34.99968338;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path7410\"/>"
            "<path d=\"M 241.70075,414.19989 C 241.70789,460.38118 204.27256,497.8223 158.09128,497.8223 C 111.90999,497.8223 74.474661,460.38118 74.481804,414.19989 C 74.474661,368.0186 111.90999,330.57748 158.09128,330.57748 C 204.27256,330.57748 241.70789,368.0186 241.70075,414.19989 L 241.70075,414.19989 z \" transform=\"matrix(0.974466,0,0,0.974466,388.6178,-9.97323)\" style=\"opacity:1;fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:34.99968338;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path8297\"/>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_267()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
            "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"725\" height=\"725\">"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"350\" fill=\"#fff\" stroke=\"#000\" stroke-width=\"2.5\"/>"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"335.1375\" fill=\"#c1121c\"/>"
            "<rect x=\"55\" y=\"308\" width=\"614\" height=\"109\" fill=\"#fff\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_270_1()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
            "<!-- Generator: Adobe Illustrator 12.0.1, SVG Export Plug-In . SVG Version: 6.00 Build 51448)  -->"
            "<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\" ["
            "<!ENTITY ns_svg \"http://www.w3.org/2000/svg\">"
            "<!ENTITY ns_xlink \"http://www.w3.org/1999/xlink\">"
            "]>"
            "<svg version=\"1.1\" id=\"Ebene_1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"586.262\" height=\"586.262\" viewBox=\"0 0 586.262 586.262\" overflow=\"visible\" enable-background=\"new 0 0 586.262 586.262\" xml:space=\"preserve\">"
            "<path fill=\"#FFFFFF\" stroke=\"#000000\" d=\"M546.707,585.762c21.527,0,38.977-17.451,38.977-38.977l0.078-507.23  c0-21.527-17.451-38.977-38.977-38.977L39.554,0.5C18.027,0.5,0.578,17.951,0.578,39.477L0.5,546.708  c0,21.527,17.451,38.977,38.977,38.977L546.707,585.762z\"/>"
            "<g>"
            "<path fill=\"none\" stroke=\"#000000\" stroke-width=\"14\" d=\"M39.479,568.685c-12.121,0-21.979-9.858-21.979-21.977   c0,0.003,0.078-507.229,0.078-507.229c0-12.121,9.859-21.979,21.977-21.979l507.228,0.078c12.121,0,21.979,9.858,21.979,21.977   l-0.078,507.228c0,12.121-9.858,21.979-21.977,21.979h0.003L39.479,568.685z\"/>"
            "</g>"
            "<path fill=\"#CC0000\" d=\"M478.146,238.128c0,102.229-82.873,185.104-185.102,185.104c-102.229,0-185.103-82.875-185.103-185.104  c0-102.229,82.874-185.101,185.103-185.101C395.273,53.027,478.146,135.899,478.146,238.128z\"/>"
            "<path fill=\"#FFFFFF\" d=\"M429.432,238.128c0,75.324-61.062,136.388-136.388,136.388s-136.388-61.064-136.388-136.388  c0-75.325,61.063-136.387,136.388-136.387S429.432,162.804,429.432,238.128z\"/>"
            "<path d=\"M166.885,210.514h8.281v35.558c0,6.188,5.016,11.203,11.203,11.203c6.188,0,11.204-5.015,11.204-11.203v-35.558h8.28v35.558  c0,10.761-8.723,19.483-19.484,19.483c-10.76,0-19.484-8.723-19.484-19.483V210.514z M216.569,265.068v-38.967h7.793v4.397  c2.497-3.09,6.257-4.885,10.229-4.885c4.187,0,8.124,1.994,10.603,5.37l0,0c2.774-3.397,6.93-5.37,11.316-5.37  c8.071,0,14.613,6.543,14.613,14.613v24.842h-7.793V241.2c0-4.304-3.489-7.793-7.794-7.793c-4.304,0-7.793,3.489-7.793,7.793v23.868  h-7.794V241.2c0-4.304-3.488-7.793-7.793-7.793s-7.794,3.489-7.794,7.793v23.868H216.569z M291.096,265.068l-12.179-38.967h8.281  l7.306,27.277l8.77-27.277h5.845l8.767,27.277l7.308-27.277h8.28l-12.176,38.967h-6.819l-8.281-27.278l-8.28,27.278H291.096z   M371.469,248.506h-24.357v0.975c0,3.386,2.061,6.431,5.205,7.689l0,0c1.288,0.514,2.664,0.779,4.051,0.779  c3.18,0,6.201-1.389,8.273-3.803l5.914,5.076c-3.553,4.139-8.734,6.52-14.188,6.52c-2.378,0-4.736-0.454-6.945-1.337l0,0  c-6.101-2.441-10.104-8.352-10.104-14.925v-7.793c0-8.877,7.195-16.075,16.074-16.075c8.878,0,16.076,7.197,16.076,16.075V248.506z   M347.111,241.688h16.562c0-4.574-3.708-8.281-8.281-8.281C350.82,233.407,347.111,237.114,347.111,241.688z M395.822,265.068  h-4.871c-4.842,0-8.768-3.926-8.768-8.767v-45.788h7.793v44.813c0,1.344,1.09,2.436,2.436,2.436h3.41V265.068z M419.203,265.068  h-4.871c-4.844,0-8.768-3.926-8.768-8.767v-23.869h-3.897v-6.331h3.897V214.41h7.791v11.691h5.848v6.331h-5.848v22.895  c0,1.344,1.093,2.436,2.436,2.436h3.412V265.068z\"/>"
            "<path d=\"M157.254,533.569v-10.221l37.233-60.596h-35.773v-10.951h51.104v9.49l-37.233,60.596h37.233v11.682H157.254z M221.5,505.097  v-24.822c0-16.127,13.074-29.203,29.202-29.203s29.202,13.076,29.202,29.203v24.822c0,16.129-13.074,29.201-29.202,29.201  S221.5,521.226,221.5,505.097z M233.911,505.097c0,9.273,7.518,16.791,16.791,16.791s16.791-7.518,16.791-16.791v-24.822  c0-9.273-7.518-16.791-16.791-16.791s-16.791,7.518-16.791,16.791V505.097z M295.965,533.569v-81.768h11.682l37.232,58.404v-58.404  h12.412v81.768h-11.682l-37.232-58.404v58.404H295.965z M376.271,533.569v-81.768h52.564v11.682h-40.154v23.361h34.314v10.951  h-34.314v24.092h40.154v11.682H376.271z\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_274_56()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"600\" height=\"600\" id=\"svg1961\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_274-56.svg\">"
            "<metadata id=\"metadata12\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview10\" showgrid=\"false\" inkscape:zoom=\"0.39333333\" inkscape:cx=\"300\" inkscape:cy=\"300\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg1961\"/>"
            "<defs id=\"defs1963\"/>"
            "<g transform=\"translate(0.62188,-134.606)\" id=\"layer1\">"
            "<path d=\"M 591.95264,434.74696 C 593.09662,287.86662 481.45088,162.26431 335.97021,144.44513 C 168.29633,123.44973 18.636786,248.23779 7.3113803,416.57787 C -2.5874147,584.50073 131.06315,727.83475 299.63202,727.0676 C 460.35453,728.16448 592.98223,595.36181 591.95264,434.74696\" style=\"fill:#fffefe;fill-rule:evenodd;stroke:black;stroke-width:1.1739316;stroke-opacity:1\" id=\"path10\"/>"
            "<path d=\"M 591.69875,434.80787 L 591.29499,416.63878 M 591.29499,416.63878 L 586.85366,379.89681 M 586.85366,379.89681 L 577.56724,344.36613 M 577.56724,344.36613 L 564.24322,310.04673 M 564.24322,310.04673 L 546.47788,278.14986 M 546.47788,278.14986 L 524.67496,248.27178 M 524.67496,248.27178 L 499.64199,221.62377 M 499.64199,221.62377 L 471.37893,198.20582 M 471.37893,198.20582 L 440.28959,178.42168 M 440.28959,178.42168 L 407.18144,162.67514 M 407.18144,162.67514 L 372.05453,151.36992 M 372.05453,151.36992 L 335.71632,144.50604 M 335.71632,144.50604 L 299.37813,142.08349 M 299.37813,142.08349 L 262.63617,144.50604 M 262.63617,144.50604 L 226.70172,151.36992 M 226.70172,151.36992 L 191.5748,162.67514 M 191.5748,162.67514 L 158.46666,178.42168 M 158.46666,178.42168 L 127.37732,198.20582 M 127.37732,198.20582 L 99.114266,221.62377 M 99.114266,221.62377 L 74.081283,248.27178 M 74.081283,248.27178 L 52.278363,278.14986 M 52.278363,278.14986 L 34.513021,310.04673 M 34.513021,310.04673 L 21.189014,344.36613 M 21.189014,344.36613 L 11.902585,379.89681 M 11.902585,379.89681 L 7.0574922,416.63878 M 7.0574922,416.63878 L 7.0574922,452.97698 M 7.0574922,452.97698 L 11.902585,489.71893 M 11.902585,489.71893 L 21.189014,525.24962 M 21.189014,525.24962 L 34.513021,559.16528 M 34.513021,559.16528 L 52.278363,591.4659 M 52.278363,591.4659 L 74.081283,621.34397 M 74.081283,621.34397 L 99.114266,647.99199 M 99.114266,647.99199 L 127.37732,671.40994 M 127.37732,671.40994 L 158.46666,691.19406 M 158.46666,691.19406 L 191.5748,706.94062 M 191.5748,706.94062 L 226.70172,718.24584 M 226.70172,718.24584 L 262.63617,725.10972 M 262.63617,725.10972 L 299.37813,727.12851 M 299.37813,727.12851 L 335.71632,725.10972 M 335.71632,725.10972 L 372.05453,718.24584 M 372.05453,718.24584 L 407.18144,706.94062 M 407.18144,706.94062 L 440.28959,691.19406 M 440.28959,691.19406 L 471.37893,671.40994 M 471.37893,671.40994 L 499.64199,647.99199 M 499.64199,647.99199 L 524.67496,621.34397 M 524.67496,621.34397 L 546.47788,591.4659 M 546.47788,591.4659 L 564.24322,559.16528 M 564.24322,559.16528 L 577.56724,525.24962 M 577.56724,525.24962 L 586.85366,489.71893 M 586.85366,489.71893 L 591.29499,452.97698 M 591.29499,452.97698 L 591.69875,434.80787\" id=\"path14\"/>"
            "<path d=\"M 577.25603,434.71143 C 577.71363,294.64114 472.93175,176.59581 334.19386,158.94488 C 175.51705,138.81082 31.52356,257.36757 22.089087,417.34986 C 11.712512,577.4129 139.26632,712.78614 299.47069,712.49679 C 452.43432,712.94766 577.88186,587.78947 577.25603,434.71143\" style=\"fill:#c1121c;fill-opacity:1;fill-rule:evenodd;stroke:none\" id=\"path16\"/>"
            "<path d=\"M 504.08836,434.63645 C 504.39791,331.94066 426.91007,243.75996 324.81991,231.54629 C 208.09354,216.52649 102.0331,304.28326 95.081736,421.71621 C 87.645864,540.16528 181.13599,638.77639 299.38318,639.34165 C 412.96697,638.43992 503.57021,548.65766 504.08836,434.63645\" style=\"fill:#fffefe;fill-rule:evenodd;stroke:none\" id=\"path18\"/>"
            "<path d=\"M 220.0529,315.08708 L 258.4099,315.08708 L 207.13266,417.2378 C 234.1777,407.23133 261.46499,416.36971 276.579,441.05949 C 290.37405,466.4626 287.0767,517.89461 262.44747,537.55761 C 232.48192,564.81799 189.36059,561.7427 162.71931,531.50125 C 149.67792,514.55688 146.2931,498.25853 147.3765,477.3977 L 147.3765,474.16764 L 147.78027,467.70752 L 148.99154,461.65115 L 150.60657,455.59477 L 153.02912,449.53841 L 154.24039,446.71211 L 220.0529,315.08708 z M 181.29216,477.3977 C 175.18197,532.98843 246.97009,536.52802 249.52722,487.89541 C 256.32381,431.44334 183.75509,428.73144 181.29216,477.3977 z M 313.7247,487.89541 C 320.85776,423.46912 285.03099,330.98167 373.48087,313.47204 C 413.9643,308.64714 450.45728,340.1739 450.19484,381.30335 C 443.08197,446.58425 478.88857,537.5105 390.4387,555.72672 C 349.34288,560.34974 313.76509,529.51609 313.7247,487.89541 z M 347.64036,487.89541 L 347.64036,381.30335 L 348.04413,378.8808 L 348.44787,374.84323 L 349.2554,370.80565 L 350.87042,366.76807 L 352.88921,362.73049 C 359.85404,353.74688 366.09209,349.23152 377.51844,347.38769 C 398.29851,344.75654 415.9158,360.47617 415.87542,381.30335 L 415.87542,489.9142 L 415.47167,494.35553 L 414.26039,498.3931 L 412.64537,502.43069 L 410.62659,506.0645 C 405.52577,514.82605 395.89615,520.43156 385.99736,521.81106 C 376.06491,522.83391 365.66143,519.67114 358.54182,512.52462 C 349.9014,504.26779 348.87856,499.08623 347.64036,487.89541\" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"path20\"/>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_327()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"480\" height=\"480\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_327.svg\">"
            "<metadata id=\"metadata22\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"640\" inkscape:window-height=\"484\" id=\"namedview20\" showgrid=\"false\" inkscape:zoom=\"0.49166667\" inkscape:cx=\"240\" inkscape:cy=\"240\" inkscape:window-x=\"0\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs4\"/>"
            "<path d=\"M 30.856274,5.7720243 L 450.86109,5.7720243 C 461.67691,6.5627045 473.93298,17.615789 474.52755,30.636789 L 474.52755,449.4433 C 474.57722,459.76184 462.73404,473.63554 449.36321,474.30807 L 29.957547,474.30807 C 16.93511,474.30807 5.0927831,462.751 5.0927831,449.14373 L 5.691934,30.936364 C 5.691934,17.424109 14.494985,5.7720243 30.856274,5.7720243 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:2;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path3669\"/>"
            "<path d=\"M 393.71875,16.71875 L 393.71875,16.75 L 84.75,16.75 L 84.75,16.78125 L 35.1875,16.78125 C 23.426887,16.266334 16.714331,24.30046 17.15625,37.15625 L 17.15625,443.5625 C 17.202803,452.2297 20.884421,462.63293 32.84375,462.84375 L 84.15625,462.84375 L 393.71875,462.78125 L 393.71875,462.8125 L 447.28125,462.8125 C 459.24058,462.6017 462.95345,452.19845 463,443.53125 L 463,37.09375 C 463.44191,24.237959 456.72937,16.20383 444.96875,16.71875 L 393.71875,16.71875 z M 393.71875,83.21875 L 393.71875,396.125 L 86.4375,396.34375 L 86.4375,83.28125 L 393.71875,83.21875 z \" style=\"fill:#154889;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path3661\"/>"
            "<g id=\"g8184\">"
            "<path d=\"M 240.1875,155.15625 C 167.33571,155.15625 118.40625,219.03071 118.40625,256.3125 C 118.40625,256.3125 118.5,256.65625 118.5,256.65625 L 118.5,347.5625 L 359.34375,345.75 L 359.34375,256.65625 L 359.75,256.4375 C 359.75,219.53516 311.81302,156.59041 240.1875,155.3125 L 240.1875,155.15625 z \" style=\"opacity:1;color:black;fill:black;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:1;stroke-linecap:round;stroke-linejoin:miter;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible\" id=\"path3703\"/>"
            "<path d=\"M 381.915,346.95341 L 93.845366,347.54736 L 95.62724,241.82284 L 118.7916,196.08807 L 157.99283,156.29288 L 210.85509,133.72248 L 264.31132,133.72248 L 318.3615,156.29288 L 361.42345,196.97901 L 382.21198,243.01076 L 381.915,346.95341 z \" style=\"opacity:1;color:black;fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible\" id=\"path1882\"/>"
            "<path d=\"M 97.438084,244.21377 L 117.87656,256.01393\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path2780\"/>"
            "<path d=\"M 119.27765,196.38505 L 136.49732,209.94531\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3667\"/>"
            "<path d=\"M 158.75688,156.29288 L 170.51665,175.92598\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3670\"/>"
            "<path d=\"M 212.09583,133.92681 L 213.7758,156.29288\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3672\"/>"
            "<path d=\"M 96.178108,301.50351 L 116.33771,301.50351\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3674\"/>"
            "<path d=\"M 380.09252,244.84375 L 359.65404,256.64391\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3685\"/>"
            "<path d=\"M 358.25295,197.01503 L 341.03328,210.57529\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3687\"/>"
            "<path d=\"M 318.77372,156.92286 L 307.01395,176.55596\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3689\"/>"
            "<path d=\"M 265.43477,134.55679 L 263.7548,156.92286\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3691\"/>"
            "<path d=\"M 381.35249,302.13349 L 361.19289,302.13349\" style=\"fill:none;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3693\"/>"
            "</g>"
            "<path d=\"M 117.65052,255.56477 C 118.1501,255.56477 118.1501,255.56477 117.65052,255.56477 z \" style=\"opacity:1;fill:none;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:3;stroke-linecap:round;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3709\"/>"
            "</svg>";
      }

      // Mautpflichtige Strasse
      tCString tcl_SVG_Resources_GER::get_Zeichen_391()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:dc=\"http://purl.org/dc/elements/1.1/\" xmlns:cc=\"http://creativecommons.org/ns#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\" xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\" version=\"1.0\" width=\"725\" height=\"725\" id=\"svg2\" inkscape:version=\"0.48.1 r9760\" sodipodi:docname=\"Zeichen_391.svg\">"
            "<metadata id=\"metadata18\">"
            "<rdf:RDF>"
            "<cc:Work rdf:about=\"\">"
            "<dc:format>image/svg+xml</dc:format>"
            "<dc:type rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\"/>"
            "</cc:Work>"
            "</rdf:RDF>"
            "</metadata>"
            "<sodipodi:namedview pagecolor=\"#ffffff\" bordercolor=\"#666666\" borderopacity=\"1\" objecttolerance=\"10\" gridtolerance=\"10\" guidetolerance=\"10\" inkscape:pageopacity=\"0\" inkscape:pageshadow=\"2\" inkscape:window-width=\"1180\" inkscape:window-height=\"990\" id=\"namedview16\" showgrid=\"false\" inkscape:zoom=\"0.67544828\" inkscape:cx=\"470.02119\" inkscape:cy=\"299.52331\" inkscape:window-x=\"441\" inkscape:window-y=\"0\" inkscape:window-maximized=\"0\" inkscape:current-layer=\"svg2\"/>"
            "<defs id=\"defs9\"/>"
            "<circle cx=\"362.5\" cy=\"362.5\" r=\"350\" style=\"opacity:1;fill:white;fill-opacity:1;stroke:black;stroke-width:2.5px\" id=\"circle4\"/>"
            "<path d=\"M 113.09375,332.1875 C 72.544148,331.94572 71.31547,393.74982 112.75,393.03125 L 613.34375,393.03125 C 654.77828,393.74982 653.54962,331.94573 613,332.1875 L 113.09375,332.1875 z \" style=\"opacity:1;fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path2773\"/>"
            "<path d=\"M 152.2704,301.47899 L 152.2704,178.1108 L 169.96701,178.1108 L 205.36022,258.54991 L 239.99137,178.1108 L 257.68798,178.1108 L 257.68798,301.47899 L 238.9753,301.47899 L 238.9753,224.51146 L 238.63661,224.51146 L 212.81142,283.86706 L 197.23163,283.86706 L 171.40645,224.51146 L 170.98308,224.51146 L 170.98308,301.47899 L 152.2704,301.47899 z M 270.72758,301.39432 L 315.77349,177.94145 L 331.18393,177.94145 L 376.22983,301.39432 L 356.58575,301.39432 L 347.1024,273.53698 L 300.27837,273.53698 L 290.45633,301.39432 L 270.72758,301.39432 z M 305.7821,257.0258 L 341.514,257.0258 C 338.9173,249.4053 336.87105,243.43588 335.37523,239.11751 C 333.87928,234.79927 332.58096,230.97489 331.48028,227.64435 C 330.37947,224.31397 329.26462,220.92706 328.13571,217.48362 C 327.00668,214.04035 325.5108,209.38336 323.64805,203.51262 C 321.6723,209.60915 320.09175,214.47783 318.90638,218.11867 C 317.72091,221.75968 316.57783,225.27359 315.47713,228.66043 C 314.37634,232.04741 313.10625,235.82945 311.66686,240.00657 C 310.22738,244.18382 308.2658,249.85689 305.7821,257.0258 L 305.7821,257.0258 z M 389.52344,259.73533 L 389.52344,178.1108 L 408.23612,178.1108 L 408.23612,257.61851 C 408.23609,266.14227 410.64926,272.64795 415.47564,277.13558 C 420.30194,281.62325 426.27137,283.86708 433.38393,283.86706 C 440.49637,283.86708 446.4658,281.62325 451.29221,277.13558 C 456.11848,272.64795 458.53165,266.14227 458.53173,257.61851 L 458.53173,178.1108 L 477.24441,178.1108 L 477.24441,259.73533 C 477.24431,272.60561 472.98245,282.94979 464.45882,290.76789 C 455.93502,298.58601 445.57673,302.49506 433.38393,302.49506 C 421.13456,302.49506 410.76216,298.58601 402.26669,290.76789 C 393.77118,282.94979 389.52343,272.60561 389.52344,259.73533 L 389.52344,259.73533 z M 522.12099,301.47899 L 522.12099,194.70665 L 488.33656,194.70665 L 488.33656,178.1108 L 574.6181,178.1108 L 574.6181,194.70665 L 540.83367,194.70665 L 540.83367,301.47899 L 522.12099,301.47899 z \" style=\"font-size:173.40979004px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;opacity:1;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text2768\"/>"
            "<path d=\"M 186.64852,502.47345 L 261.41418,424.89482 C 264.99531,421.53185 268.23078,421.16588 273.54027,426.12571 L 398.3951,545.58504 L 320.35833,628.21351 C 317.92042,630.65142 313.00755,630.33591 310.46082,627.78918 L 189.41941,510.94067 C 186.55997,508.23925 184.08167,505.0403 186.64852,502.47345 z \" style=\"opacity:1;fill:none;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:6;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path3692\"/>"
            "<path d=\"M 236.51328,451.89764 L 367.59319,578.71799 L 382.74324,559.84362 L 253.9901,435.02295 L 236.51328,451.89764 z \" style=\"opacity:1;fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path4579\"/>"
            "<path d=\"M 456.22356 524.41565 A 49.664845 49.664845 0 1 1  356.89387,524.41565 A 49.664845 49.664845 0 1 1  456.22356 524.41565 z\" transform=\"matrix(1.037745,-0.469226,0.469226,1.037745,-265.6495,185.6036)\" style=\"opacity:1;fill:white;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:6;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path3680\"/>"
            "<path d=\"M 456.22356 524.41565 A 49.664845 49.664845 0 1 1  356.89387,524.41565 A 49.664845 49.664845 0 1 1  456.22356 524.41565 z\" transform=\"matrix(1.138897,0,0,1.138897,-6.034856,-109.0295)\" style=\"opacity:1;fill:white;fill-opacity:1;fill-rule:nonzero;stroke:black;stroke-width:6;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1\" id=\"path2778\"/>"
            "<text x=\"135.64926\" y=\"694.27173\" transform=\"matrix(0.911184,-0.412,0.412,0.911184,0,0)\" style=\"font-size:105.47325134px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;opacity:1;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text3682\" xml:space=\"preserve\"><tspan x=\"135.64926\" y=\"694.27173\" style=\"font-size:105.47325134px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;fill-opacity:1;font-family:Arial\" id=\"tspan3684\"></tspan></text>"
            "<text x=\"448.13858\" y=\"525.57068\" style=\"font-size:105.47323608px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;opacity:1;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text3669\" xml:space=\"preserve\"><tspan x=\"448.13858\" y=\"525.57068\" style=\"font-size:105.47323608px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;fill-opacity:1;font-family:Arial\" id=\"tspan3671\"></tspan></text>"
            "<path style=\"font-size:medium;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-indent:0;text-align:start;text-decoration:none;line-height:normal;letter-spacing:normal;word-spacing:normal;text-transform:none;direction:ltr;block-progression:tb;writing-mode:lr-tb;text-anchor:start;baseline-shift:baseline;color:#000000;fill:#c1121c;fill-opacity:1;stroke:none;stroke-width:25;marker:none;visibility:visible;display:inline;overflow:visible;enable-background:accumulate;font-family:Sans;-inkscape-font-specification:Sans\" d=\"M 362.5,16.06157 C 171.3369,16.06157 16.06157,171.3369 16.06157,362.5 16.06157,553.6631 171.3369,708.93842 362.5,708.93842 553.6631,708.93842 708.93842,553.6631 708.93842,362.5 708.93842,171.3369 553.6631,16.06157 362.5,16.06157 z m 0,28.631275 c 175.68961,0 317.80715,142.117545 317.80715,317.807155 0,175.68961 -142.11754,317.80715 -317.80715,317.80715 C 186.81039,680.30715 44.692845,538.18961 44.692845,362.5 44.692845,186.81039 186.81039,44.692845 362.5,44.692845 z\" id=\"circle3108\" inkscape:connector-curvature=\"0\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zeichen_610()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.0\" width=\"560\" height=\"760\" id=\"svg1961\">"
            "<defs id=\"defs1963\"/>"
            "<path d=\"M -383.15951,327.05217 L -385.24892,327.05217 M -385.24892,327.05217 L -389.84563,326.21641 M -389.84563,326.21641 L -394.44234,324.96276 M -394.44234,324.96276 L -399.03905,323.29123 M -399.03905,323.29123 L -403.21787,321.20182 M -403.21787,321.20182 L -406.97882,318.69452 M -406.97882,318.69452 L -410.73976,315.35146 M -410.73976,315.35146 L -413.66494,312.0084 M -413.66494,312.0084 L -416.17223,308.24745 M -416.17223,308.24745 L -418.67953,304.06863 M -418.67953,304.06863 L -420.35106,299.47192 M -420.35106,299.47192 L -421.18682,294.87521 M -421.18682,294.87521 L -422.02259,290.2785 M -422.02259,290.2785 L -422.02259,287.77121 L -422.02259,-219.12041 L -422.02259,-221.20982 M -422.02259,-221.20982 L -421.18682,-225.80653 M -421.18682,-225.80653 L -420.35106,-230.40324 M -420.35106,-230.40324 L -418.67953,-234.99995 M -418.67953,-234.99995 L -416.17223,-239.17877 M -416.17223,-239.17877 L -413.66494,-242.93972 M -413.66494,-242.93972 L -410.73976,-246.70066 M -410.73976,-246.70066 L -406.97882,-249.62584 M -406.97882,-249.62584 L -403.21787,-252.13313 M -403.21787,-252.13313 L -399.03905,-254.64043 M -399.03905,-254.64043 L -394.44234,-256.31196 M -394.44234,-256.31196 L -389.84563,-257.14772 L -385.24892,-257.98349 M -385.24892,-257.98349 L -383.15951,-257.98349 L 123.73211,-257.98349 L 126.2394,-257.98349 M 126.2394,-257.98349 L 130.83611,-257.14772 L 135.43282,-256.31196 M 135.43282,-256.31196 L 140.02953,-254.64043 M 140.02953,-254.64043 L 144.20835,-252.13313 M 144.20835,-252.13313 L 147.9693,-249.62584 M 147.9693,-249.62584 L 151.31236,-246.70066 M 151.31236,-246.70066 L 154.65542,-242.93972 M 154.65542,-242.93972 L 157.16272,-239.17877 M 157.16272,-239.17877 L 159.25213,-234.99995 M 159.25213,-234.99995 L 160.92366,-230.40324 M 160.92366,-230.40324 L 162.17731,-225.80653 M 162.17731,-225.80653 L 163.01307,-221.20982 M 163.01307,-221.20982 L 163.01307,-219.12041 L 163.01307,287.77121 L 163.01307,290.2785 M 163.01307,290.2785 L 162.17731,294.87521 M 162.17731,294.87521 L 160.92366,299.47192 M 160.92366,299.47192 L 159.25213,304.06863 M 159.25213,304.06863 L 157.16272,308.24745 M 157.16272,308.24745 L 154.65542,312.0084 M 154.65542,312.0084 L 151.31236,315.35146 L 147.9693,318.69452 M 147.9693,318.69452 L 144.20835,321.20182 M 144.20835,321.20182 L 140.02953,323.29123 M 140.02953,323.29123 L 135.43282,324.96276 M 135.43282,324.96276 L 130.83611,326.21641 M 130.83611,326.21641 L 126.2394,327.05217 M 126.2394,327.05217 L 123.73211,327.05217 M 123.73211,327.05217 L -383.15951,327.05217\" id=\"path48\"/>"
            "<path d=\"M 252.31334,1.5271521 L 308.81908,1.5271521 L 514.05591,747.04061 L 47.517773,747.04061 L 252.31334,1.5271521 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path22687\"/>"
            "<path d=\"M 252.70445,2.0036891 L 308.4518,2.0036891 L 349.62589,151.61893 L 211.516,151.73595 L 252.70445,2.0036891 z \" style=\"fill:#c00;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path23580\"/>"
            "<path d=\"M 6.0422638,752.03719 C 11.658709,752.03719 553.95774,752.03719 553.95774,752.03719\" style=\"fill:none;fill-opacity:0.75;fill-rule:evenodd;stroke:black;stroke-width:12.82950115;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path22689\"/>"
            "<path d=\"M 89.097962,597.64689 L 472.46888,597.72078 L 513.26909,745.62075 L 48.351913,745.66388 L 89.097962,597.64689 z \" style=\"fill:#c00;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path23576\"/>"
            "<path d=\"M 170.82974,299.73264 L 390.43481,299.73264 L 431.85705,450.23529 L 129.53014,450.23529 L 170.82974,299.73264 z \" style=\"fill:#c00;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path23578\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zusatzzeichen_1020_30()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.0\" width=\"490\" height=\"270\" id=\"svg2\">"
            "<defs id=\"defs4\"/>"
            "<path d=\"M 38.78125,4.984375 C 20.356889,4.9843748 9.96875,12.12016 9.96875,33.203125 L 9.65625,236.79688 C 9.65625,257.87984 20.044391,265.01563 38.46875,265.01563 L 451.21875,264.98438 C 469.64311,264.98438 480.03124,257.84859 480.03125,236.76563 L 480.34375,33.234375 C 480.34375,12.15141 469.95561,5.0156248 451.53125,5.015625 L 38.78125,4.984375 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:2;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path1881\"/>"
            "<path d=\"M 453.3125,17.796875 L 36.78125,17.828125 C 28.356999,17.828125 23.40625,23.829135 23.40625,32.703125 L 23.40625,237.35938 C 23.406249,246.23335 28.35701,252.23438 36.78125,252.23438 L 453.28125,252.20313 C 461.70549,252.20312 466.65625,246.20211 466.65625,237.32813 L 466.65625,32.671875 C 466.65625,23.797885 461.73674,17.796875 453.3125,17.796875 z \" style=\"fill:none;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:10.05090809;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path3976\"/>"
            "<path d=\"M 67.12418,120.39301 L 92.898369,49.75623 L 101.71586,49.75623 L 127.49004,120.39301 L 116.25017,120.39301 L 110.82403,104.45371 L 84.032436,104.45371 L 78.4125,120.39301 L 67.12418,120.39301 z M 87.181538,95.00641 L 107.62648,95.00641 C 106.14071,90.64614 104.96989,87.23058 104.11402,84.75971 C 103.25807,82.28892 102.51521,80.1007 101.88542,78.19505 C 101.25557,76.28948 100.61767,74.35157 99.971737,72.38132 C 99.325735,70.41116 98.469826,67.74654 97.404008,64.38744 C 96.273531,67.87573 95.369175,70.66147 94.690935,72.74468 C 94.01264,74.82797 93.358596,76.83855 92.728802,78.77642 C 92.098957,80.71437 91.372242,82.87836 90.548655,85.26841 C 89.725021,87.65853 88.602649,90.90453 87.181538,95.00641 L 87.181538,95.00641 z M 135.48392,120.44146 L 135.48392,70.15272 L 145.60949,70.15272 L 145.60949,75.53042 L 145.80329,75.53042 C 148.93622,71.55776 153.29651,69.5714 158.88417,69.57135 C 162.79225,69.5714 166.5631,71.05713 170.19671,74.02854 C 173.83025,77.00005 175.64704,81.32804 175.64708,87.01253 L 175.64708,120.44146 L 165.52151,120.44146 L 165.52151,90.50077 C 165.52147,87.10946 164.57674,84.46099 162.68732,82.55534 C 160.79782,80.64977 158.44811,79.69697 155.63817,79.69692 C 152.73129,79.69697 150.33313,80.64977 148.44369,82.55534 C 146.55421,84.46099 145.60948,87.10946 145.60949,90.50077 L 145.60949,120.44146 L 135.48392,120.44146 z M 188.77642,108.28108 L 188.77642,49.85313 L 198.90199,49.85313 L 198.90199,107.45747 C 198.90197,109.78297 200.16161,110.94572 202.68091,110.94571 L 206.1207,110.94571 L 206.1207,120.44146 L 201.66351,120.44146 C 197.98147,120.44146 194.91312,119.54518 192.45844,117.75261 C 190.00375,115.96005 188.77641,112.80288 188.77642,108.28108 L 188.77642,108.28108 z M 214.64751,120.44146 L 214.64751,70.15272 L 224.77308,70.15272 L 224.77308,120.44146 L 214.64751,120.44146 z M 214.64751,59.9787 L 214.64751,49.85313 L 224.77308,49.85313 L 224.77308,59.9787 L 214.64751,59.9787 z M 277.14507,99.12446 L 245.84784,99.12446 C 245.84782,103.25868 246.97019,106.35934 249.21495,108.42643 C 251.45968,110.49354 254.32617,111.52709 257.81442,111.52708 C 261.9809,111.52709 265.66292,109.91217 268.86051,106.68231 L 276.17611,112.93206 C 273.68909,115.83893 270.8872,117.91411 267.77043,119.1576 C 264.65359,120.40109 261.39953,121.02283 258.00821,121.02283 C 252.84044,121.02283 247.83418,119.35139 242.98942,116.00849 C 238.14464,112.66561 235.72226,105.82641 235.72226,95.49088 C 235.72226,85.70448 237.95893,78.93795 242.43227,75.19129 C 246.9056,71.44471 251.5808,69.5714 256.45789,69.57135 C 261.9809,69.5714 266.80952,71.48508 270.94376,75.31241 C 275.07792,79.13982 277.14502,84.29949 277.14507,90.79145 L 277.14507,99.12446 z M 245.84784,90.79145 L 267.06794,90.79145 C 266.90641,87.01256 265.84056,84.12185 263.87039,82.11931 C 261.90015,80.11685 259.42932,79.11559 256.45789,79.11555 C 253.45411,79.11559 250.95905,80.11685 248.97271,82.11931 C 246.98634,84.12185 245.94472,87.01256 245.84784,90.79145 L 245.84784,90.79145 z M 316.04859,120.39301 L 316.04859,115.20911 C 312.52803,119.08493 308.20003,121.02283 303.0646,121.02283 C 299.77014,121.02283 297.0167,120.36879 294.80427,119.0607 C 292.59181,117.75261 290.92036,116.37186 289.78993,114.91842 C 288.33649,113.04512 287.34331,111.05876 286.81039,108.95935 C 286.27746,106.85996 286.011,102.32203 286.011,95.34554 C 286.011,88.3691 286.27746,83.83117 286.81039,81.73173 C 287.34331,79.63237 288.33649,77.62986 289.78993,75.72421 C 290.92036,74.30312 292.59181,72.92237 294.80427,71.58193 C 297.0167,70.24159 299.77014,69.5714 303.0646,69.57135 C 307.97394,69.5714 312.30194,71.55776 316.04859,75.53042 L 316.04859,70.15272 L 326.17417,70.15272 L 326.17417,119.27872 C 326.17412,126.83655 323.96975,132.40804 319.56105,135.99318 C 315.15228,139.57829 310.08949,141.37086 304.37269,141.37088 C 301.14282,141.37086 297.97757,140.59569 294.87694,139.04539 C 291.77627,137.49504 289.11165,135.46024 286.88306,132.94097 L 294.73159,126.69122 C 295.95892,127.91855 297.42043,128.9844 299.11611,129.88877 C 300.81176,130.79311 302.62855,131.24529 304.56648,131.2453 C 307.9255,131.24529 310.67894,130.30864 312.82682,128.43534 C 314.97463,126.56202 316.04856,123.88125 316.04859,120.39301 L 316.04859,120.39301 z M 296.13658,95.34554 C 296.13656,99.38287 296.24153,102.06364 296.45149,103.38786 C 296.66141,104.71212 297.21856,105.93946 298.12293,107.06989 C 298.80118,107.97426 299.80244,108.84632 301.12669,109.68607 C 302.45091,110.52584 304.13043,110.94572 306.16526,110.94571 C 308.13544,110.94572 309.77458,110.52584 311.0827,109.68607 C 312.39076,108.84632 313.40008,107.97426 314.11068,107.06989 C 314.98271,105.93946 315.52371,104.71212 315.73368,103.38786 C 315.94359,102.06364 316.04856,99.38287 316.04859,95.34554 C 316.04856,91.30826 315.94359,88.62749 315.73368,87.30322 C 315.52371,85.97901 314.98271,84.73552 314.11068,83.57274 C 313.40008,82.70072 312.39076,81.83674 311.0827,80.98079 C 309.77458,80.12492 308.13544,79.69697 306.16526,79.69692 C 304.13043,79.69697 302.45091,80.12492 301.12669,80.98079 C 299.80244,81.83674 298.80118,82.70072 298.12293,83.57274 C 297.21856,84.73552 296.66141,85.97901 296.45149,87.30322 C 296.24153,88.62749 296.13656,91.30826 296.13658,95.34554 L 296.13658,95.34554 z M 378.30391,99.12446 L 347.00668,99.12446 C 347.00667,103.25868 348.12904,106.35934 350.3738,108.42643 C 352.61852,110.49354 355.48501,111.52709 358.97327,111.52708 C 363.13974,111.52709 366.82177,109.91217 370.01935,106.68231 L 377.33496,112.93206 C 374.84793,115.83893 372.04604,117.91411 368.92928,119.1576 C 365.81244,120.40109 362.55837,121.02283 359.16706,121.02283 C 353.99928,121.02283 348.99302,119.35139 344.14826,116.00849 C 339.30349,112.66561 336.8811,105.82641 336.88111,95.49088 C 336.8811,85.70448 339.11777,78.93795 343.59112,75.19129 C 348.06444,71.44471 352.73964,69.5714 357.61673,69.57135 C 363.13974,69.5714 367.96836,71.48508 372.1026,75.31241 C 376.23676,79.13982 378.30386,84.29949 378.30391,90.79145 L 378.30391,99.12446 z M 347.00668,90.79145 L 368.22678,90.79145 C 368.06526,87.01256 366.99941,84.12185 365.02923,82.11931 C 363.059,80.11685 360.58816,79.11559 357.61673,79.11555 C 354.61295,79.11559 352.1179,80.11685 350.13156,82.11931 C 348.14519,84.12185 347.10356,87.01256 347.00668,90.79145 L 347.00668,90.79145 z M 388.96241,120.44146 L 388.96241,70.15272 L 399.08799,70.15272 L 399.08799,75.53042 L 399.28178,75.53042 C 402.41471,71.55776 406.775,69.5714 412.36266,69.57135 C 416.04466,69.5714 419.54904,70.86334 422.87582,73.44717 L 415.56021,82.16776 C 413.36389,80.52058 411.13529,79.69697 408.87443,79.69692 C 406.38742,79.69697 404.1346,80.52865 402.11597,82.19198 C 400.0973,83.85539 399.08797,86.52809 399.08799,90.21008 L 399.08799,120.44146 L 388.96241,120.44146 z M 182.42976,219.6624 L 182.42976,177.1253 L 177.34275,177.1253 L 177.34275,169.37366 L 182.42976,169.37366 L 182.42976,162.73632 C 182.42976,158.05311 183.72169,154.60525 186.30558,152.39273 C 188.88945,150.18036 192.15159,149.07414 196.09202,149.07407 L 202.63247,149.07407 L 202.63247,158.56982 L 196.91563,158.56982 C 193.97645,158.56988 192.50687,159.95871 192.50689,162.73632 L 192.50689,169.37366 L 202.63247,169.37366 L 202.63247,177.1253 L 192.50689,177.1253 L 192.50689,219.6624 L 182.42976,219.6624 z M 208.3493,219.6624 L 208.3493,169.37366 L 218.47487,169.37366 L 218.47487,174.75136 L 218.66866,174.75136 C 221.80159,170.7787 226.16188,168.79234 231.74955,168.79229 C 235.43154,168.79234 238.93592,170.08428 242.2627,172.66811 L 234.9471,181.3887 C 232.75077,179.74152 230.52218,178.9179 228.26131,178.91786 C 225.7743,178.9179 223.52149,179.74959 221.50285,181.41292 C 219.48418,183.07633 218.47485,185.74903 218.47487,189.43102 L 218.47487,219.6624 L 208.3493,219.6624 z M 285.86565,198.3454 L 254.56842,198.3454 C 254.56841,202.47962 255.69078,205.58028 257.93554,207.64736 C 260.18027,209.71448 263.04675,210.74803 266.53501,210.74802 C 270.70149,210.74803 274.38351,209.13311 277.58109,205.90325 L 284.8967,212.153 C 282.40967,215.05987 279.60778,217.13505 276.49102,218.37854 C 273.37418,219.62203 270.12011,220.24377 266.7288,220.24377 C 261.56102,220.24377 256.55476,218.57233 251.71001,215.22943 C 246.86523,211.88655 244.44285,205.04735 244.44285,194.71182 C 244.44285,184.92542 246.67951,178.15889 251.15286,174.41223 C 255.62618,170.66565 260.30139,168.79234 265.17848,168.79229 C 270.70149,168.79234 275.5301,170.70602 279.66435,174.53335 C 283.79851,178.36076 285.86561,183.52043 285.86565,190.01239 L 285.86565,198.3454 z M 254.56842,190.01239 L 275.78853,190.01239 C 275.627,186.2335 274.56115,183.34279 272.59098,181.34025 C 270.62074,179.33778 268.14991,178.33653 265.17848,178.33649 C 262.1747,178.33653 259.67964,179.33778 257.6933,181.34025 C 255.70693,183.34279 254.66531,186.2335 254.56842,190.01239 L 254.56842,190.01239 z M 296.81484,219.6624 L 296.81484,169.37366 L 306.94041,169.37366 L 306.94041,219.6624 L 296.81484,219.6624 z M 296.81484,159.19964 L 296.81484,149.07407 L 306.94041,149.07407 L 306.94041,159.19964 L 296.81484,159.19964 z \" style=\"font-size:99.22093964px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text3933\"/>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zusatzzeichen_1048_12()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.0\" width=\"490\" height=\"270\" id=\"svg2\">"
            "<defs id=\"defs4\"/>"
            "<path d=\"M 38.78125,4.984375 C 20.356889,4.9843748 9.96875,12.12016 9.96875,33.203125 L 9.65625,236.79688 C 9.65625,257.87984 20.044391,265.01563 38.46875,265.01563 L 451.21875,264.98438 C 469.64311,264.98438 480.03124,257.84859 480.03125,236.76563 L 480.34375,33.234375 C 480.34375,12.15141 469.95561,5.0156248 451.53125,5.015625 L 38.78125,4.984375 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:2;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path1881\"/>"
            "<path d=\"M 453.3125,17.796875 L 36.78125,17.828125 C 28.356999,17.828125 23.40625,23.829135 23.40625,32.703125 L 23.40625,237.35938 C 23.406249,246.23335 28.35701,252.23438 36.78125,252.23438 L 453.28125,252.20313 C 461.70549,252.20312 466.65625,246.20211 466.65625,237.32813 L 466.65625,32.671875 C 466.65625,23.797885 461.73674,17.796875 453.3125,17.796875 z \" style=\"fill:none;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:10.05090809;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path3976\"/>"
            "<path d=\"M 37.10863,487.51009 L 37.10863,541.80186 L 50.66977,541.80186 L 50.66977,488.38108 L 37.10863,487.51009 z \" style=\"color:black;fill:white;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;stroke-linecap:round;stroke-linejoin:miter;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible\" id=\"path5404\"/>"
            "<path d=\"M 91.06256,486.09351 L 91.06256,540.38528 L 104.6237,540.38528 L 104.6237,486.9645 L 91.06256,486.09351 z \" style=\"color:black;fill:white;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:1;stroke-linecap:round;stroke-linejoin:miter;marker:none;marker-start:none;marker-mid:none;marker-end:none;stroke-miterlimit:4;stroke-dasharray:none;stroke-dashoffset:0;stroke-opacity:1;visibility:visible;display:inline;overflow:visible\" id=\"path5425\"/>"
            "<g transform=\"matrix(0.342814,0,0,0.342814,73.43973,49.09789)\" id=\"g5452\">"
            "<path d=\"M 295.78419,86.816926 L 295.78419,335.08252 L 687.71625,335.4031 C 664.71649,354.19396 650.35734,380.09418 650.54503,414.08813 L 261.47933,413.85667 C 257.75238,281.97351 70.642616,282.42223 66.576854,413.09434 C 38.473995,412.88466 34.575813,406.50199 34.30487,380.61469 L 34.304868,281.61469 C 33.952015,237.37253 28.42681,266.57731 61.177014,182.67997 C 94.875059,93.246445 85.585107,101.51291 116.0648,99.204795 L 295.78419,86.816926 z M 217.93865,233.19966 L 219.48981,127.72046 L 119.43969,133.92512 C 101.20003,135.14704 101.04823,135.26154 94.62105,156.41701 L 69.026832,224.66825 C 60.428592,245.6025 61.79713,251.77115 85.314062,248.71131 L 217.93865,233.19966 z M 966.63494,335.59074 L 966.82552,391.36792 L 902.21802,414.23783 L 845.4914,414.20156 C 845.7223,381.85903 832.28136,354.65711 808.44981,335.54893 L 966.63494,335.59074 z \" style=\"fill:black;fill-rule:evenodd;stroke:none\" id=\"path5439\"/>"
            "<rect width=\"631.32404\" height=\"301.70154\" x=\"335.82718\" y=\"12.158683\" style=\"fill:black;stroke:none\" id=\"rect5441\"/>"
            "<circle cx=\"164\" cy=\"412\" r=\"77\" style=\"fill:black;stroke:none\" id=\"circle5443\"/>"
            "<circle cx=\"748\" cy=\"412\" r=\"77\" style=\"fill:black;stroke:none\" id=\"circle5445\"/>"
            "</g>"
            "</svg>";
      }

      tCString tcl_SVG_Resources_GER::get_Zusatzzeichen_1052_36()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->"
            "<svg xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.0\" width=\"490\" height=\"490\" id=\"svg2\">"
            "<defs id=\"defs4\"/>"
            "<path d=\"M 38.781255,9.665355 C 20.356895,9.665345 9.968755,19.290965 9.968755,47.730255 L 9.656255,442.26975 C 9.656255,470.70902 20.044395,480.33465 38.468755,480.33465 L 451.21875,480.29249 C 469.6431,480.29249 480.03124,470.66687 480.03125,442.2276 L 480.34375,47.772405 C 480.34375,19.333125 469.9556,9.707495 451.53125,9.707515 L 38.781255,9.665355 z \" style=\"fill:white;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:3;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path1881\"/>"
            "<path d=\"M 453.23342,24.769243 L 36.797822,24.812153 C 28.375507,24.812153 23.425893,33.050693 23.425893,45.233473 L 23.425893,444.80943 C 23.425893,456.99217 28.375517,465.23076 36.797822,465.23076 L 453.20218,465.18785 C 461.62449,465.18784 466.57411,456.94929 466.57411,444.76653 L 466.57411,45.190573 C 466.57411,33.007793 461.65573,24.769243 453.23342,24.769243 z \" style=\"fill:none;fill-opacity:1;fill-rule:evenodd;stroke:black;stroke-width:12;stroke-linecap:butt;stroke-linejoin:miter;stroke-miterlimit:4;stroke-dasharray:none;stroke-opacity:1\" id=\"path3976\"/>"
            "<g transform=\"translate(-82.2419,-339.9924)\" id=\"g1905\">"
            "<path d=\"M 202.8033,651.98188 C 202.1743,605.61348 199.65815,645.51187 227.60501,576.76802 C 247.82379,530.04018 227.33543,542.62074 331.93391,540.91338 C 425.03014,542.80047 406.24915,529.32129 427.63612,578.92469 C 454.41477,642.45659 452.34797,609.20792 452.16825,650.63396 C 451.17977,696.10375 467.98383,684.42178 327.0814,685.94942 C 187.25731,684.06234 203.79175,695.92402 202.8033,651.98188 z M 231.10959,607.23098 L 250.25004,563.01925 C 253.82119,555.16582 252.68184,556.32514 261.03339,556.27966 L 394.85342,556.26524 C 402.09778,556.29186 401.03498,555.82147 404.01925,562.73525 L 423.0532,606.69181 L 231.10959,607.23098 z M 217.42074,691.02159 L 253.21546,690.94171 C 253.10563,735.88232 256.82988,733.37619 237.31002,733.66574 C 214.06591,733.57588 217.74025,735.92226 217.42074,691.02159 z M 401.75609,691.3411 L 437.61072,691.3411 C 437.37109,736.35159 440.64603,733.27634 420.35736,733.39616 C 399.37975,733.11659 402.04563,736.43147 401.75609,691.3411 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none\" id=\"Car\"/>"
            "<path d=\"M 190.30768,729.18441 C 181.02903,729.20372 174.18448,731.74585 167.45411,734.71566 L 167.14735,750.02816 C 180.39679,745.51715 193.72552,741.07975 215.46195,750.02816 C 228.48004,753.77242 241.35742,757.83586 259.40523,750.02816 C 275.17283,743.76846 291.42359,740.36591 309.98218,750.02816 C 322.3961,754.44907 335.2037,757.84334 352.46835,750.02816 C 360.27048,747.15739 368.09496,745.26554 375.89709,744.87191 C 382.75832,744.84573 390.4969,746.20406 399.78598,750.02816 C 412.80408,753.77242 425.68143,757.83586 443.72925,750.02816 C 457.66069,744.49741 471.99924,741.19712 487.95059,747.168 C 487.95059,747.168 488.76412,732.93914 488.76412,732.93914 C 473.4098,727.43504 459.0164,729.05589 445.18636,734.71566 C 430.13888,739.92898 415.86454,739.59517 402.20171,734.84066 L 402.20171,734.71566 C 401.0585,734.36455 399.95131,734.04771 398.82735,733.71566 C 375.13299,725.8483 363.30339,729.64699 351.81648,734.71566 L 351.81648,734.93441 C 336.99331,738.80693 321.8779,740.1195 308.83183,734.71566 C 291.80446,727.16206 275.97612,728.51484 260.82399,734.71566 C 245.63751,739.97714 231.23349,739.59657 217.45589,734.71566 C 206.19816,730.67782 197.52441,729.16939 190.30768,729.18441 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5597\"/>"
            "<path d=\"M 188.9727,753.30988 C 179.65692,753.32919 172.78498,755.87132 166.02767,758.84113 L 165.71968,774.15363 C 179.02214,769.64262 192.40422,765.20522 214.22763,774.15363 C 227.29782,777.89789 240.22674,781.96133 258.34677,774.15363 C 274.17747,767.89393 290.49327,764.49138 309.12613,774.15363 C 321.58973,778.57454 334.44858,781.96881 351.78233,774.15363 C 359.61568,771.28286 367.47148,769.39101 375.30483,768.99738 C 382.19352,768.9712 389.96307,770.32953 399.28932,774.15363 C 412.35951,777.89789 425.2884,781.96133 443.40846,774.15363 C 457.33588,768.64652 471.66854,765.35084 487.60152,771.21743 C 487.60152,771.21743 488.26199,756.93676 488.26199,756.93676 C 472.98175,751.58611 458.64816,753.22563 444.87139,758.84113 C 429.7637,764.05445 415.43222,763.72064 401.71472,758.96613 L 401.71472,758.84113 C 400.56694,758.49002 399.45531,758.17318 398.32686,757.84113 C 374.53767,749.97377 362.66073,753.77246 351.12785,758.84113 L 351.12785,759.05988 C 336.24535,762.9324 321.06946,764.24497 307.97117,758.84113 C 290.87565,751.28753 274.98398,752.64031 259.77121,758.84113 C 244.52396,764.10261 230.06229,763.72204 216.22955,758.84113 C 204.92677,754.80329 196.2183,753.29486 188.9727,753.30988 z \" style=\"fill:black;fill-opacity:1;fill-rule:evenodd;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" id=\"path5633\"/>"
            "<path d=\"M 289.74471,438.80382 L 289.74471,391.15741 L 296.57937,391.15741 L 296.57937,408.48932 C 297.84383,407.29029 299.17914,406.32014 300.58533,405.57887 C 301.99149,404.83766 303.57752,404.46704 305.34343,404.46701 C 307.41452,404.46704 309.20221,404.88672 310.70652,405.72603 C 312.21077,406.5654 313.45343,407.61731 314.43451,408.88174 C 315.37193,410.10264 316.00961,411.52516 316.34756,413.14932 C 316.68545,414.77353 316.85441,417.65673 316.85444,421.79892 C 316.85441,425.98476 316.68545,428.90066 316.34756,430.54663 C 316.00961,432.19263 315.37193,433.61515 314.43451,434.81421 C 313.45343,436.10048 312.21077,437.15238 310.70652,437.96993 C 309.20221,438.78747 307.41452,439.19624 305.34343,439.19624 C 301.85523,439.19624 298.93388,437.88817 296.57937,435.27203 L 296.57937,438.80382 L 289.74471,438.80382 z M 303.28323,411.30167 C 300.07844,411.3017 298.15994,412.44626 297.52772,414.73535 C 296.89548,417.02449 296.57936,419.37902 296.57937,421.79892 C 296.57936,424.28427 296.89548,426.67149 297.52772,428.9606 C 298.15994,431.24973 300.07844,432.39429 303.28323,432.39428 C 306.48797,432.39429 308.41192,431.29333 309.05508,429.09141 C 309.69819,426.8895 310.01976,424.45868 310.01978,421.79892 C 310.01976,419.20461 309.69819,416.80648 309.05508,414.60454 C 308.41192,412.40265 306.48797,411.3017 303.28323,411.30167 L 303.28323,411.30167 z M 350.83153,424.41506 L 329.70622,424.41506 C 329.70621,427.20562 330.4638,429.29853 331.97899,430.69379 C 333.49415,432.08907 335.429,432.78671 337.78354,432.7867 C 340.59587,432.78671 343.0812,431.69665 345.23953,429.51653 L 350.17749,433.73505 C 348.49878,435.69716 346.60753,437.09788 344.50375,437.93722 C 342.39991,438.77657 340.20345,439.19624 337.91435,439.19624 C 334.42615,439.19624 331.04698,438.06803 327.77681,435.81161 C 324.50664,433.5552 322.87155,428.93881 322.87156,421.96243 C 322.87155,415.35671 324.38128,410.78937 327.40074,408.26041 C 330.42019,405.73151 333.57591,404.46704 336.86789,404.46701 C 340.59587,404.46704 343.85514,405.75876 346.64571,408.34216 C 349.43623,410.92563 350.8315,414.40836 350.83153,418.79037 L 350.83153,424.41506 z M 329.70622,418.79037 L 344.02957,418.79037 C 343.92054,416.23965 343.2011,414.28845 341.87126,412.93676 C 340.54137,411.58511 338.87358,410.90928 336.86789,410.90925 C 334.84037,410.90928 333.15623,411.58511 331.81548,412.93676 C 330.4747,414.28845 329.77161,416.23965 329.70622,418.79037 L 329.70622,418.79037 z M 358.22212,438.80382 L 358.22212,404.85943 L 365.05678,404.85943 L 365.05678,438.80382 L 358.22212,438.80382 z M 358.22212,397.99207 L 358.22212,391.15741 L 365.05678,391.15741 L 365.05678,397.99207 L 358.22212,397.99207 z \" style=\"font-size:66.97312927px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text1944\"/>"
            "<path d=\"M 210.59909,518.40083 L 210.59909,452.66888 L 220.02803,452.66888 L 249.75854,499.40759 L 249.939,499.40759 L 249.939,452.66888 L 259.95444,452.66888 L 259.95444,518.40083 L 250.52549,518.40083 L 220.79498,471.66212 L 220.56941,471.66212 L 220.56941,518.40083 L 210.59909,518.40083 z M 297.53488,518.40083 L 297.53488,514.25029 L 297.30931,514.25029 C 295.41447,517.37823 291.5647,518.9422 285.75998,518.9422 C 280.52667,518.9422 276.46636,517.58125 273.57904,514.85933 C 270.6917,512.13743 269.24804,508.73128 269.24804,504.64088 C 269.24804,500.9415 270.52628,497.70829 273.08278,494.94125 C 275.63926,492.17424 279.44392,490.79073 284.49677,490.7907 L 297.53488,490.7907 L 297.53488,485.91833 C 297.53485,481.91821 294.33172,479.91813 287.92548,479.91809 C 283.47416,479.91813 280.51163,481.10614 279.0379,483.48214 L 271.63911,477.88793 C 274.91743,473.31637 280.18079,471.03057 287.42922,471.03052 C 293.20386,471.03057 297.89577,472.15843 301.50497,474.41411 C 305.11409,476.66988 306.91868,480.68508 306.91872,486.4597 L 306.91872,518.40083 L 297.53488,518.40083 z M 297.53488,501.97912 L 297.53488,498.55041 L 286.25624,498.55041 C 280.8124,498.55043 278.09049,500.4302 278.0905,504.18973 C 278.09049,505.7838 278.77472,507.16731 280.14321,508.34028 C 281.51167,509.51326 283.78996,510.09975 286.97807,510.09974 C 290.88798,510.09975 293.62493,509.66365 295.18892,508.79142 C 296.75287,507.91922 297.53485,505.64845 297.53488,501.97912 L 297.53488,501.97912 z M 293.06854,464.30845 L 293.06854,454.33812 L 303.03886,454.33812 L 303.03886,464.30845 L 293.06854,464.30845 z M 276.82729,464.30845 L 276.82729,454.33812 L 286.79761,454.33812 L 286.79761,464.30845 L 276.82729,464.30845 z M 313.95659,510.59601 L 320.54332,504.09951 C 324.6337,508.09968 329.55118,510.09975 335.29579,510.09974 C 337.97256,510.09975 340.18317,509.59597 341.92763,508.58841 C 343.67203,507.58086 344.54424,506.08456 344.54428,504.09951 C 344.54424,501.36257 342.6344,499.82868 338.81472,499.49782 L 330.51364,498.73087 C 326.63377,498.43013 323.4156,497.15188 320.85912,494.89613 C 318.30262,492.64043 317.02438,489.49745 317.02438,485.46718 C 317.02438,480.71515 318.69362,477.12103 322.0321,474.6848 C 325.37057,472.24866 329.5211,471.03057 334.48372,471.03052 C 338.57409,471.03057 342.07798,471.60954 344.99542,472.76743 C 347.9128,473.92541 350.52944,475.46683 352.84536,477.39167 L 347.02558,484.24909 C 345.16081,482.98592 343.23592,481.94828 341.25091,481.13618 C 339.26584,480.32416 337.01012,479.91813 334.48372,479.91809 C 331.47607,479.91813 329.38576,480.45198 328.2128,481.51966 C 327.0398,482.58741 326.45332,483.93332 326.45333,485.55741 C 326.45332,486.58004 326.88942,487.52745 327.76165,488.39963 C 328.63385,489.27188 330.25797,489.79821 332.63403,489.97864 L 340.39373,490.52002 C 345.236,490.85088 348.70982,492.34718 350.8152,495.00892 C 352.92051,497.6707 353.97318,500.85127 353.97322,504.55065 C 353.97318,509.15235 352.09341,512.70136 348.3339,515.19769 C 344.57432,517.69403 339.98768,518.9422 334.57395,518.9422 C 326.78416,518.9422 319.91171,516.16014 313.95659,510.59601 L 313.95659,510.59601 z M 358.34934,510.59601 L 364.93607,504.09951 C 369.02644,508.09968 373.94393,510.09975 379.68853,510.09974 C 382.36531,510.09975 384.57592,509.59597 386.32038,508.58841 C 388.06478,507.58086 388.93699,506.08456 388.93702,504.09951 C 388.93699,501.36257 387.02714,499.82868 383.20747,499.49782 L 374.90639,498.73087 C 371.02652,498.43013 367.80835,497.15188 365.25187,494.89613 C 362.69537,492.64043 361.41712,489.49745 361.41713,485.46718 C 361.41712,480.71515 363.08636,477.12103 366.42485,474.6848 C 369.76331,472.24866 373.91385,471.03057 378.87647,471.03052 C 382.96683,471.03057 386.47073,471.60954 389.38817,472.76743 C 392.30554,473.92541 394.92219,475.46683 397.2381,477.39167 L 391.41832,484.24909 C 389.55356,482.98592 387.62867,481.94828 385.64366,481.13618 C 383.65859,480.32416 381.40286,479.91813 378.87647,479.91809 C 375.86881,479.91813 373.77851,480.45198 372.60554,481.51966 C 371.43255,482.58741 370.84606,483.93332 370.84608,485.55741 C 370.84606,486.58004 371.28217,487.52745 372.1544,488.39963 C 373.0266,489.27188 374.65072,489.79821 377.02677,489.97864 L 384.78648,490.52002 C 389.62875,490.85088 393.10257,492.34718 395.20795,495.00892 C 397.31326,497.6707 398.36593,500.85127 398.36597,504.55065 C 398.36593,509.15235 396.48616,512.70136 392.72665,515.19769 C 388.96707,517.69403 384.38042,518.9422 378.9667,518.9422 C 371.1769,518.9422 364.30445,516.16014 358.34934,510.59601 L 358.34934,510.59601 z M 444.20238,498.55041 L 415.05836,498.55041 C 415.05835,502.40021 416.1035,505.28754 418.19383,507.21241 C 420.28412,509.13731 422.95339,510.09975 426.20166,510.09974 C 430.08149,510.09975 433.51019,508.59594 436.48779,505.58829 L 443.30009,511.40807 C 440.98417,514.11495 438.37505,516.04735 435.47271,517.20529 C 432.57031,518.36323 429.54012,518.9422 426.38212,518.9422 C 421.56988,518.9422 416.90805,517.38575 412.3966,514.27284 C 407.88514,511.15994 405.62941,504.79128 405.62942,495.16682 C 405.62941,486.05371 407.7122,479.75271 411.87778,476.26381 C 416.04335,472.77499 420.3969,471.03057 424.93846,471.03052 C 430.08149,471.03057 434.57791,472.81259 438.42772,476.3766 C 442.27745,479.94069 444.20234,484.74538 444.20238,490.7907 L 444.20238,498.55041 z M 415.05836,490.7907 L 434.81855,490.7907 C 434.66813,487.2718 433.67561,484.57996 431.84099,482.71519 C 430.0063,480.8505 427.70546,479.91813 424.93846,479.91809 C 422.14133,479.91813 419.81793,480.8505 417.96825,482.71519 C 416.11854,484.57996 415.14858,487.2718 415.05836,490.7907 L 415.05836,490.7907 z \" style=\"font-size:92.39466095px;font-style:normal;font-variant:normal;font-weight:normal;font-stretch:normal;text-align:center;line-height:100%;writing-mode:lr-tb;text-anchor:middle;fill:black;fill-opacity:1;stroke:none;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1;font-family:DIN 1451 Mittelschrift\" id=\"text1948\"/>"
            "</g>"
            "</svg>";
      }

      // source: https://commons.wikimedia.org/wiki/File:Norwegian-road-sign-556.0.svg
      tCString tcl_SVG_Resources_NORWAY::get_road_sign_556_0()
      {
         return
            "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n"
            "<!-- Created with Inkscape (http://www.inkscape.org/) -->\n"
            "<svg\n"
            "xmlns:svg=\"http://www.w3.org/2000/svg\"\n"
            "xmlns=\"http://www.w3.org/2000/svg\"\n"
            "version=\"1.0\"\n"
            "width=\"744.21252\"\n"
            "height=\"744.21252\"\n"
            "id=\"svg2\"\n"
            "xml:space=\"preserve\"><defs\n"
            "id=\"defs5\"><clipPath\n"
            "id=\"clipPath19\"><path\n"
            "d=\"M 0.496094,0.496094 L 5953.25,0.496094 L 5953.25,5953.25 L 0.496094,5953.25 L 0.496094,0.496094 z\"\n"
            "id=\"path21\" /></clipPath></defs><g\n"
            "transform=\"matrix(1.25,0,0,-1.25,0,744.2125)\"\n"
            "id=\"g11\"><g\n"
            "transform=\"scale(0.1,0.1)\"\n"
            "id=\"g13\"><g\n"
            "id=\"g15\"><g\n"
            "clip-path=\"url(#clipPath19)\"\n"
            "id=\"g17\"><path\n"
            "d=\"M 4.03516,4.02734 L 5949.7152,4.02734 L 5949.7152,5949.7073 L 4.03516,5949.7073 L 4.03516,4.02734 z\"\n"
            "id=\"path23\"\n"
            "style=\"fill:#0046ac;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 4.03516,4.02734 L 5949.7152,4.02734 L 5949.7152,5949.7073 L 4.03516,5949.7073 L 4.03516,4.02734 z\"\n"
            "id=\"path25\"\n"
            "style=\"fill:none;stroke:#0046ac;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 5949.71,289.418 L 5949.71,5664.3 C 5949.71,5740.01 5919.64,5812.6 5866.12,5866.12 C 5812.6,5919.64 5740.01,5949.71 5664.32,5949.71 L 289.438,5949.71 C 213.738,5949.71 141.145,5919.64 87.6367,5866.12 C 34.1172,5812.6 4.04688,5740.01 4.04688,5664.3 L 4.04688,289.418 C 4.04688,213.727 34.1172,141.137 87.6367,87.6172 C 141.156,34.0977 213.746,4.02734 289.438,4.02734 L 5664.32,4.02734 C 5740.01,4.02734 5812.6,34.0977 5866.12,87.6172 C 5919.64,141.137 5949.71,213.727 5949.71,289.418\"\n"
            "id=\"path27\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 5949.71,289.418 L 5949.71,5664.3 C 5949.71,5740.01 5919.64,5812.6 5866.12,5866.12 C 5812.6,5919.64 5740.01,5949.71 5664.32,5949.71 L 289.438,5949.71 C 213.738,5949.71 141.145,5919.64 87.6367,5866.12 C 34.1172,5812.6 4.04688,5740.01 4.04688,5664.3 L 4.04688,289.418 C 4.04688,213.727 34.1172,141.137 87.6367,87.6172 C 141.156,34.0977 213.746,4.02734 289.438,4.02734 L 5664.32,4.02734 C 5740.01,4.02734 5812.6,34.0977 5866.12,87.6172 C 5919.64,141.137 5949.71,213.727 5949.71,289.418 z\"\n"
            "id=\"path29\"\n"
            "style=\"fill:none;stroke:#0046ac;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 5807.02,289.418 L 5807.02,5664.3 C 5807.02,5702.16 5791.98,5738.46 5765.23,5765.21 C 5738.46,5791.98 5702.17,5807.01 5664.32,5807.01 L 289.438,5807.01 C 251.586,5807.01 215.297,5791.98 188.527,5765.21 C 161.766,5738.46 146.727,5702.16 146.727,5664.3 L 146.727,289.418 C 146.727,251.574 161.766,215.277 188.527,188.516 C 215.297,161.766 251.586,146.727 289.438,146.727 L 5664.32,146.727 C 5702.17,146.727 5738.46,161.766 5765.23,188.516 C 5791.98,215.277 5807.02,251.574 5807.02,289.418\"\n"
            "id=\"path31\"\n"
            "style=\"fill:#0046ac;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 5807.02,289.418 L 5807.02,5664.3 C 5807.02,5702.16 5791.98,5738.46 5765.23,5765.21 C 5738.46,5791.98 5702.17,5807.01 5664.32,5807.01 L 289.438,5807.01 C 251.586,5807.01 215.297,5791.98 188.527,5765.21 C 161.766,5738.46 146.727,5702.16 146.727,5664.3 L 146.727,289.418 C 146.727,251.574 161.766,215.277 188.527,188.516 C 215.297,161.766 251.586,146.727 289.438,146.727 L 5664.32,146.727 C 5702.17,146.727 5738.46,161.766 5765.23,188.516 C 5791.98,215.277 5807.02,251.574 5807.02,289.418 z\"\n"
            "id=\"path33\"\n"
            "style=\"fill:none;stroke:#0046ac;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 1259.94,3192.88 C 1259.94,3143.62 1299.87,3103.7 1349.12,3103.7 L 4604.62,3103.7 C 4628.28,3103.7 4650.96,3113.09 4667.7,3129.82 C 4684.43,3146.55 4693.82,3169.23 4693.82,3192.88 L 4693.82,4845.91 C 4693.82,4895.16 4653.89,4935.1 4604.62,4935.1 L 3749.5,4935.1 L 3463.34,5331.35 L 2490.41,5331.35 L 2204.26,4935.1 L 1349.12,4935.1 C 1325.48,4935.1 1302.79,4925.7 1286.07,4908.98 C 1269.34,4892.25 1259.94,4869.57 1259.94,4845.91 L 1259.94,3192.88\"\n"
            "id=\"path35\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 1259.94,3192.88 C 1259.94,3143.62 1299.87,3103.7 1349.12,3103.7 L 4604.62,3103.7 C 4628.28,3103.7 4650.96,3113.09 4667.7,3129.82 C 4684.43,3146.55 4693.82,3169.23 4693.82,3192.88 L 4693.82,4845.91 C 4693.82,4895.16 4653.89,4935.1 4604.62,4935.1 L 3749.5,4935.1 L 3463.34,5331.35 L 2490.41,5331.35 L 2204.26,4935.1 L 1349.12,4935.1 C 1325.48,4935.1 1302.79,4925.7 1286.07,4908.98 C 1269.34,4892.25 1259.94,4869.57 1259.94,4845.91 L 1259.94,3192.88 z\"\n"
            "id=\"path37\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 3741.32,3998.95 C 3741.32,4421.14 3399.07,4763.39 2976.88,4763.39 C 2554.69,4763.39 2212.44,4421.14 2212.44,3998.95 C 2212.44,3576.76 2554.69,3234.5 2976.88,3234.5 C 3399.07,3234.5 3741.32,3576.76 3741.32,3998.95\"\n"
            "id=\"path39\"\n"
            "style=\"fill:#0046ac;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 3741.32,3998.95 C 3741.32,4421.14 3399.07,4763.39 2976.88,4763.39 C 2554.69,4763.39 2212.44,4421.14 2212.44,3998.95 C 2212.44,3576.76 2554.69,3234.5 2976.88,3234.5 C 3399.07,3234.5 3741.32,3576.76 3741.32,3998.95 z\"\n"
            "id=\"path41\"\n"
            "style=\"fill:none;stroke:#0046ac;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 3669.25,3998.95 C 3669.25,4381.32 3359.26,4691.32 2976.88,4691.32 C 2594.48,4691.32 2284.51,4381.32 2284.51,3998.95 C 2284.51,3616.57 2594.48,3306.57 2976.88,3306.57 C 3359.26,3306.57 3669.25,3616.57 3669.25,3998.95\"\n"
            "id=\"path43\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 3669.25,3998.95 C 3669.25,4381.32 3359.26,4691.32 2976.88,4691.32 C 2594.48,4691.32 2284.51,4381.32 2284.51,3998.95 C 2284.51,3616.57 2594.48,3306.57 2976.88,3306.57 C 3359.26,3306.57 3669.25,3616.57 3669.25,3998.95 z\"\n"
            "id=\"path45\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 3571.45,3998.95 C 3571.45,4327.32 3305.25,4593.51 2976.88,4593.51 C 2648.51,4593.51 2382.3,4327.32 2382.3,3998.95 C 2382.3,3670.57 2648.51,3404.38 2976.88,3404.38 C 3305.25,3404.38 3571.45,3670.57 3571.45,3998.95\"\n"
            "id=\"path47\"\n"
            "style=\"fill:#0046ac;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 3571.45,3998.95 C 3571.45,4327.32 3305.25,4593.51 2976.88,4593.51 C 2648.51,4593.51 2382.3,4327.32 2382.3,3998.95 C 2382.3,3670.57 2648.51,3404.38 2976.88,3404.38 C 3305.25,3404.38 3571.45,3670.57 3571.45,3998.95 z\"\n"
            "id=\"path49\"\n"
            "style=\"fill:none;stroke:#0046ac;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 4121.5,4970.77 L 4464.883,4970.77 L 4464.883,5085.231 L 4121.5,5085.231 L 4121.5,4970.77 z\"\n"
            "id=\"path51\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 4121.5,4970.77 L 4464.883,4970.77 L 4464.883,5085.231 L 4121.5,5085.231 L 4121.5,4970.77 z\"\n"
            "id=\"path53\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:4.76926994;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 1488.86,4970.77 L 1832.251,4970.77 L 1832.251,5085.231 L 1488.86,5085.231 L 1488.86,4970.77 z\"\n"
            "id=\"path55\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 1488.86,4970.77 L 1832.251,4970.77 L 1832.251,5085.231 L 1488.86,5085.231 L 1488.86,4970.77 z\"\n"
            "id=\"path57\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:4.76926994;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 2155.73,2612 L 2420.62,2746.95 C 2527.2,2537.79 2742.12,2406.09 2976.88,2406.09 C 3211.62,2406.09 3426.54,2537.79 3533.12,2746.95 L 3798.01,2612 C 3640.69,2303.21 3323.43,2108.8 2976.88,2108.8 C 2630.32,2108.8 2313.07,2303.21 2155.73,2612\"\n"
            "id=\"path59\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 2155.73,2612 L 2420.62,2746.95 C 2527.2,2537.79 2742.12,2406.09 2976.88,2406.09 C 3211.62,2406.09 3426.54,2537.79 3533.12,2746.95 L 3798.01,2612 C 3640.69,2303.21 3323.43,2108.8 2976.88,2108.8 C 2630.32,2108.8 2313.07,2303.21 2155.73,2612 z\"\n"
            "id=\"path61\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 1493.54,2274.59 L 1758.42,2409.54 C 1991.88,1951.36 2462.64,1662.88 2976.88,1662.88 C 3491.11,1662.88 3961.88,1951.36 4195.34,2409.54 L 4460.21,2274.59 C 4176.01,1716.79 3602.89,1365.59 2976.88,1365.59 C 2350.86,1365.59 1777.75,1716.79 1493.54,2274.59\"\n"
            "id=\"path63\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 1493.54,2274.59 L 1758.42,2409.54 C 1991.88,1951.36 2462.64,1662.88 2976.88,1662.88 C 3491.11,1662.88 3961.88,1951.36 4195.34,2409.54 L 4460.21,2274.59 C 4176.01,1716.79 3602.89,1365.59 2976.88,1365.59 C 2350.86,1365.59 1777.75,1716.79 1493.54,2274.59 z\"\n"
            "id=\"path65\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /><path\n"
            "d=\"M 831.336,1937.18 L 1096.21,2072.14 C 1456.55,1364.94 2183.17,919.668 2976.88,919.668 C 3770.59,919.668 4497.21,1364.94 4857.54,2072.14 L 5122.41,1937.18 C 4711.34,1130.36 3882.38,622.375 2976.88,622.375 C 2071.38,622.375 1242.42,1130.36 831.336,1937.18\"\n"
            "id=\"path67\"\n"
            "style=\"fill:#ffffff;fill-opacity:1;fill-rule:nonzero;stroke:none\" /><path\n"
            "d=\"M 831.336,1937.18 L 1096.21,2072.14 C 1456.55,1364.94 2183.17,919.668 2976.88,919.668 C 3770.59,919.668 4497.21,1364.94 4857.54,2072.14 L 5122.41,1937.18 C 4711.34,1130.36 3882.38,622.375 2976.88,622.375 C 2071.38,622.375 1242.42,1130.36 831.336,1937.18 z\"\n"
            "id=\"path69\"\n"
            "style=\"fill:none;stroke:#ffffff;stroke-width:7.07818985;stroke-linecap:round;stroke-linejoin:round;stroke-miterlimit:500;stroke-dasharray:none;stroke-opacity:1\" /></g></g></g></g></svg>\n";
      }

      // source: https://commons.wikimedia.org/wiki/File:Sweden_road_sign_E25.svg
      tCString tcl_SVG_Resources_SWEDEN::get_road_sign_E25()
      {
         return 
         "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n"
         "<!-- Created with Inkscape (http://www.inkscape.org/) -->\n"
         "\n"
         "<svg\n"
         "   xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n"
         "   xmlns:cc=\"http://creativecommons.org/ns#\"\n"
         "   xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n"
         "   xmlns:svg=\"http://www.w3.org/2000/svg\"\n"
         "   xmlns=\"http://www.w3.org/2000/svg\"\n"
         "   xmlns:sodipodi=\"http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd\"\n"
         "   xmlns:inkscape=\"http://www.inkscape.org/namespaces/inkscape\"\n"
         "   width=\"500.39999\"\n"
         "   height=\"500.39999\"\n"
         "   id=\"svg2\"\n"
         "   sodipodi:version=\"0.32\"\n"
         "   inkscape:version=\"0.48.4 r9939\"\n"
         "   version=\"1.0\"\n"
         "   sodipodi:docname=\"AJAX.svg\"\n"
         "   inkscape:output_extension=\"org.inkscape.output.svg.inkscape\">\n"
         "  <defs\n"
         "     id=\"defs4\">\n"
         "    <inkscape:perspective\n"
         "       sodipodi:type=\"inkscape:persp3d\"\n"
         "       inkscape:vp_x=\"0 : 300.5 : 1\"\n"
         "       inkscape:vp_y=\"0 : 1000 : 0\"\n"
         "       inkscape:vp_z=\"601 : 300.5 : 1\"\n"
         "       inkscape:persp3d-origin=\"300.5 : 200.33333 : 1\"\n"
         "       id=\"perspective3380\" />\n"
         "    <inkscape:perspective\n"
         "       id=\"perspective3990\"\n"
         "       inkscape:persp3d-origin=\"375 : 250 : 1\"\n"
         "       inkscape:vp_z=\"750 : 375 : 1\"\n"
         "       inkscape:vp_y=\"0 : 1000 : 0\"\n"
         "       inkscape:vp_x=\"0 : 375 : 1\"\n"
         "       sodipodi:type=\"inkscape:persp3d\" />\n"
         "  </defs>\n"
         "  <sodipodi:namedview\n"
         "     id=\"base\"\n"
         "     pagecolor=\"#ffffff\"\n"
         "     bordercolor=\"#666666\"\n"
         "     borderopacity=\"1.0\"\n"
         "     gridtolerance=\"10000\"\n"
         "     guidetolerance=\"10\"\n"
         "     objecttolerance=\"10\"\n"
         "     inkscape:pageopacity=\"0.0\"\n"
         "     inkscape:pageshadow=\"2\"\n"
         "     inkscape:zoom=\"0.81832973\"\n"
         "     inkscape:cx=\"213.90735\"\n"
         "     inkscape:cy=\"296.15018\"\n"
         "     inkscape:document-units=\"px\"\n"
         "     inkscape:current-layer=\"layer1\"\n"
         "     width=\"601px\"\n"
         "     height=\"601px\"\n"
         "     inkscape:window-width=\"1280\"\n"
         "     inkscape:window-height=\"1001\"\n"
         "     inkscape:window-x=\"-8\"\n"
         "     inkscape:window-y=\"-8\"\n"
         "     showgrid=\"false\"\n"
         "     fit-margin-top=\"0.2\"\n"
         "     fit-margin-left=\"0.2\"\n"
         "     fit-margin-right=\"0.2\"\n"
         "     fit-margin-bottom=\"0.2\"\n"
         "     inkscape:window-maximized=\"1\"\n"
         "     showguides=\"true\"\n"
         "     inkscape:guide-bbox=\"true\" />\n"
         "  <metadata\n"
         "     id=\"metadata7\">\n"
         "    <rdf:RDF>\n"
         "      <cc:Work\n"
         "         rdf:about=\"\">\n"
         "        <dc:format>image/svg+xml</dc:format>\n"
         "        <dc:type\n"
         "           rdf:resource=\"http://purl.org/dc/dcmitype/StillImage\" />\n"
         "        <dc:title />\n"
         "      </cc:Work>\n"
         "    </rdf:RDF>\n"
         "  </metadata>\n"
         "  <g\n"
         "     inkscape:label=\"Layer 1\"\n"
         "     inkscape:groupmode=\"layer\"\n"
         "     id=\"layer1\"\n"
         "     transform=\"translate(2503.4096,3754.8449)\">\n"
         "    <rect\n"
         "       style=\"color:#000000;fill:#000000;fill-opacity:1;fill-rule:nonzero;stroke:none;stroke-width:0.8735441;marker:none;visibility:visible;display:inline;overflow:visible\"\n"
         "       id=\"rect3653\"\n"
         "       width=\"0\"\n"
         "       height=\"27.202072\"\n"
         "       x=\"578.73834\"\n"
         "       y=\"298.1684\"\n"
         "       rx=\"249.48199\"\n"
         "       ry=\"27.202072\" />\n"
         "    <path\n"
         "       style=\"fill:#000000;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2461.5533,-3754.6449 c -23.0119,0 -41.6563,18.6443 -41.6563,41.6563 l 0,416.6875 c 0,23.012 18.6444,41.6562 41.6563,41.6562 l 416.6875,0 c 23.0119,0 41.6562,-18.6442 41.6562,-41.6562 l 0,-416.6875 c 0,-23.012 -18.6443,-41.6563 -41.6562,-41.6563 z\"\n"
         "       id=\"path13\"\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       sodipodi:nodetypes=\"sssssssss\" />\n"
         "    <path\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2461.554,-3733.8016 c -11.5068,0 -20.8126,9.3056 -20.8126,20.8126 l 0,416.6888 c 0,11.5069 9.3058,20.8126 20.8126,20.8126 l 416.6888,0 c 11.5068,0 20.8126,-9.3057 20.8126,-20.8126 l 0,-416.6888 c 0,-11.507 -9.3058,-20.8126 -20.8126,-20.8126 z\"\n"
         "       id=\"path15\"\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       sodipodi:nodetypes=\"sssssssss\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#000000;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2215.706,-3684.376 120.7397,173.4111 58.423,30.3419 0,184.3119 c 0,2.2107 -0.8774,4.3303 -2.4414,5.8929 -1.5626,1.5625 -3.6822,2.4401 -5.8914,2.4401 l -416.6664,0 c -4.6036,0 -8.3344,-3.7293 -8.3344,-8.333 l 0,-130.7485 179.1614,-257.3164 75.0095,0 z\"\n"
         "       id=\"path17\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2213.3861,-3297.0936 -3.541,-38.5234 c -27.5461,7.0689 -56.3519,-5.6106 -69.7443,-30.6976 l -6.3632,69.221 79.6485,0 z\"\n"
         "       id=\"path19\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2045.6576,-3297.0936 0,-113.7621 -5.6033,0.042 c -3.6807,-0.1117 -7.2878,-1.0554 -10.551,-2.7605 l -59.3859,-38.1441 c 8.6137,19.2661 6.7792,41.6013 -4.8639,59.2036 -11.6432,17.6006 -31.4811,28.0282 -52.5816,27.6386 -6.8527,12.0548 -17.5683,21.4475 -30.4169,26.6642 l 71.9844,41.1178 91.4182,0 z\"\n"
         "       id=\"path21\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2318.1598,-3440.2377 30.3493,18.0872 c -4.692,9.7264 -6.7484,20.514 -5.962,31.2841 l -40.0609,-24.1668 c -2.7164,-5.4136 -2.4224,-11.8489 0.7762,-16.9922 3.1985,-5.1431 8.84,-8.252 14.8974,-8.2123 z\"\n"
         "       id=\"path23\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2327.6568,-3459.0437 45.6539,27.2256 c 6.3176,-8.6195 14.7652,-15.4473 24.5166,-19.8188 l -56.5915,-32.8466 c -7.8361,-1.9035 -15.8721,2.2784 -18.8075,9.7896 -2.2651,5.7944 -0.066,12.3825 5.2285,15.6502 z\"\n"
         "       id=\"path25\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2214.6619,-3475.764 -94.6622,-54.9466 c -7.8361,-1.9021 -15.8721,2.2813 -18.8075,9.7896 -2.2651,5.7958 -0.066,12.381 5.2285,15.6516 l 81.9283,48.8568 c 3.2647,-0.4645 6.5602,-0.6689 9.8558,-0.6085 4.1524,-7.3041 9.7528,-13.6819 16.4571,-18.7429 z\"\n"
         "       id=\"path27\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2269.0707,-3554.5217 c -7.8346,-1.9035 -15.8705,2.2798 -18.8074,9.7896 -2.2666,5.7959 -0.065,12.3811 5.2299,15.6516 l 78.5975,46.8695 c 8.1345,-3.8776 17.0201,-5.9281 26.0291,-6.0031 l -34.4443,-22.1236 c -5.7753,-3.2926 -10.8759,-7.6464 -15.0299,-12.8352 -1.242,-1.5522 -2.0475,-3.4102 -2.3327,-5.3799 -0.1587,-1.1098 -0.2514,-2.2299 -0.272,-3.35 l -38.9702,-22.6189 z\"\n"
         "       id=\"path29\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffd100;fill-opacity:1;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2179.7002,-3395.357 c 0,-29.0278 -23.5317,-52.5595 -52.5595,-52.5595 -29.0293,0 -52.5625,23.5317 -52.5625,52.5595 0,29.0277 23.5332,52.561 52.5625,52.561 29.0278,0 52.5595,-23.5333 52.5595,-52.561 z\"\n"
         "       id=\"path31\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffd100;fill-opacity:1;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2174.3732,-3374.0741 c 6.2721,-17.0569 4.6993,-36.0114 -4.2936,-51.8026 -8.9929,-15.7927 -24.4946,-26.8156 -42.3628,-30.1243 13.8127,-20.4082 39.9506,-28.481 62.8665,-19.4146 22.9174,9.0694 36.4553,32.8407 32.563,57.178 -3.8939,24.3344 -24.1727,42.6965 -48.7731,44.1635 z\"\n"
         "       id=\"path33\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2220.8062,-3529.8508 c -0.2322,-1.6212 -0.2469,-3.2661 -0.044,-4.8933 0.072,-0.5615 0.2617,-1.101 0.5615,-1.5816 l 8.9018,-11.333 c 1.2553,-1.0495 2.787,-1.708 4.4082,-1.9006 2.7429,-0.3219 5.4945,-0.5776 8.2491,-0.7628 2.3799,-0.1633 4.7714,0.012 7.1042,0.5144 1.7388,0.3748 3.4439,0.8951 5.0976,1.5581 l 140.8702,73.1647 0,55.1143 -5.4798,0.041 c -2.1299,-0.086 -4.2186,-0.616 -6.131,-1.5597 l -150.4849,-96.6553 c -4.8566,-2.7341 -9.1443,-6.375 -12.6265,-10.7259 -0.2264,-0.2822 -0.3734,-0.6218 -0.4263,-0.9805 z\"\n"
         "       id=\"path35\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2259.3531,-3663.5045 12.287,0 -1.4905,-16.2135 -9.306,0 -1.4905,16.2135 z\"\n"
         "       id=\"path37\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2268.5253,-3563.7146 c 1.0201,0.178 2.0285,0.4175 3.0192,0.7203 l 29.2379,16.9731 -3.8423,-41.8042 -26.1982,0 -2.2166,24.1108 z\"\n"
         "       id=\"path39\" />\n"
         "    <path\n"
         "       inkscape:connector-curvature=\"0\"\n"
         "       style=\"fill:#ffffff;fill-rule:nonzero;stroke:none\"\n"
         "       d=\"m -2263.3439,-3620.0762 20.27,0 -2.2827,-24.8333 -15.706,0 -2.2813,24.8333 z\"\n"
         "       id=\"path41\" />\n"
         "  </g>\n"
         "</svg>\n";
      }

   } // namespace Resources
} // namespace ImageLib
