/******************************************************************
*FILE: main.c 
*SW-COMPONENT: ai_isoconnectivity
*DESCRIPTION: This file contains main function of hostproxy
*COPYRIGHT: © 2018 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include "peer_client.h"
#include "logs-internal.h"
#include <sys/signalfd.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <getopt.h>
#include <sys/types.h>
#include <sys/stat.h>

static GMainLoop *pMainLoop = NULL;
static unsigned int terminated = 0;
DLT_DECLARE_CONTEXT(hostproxy_context);

static gboolean
signal_handler (GIOChannel *channel,
                GIOCondition cond,
                gpointer data)
{
    struct signalfd_siginfo si;
    ssize_t result;
    int fd;

    if (cond & (G_IO_NVAL | G_IO_ERR | G_IO_HUP))
        return FALSE;

    fd = g_io_channel_unix_get_fd (channel);

    result = read (fd, &si, sizeof(struct signalfd_siginfo));
    if (result != sizeof (struct signalfd_siginfo))
        return FALSE;

    switch (si.ssi_signo) {
    case SIGINT:
    case SIGTERM:
        if (terminated == 0) {
            DLT_LOG(hostproxy_context,DLT_LOG_INFO, DLT_STRING("Terminating"));
	    DLT_UNREGISTER_CONTEXT(hostproxy_context);
            DLT_UNREGISTER_APP();
            g_main_loop_quit (pMainLoop);
        }

        terminated = 1;
        break;
    default:
        break;
    }

    return TRUE;
}

static guint
setup_signalfd (void)
{
    GIOChannel *channel;
    guint source;
    sigset_t mask;
    int fd;

    sigemptyset (&mask);
    sigaddset (&mask, SIGINT);
    sigaddset (&mask, SIGTERM);

    if (sigprocmask (SIG_BLOCK, &mask, NULL) < 0) {
        DLT_LOG(hostproxy_context,DLT_LOG_ERROR, DLT_STRING("Failed to set signal mask"));
        return 0;
    }

    fd = signalfd (-1, &mask, 0);
    if (fd < 0) {
        DLT_LOG(hostproxy_context,DLT_LOG_ERROR, DLT_STRING("Failed to create signal descriptor"));
        return 0;
    }
    channel = g_io_channel_unix_new (fd);

    g_io_channel_set_close_on_unref (channel, TRUE);
    g_io_channel_set_encoding (channel, NULL, NULL);
    g_io_channel_set_buffered (channel, FALSE);

    source = g_io_add_watch (channel,
                G_IO_IN | G_IO_HUP | G_IO_ERR | G_IO_NVAL,
                signal_handler, NULL);

    g_io_channel_unref (channel);

    return source;
}

gint main(gint argc, gchar *argv[])
{

	DLT_REGISTER_APP(DLT_APPID_IDC_HOSTPROXY,"DLT Logging in Hostproxy");

        DLT_REGISTER_CONTEXT(hostproxy_context,"HPCO","context for hostproxy");

        DLT_LOG(hostproxy_context,DLT_LOG_INFO, DLT_STRING(__FUNCTION__), DLT_STRING("entered")); 

	guint signal;

        g_autoptr (PeerClient) peer_client = NULL;

        umask(0077);
        pMainLoop = g_main_loop_new(NULL, FALSE);
 	signal = setup_signalfd ();
	peer_client = peer_client_get_object();

        g_main_loop_run(pMainLoop);
	g_source_remove (signal);
	DLT_UNREGISTER_CONTEXT(hostproxy_context);
	DLT_UNREGISTER_APP();
	g_main_loop_unref (pMainLoop);
        exit(0);
}
