/************************************************************************
 * @file: adit_typedef.h
 *
 * @version: $Id: adit_typedef_linux.h,v 1.6 2012/05/11 07:59:21 apfohl Exp $
 *
 * This header file declares the basic types that are to be used for programming
 * of the ADIT platform, based on TKernel OS and gcc compiler.
 * @component: global definition file
 *
 * @author: T.Rodenbach <trodenbach@de.adit-jv.com>
 *
 * @copyright: (c) 2003 - 2004 ADIT Corporation
 *
 ***********************************************************************/

#ifndef ADIT_TYPEDEF_LINUX_H
#define ADIT_TYPEDEF_LINUX_H

#include <limits.h>

/** 8 bit signed Integer */
typedef signed char S8;
#define S8_MAX SCHAR_MAX
#define S8_MIN SCHAR_MIN

/** 16 bit signed Integer */
typedef short S16;
#define S16_MAX SHRT_MAX
#define S16_MIN SHRT_MIN

/** 32 bit signed Integer */
typedef int S32;
#define S32_MAX INT_MAX
#define S32_MIN INT_MIN

/** 8 bit unsigned Integer */
typedef unsigned char U8;
#define U8_MAX UCHAR_MAX
#define U8_MIN 0

/** 16 bit unsigned Integer */
typedef unsigned short U16;
typedef volatile unsigned int _U16;
#define U16_MAX USHRT_MAX
#define U16_MIN 0

/** 32 bit unsigned Integer */
typedef unsigned int U32;
typedef volatile unsigned int _U32;
#define U32_MAX UINT_MAX
#define U32_MIN UINT_MIN

/** 64 bit unsigned Integer */
typedef unsigned long long U64;
#define U64_MAX ULLONG_MAX
#define U64_MIN 0

/** 64 bit signed Integer */
typedef signed long long S64;
#define S64_MAX LLONG_MAX
#define S64_MIN LLONG_MIN

/** single precision floating point */
typedef float F32;

/** double precision floating point */
typedef double F64;

#if defined(__GNUC__)
#  define ATTRIBUTE(attributes) __attribute__(attributes)
#else
#  define ATTRIBUTE(attributes)
#endif

/** bool definition */
typedef S32     BOOL;

/** general void pointer definition */
typedef void*   VP;

/** general function address */
typedef void    (*FP)(void);

/** Local symbol definition  */
#define LOCAL   static

/** Global symbol definition */
#define EXPORT

/** Global symbol reference  */
#define IMPORT  extern

/** Global symbol definition */
#define Inline  static inline

#ifndef TRUE 
 #define TRUE   1
#endif

#ifndef FALSE
 #define FALSE  0
#endif


#endif /* ADIT_TYPEDEF_LINUX_H */
