/********************************************************************//**
 * \file iap2_commands.h
 *
 * \brief Application side iAP2 Control session messages
 * \version $ $
 *
 * This header file declares functions required for forming the messages which be sent to the Apple Devices.
 *
 * \component global definition file
 *
 * \author Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
 *
 * \copyright (c) 2010 - 2016 ADIT Corporation
 *
 * \warning CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
 *          DO NOT CHANGE THE CODE MANUALLY
 ***********************************************************************/

#ifndef IAP2_COMMANDS_H
#define IAP2_COMMANDS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "iap2_init.h"

/**
 * \addtogroup ControlSessionAPIs
 * @{
 */

 /***************************************************************************//**
 * Send AccessoryAuthenticationSerialNumber message to apple device
 * 
 * This API must be called if control session version 2 is
 * in use and ReuqestAuthenticationCertificate message contains
 * RequestAuthenticationCertificateSerialNumber parameter.
 * It retrieves X.509 certificate serial number from authentication
 * co-processor and sends to apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AccessoryAuthenticationSerialNumberParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2AccessoryAuthenticationSerialNumber(iAP2Device_t* device, const iAP2AccessoryAuthenticationSerialNumberParameter* iAP2AccessoryAuthenticationSerialNumberParameter);

 /***************************************************************************//**
 * Send AuthenticationCertificate message to apple device
 * 
 * This API must be called to respond to iAP2RequestAuthenticateCertificate message
 * from Apple device. It retrieves X.509 certificate from authentication co-processor and sends to apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AuthenticationCertificateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note This is automatic response to iAP2RequestAuthenticationCertificate Message. 
 * It is not intended to use by Application.
 ******************************************************************************/
S32 iAP2AuthenticationCertificate(iAP2Device_t* device, const iAP2AuthenticationCertificateParameter* iAP2AuthenticationCertificateParameter);

 /***************************************************************************//**
 * Send AuthenticationResponse message to apple device
 * 
 * This API must be called to respond to iAP2RequestAuthenticateChallengeResponse message
 * from Apple device. It retrieves Authentication Challenge data from authentication co-processor and sends to apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AuthenticationResponseParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note This is automatic response to iAP2RequestAuthenticationChallengeResponse Message. 
 * It is not intended to use by Application.
 ******************************************************************************/
S32 iAP2AuthenticationResponse(iAP2Device_t* device, const iAP2AuthenticationResponseParameter* iAP2AuthenticationResponseParameter);

 /***************************************************************************//**
 * Send IdentificationInformation message to apple device
 * 
 * This API must be called to respond to iAP2StartIdentification message
 * within 1 second. It sends list of supported features to apple device. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2IdentificationInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note This is automatic response to iAP2StartIdentification Message. 
 * It is not intended to use by Application. 
 * Application can configure the parameters of this API through interface provided.
 ******************************************************************************/
S32 iAP2IdentificationInformation(iAP2Device_t* device, const iAP2IdentificationInformationParameter* iAP2IdentificationInformationParameter);

 /***************************************************************************//**
 * Send CancelIdentification message to apple device
 * 
 * This API is called to abort the identification process.
 * Cancellation will cause apple device to inform the user that 
 * the accessory is not supported.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2CancelIdentificationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2CancelIdentification(iAP2Device_t* device, const iAP2CancelIdentificationParameter* iAP2CancelIdentificationParameter);

 /***************************************************************************//**
 * Send IdentificationInformationUpdate message to apple device
 * 
 * This API is used to update identification information.
 * It sends updated list of supported of features.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2IdentificationInformationUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2IdentificationInformationUpdate(iAP2Device_t* device, const iAP2IdentificationInformationUpdateParameter* iAP2IdentificationInformationUpdateParameter);

 /***************************************************************************//**
 * Send RequestAppLaunch message to apple device
 * 
 * This API must be called if the accessory supports
 * App launch feature. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestAppLaunchParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestAppLaunch(iAP2Device_t* device, const iAP2RequestAppLaunchParameter* iAP2RequestAppLaunchParameter);

 /***************************************************************************//**
 * Send OOBBTPairingAccessoryInformation message to apple device
 * 
 * This API must be called to register the accessory's BT name, pairing status and device class in response to the StartOOBBTPairing message from the Apple device
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2OOBBTPairingAccessoryInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2OOBBTPairingAccessoryInformation(iAP2Device_t* device, const iAP2OOBBTPairingAccessoryInformationParameter* iAP2OOBBTPairingAccessoryInformationParameter);

 /***************************************************************************//**
 * Send OOBBTPairingCompletionInformation message to apple device
 * 
 * This API must be called to notify the Apple device whether the accessory has successfully stored the link key or not
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2OOBBTPairingCompletionInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2OOBBTPairingCompletionInformation(iAP2Device_t* device, const iAP2OOBBTPairingCompletionInformationParameter* iAP2OOBBTPairingCompletionInformationParameter);

 /***************************************************************************//**
 * Send StartRouteGuidanceUpdate message to apple device
 * 
 * Application must call this API to start receiving Route Guidance Update message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartRouteGuidanceUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartRouteGuidanceUpdate(iAP2Device_t* device, const iAP2StartRouteGuidanceUpdateParameter* iAP2StartRouteGuidanceUpdateParameter);

 /***************************************************************************//**
 * Send StopRouteGuidanceUpdate message to apple device
 * 
 * Application must call this API to stop receiving Route Guidance Update message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopRouteGuidanceUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopRouteGuidanceUpdate(iAP2Device_t* device, const iAP2StopRouteGuidanceUpdateParameter* iAP2StopRouteGuidanceUpdateParameter);

 /***************************************************************************//**
 * Send StartAssistiveTouch message to apple device
 * 
 * This API is called to enable assistive touch feature
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartAssistiveTouchParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartAssistiveTouch(iAP2Device_t* device, const iAP2StartAssistiveTouchParameter* iAP2StartAssistiveTouchParameter);

 /***************************************************************************//**
 * Send StopAssistiveTouch message to apple device
 * 
 * This API is called to disable Assistive touch feature
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopAssistiveTouchParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopAssistiveTouch(iAP2Device_t* device, const iAP2StopAssistiveTouchParameter* iAP2StopAssistiveTouchParameter);

 /***************************************************************************//**
 * Send StartAssistiveTouchInformation message to apple device
 * 
 * This API must be called to get notification from device
 * whether Assistive touch feature is enabled or disabled.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartAssistiveTouchInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartAssistiveTouchInformation(iAP2Device_t* device, const iAP2StartAssistiveTouchInformationParameter* iAP2StartAssistiveTouchInformationParameter);

 /***************************************************************************//**
 * Send StopAssistiveTouchInformation message to apple device
 * 
 * This API must be called to stop getting notification of
 * assistive touch support.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopAssistiveTouchInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopAssistiveTouchInformation(iAP2Device_t* device, const iAP2StopAssistiveTouchInformationParameter* iAP2StopAssistiveTouchInformationParameter);

 /***************************************************************************//**
 * Send BluetoothComponentInformation message to apple device
 * 
 * Application must call this API within 2 seconds of
 * receiving IdentificationAccepted message to report 
 * initial state of bluetooth components and also whenever state changes
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2BluetoothComponentInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2BluetoothComponentInformation(iAP2Device_t* device, const iAP2BluetoothComponentInformationParameter* iAP2BluetoothComponentInformationParameter);

 /***************************************************************************//**
 * Send StartBluetoothConnectionUpdates message to apple device
 * 
 * This API must be called to start receiving status of bluetooth
 * components updates. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartBluetoothConnectionUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartBluetoothConnectionUpdates(iAP2Device_t* device, const iAP2StartBluetoothConnectionUpdatesParameter* iAP2StartBluetoothConnectionUpdatesParameter);

 /***************************************************************************//**
 * Send StopBluetoothConnectionUpdates message to apple device
 * 
 * Application can call this API to stop receiving bluetooth 
 * components status updates.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopBluetoothConnectionUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopBluetoothConnectionUpdates(iAP2Device_t* device, const iAP2StopBluetoothConnectionUpdatesParameter* iAP2StopBluetoothConnectionUpdatesParameter);

 /***************************************************************************//**
 * Send AcceptCall message to apple device
 * 
 * This API must be called in order to accept an incoming call
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AcceptCallParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2AcceptCall(iAP2Device_t* device, const iAP2AcceptCallParameter* iAP2AcceptCallParameter);

 /***************************************************************************//**
 * Send EndCall message to apple device
 * 
 * This API must be called in order to end an ongoing call
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2EndCallParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2EndCall(iAP2Device_t* device, const iAP2EndCallParameter* iAP2EndCallParameter);

 /***************************************************************************//**
 * Send HoldStatusUpdate message to apple device
 * 
 * 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2HoldStatusUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2HoldStatusUpdate(iAP2Device_t* device, const iAP2HoldStatusUpdateParameter* iAP2HoldStatusUpdateParameter);

 /***************************************************************************//**
 * Send InitiateCall message to apple device
 * 
 * This API must be called in order to initiate a call from head unit
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2InitiateCallParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2InitiateCall(iAP2Device_t* device, const iAP2InitiateCallParameter* iAP2InitiateCallParameter);

 /***************************************************************************//**
 * Send MergeCalls message to apple device
 * 
 * This API must be called in order to merge the new call
 * with already ongoing call thereby creates a conference call
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2MergeCallsParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2MergeCalls(iAP2Device_t* device, const iAP2MergeCallsParameter* iAP2MergeCallsParameter);

 /***************************************************************************//**
 * Send MuteStatusUpdate message to apple device
 * 
 * This API must be called in order to know the must status
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2MuteStatusUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2MuteStatusUpdate(iAP2Device_t* device, const iAP2MuteStatusUpdateParameter* iAP2MuteStatusUpdateParameter);

 /***************************************************************************//**
 * Send SendDTMF message to apple device
 * 
 * This API must be called in order to Send DTMF tones
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2SendDTMFParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2SendDTMF(iAP2Device_t* device, const iAP2SendDTMFParameter* iAP2SendDTMFParameter);

 /***************************************************************************//**
 * Send StartCallStateUpdates message to apple device
 * 
 * This API must be called to start receiving call updates.
 * Application can set "iAP2CallStatevCardFileTransferIdentifier" parameter
 * If it wish to receive vCards.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartCallStateUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartCallStateUpdates(iAP2Device_t* device, const iAP2StartCallStateUpdatesParameter* iAP2StartCallStateUpdatesParameter);

 /***************************************************************************//**
 * Send StartCommunicationsUpdates message to apple device
 * 
 * This API must be called to start receiving Communications updates.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartCommunicationsUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartCommunicationsUpdates(iAP2Device_t* device, const iAP2StartCommunicationsUpdatesParameter* iAP2StartCommunicationsUpdatesParameter);

 /***************************************************************************//**
 * Send StartListUpdates message to apple device
 * 
 * This API must be called in order to receive the recents &amp; favorites list from Apple device.
 * Applicable only for CarPlay Accessories
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartListUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartListUpdates(iAP2Device_t* device, const iAP2StartListUpdatesParameter* iAP2StartListUpdatesParameter);

 /***************************************************************************//**
 * Send StopCallStateUpdates message to apple device
 * 
 * This API must be called to stop receiving call updates.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopCallStateUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopCallStateUpdates(iAP2Device_t* device, const iAP2StopCallStateUpdatesParameter* iAP2StopCallStateUpdatesParameter);

 /***************************************************************************//**
 * Send StopCommunicationsUpdates message to apple device
 * 
 * This API must be called to stop receiving Communications updates.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopCommunicationsUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopCommunicationsUpdates(iAP2Device_t* device, const iAP2StopCommunicationsUpdatesParameter* iAP2StopCommunicationsUpdatesParameter);

 /***************************************************************************//**
 * Send StopListUpdates message to apple device
 * 
 * This API must be called in order to stop receiving  the recents &amp; favorites list from Apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopListUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopListUpdates(iAP2Device_t* device, const iAP2StopListUpdatesParameter* iAP2StopListUpdatesParameter);

 /***************************************************************************//**
 * Send SwapCalls message to apple device
 * 
 * This API must be called in order to swap between the ongoing calls
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2SwapCallsParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2SwapCalls(iAP2Device_t* device, const iAP2SwapCallsParameter* iAP2SwapCallsParameter);

 /***************************************************************************//**
 * Send RequestDeviceAuthenticationCertificate message to apple device
 * 
 * This API must be called to initiate Authentication process 
 * from accessory side.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestDeviceAuthenticationCertificateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestDeviceAuthenticationCertificate(iAP2Device_t* device, const iAP2RequestDeviceAuthenticationCertificateParameter* iAP2RequestDeviceAuthenticationCertificateParameter);

 /***************************************************************************//**
 * Send RequestDeviceAuthenticationChallengeResponse message to apple device
 * 
 * Application must call this API to get challenge response of device.
 * It must be called only if the authentication certificate provided by 
 * apple device is valid. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestDeviceAuthenticationChallengeResponseParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestDeviceAuthenticationChallengeResponse(iAP2Device_t* device, const iAP2RequestDeviceAuthenticationChallengeResponseParameter* iAP2RequestDeviceAuthenticationChallengeResponseParameter);

 /***************************************************************************//**
 * Send DeviceAuthenticationFailed message to apple device
 * 
 * Application must call this API if authentication response received
 * from apple device is incorrect.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2DeviceAuthenticationFailedParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2DeviceAuthenticationFailed(iAP2Device_t* device, const iAP2DeviceAuthenticationFailedParameter* iAP2DeviceAuthenticationFailedParameter);

 /***************************************************************************//**
 * Send DeviceAuthenticationSucceeded message to apple device
 * 
 * Application must call this API if authentication response received
 * from apple device is correct.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2DeviceAuthenticationSucceededParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2DeviceAuthenticationSucceeded(iAP2Device_t* device, const iAP2DeviceAuthenticationSucceededParameter* iAP2DeviceAuthenticationSucceededParameter);

 /***************************************************************************//**
 * Send StatusExternalAccessoryProtocolSession message to apple device
 * 
 * If Application wish to have multiple iAP2 EA sessions per protocol
 * then it must support this API.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StatusExternalAccessoryProtocolSessionParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StatusExternalAccessoryProtocolSession(iAP2Device_t* device, const iAP2StatusExternalAccessoryProtocolSessionParameter* iAP2StatusExternalAccessoryProtocolSessionParameter);

 /***************************************************************************//**
 * Send StartHID message to apple device
 * 
 * This API must be called to use HID feature over control session.
 * For each identified iAP2HIDComponent, it must be called.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartHIDParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartHID(iAP2Device_t* device, const iAP2StartHIDParameter* iAP2StartHIDParameter);

 /***************************************************************************//**
 * Send AccessoryHIDReport message to apple device
 * 
 * This API must be called to send HID report referred in specific HID component.
 * Application may send more than HID report using this message.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AccessoryHIDReportParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2AccessoryHIDReport(iAP2Device_t* device, const iAP2AccessoryHIDReportParameter* iAP2AccessoryHIDReportParameter);

 /***************************************************************************//**
 * Send StopHID message to apple device
 * 
 * This API must be called to stop usage of particular HID report descriptor. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopHIDParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopHID(iAP2Device_t* device, const iAP2StopHIDParameter* iAP2StopHIDParameter);

 /***************************************************************************//**
 * Send LocationInformation message to apple device
 * 
 * Application must call this API in response to 
 * StartLocationInformation message from device.
 * Application will provide location information in the form 
 * of NMEA sentences using this message. This message must be sent at a rate not exceeding 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2LocationInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2LocationInformation(iAP2Device_t* device, const iAP2LocationInformationParameter* iAP2LocationInformationParameter);

 /***************************************************************************//**
 * Send PlayMediaLibraryCollection message to apple device
 * 
 * This API must be called to start playback of specific
 * media library collection(i.e playlist). Media library collection must be
 * obtained from iAP2MediaLibraryUpdate message. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2PlayMediaLibraryCollectionParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2PlayMediaLibraryCollection(iAP2Device_t* device, const iAP2PlayMediaLibraryCollectionParameter* iAP2PlayMediaLibraryCollectionParameter);

 /***************************************************************************//**
 * Send PlayMediaLibraryCurrentSelection message to apple device
 * 
 * This API must called to resume playback of library's
 * current selection.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2PlayMediaLibraryCurrentSelectionParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2PlayMediaLibraryCurrentSelection(iAP2Device_t* device, const iAP2PlayMediaLibraryCurrentSelectionParameter* iAP2PlayMediaLibraryCurrentSelectionParameter);

 /***************************************************************************//**
 * Send PlayMediaLibraryItems message to apple device
 * 
 * This API must be called to start playback of specific
 * media library items. Set of media library items must be
 * obtained from iAP2MediaLibraryUpdate message. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2PlayMediaLibraryItems Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2PlayMediaLibraryItems(iAP2Device_t* device, const iAP2PlayMediaLibraryItemsParameter* iAP2PlayMediaLibraryItems);

 /***************************************************************************//**
 * Send PlayMediaLibrarySpecial message to apple device
 * 
 * Application must call this API to play all songs from the Artist/Album/etc., categories by passing their MediaLibraryUniqueIdentifiers.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2PlayMediaLibrarySpecialParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2PlayMediaLibrarySpecial(iAP2Device_t* device, const iAP2PlayMediaLibrarySpecialParameter* iAP2PlayMediaLibrarySpecialParameter);

 /***************************************************************************//**
 * Send StartMediaLibraryInformation message to apple device
 * 
 * Application must call this API to start receiving information about media libraries available on device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartMediaLibraryInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartMediaLibraryInformation(iAP2Device_t* device, const iAP2StartMediaLibraryInformationParameter* iAP2StartMediaLibraryInformationParameter);

 /***************************************************************************//**
 * Send StartMediaLibraryUpdates message to apple device
 * 
 * Application must use this API to make use of media library updates.
 * MediaLibraryUniqueIdentifier must be copied from MediaLibraryInformation message.
 * Media item properties and/or media playlist properties that wish 
 * to receive for particular media library, must be added in the parameters.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartMediaLibraryUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartMediaLibraryUpdates(iAP2Device_t* device, const iAP2StartMediaLibraryUpdatesParameter* iAP2StartMediaLibraryUpdatesParameter);

 /***************************************************************************//**
 * Send StopMediaLibraryInformation message to apple device
 * 
 * Application must call this API to stop receiving media library information.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopMediaLibraryInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopMediaLibraryInformation(iAP2Device_t* device, const iAP2StopMediaLibraryInformationParameter* iAP2StopMediaLibraryInformationParameter);

 /***************************************************************************//**
 * Send StopMediaLibraryUpdates message to apple device
 * 
 * Application must call this API to stop receiving media library updates.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopMediaLibraryUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopMediaLibraryUpdates(iAP2Device_t* device, const iAP2StopMediaLibraryUpdatesParameter* iAP2StopMediaLibraryUpdatesParameter);

 /***************************************************************************//**
 * Send SetNowPlayingInformation message to apple device
 * 
 * Application must call this API to set elapsed time of the current playing song.
 * Only effective if NowPlayingUpdate message SetElapsedTimeAvail parameter is true.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2SetNowPlayingInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2SetNowPlayingInformation(iAP2Device_t* device, const iAP2SetNowPlayingInformationParameter* iAP2SetNowPlayingInformationParameter);

 /***************************************************************************//**
 * Send StartNowPlayingUpdates message to apple device
 * 
 * Application must call this API to receive now playing information 
 * changes of media item or playback engine state.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartNowPlayingUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartNowPlayingUpdates(iAP2Device_t* device, const iAP2StartNowPlayingUpdatesParameter* iAP2StartNowPlayingUpdatesParameter);

 /***************************************************************************//**
 * Send StopNowPlayingUpdates message to apple device
 * 
 * Application must call this API once it no longer needs 
 * now playing information changes.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopNowPlayingUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopNowPlayingUpdates(iAP2Device_t* device, const iAP2StopNowPlayingUpdatesParameter* iAP2StopNowPlayingUpdatesParameter);

 /***************************************************************************//**
 * Send StartPowerUpdates message to apple device
 * 
 * Application must call this API to start receiving PowerUpdate message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartPowerUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartPowerUpdates(iAP2Device_t* device, const iAP2StartPowerUpdatesParameter* iAP2StartPowerUpdatesParameter);

 /***************************************************************************//**
 * Send StopPowerUpdates message to apple device
 * 
 * Application must call this API to stop receiving PowerUpdate message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopPowerUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopPowerUpdates(iAP2Device_t* device, const iAP2StopPowerUpdatesParameter* iAP2StopPowerUpdatesParameter);

 /***************************************************************************//**
 * Send PowerSourceUpdate message to apple device
 * 
 * Application must call this API to notify apple device 
 * about changes in power source. 
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2PowerSourceUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2PowerSourceUpdate(iAP2Device_t* device, const iAP2PowerSourceUpdateParameter* iAP2PowerSourceUpdateParameter);

 /***************************************************************************//**
 * Send StartTelephonyCallStateInformation message to apple device
 * 
 * This API must be called to start receiving call updates.
 * Application can set "iAP2CallStatevCardFileTransferIdentifier" parameter
 * If it wish to receive vCards.
 * CAUTION: This Message is Deprecated, Don't use this. Kindly refer Apple Specification.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartTelephonyCallStateInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartTelephonyCallStateInformation(iAP2Device_t* device, const iAP2StartTelephonyCallStateInformationParameter* iAP2StartTelephonyCallStateInformationParameter);

 /***************************************************************************//**
 * Send StartTelephonyUpdates message to apple device
 * 
 * This API must be called to start receiving Telephony updates.
 * CAUTION: This Message is Deprecated, Don't use this. Kindly refer Apple Specification.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartTelephonyUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartTelephonyUpdates(iAP2Device_t* device, const iAP2StartTelephonyUpdatesParameter* iAP2StartTelephonyUpdatesParameter);

 /***************************************************************************//**
 * Send StopTelephonyCallStateInformation message to apple device
 * 
 * This API must be called to stop receiving call updates.
 * CAUTION: This Message is Deprecated, Don't use this. Kindly refer Apple Specification.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopTelephonyCallStateInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopTelephonyCallStateInformation(iAP2Device_t* device, const iAP2StopTelephonyCallStateInformationParameter* iAP2StopTelephonyCallStateInformationParameter);

 /***************************************************************************//**
 * Send StopTelephonyUpdates message to apple device
 * 
 * This API must be called to stop receiving Telephony updates.
 * CAUTION: This Message is Deprecated, Don't use this. Kindly refer Apple Specification.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopTelephonyUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopTelephonyUpdates(iAP2Device_t* device, const iAP2StopTelephonyUpdatesParameter* iAP2StopTelephonyUpdatesParameter);

 /***************************************************************************//**
 * Send StartUSBDeviceModeAudio message to apple device
 * 
 * Application must call this API to start receiving audio
 * streaming output from apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartUSBDeviceModeAudioParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartUSBDeviceModeAudio(iAP2Device_t* device, const iAP2StartUSBDeviceModeAudioParameter* iAP2StartUSBDeviceModeAudioParameter);

 /***************************************************************************//**
 * Send StopUSBDeviceModeAudio message to apple device
 * 
 * Application must call this API to stop receiving audio
 * streaming output from apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopUSBDeviceModeAudioParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopUSBDeviceModeAudio(iAP2Device_t* device, const iAP2StopUSBDeviceModeAudioParameter* iAP2StopUSBDeviceModeAudioParameter);

 /***************************************************************************//**
 * Send VehicleStatusUpdate message to apple device
 * 
 * This API must be called in response to "iAP2StartVehicleStatusUpdates" message.
 * It sends sensor data and other information of vehicle to apple device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2VehicleStatusUpdateParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2VehicleStatusUpdate(iAP2Device_t* device, const iAP2VehicleStatusUpdateParameter* iAP2VehicleStatusUpdateParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverActivateCursor message to apple device
 * 
 * This API must must be called to activate voice over cursor.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverActivateCursorParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverActivateCursor(iAP2Device_t* device, const iAP2RequestVoiceOverActivateCursorParameter* iAP2RequestVoiceOverActivateCursorParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverConfiguration message to apple device
 * 
 * Application must call this API to adjust volume and/or 
 * speaking rate after the feature is started.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverConfigurationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverConfiguration(iAP2Device_t* device, const iAP2RequestVoiceOverConfigurationParameter* iAP2RequestVoiceOverConfigurationParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverMoveCursor message to apple device
 * 
 * Application must call this API to set cursor direction
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverMoveCursorParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverMoveCursor(iAP2Device_t* device, const iAP2RequestVoiceOverMoveCursorParameter* iAP2RequestVoiceOverMoveCursorParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverPauseText message to apple device
 * 
 * This API must be called to pause voice over text
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverPauseTextParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverPauseText(iAP2Device_t* device, const iAP2RequestVoiceOverPauseTextParameter* iAP2RequestVoiceOverPauseTextParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverResumeText message to apple device
 * 
 * This API must be called to resume voice over text
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverResumeTextParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverResumeText(iAP2Device_t* device, const iAP2RequestVoiceOverResumeTextParameter* iAP2RequestVoiceOverResumeTextParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverScrollPage message to apple device
 * 
 * This API must be called to set scroll direction
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverScrollPageParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverScrollPage(iAP2Device_t* device, const iAP2RequestVoiceOverScrollPageParameter* iAP2RequestVoiceOverScrollPageParameter);

 /***************************************************************************//**
 * Send RequestVoiceOverSpeakText message to apple device
 * 
 * This API must be called to convert text to audio.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestVoiceOverScrollPageParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestVoiceOverSpeakText(iAP2Device_t* device, const iAP2RequestVoiceOverSpeakTextParameter* iAP2RequestVoiceOverScrollPageParameter);

 /***************************************************************************//**
 * Send StartVoiceOver message to apple device
 * 
 * Application must call this API to start VoiceOver feature.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartVoiceOverParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartVoiceOver(iAP2Device_t* device, const iAP2StartVoiceOverParameter* iAP2StartVoiceOverParameter);

 /***************************************************************************//**
 * Send StartVoiceOverCursorUpdates message to apple device
 * 
 * Application must call this API to get information
 * about currently selected user interface element.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartVoiceOverCursorUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartVoiceOverCursorUpdates(iAP2Device_t* device, const iAP2StartVoiceOverCursorUpdatesParameter* iAP2StartVoiceOverCursorUpdatesParameter);

 /***************************************************************************//**
 * Send StartVoiceOverUpdates message to apple device
 * 
 * Application must call this API to start receiving
 * "iAP2VoiceOverUpdates" message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StartVoiceOverUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StartVoiceOverUpdates(iAP2Device_t* device, const iAP2StartVoiceOverUpdatesParameter* iAP2StartVoiceOverUpdatesParameter);

 /***************************************************************************//**
 * Send StopVoiceOver message to apple device
 * 
 * Application must call this API to stop VoiceOver feature.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopVoiceOverParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopVoiceOver(iAP2Device_t* device, const iAP2StopVoiceOverParameter* iAP2StopVoiceOverParameter);

 /***************************************************************************//**
 * Send StopVoiceOverCursorUpdates message to apple device
 * 
 * Application must call this API to stop receiving 
 * VoiceOver cursor updates
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopVoiceOverCursorUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopVoiceOverCursorUpdates(iAP2Device_t* device, const iAP2StopVoiceOverCursorUpdatesParameter* iAP2StopVoiceOverCursorUpdatesParameter);

 /***************************************************************************//**
 * Send StopVoiceOverUpdates message to apple device
 * 
 * Application must call this API to stop receiving
 * "iAP2VoiceOverUpdates" message from device.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2StopVoiceOverUpdatesParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2StopVoiceOverUpdates(iAP2Device_t* device, const iAP2StopVoiceOverUpdatesParameter* iAP2StopVoiceOverUpdatesParameter);

 /***************************************************************************//**
 * Send AccessoryWiFiConfigurationInformation message to apple device
 * 
 * This API must be called in response to RequestAccessoryWiFiConfigurationinformation
 * from Apple Device.
 * It will share the Wi-Fi configuration of the accessory
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2AccessoryWiFiConfigurationInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2AccessoryWiFiConfigurationInformation(iAP2Device_t* device, const iAP2AccessoryWiFiConfigurationInformationParameter* iAP2AccessoryWiFiConfigurationInformationParameter);

 /***************************************************************************//**
 * Send RequestWiFiInformation message to apple device
 * 
 * This API must be called to request connected Wi-Fi network information.
 * It must only be sent in response to direct user action.
 * 
 * \param[in] device initialized device structure
 * \param[in] iAP2RequestWiFiInformationParameter Initialized parameter structure
 * \return A signed integer value indicating success or failure 
 * 
 * \see
 * \note
 ******************************************************************************/
S32 iAP2RequestWiFiInformation(iAP2Device_t* device, const iAP2RequestWiFiInformationParameter* iAP2RequestWiFiInformationParameter);

/** @} */

#ifdef __cplusplus
}
#endif

#endif
