/*******************************************************
	Author: 
		Liu Caiquan
	Date: 
		@8th-December-2016@

	CarLife Protocol version:
		@V1.2.4@
							Copyright (C) Under BaiDu, Inc.
*******************************************************/
#ifndef CCONNECT_MANAGER_H
#define CCONNECT_MANAGER_H

#include "CVirtualShell.h"
#include "ASocketConnector.h" //Changed by ADIT from CSocketConnector to ASocketConnector
#include "CommonUtil.h"

#define ADB_FORWARD_CMD	"adb forward tcp:7200 tcp:7240"
#define ADB_FORWARD_VIDEO	"adb forward tcp:8200 tcp:8240"
#define ADB_FORWARD_MEDIA	"adb forward tcp:9200 tcp:9240"
#define ADB_FORWARD_TTS	"adb forward tcp:9201 tcp:9241"
#define ADB_FORWARD_VR	"adb forward tcp:9202 tcp:9242"
#define ADB_FORWARD_TOUCH	"adb forward tcp:9300 tcp:9340"

#define LOCAL_IP_ADDR "127.0.0.1"

#define CMD_SOCKET_PORT_MD	7240
#define VIDEO_SOCKET_PORT_MD	8240
#define MEDIA_SOCKET_PORT_MD 9240
#define TTS_SOCKET_PORT_MD	9241
#define VR_SOCKET_PORT_MD	9242
#define TOUCH_SOCKET_PORT_MD		9340

#define CMD_SOCKET_PORT_HU	7200
#define VIDEO_SOCKET_PORT_HU	8200
#define MEDIA_SOCKET_PORT_HU 9200
#define TTS_SOCKET_PORT_HU	9201
#define VR_SOCKET_PORT_HU	9202
#define TOUCH_SOCKET_PORT_HU		9300

class CConnectManager{
public:
	~CConnectManager();
	static CConnectManager* getInstance();

	bool startBdclServerAsRoot();
	bool execGetDeviceCmd();
	bool execSocketForward();
	bool execGetPropCmd();
	bool execStartCarlife();
	bool execKillBdsc();
	bool execStartBdsc();
	

	// ADIT modified
	bool createProtocolConnector(int accOrWrId, int devOrRdId, deviceType inDevice);
	void wakeupThreads();

	/////

	bool createCmdSocket(IProtocolSocketConnector*);//modified by ADIT

	bool createCmdSocket();
	bool createCmdSocket(string mdIPAddress);
	bool createCmdSocket(string mdIPAddress, string interfaceName);

	bool createVideoSocket(IProtocolSocketConnector*);//modified by ADIT
	bool createVideoSocket();
	bool createVideoSocket(string mdIPAddress);
	bool createVideoSocket(string mdIPAddress, string interfaceName);

	bool createMediaSocket(IProtocolSocketConnector*);//modified by ADIT
	bool createMediaSocket();
	bool createMediaSocket(string mdIPAddress);
	bool createMediaSocket(string mdIPAddress, string interfaceName);

	bool createTTSSocket(IProtocolSocketConnector*);//modified by ADIT
	bool createTTSSocket();
	bool createTTSSocket(string mdIPAddress);
	bool createTTSSocket(string mdIPAddress, string interfaceName);

	bool createVRSocket(IProtocolSocketConnector*);//modified by ADIT
	bool createVRSocket();
	bool createVRSocket(string mdIPAddress);
	bool createVRSocket(string mdIPAddress, string interfaceName);

	bool createTouchSocket(IProtocolSocketConnector*);//modified by ADIT
	bool createTouchSocket();
	bool createTouchSocket(string mdIPAddress);
	bool createTouchSocket(string mdIPAddress, string interfaceName);

	bool readCmdData(u8* data, u32 len);
	bool writeCmdData(u8* data, u32 len);

	bool readVideoData(u8* data, u32 len);
	bool writeVideoData(u8* data, u32 len);// added by ADIT

	bool readMediaData(u8*data, u32 len);
	bool readTTSData(u8*data, u32 len);

	bool readVRData(u8*data, u32 len);
	bool writeVRData(u8*data, u32 len);

	bool writeCtrlData(u8*data, u32 len);

	IProtocolSocketConnector* aProtocolHandler; //added by ADIT
private:
	CConnectManager();

	static CConnectManager* pInstance;

	static CmdRet cmdRet;

	ASocketConnector* cmdSocket; //added by ADIT
	ASocketConnector* videoSocket;//added by ADIT
	ASocketConnector* mediaSocket;//added by ADIT
	ASocketConnector* ttsSocket;//added by ADIT
	ASocketConnector* vrSocket;//added by ADIT
	ASocketConnector* ctrlSocket;//added by ADIT
};





































#endif





























