/**
* \file: AoapTransport.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef PLATFORM_BDCL_TRANSPORT_AOAP_TRANSPORT_INCLUDE_AOAPTRANSPORT_H_
#define PLATFORM_BDCL_TRANSPORT_AOAP_TRANSPORT_INCLUDE_AOAPTRANSPORT_H_
/* *************  includes  ************* */

#include <semaphore.h>
/* *************  defines  ************* */

namespace adit { namespace bdcl {

/**
 * @struct aoapAccessoryInfo_t
 * The accessory information consisting of the six identification strings
 * and a flag for enabling audio
 */
struct aoapAccessoryInfo_t
{
    const char *manufacturer; // The manufacturer of the MD application (for identification of Android application)
    const char *modelName;    // The model name of the MD application (for identification of Android application)
    const char *description;  // The description of the MD application (for identification of Android application)
    const char *version;      // The version (for identification of Android application)
    const char *uri;          // The URI where to download the MD application (for identification of Android application)
    const char *serial;       // The serial number of the HU
    unsigned int enableAudio; // =0 : disable audio. >0 : enable audio (only necessary for AOA 2.0)
};

/**
 * @struct aoapDeviceInfo_t
 * The device information (vendorId, producId, serial number) to identify the device
 */
struct aoapDeviceInfo_t
{
    unsigned int vendorId;
    unsigned int productId;
    char* pSerial;

    aoapAccessoryInfo_t aoapAccessoryInfo;
};

/**
 * @struct aoapTransportInfo_t
 * The AOAP information which are necessary for AoapTransport e.g. GalReceiver Transport
 */
struct aoapTransportInfo_t
{
    int aoapAccessoryId;
    int aoapDeviceId;
};


/* class AoapDevice
 * This class provides a member function to switch the MD into the accessory mode using the AOAP
 * library.
 */
class AoapDevice {
public:
    AoapDevice();
    virtual ~AoapDevice() {
        sem_destroy(&mAoapSyncSem);
    };
    /**
     * @brief Initialize the AOAP library and switch the device identified by aoapDeviceInfo_t
     * to the accessory mode. It return in structure aoapTransportInfo_t the necessary information
     * to use the AOAP library transport by class AoapTransport.
     * This API is blocking and return if the device was switched of the timeout set by
     * inTimeout passed.
     *
     * @param inAoapDeviceInfo structure with device information and accessory information
     * @param outTransportInfo parameters which a necessary to use the AOAP library as transport
     *        (class AoapTransport)
     * @param inTimeout[ms] maximum time in millisecond to wait to switch the device to accessory mode
     *
     * @return 0 if success, otherwise negative return value
     */
    int switchDevice(aoapDeviceInfo_t* inAoapDeviceInfo, aoapTransportInfo_t* outTransportInfo,
            unsigned int inTimeout);
private:
    /**
     * @brief Callback for AOAP library which is triggered during/after switch to accessory mode
     */
    static void switchCallback(int accessoryId, int deviceId, int result, void *pToken,
            unsigned int audioSupport);

    sem_t mAoapSyncSem;
    int mSwitchResult;
};



} } /* namespace adit { namespace bdcl { */





#endif /* PLATFORM_BDCL_TRANSPORT_AOAP_TRANSPORT_INCLUDE_AOAPTRANSPORT_H_ */
