/**
* \file: AlsaAudioSink.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_ALSAAUDIOSINK_H
#define AAUTO_ALSAAUDIOSINK_H

#include "aauto/AditAudioSink.h"

namespace adit { namespace aauto {

/* forward declaration of internal implementation */
class AlsaAudioSinkImpl;

/** 
 * @brief AlsaAudioSink provides ALSA specific audio sink implementation.*/
class AlsaAudioSink : public AditAudioSink
{
public:
    /**
     * @brief  Constructor of AlsaAudioSink
     * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
     * @param  inMessageRouter  inMessageRouter is message router obtained from GalReceiver. */
    AlsaAudioSink(uint8_t inSessionId, MessageRouter* inMessageRouter);
    virtual ~AlsaAudioSink();

    /**
     * @brief Initialize the AlsaAudioSink. All configuration items must be set.
     *
     * @return true if initialization succeeds.
     *          false if configuration items without default value is not set or initialization
     *          fails. */
    bool init();

    /**
     * @brief  Shutdown the Alsa Audio Sink */
    void shutdown();

    /** @brief Set configuration for platform and AudioSink-related items. Must be called before init().
     * @param  inKey        The key string for configuration (e.g. "alsa-main-audio")
     *  - [ALSA Configuration]
     *  - alsa-main-audio [mandatory] :             Defines the ALSA device name to be used and
     *                                              also 3 parameters: periodMs, bufferPeriods, and silenceMs.
     * <pre>
     *     device [mandatory]                         ALSA device name.
     *     periodMs [mandatory]                       Size of one period in milliseconds.
     *     bufferPeriods [optional, default=3]        Number of periods in the audio buffer of the adapter.
     *                                                The buffer size will be extended internally
     *                                                if it can't fit (silenceMs + periodMs)
     *                                                to hold at least (silenceMs + periodMs).
     *     silenceMs [optional, default=2x periodMs]  Length of 0 prefill in the audio buffer to
     *                                                avoid buffer underrun at the cost of latency.
     * </pre>
     * @param  inValue      The actual value for configuration (e.g. "device=entertainment_main periodMs=8")
     * */
    void setConfigItem(string inKey, string inValue);

    /**
     * @brief Register callback interface to receive AudioSink-related notifications.
     * See IAditAudioSinkCallbacks for details.
     *
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditAudioSinkCallbacks* inCallbacks);

private:
    AlsaAudioSinkImpl* impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ALSAAUDIOSINK_H */
