/**
* \file: IInputAdapter.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_IINPUTADAPTER_H
#define CARPLAY_IINPUTADAPTER_H

#include "IConfiguration.h"

namespace adit { namespace carplay
{

struct HIDDevice
{
    const char*     DisplayUUID;
    int             HIDCountryCode; /* 0-255 */
    const uint8_t*  HIDDescriptor;
    size_t          HIDDescriptorLen;
    int             HIDProductId;
    int             HIDVendorId;
    const char*     Name;
    const char*     UUID;
};

struct HIDInputReport
{
    const uint8_t*  HIDReportData;
    size_t          HIDReportLen;
    const char*     UUID;
};

/**
 * Interface provided by CarPlay.
 */
class IInputReceiver
{
public :
    /**
     * Attach HID device.
     *
     * \param [in] device       HID device info
     */
    virtual bool AttachInput(const HIDDevice& device) = 0;

    /**
     * Detach HID device.
     *
     * \param [in] uuid         UUID of the HID device
     */
    virtual bool DetachInput(const std::string& uuid) = 0;

    /**
     * Send HID input report.
     *
     * \param [in] report       UUID and HID report bytes
     */
    virtual bool SendInput(const HIDInputReport& report) = 0;

protected:
    /**
     * Default virtual destructor.
     */
    virtual ~IInputReceiver() {};
};

/**
 * Interface to be implemented by adapter.
 */
class IInputAdapter
{
public:
    /**
     * Default virtual destructor.
     */
    virtual ~IInputAdapter() {};

    /**
     * Initialize input adapter.
     * May include multeplie HID devices.
     *
     * \param [in] config       configuration
     * \param [in] receiver     HID input receiver
     *
     * \return bool             false: if failed to initialize.
     */
    virtual bool Initialize(const IConfiguration& config, IInputReceiver& receiver, SessionId inSessionId) = 0;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_IINPUTADAPTER_H */
