/*
 * include/uapi/drm/imx_drm.h
 *
 * Copyright (C) 2013-2014 Mentor Graphics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __IMX_DRM_H__
#define __IMX_DRM_H__

#include "drm.h"

#define DRM_IMX_GAMMA_SIZE         16
struct drm_imx_gamma {
	bool     enable;
	uint32_t crtc_id;
	uint32_t m[DRM_IMX_GAMMA_SIZE];
	uint32_t b[DRM_IMX_GAMMA_SIZE];
};

enum drm_imx_csc_type {
	DRM_IMX_CSC_RGB2RGB = 0,
	DRM_IMX_CSC_RGB2YUV,
	DRM_IMX_CSC_YUV2RGB,
	DRM_IMX_CSC_YUV2YUV,
};

struct drm_imx_csc {
	bool     enable;
	uint32_t crtc_id;
	enum drm_imx_csc_type type;
	int A[3][3]; /* 3x3 CSC matrix */
	int B[3];    /* offset vector */
	int E[3];    /* exponent vector */
};

#define DRM_IMX_SET_GAMMA    0x00
#define DRM_IMX_SET_CSC      0x01

#define DRM_IOCTL_IMX_SET_GAMMA                                         \
	DRM_IOW(DRM_COMMAND_BASE + DRM_IMX_SET_GAMMA, struct drm_imx_gamma)
#define DRM_IOCTL_IMX_SET_CSC						\
	DRM_IOW(DRM_COMMAND_BASE + DRM_IMX_SET_CSC, struct drm_imx_csc)

#endif /* __IMX_DRM_H__ */
