/*
 * Copyright (c) 2014-2015 Mentor Graphics Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version
 */

#ifndef __UAPI_MEDIA_IMX6_H__
#define __UAPI_MEDIA_IMX6_H__

enum imx6_csc_type {
	IMX6_CSC_RGB2RGB = 0,
	IMX6_CSC_RGB2YUV,
	IMX6_CSC_YUV2RGB,
	IMX6_CSC_YUV2YUV,
};

enum imx6_csc_satmode {
	IMX6_CSC_SAT_0_255 = 0,
	IMX6_CSC_SAT_16_235Y_240UV,
};

struct imx6_csc {
	bool enable;
	enum imx6_csc_type type;
	enum imx6_csc_satmode sat;
	int csc[3][3]; /* 3x3 CSC matrix */
	int off[3];    /* offset vector */
	int exp;       /* exponent scalar */
};

/*
 * This is a private ioctl in imx6 v4l2 drivers, to retrieve the physical
 * address of a v4l2 buffer. It should be removed once userland apps
 * (Freescale gstreamer plugins and others) are converted to use
 * VIDIOC_EXPBUF and pass around dmabuf file descriptors.
 */
#define VIDIOC_IMX6_GET_PHYS \
	_IOWR('i', BASE_VIDIOC_PRIVATE+0, struct v4l2_buffer)

/* private ioctl to set IC color space conversion matrix */
#define VIDIOC_IMX6_SET_CSC \
	_IOWR('i', BASE_VIDIOC_PRIVATE+1, struct imx6_csc)

enum imx6_ctrl_id {
	V4L2_CID_IMX6_MOTION = (V4L2_CID_USER_IMX6_BASE + 0),
	V4L2_CID_IMX6_FIM_ENABLE,
	V4L2_CID_IMX6_FIM_NUM,
	V4L2_CID_IMX6_FIM_TOLERANCE_MIN,
	V4L2_CID_IMX6_FIM_TOLERANCE_MAX,
	V4L2_CID_IMX6_FIM_NUM_SKIP,
};

#endif
