/**
* \file: AautoErrorCodes.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_ERROR_CODES_H
#define AAUTO_ERROR_CODES_H

namespace adit { namespace aauto {

/**
 * @brief defined error values to notify upper layer in case of an error.
 * */
enum aautoErrorCodes {
    /* Audio Errors */
    AUDIO_SINK_CONFIGURATION_ERROR   = 101,
    AUDIO_SINK_START_ERROR           = 102,
    AUDIO_SINK_WRITE_ERROR           = 103,
    AUDIO_SOURCE_CONFIGURATION_ERROR = 151,
    AUDIO_SOURCE_START_ERROR         = 152,
    AUDIO_SOURCE_READ_ERROR          = 153,
    /* Video Errors */
    VIDEO_SINK_CONFIGURATION_ERROR   = 201,
    VIDEO_SINK_START_ERROR           = 202,
    VIDEO_SINK_RENDER_ERROR          = 203,
    /* Input Touch Errors */
    ATTACHED_TOUCH_INIT_ERROR        = 301,
    INPUT_EVENT_DISPATCH_ERROR       = 302
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ERROR_CODES_H */
