/**
* \file: GstreamerVideoSink.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_GSTREAMERVIDEOSINK_H
#define AAUTO_GSTREAMERVIDEOSINK_H

/* GalReceiver headers*/
#include <aauto/util/shared_ptr.h>
#include <aauto/VideoSink.h>
#include "aauto/AditVideoSink.h"

namespace adit { namespace aauto {

/* forward declaration of internal implementation */
class GstreamerVideoSinkImpl;

/** 
 * @brief GstreamerVideoSink provides Gstreamer specific video implementation.*/
class GstreamerVideoSink : public AditVideoSink
{
public:

    /**
     * @brief  Constructor of GstreamerVideoSink
     * @param  inSessionId      inSessionId is Id that is used in GalReceiver as identification data on session.
     * @param  inMessageRouter    inMessageRouter is message router obtained from GalReceiver
     * @param  inAutoStart      true if starting projection mode automatically, otherwise false. */
    GstreamerVideoSink(uint8_t inSessionId, MessageRouter* inMessageRouter, bool inAutoStart);
    virtual ~GstreamerVideoSink();
    
    /**
     * @brief Initialize the GstreamerVideoSink. All configuration items must be set.
     *
     * @return true if initialization succeeds.
     *          false if configuration items without default value is not set or initialization
     *          fails. */
    bool init();
    
    /**
     * @brief  Shutdown the Gstreamer Video Sink */
    void shutdown();

    /**
     * @brief Set configuration for platform and Gstreamer-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     *      - gstreamer-video-pipeline [mandatory]: The Gstreamer video pipeline to be created. (e.g. "vpudec low-latency=true frame-plus=2 framedrop=false framerate-nu=30 dis-reorder=true ! gst_apx_sink display-width=960 display-height=540 layer-id=3000 surface-id=40 sync=false qos=false max-lateness=3000000000")
     * @param  inValue      The actual value for configuration */  
    void setConfigItem(string inKey, string inValue);
    
    /**
     * @brief Register callback interface to receive video-related notifications.
     * See IAditVideoSinkCallbacks for details.
     *
     * @param   inCallbacks object implementing the callback interface */
    void registerCallbacks(IAditVideoSinkCallbacks* inCallbacks);

private:
    GstreamerVideoSinkImpl* impl;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_GSTREAMERVIDEOSINK_H */
