/*
 * json_utils.h
 *
 *  
 *      
 */

#ifndef JSON_UTILS_op_H_
#define JSON_UTILS_op_H_

//#define   _NEW
#include "json.h"
//#undef _NEW

#define SYSTEM_S_IMPORT_INTERFACE_STRING
#include <stl_pif.h>

class json_utils {
public:
	json_utils();
	~json_utils();

	tBool getJSONObject(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getJSONArray(Json::Value& input, tCString jsonObjName, Json::Value& output);
	tBool getString(Json::Value& input, tCString name, std::string& output);
	tBool gettBool(Json::Value& input, tCString jsonObjName, tBool& output);
	tBool gettU8UInt(Json::Value& input, tCString jsonObjName, tU8& output);
	tBool gettU16UInt(Json::Value& input, tCString jsonObjName, tU16& output);
	tBool gettU32UInt(Json::Value& input, tCString jsonObjName, tU32& output);
	tBool gettU64UInt(Json::Value& input, tCString jsonObjName, tU64& output);
	tBool getDouble(Json::Value& input, tCString jsonObjName, double& output);
	tBool getFloat(Json::Value& input, tCString jsonObjName, float& output);

	//ApplicationHeader: File Header JSON object names
	static tCString APPLICATIONHEADER;
	static tCString DATADICTIONARYVERSION;

	static tCString MESSAGETYPE;//long lablel
	static tCString MSGTYPE;//short lablel

	static tCString TARGETID;//long lablel
	static tCString TID;//short lablel

	static tCString DEVID;
	static tCString DEVICETYPE;
	static tCString VIN;
	static tCString BIN;
	static tCString TIMESTAMP;
	static tCString TS;

	static tCString CORRELATIONID;//long lablel
	static tCString CID;//short lablel

	static tCString GLOBALMESSAGEID;//long lablel
	static tCString GID;//short lablel

	static tCString USERID;
	static tCString TOKEN;

	//ApplicationData: Data JSON object name
	static tCString VERSION;
	static tCString DCMVERSION;

	//static tCString TIMESTAMP;
	static tCString DATAWIPE_DATA_ACTION;

	//UpLoadData from clients
	static tCString UPLOADHEADER;
	static tCString UPLOADFUNCTIONID;
	static tCString UPLOADDATA;
	// For DownLoad and UpLoad ConfigPolicy

	//DownLoad
	static tCString DBMAPDOWNLOAD;
	static tCString DOWNLOAD;
	static tCString DRMDATAREQTIMEOUT;
	static tCString GIDLISTMAX;

	//Upload
	static tCString DBMAPUPLOAD;
	static tCString UPLOAD;
	static tCString UPLOADTOPIC;
	static tCString TOPICNAME;

	//Common of ConfigPolicy
	static tCString BUFFERSTYPE;
	static tCString DBPRIO;
	static tCString UMSOURCE;
	static tCString BUFFERS;
	static tCString QUEUESIZE;
	static tCString QUEUELENGTH;

	//UploadFunction
	static tCString UPLOADFUNCTION;

	//Signal Map DownLoad
	static tCString SIGNALMAPDOWNLOAD;
	static tCString SIGNAL;

	//SignalDownLoadBlock
	static tCString SIGNALDOWNLOADBLOCK;

	//GenGlobalMessageId
	static tCString GENGLOBALMESSAGEID;

	//Data Dictionary
	static tCString DATADICTIONARY;
	static tCString LONGLABEL;
	static tCString SHORTLABEL;

	//DataWipe
	static tCString DATAWIPE;
	static tCString DWASTA;
	static tCString DATAWIPE_DATA_STATUS;
	static tCString DWAEC;
	static tCString DATAWIPE_DATA_ERRORCODE;
	static tCString DWAC;

	//FIFOFull
	static tCString DRMBUFFERFULL;
	static tCString REMOTEREQUEST_SENT_DRM_ERRORCODE;

	//FIFO full recovery
	static tCString DRMBUFFERSTATUS;
	static tCString REMOTEREQUEST_SENT_DRM_BUFFERSTATE;

	//LogTrace
	static tCString LOGTRACE;

	//LabelConvert
	static tCString LABELCONVERT;

	//IVIVersionNotification
	static tCString MQTTMANAGERVERSION;
	static tCString DDVERSION;

	//Mqtt Configuration needs
	static tCString MQTT;
	static tCString DRM;

	static tCString MQTTCONFIGPOLICY;
	static tCString MQTTSESSIONTYPE;
	static tCString MQTTKEEPTIMEALIVE;

	static tCString KEEPALIVE;
	static tCString INTERVAL;
	static tCString USERNAME;
	static tCString PASSWORD;
	static tCString OCCURRENCE;
	static tCString TIMEOUT;
	static tCString CLEANSESSION;
	static tCString DELAY;

	static tCString MQTTPERIODICCONNECTINTERVAL;
	static tCString MQTTPAYLOADCOMPRESSION;
	static tCString MQTTUSERNAMECONFIG;
	static tCString MQTTPASSWORDCONFIG;
	static tCString URL;
	static tCString PORT;
	static tCString MQTTRETRYCONNECTINTERVAL;
	static tCString MQTTRETRYCONNECTOCCURRENCE;
	static tCString MQTTRETRYPUBLISHINTERVAL;
	static tCString MQTTRETRYPUBLISHOCCURRENCE;
	static tCString MQTTRETRYSUBSCRIBEINTERVAL;
	static tCString MQTTRETRYSUBSCRIBEOCCURRENCE;
	static tCString MQTTCONNECTIONTIMEOUT;
	static tCString MQTTSUBSCRIPTIONTIMEOUT;
	static tCString MQTTPUBLISHTIMEOUT;
	static tCString MQTTCLEANSWITCHTOZLIB;
	static tCString MQTTCLEANSWITCHFROMZLIB;
	static tCString TLS_EXPBACKOFFSTARTDELAY;
	static tCString MQTTSESSIONTIMEOUT;

	static tCString TLS;
	//Dummy Download and Upload topics
	static tCString MQTTDOWNLOADTOPIC_01;
	static tCString MQTTDOWNLOADTOPIC_02;
	static tCString MQTTDOWNLOADTOPIC_03;
	static tCString MQTTDOWNLOADTOPIC_04;

	static tCString MQTTUPLOADTOPIC_DEFAULT;
	static tCString MQTTUPLOADTOPIC_01;
	static tCString MQTTUPLOADTOPIC_02;
	static tCString MQTTUPLOADTOPIC_03;
	static tCString MQTTUPLOADTOPIC_04;
	static tCString MQTTUPLOADTOPIC_05;

	//POI data
	static tCString APPLICATIONDATA;

};

#endif /* JSON_UTILS_H_ */
