/**
* \file: compositor_shim.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: compositor_shim
*
* \author: E. Ucan / ADITG/SW1 / eucan@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef COMPOSITOR_SHIM_H
#define COMPOSITOR_SHIM_H

#ifdef __cplusplus
extern "C" {
#endif

#include <wayland-client.h>

typedef enum
{
    ADAPTER_CONFIGURATION_VISIBILITY = (1 << 1),
    ADAPTER_CONFIGURATION_OPACITY = (1 << 2),
    ADAPTER_CONFIGURATION_ORIENTATION = (1 << 3),
    ADAPTER_CONFIGURATION_SOURCE_RECT = (1 << 4),
    ADAPTER_CONFIGURATION_DEST_RECT = (1 << 5),
    ADAPTER_CONFIGURATION_CREATE = (1 << 6),
    ADAPTER_CONFIGURATION_ADD = (1 << 7),
    ADAPTER_CONFIGURATION_ALL = 0xffff
} compositor_shim_configuration_mask;

struct compositor_shim_context;

struct compositor_shim_surface_context
{
    struct wl_surface* wlSurface;
    struct wl_shell_surface* wlShellSurface;
    void* iviSurface;

    uint32_t surface_id;
    uint32_t layer_id;

    double opacity;                    /*!< opacity value of the surface */
    uint32_t sourceX;                     /*!< x source position value of the surface */
    uint32_t sourceY;                     /*!< y source position value of the surface */
    uint32_t sourceWidth;                 /*!< source width value of the surface */
    uint32_t sourceHeight;                /*!< source height value of the surface */
    uint32_t origSourceWidth;             /*!< original source width value of the surface */
    uint32_t origSourceHeight;            /*!< original source height value of the surface */
    uint32_t destX;                       /*!< x destination position value of the surface */
    uint32_t destY;                       /*!< y desitination position value of the surface */
    uint32_t destWidth;                   /*!< destination width value of the surface */
    uint32_t destHeight;                  /*!< destination height value of the surface */
    uint32_t visibility;                  /*!< visibility value of the surface */

    struct compositor_shim_context *shim_ctx;
};

int compositor_shim_surface_init(struct compositor_shim_surface_context* surf_ctx,
                                      struct wl_surface* wlSurface, uint32_t layer_id,
                                      uint32_t surface_id, uint32_t width, uint32_t height);
int compositor_shim_surface_configure(struct compositor_shim_context* ctx,
                                      struct compositor_shim_surface_context* surf_ctx, uint32_t mask);
int compositor_shim_surface_configure_srcdst_deferred(struct compositor_shim_context* ctx,
                                      struct compositor_shim_surface_context* surf_ctx, uint32_t mask);
int compositor_shim_surface_destroy(struct compositor_shim_surface_context* surf_ctx);
int compositor_shim_wait_server (void);
int compositor_shim_close_server (void);
int compositor_shim_terminate (struct compositor_shim_context* ctx);
struct compositor_shim_context* compositor_shim_initialize (struct wl_display* wlDisplay);

#ifdef __cplusplus
}
#endif

#endif  /*  COMPOSITOR_SHIM_H  */

