/* -*-c++-*-
mapengine_oss

Copyright (C) 1998-2006 Robert Osfield
Copyright (C) 2015 Robert Bosch Car Multimedia GmbH

This library is open source and may be redistributed and/or modified under
the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
(at your option) any later version.  The full license is in LICENSE file
included with this distribution, and on the openscenegraph.org website.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
OpenSceneGraph Public License for more details.

History:
Copied from https://github.com/openscenegraph/osg/blob/OpenSceneGraph-3.2.0/include/osgTerrain/GeometryTechnique
List of changes:
1. Modified terrain technique to use skirts
*/

#ifndef MAPENGINE_OSS_SKIRTTERRAINTECHNIQUE_
#define MAPENGINE_OSS_SKIRTTERRAINTECHNIQUE_ 1

#include <osgTerrain/GeometryTechnique>
#include "oss/Export.h"

namespace mapengine {
namespace oss {

/**
* Technique for creating the geometry for the given tile
*/
class MAPENGINE_OSS_EXPORT me_SkirtTerrainTechnique : public osgTerrain::GeometryTechnique
{
public:
   me_SkirtTerrainTechnique();

protected:
   virtual ~me_SkirtTerrainTechnique(){}

private:
   virtual void generateGeometry(BufferData& buffer, osgTerrain::Locator* masterLocator, const osg::Vec3d& centerModel);
   virtual void applyColorLayers(BufferData& buffer);

};

}
}

#endif // MAPENGINE_OSS_SKIRTTERRAINTECHNIQUE_
