/* -*-c++-*- */
/* osgEarth - Dynamic map generation toolkit for OpenSceneGraph
* Copyright 2016 Pelican Mapping
* http://osgearth.org
*
* osgEarth is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
* FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
* IN THE SOFTWARE.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>
*/

#ifndef PROJMAT_FOR_CASCADED_SHADOW_MAP_HEADER_
#define PROJMAT_FOR_CASCADED_SHADOW_MAP_HEADER_ 1

#include <osg/Matrix>
#include <osgShadow/ConvexPolyhedron>

namespace mapengine {
namespace shadows {

void calculateProjMat(const double fovy, const double ar, const double n, const double f, const osg::Matrix& MVMat, const osg::Matrix& lightViewMat, osg::BoundingBoxd& bbox)
{
   osg::Matrix projMat;
   projMat.makePerspective(fovy, ar, n, f);

   // extract the corner points of the camera frustum in world space.
   osg::Matrix MVP = MVMat * projMat;
   osg::Matrix inverseMVP;
   inverseMVP.invert(MVP);
   osgShadow::ConvexPolyhedron frustumPH;
   frustumPH.setToUnitFrustum(true, true);
   frustumPH.transform(inverseMVP, MVP);
   std::vector<osg::Vec3d> verts;
   frustumPH.getPoints(verts);

   // project those on to the plane of the light camera and fit them
   // to a bounding box. That box will form the extent of our orthographic camera.
   for (std::vector<osg::Vec3d>::iterator v = verts.begin(); v != verts.end(); ++v)
   {
      bbox.expandBy((*v) * lightViewMat);
   }
}

}
}

#endif   //PROJMAT_FOR_CASCADED_SHADOW_MAP_HEADER_
