/**
* \file: AautoLogging.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: D. Girnus / ADIT/SW2 / dgirnus@de.adit-jv.com
*
* \copyright (c) 2015 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef AAUTO_LOGGING_H
#define AAUTO_LOGGING_H

#include <stdio.h>

/**
 * @brief API to register the application with DLT
 * @param ApplnID The application id for DLT, e.g. "ADEM"
 * @param ApplnDesc The description of the application, e.g. "Android Auto demo"
 * */
void aautoRegisterAppWithDLT(const char * ApplnID, const char * ApplnDesc);
/**
 * @brief API to unregister the application from DLT
 * */
void aautoDeRegisterAppWithDLT(void);

/**
 * @brief API to register DLT context for all AndroidAuto plug-in.
 * DLT context are:
 *   aauto_receiver
 *   aauto_transport
 *   aauto_authentication
 * */
void aautoRegisterCtxtWithDLT(void);
/**
 * @brief API to unregister all AndroidAuto DLT context.
 * */
void aautoDeRegisterCtxtWithDLT(void);

int aautoLog(int log_level, va_list args);

#endif /* AAUTO_LOGGING_H */
