/**
* \file: Factory.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_FACTORY_H
#define CARPLAY_FACTORY_H

#include <map>
#include <string>

namespace adit { namespace carplay
{

class Factory
{
// not thread-safe, but is also not required to be
public:
    typedef void* (*CreateImplementationFn)(void);

    static Factory* Instance();

    void* Create(const std::string& name);

    template<class ImplementationType>
    bool Register(const std::string& name, CreateImplementationFn creator = Creator);

    template<class ImplementationType>
    static void* Creator();

private:
    static Factory* singleton;

    std::map<std::string, CreateImplementationFn> factoryMap;

    // do not use
public:
    static void logError(const char* msg, ...);
    static void logDebug(const char* msg, ...);
};

template<class ImplementationType>
bool Factory::Register(const std::string& name, CreateImplementationFn creator)
{
    if (creator == nullptr)
    {
        return false;
    }

    auto it = factoryMap.find(name);
    if (it != factoryMap.end())
    {
        // name already registered, cancel
        return false;
    }

    logDebug("register %s at factory", name.c_str());
    factoryMap.insert(std::pair<std::string, CreateImplementationFn>(name, creator));
    return true;
}

// ========== private ==========


template<class ImplementationType>
void* Factory::Creator()
{
    return new ImplementationType();
}

} } /* namespace adit { namespace carplay */

/* DEPRECATED ! do not use anymore */
template<class InterfaceType, class ImplementationType>
bool DipoFactory_Register(const std::string& name)
{
    using namespace adit::carplay;
    Factory::logError("DipoFactory_Register is DEPRECATED please use carplay_FactoryRegister!");
    return Factory::Instance()->template Register<ImplementationType>(name,
            Factory::template Creator<ImplementationType>);
}

/* convenience function */
template<class InterfaceType, class ImplementationType>
bool carplay_FactoryRegister(const std::string& name)
{
    using namespace adit::carplay;
    return Factory::Instance()->template Register<ImplementationType>(name,
            Factory::template Creator<ImplementationType>);
}

#endif /* CARPLAY_FACTORY_H */
